/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.trackselection;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.source.chunk.MediaChunk;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import java.util.Arrays;
import java.util.List;

@UnstableApi
public abstract class BaseTrackSelection
implements ExoTrackSelection {
    protected final TrackGroup group;
    protected final int length;
    protected final int[] tracks;
    private final int type;
    private final Format[] formats;
    private final long[] excludeUntilTimes;
    private int hashCode;

    public BaseTrackSelection(TrackGroup group, int ... tracks) {
        this(group, tracks, 0);
    }

    public BaseTrackSelection(TrackGroup group, int[] tracks, int type) {
        int i;
        Assertions.checkState((tracks.length > 0 ? 1 : 0) != 0);
        this.type = type;
        this.group = (TrackGroup)Assertions.checkNotNull((Object)group);
        this.length = tracks.length;
        this.formats = new Format[this.length];
        for (i = 0; i < tracks.length; ++i) {
            this.formats[i] = group.getFormat(tracks[i]);
        }
        Arrays.sort(this.formats, (a, b) -> b.bitrate - a.bitrate);
        this.tracks = new int[this.length];
        for (i = 0; i < this.length; ++i) {
            this.tracks[i] = group.indexOf(this.formats[i]);
        }
        this.excludeUntilTimes = new long[this.length];
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public final TrackGroup getTrackGroup() {
        return this.group;
    }

    @Override
    public final int length() {
        return this.tracks.length;
    }

    @Override
    public final Format getFormat(int index) {
        return this.formats[index];
    }

    @Override
    public final int getIndexInTrackGroup(int index) {
        return this.tracks[index];
    }

    @Override
    public final int indexOf(Format format) {
        for (int i = 0; i < this.length; ++i) {
            if (this.formats[i] != format) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOf(int indexInTrackGroup) {
        for (int i = 0; i < this.length; ++i) {
            if (this.tracks[i] != indexInTrackGroup) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final Format getSelectedFormat() {
        return this.formats[this.getSelectedIndex()];
    }

    @Override
    public final int getSelectedIndexInTrackGroup() {
        return this.tracks[this.getSelectedIndex()];
    }

    @Override
    public void enable() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void onPlaybackSpeed(float playbackSpeed) {
    }

    @Override
    public int evaluateQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        return queue.size();
    }

    @Override
    public boolean excludeTrack(int index, long exclusionDurationMs) {
        long nowMs = SystemClock.elapsedRealtime();
        boolean canExclude = this.isTrackExcluded(index, nowMs);
        for (int i = 0; i < this.length && !canExclude; ++i) {
            canExclude = i != index && !this.isTrackExcluded(i, nowMs);
        }
        if (!canExclude) {
            return false;
        }
        this.excludeUntilTimes[index] = Math.max(this.excludeUntilTimes[index], Util.addWithOverflowDefault((long)nowMs, (long)exclusionDurationMs, (long)Long.MAX_VALUE));
        return true;
    }

    @Override
    public boolean isTrackExcluded(int index, long nowMs) {
        return this.excludeUntilTimes[index] > nowMs;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 31 * System.identityHashCode(this.group) + Arrays.hashCode(this.tracks);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BaseTrackSelection other = (BaseTrackSelection)obj;
        return this.group.equals((Object)other.group) && Arrays.equals(this.tracks, other.tracks);
    }
}

