/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.trackselection;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.NullableType;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.chunk.Chunk;
import androidx.media3.exoplayer.source.chunk.MediaChunk;
import androidx.media3.exoplayer.source.chunk.MediaChunkIterator;
import androidx.media3.exoplayer.trackselection.TrackSelection;
import androidx.media3.exoplayer.upstream.BandwidthMeter;
import java.util.List;

@UnstableApi
public interface ExoTrackSelection
extends TrackSelection {
    public void enable();

    public void disable();

    public Format getSelectedFormat();

    public int getSelectedIndexInTrackGroup();

    public int getSelectedIndex();

    public int getSelectionReason();

    @Nullable
    public Object getSelectionData();

    public void onPlaybackSpeed(float var1);

    default public void onDiscontinuity() {
    }

    default public void onRebuffer() {
    }

    default public void onPlayWhenReadyChanged(boolean playWhenReady) {
    }

    public void updateSelectedTrack(long var1, long var3, long var5, List<? extends MediaChunk> var7, MediaChunkIterator[] var8);

    public int evaluateQueueSize(long var1, List<? extends MediaChunk> var3);

    default public boolean shouldCancelChunkLoad(long playbackPositionUs, Chunk loadingChunk, List<? extends MediaChunk> queue) {
        return false;
    }

    public boolean excludeTrack(int var1, long var2);

    public boolean isTrackExcluded(int var1, long var2);

    default public long getLatestBitrateEstimate() {
        return -2147483647L;
    }

    public static interface Factory {
        public @NullableType ExoTrackSelection[] createTrackSelections(@NullableType Definition[] var1, BandwidthMeter var2, MediaSource.MediaPeriodId var3, Timeline var4);
    }

    public static final class Definition {
        public final TrackGroup group;
        public final int[] tracks;
        public final int type;
        private static final String TAG = "ETSDefinition";

        public Definition(TrackGroup group, int ... tracks) {
            this(group, tracks, 0);
        }

        public Definition(TrackGroup group, int[] tracks, int type) {
            if (tracks.length == 0) {
                Log.e((String)TAG, (String)"Empty tracks are not allowed", (Throwable)new IllegalArgumentException());
            }
            this.group = group;
            this.tracks = tracks;
            this.type = type;
        }
    }
}

