/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.trackselection;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.NullableType;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.chunk.MediaChunk;
import androidx.media3.exoplayer.source.chunk.MediaChunkIterator;
import androidx.media3.exoplayer.trackselection.BaseTrackSelection;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.trackselection.TrackSelectionUtil;
import androidx.media3.exoplayer.upstream.BandwidthMeter;
import java.util.List;
import java.util.Random;

@UnstableApi
public final class RandomTrackSelection
extends BaseTrackSelection {
    private final Random random;
    private int selectedIndex;

    public RandomTrackSelection(TrackGroup group, int[] tracks, int type, Random random) {
        super(group, tracks, type);
        this.random = random;
        this.selectedIndex = random.nextInt(this.length);
    }

    @Override
    public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
        int i;
        long nowMs = SystemClock.elapsedRealtime();
        int allowedFormatCount = 0;
        for (i = 0; i < this.length; ++i) {
            if (this.isTrackExcluded(i, nowMs)) continue;
            ++allowedFormatCount;
        }
        this.selectedIndex = this.random.nextInt(allowedFormatCount);
        if (allowedFormatCount != this.length) {
            allowedFormatCount = 0;
            for (i = 0; i < this.length; ++i) {
                if (this.isTrackExcluded(i, nowMs) || this.selectedIndex != allowedFormatCount++) continue;
                this.selectedIndex = i;
                return;
            }
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public int getSelectionReason() {
        return 3;
    }

    @Override
    @Nullable
    public Object getSelectionData() {
        return null;
    }

    public static final class Factory
    implements ExoTrackSelection.Factory {
        private final Random random;

        public Factory() {
            this.random = new Random();
        }

        public Factory(int seed) {
            this.random = new Random(seed);
        }

        @Override
        public @NullableType ExoTrackSelection[] createTrackSelections(@NullableType ExoTrackSelection.Definition[] definitions, BandwidthMeter bandwidthMeter, MediaSource.MediaPeriodId mediaPeriodId, Timeline timeline) {
            return TrackSelectionUtil.createTrackSelectionsForDefinitions(definitions, definition -> new RandomTrackSelection(definition.group, definition.tracks, definition.type, this.random));
        }
    }
}

