/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.upstream;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSpec;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.upstream.CmcdConfiguration;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

@UnstableApi
public final class CmcdData {
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");
    private final CmcdObject cmcdObject;
    private final CmcdRequest cmcdRequest;
    private final CmcdSession cmcdSession;
    private final CmcdStatus cmcdStatus;
    private final int dataTransmissionMode;

    private CmcdData(CmcdObject cmcdObject, CmcdRequest cmcdRequest, CmcdSession cmcdSession, CmcdStatus cmcdStatus, int datatTransmissionMode) {
        this.cmcdObject = cmcdObject;
        this.cmcdRequest = cmcdRequest;
        this.cmcdSession = cmcdSession;
        this.cmcdStatus = cmcdStatus;
        this.dataTransmissionMode = datatTransmissionMode;
    }

    public DataSpec addToDataSpec(DataSpec dataSpec) {
        ArrayListMultimap cmcdDataMap = ArrayListMultimap.create();
        this.cmcdObject.populateCmcdDataMap((ArrayListMultimap<String, String>)cmcdDataMap);
        this.cmcdRequest.populateCmcdDataMap((ArrayListMultimap<String, String>)cmcdDataMap);
        this.cmcdSession.populateCmcdDataMap((ArrayListMultimap<String, String>)cmcdDataMap);
        this.cmcdStatus.populateCmcdDataMap((ArrayListMultimap<String, String>)cmcdDataMap);
        if (this.dataTransmissionMode == 0) {
            ImmutableMap.Builder httpRequestHeaders = ImmutableMap.builder();
            for (String headerKey : cmcdDataMap.keySet()) {
                List headerValues = cmcdDataMap.get((Object)headerKey);
                Collections.sort(headerValues);
                httpRequestHeaders.put((Object)headerKey, (Object)COMMA_JOINER.join((Iterable)headerValues));
            }
            return dataSpec.withAdditionalHeaders((Map)httpRequestHeaders.buildOrThrow());
        }
        ArrayList keyValuePairs = new ArrayList();
        for (Collection values : cmcdDataMap.asMap().values()) {
            keyValuePairs.addAll(values);
        }
        Collections.sort(keyValuePairs);
        Uri.Builder uriBuilder = dataSpec.uri.buildUpon().appendQueryParameter("CMCD", COMMA_JOINER.join(keyValuePairs));
        return dataSpec.buildUpon().setUri(uriBuilder.build()).build();
    }

    private static final class CmcdObject {
        public final int bitrateKbps;
        public final int topBitrateKbps;
        public final long objectDurationMs;
        @Nullable
        public final String objectType;
        public final ImmutableList<String> customDataList;

        private CmcdObject(Builder builder) {
            this.bitrateKbps = builder.bitrateKbps;
            this.topBitrateKbps = builder.topBitrateKbps;
            this.objectDurationMs = builder.objectDurationMs;
            this.objectType = builder.objectType;
            this.customDataList = builder.customDataList;
        }

        public void populateCmcdDataMap(ArrayListMultimap<String, String> cmcdDataMap) {
            ArrayList<String> keyValuePairs = new ArrayList<String>();
            if (this.bitrateKbps != -2147483647) {
                keyValuePairs.add("br=" + this.bitrateKbps);
            }
            if (this.topBitrateKbps != -2147483647) {
                keyValuePairs.add("tb=" + this.topBitrateKbps);
            }
            if (this.objectDurationMs != -9223372036854775807L) {
                keyValuePairs.add("d=" + this.objectDurationMs);
            }
            if (!TextUtils.isEmpty((CharSequence)this.objectType)) {
                keyValuePairs.add("ot=" + this.objectType);
            }
            keyValuePairs.addAll((Collection<String>)this.customDataList);
            if (!keyValuePairs.isEmpty()) {
                cmcdDataMap.putAll((Object)"CMCD-Object", keyValuePairs);
            }
        }

        public static final class Builder {
            private int bitrateKbps = -2147483647;
            private int topBitrateKbps = -2147483647;
            private long objectDurationMs = -9223372036854775807L;
            @Nullable
            private String objectType;
            private ImmutableList<String> customDataList = ImmutableList.of();

            @CanIgnoreReturnValue
            public Builder setBitrateKbps(int bitrateKbps) {
                Assertions.checkArgument((bitrateKbps >= 0 || bitrateKbps == -2147483647 ? 1 : 0) != 0);
                this.bitrateKbps = bitrateKbps;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setTopBitrateKbps(int topBitrateKbps) {
                Assertions.checkArgument((topBitrateKbps >= 0 || topBitrateKbps == -2147483647 ? 1 : 0) != 0);
                this.topBitrateKbps = topBitrateKbps;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setObjectDurationMs(long objectDurationMs) {
                Assertions.checkArgument((objectDurationMs >= 0L || objectDurationMs == -9223372036854775807L ? 1 : 0) != 0);
                this.objectDurationMs = objectDurationMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setObjectType(@Nullable String objectType) {
                this.objectType = objectType;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomDataList(List<String> customDataList) {
                this.customDataList = ImmutableList.copyOf(customDataList);
                return this;
            }

            public CmcdObject build() {
                return new CmcdObject(this);
            }
        }
    }

    private static final class CmcdRequest {
        public final long bufferLengthMs;
        public final long measuredThroughputInKbps;
        public final long deadlineMs;
        public final boolean startup;
        @Nullable
        public final String nextObjectRequest;
        @Nullable
        public final String nextRangeRequest;
        public final ImmutableList<String> customDataList;

        private CmcdRequest(Builder builder) {
            this.bufferLengthMs = builder.bufferLengthMs;
            this.measuredThroughputInKbps = builder.measuredThroughputInKbps;
            this.deadlineMs = builder.deadlineMs;
            this.startup = builder.startup;
            this.nextObjectRequest = builder.nextObjectRequest;
            this.nextRangeRequest = builder.nextRangeRequest;
            this.customDataList = builder.customDataList;
        }

        public void populateCmcdDataMap(ArrayListMultimap<String, String> cmcdDataMap) {
            ArrayList<String> keyValuePairs = new ArrayList<String>();
            if (this.bufferLengthMs != -9223372036854775807L) {
                keyValuePairs.add("bl=" + this.bufferLengthMs);
            }
            if (this.measuredThroughputInKbps != -2147483647L) {
                keyValuePairs.add("mtp=" + this.measuredThroughputInKbps);
            }
            if (this.deadlineMs != -9223372036854775807L) {
                keyValuePairs.add("dl=" + this.deadlineMs);
            }
            if (this.startup) {
                keyValuePairs.add("su");
            }
            if (!TextUtils.isEmpty((CharSequence)this.nextObjectRequest)) {
                keyValuePairs.add(Util.formatInvariant((String)"%s=\"%s\"", (Object[])new Object[]{"nor", this.nextObjectRequest}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.nextRangeRequest)) {
                keyValuePairs.add(Util.formatInvariant((String)"%s=\"%s\"", (Object[])new Object[]{"nrr", this.nextRangeRequest}));
            }
            keyValuePairs.addAll((Collection<String>)this.customDataList);
            if (!keyValuePairs.isEmpty()) {
                cmcdDataMap.putAll((Object)"CMCD-Request", keyValuePairs);
            }
        }

        public static final class Builder {
            private long bufferLengthMs = -9223372036854775807L;
            private long measuredThroughputInKbps = -2147483647L;
            private long deadlineMs = -9223372036854775807L;
            private boolean startup;
            @Nullable
            private String nextObjectRequest;
            @Nullable
            private String nextRangeRequest;
            private ImmutableList<String> customDataList = ImmutableList.of();

            @CanIgnoreReturnValue
            public Builder setBufferLengthMs(long bufferLengthMs) {
                Assertions.checkArgument((bufferLengthMs >= 0L || bufferLengthMs == -9223372036854775807L ? 1 : 0) != 0);
                this.bufferLengthMs = (bufferLengthMs + 50L) / 100L * 100L;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMeasuredThroughputInKbps(long measuredThroughputInKbps) {
                Assertions.checkArgument((measuredThroughputInKbps >= 0L || measuredThroughputInKbps == -2147483647L ? 1 : 0) != 0);
                this.measuredThroughputInKbps = (measuredThroughputInKbps + 50L) / 100L * 100L;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setDeadlineMs(long deadlineMs) {
                Assertions.checkArgument((deadlineMs >= 0L || deadlineMs == -9223372036854775807L ? 1 : 0) != 0);
                this.deadlineMs = (deadlineMs + 50L) / 100L * 100L;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setStartup(boolean startup) {
                this.startup = startup;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setNextObjectRequest(@Nullable String nextObjectRequest) {
                this.nextObjectRequest = nextObjectRequest == null ? null : Uri.encode((String)nextObjectRequest);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setNextRangeRequest(@Nullable String nextRangeRequest) {
                this.nextRangeRequest = nextRangeRequest;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomDataList(List<String> customDataList) {
                this.customDataList = ImmutableList.copyOf(customDataList);
                return this;
            }

            public CmcdRequest build() {
                return new CmcdRequest(this);
            }
        }
    }

    private static final class CmcdSession {
        public static final int VERSION = 1;
        @Nullable
        public final String contentId;
        @Nullable
        public final String sessionId;
        @Nullable
        public final String streamingFormat;
        @Nullable
        public final String streamType;
        public final float playbackRate;
        public final ImmutableList<String> customDataList;

        private CmcdSession(Builder builder) {
            this.contentId = builder.contentId;
            this.sessionId = builder.sessionId;
            this.streamingFormat = builder.streamingFormat;
            this.streamType = builder.streamType;
            this.playbackRate = builder.playbackRate;
            this.customDataList = builder.customDataList;
        }

        public void populateCmcdDataMap(ArrayListMultimap<String, String> cmcdDataMap) {
            ArrayList<String> keyValuePairs = new ArrayList<String>();
            if (!TextUtils.isEmpty((CharSequence)this.contentId)) {
                keyValuePairs.add(Util.formatInvariant((String)"%s=\"%s\"", (Object[])new Object[]{"cid", this.contentId}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.sessionId)) {
                keyValuePairs.add(Util.formatInvariant((String)"%s=\"%s\"", (Object[])new Object[]{"sid", this.sessionId}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.streamingFormat)) {
                keyValuePairs.add("sf=" + this.streamingFormat);
            }
            if (!TextUtils.isEmpty((CharSequence)this.streamType)) {
                keyValuePairs.add("st=" + this.streamType);
            }
            if (this.playbackRate != -3.4028235E38f && this.playbackRate != 1.0f) {
                keyValuePairs.add(Util.formatInvariant((String)"%s=%.2f", (Object[])new Object[]{"pr", Float.valueOf(this.playbackRate)}));
            }
            keyValuePairs.addAll((Collection<String>)this.customDataList);
            if (!keyValuePairs.isEmpty()) {
                cmcdDataMap.putAll((Object)"CMCD-Session", keyValuePairs);
            }
        }

        public static final class Builder {
            @Nullable
            private String contentId;
            @Nullable
            private String sessionId;
            @Nullable
            private String streamingFormat;
            @Nullable
            private String streamType;
            private float playbackRate;
            private ImmutableList<String> customDataList = ImmutableList.of();

            @CanIgnoreReturnValue
            public Builder setContentId(@Nullable String contentId) {
                Assertions.checkArgument((contentId == null || contentId.length() <= 64 ? 1 : 0) != 0);
                this.contentId = contentId;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setSessionId(@Nullable String sessionId) {
                Assertions.checkArgument((sessionId == null || sessionId.length() <= 64 ? 1 : 0) != 0);
                this.sessionId = sessionId;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setStreamingFormat(@Nullable String streamingFormat) {
                this.streamingFormat = streamingFormat;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setStreamType(@Nullable String streamType) {
                this.streamType = streamType;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPlaybackRate(float playbackRate) {
                Assertions.checkArgument((playbackRate > 0.0f || playbackRate == -3.4028235E38f ? 1 : 0) != 0);
                this.playbackRate = playbackRate;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomDataList(List<String> customDataList) {
                this.customDataList = ImmutableList.copyOf(customDataList);
                return this;
            }

            public CmcdSession build() {
                return new CmcdSession(this);
            }
        }
    }

    private static final class CmcdStatus {
        public final int maximumRequestedThroughputKbps;
        public final boolean bufferStarvation;
        public final ImmutableList<String> customDataList;

        private CmcdStatus(Builder builder) {
            this.maximumRequestedThroughputKbps = builder.maximumRequestedThroughputKbps;
            this.bufferStarvation = builder.bufferStarvation;
            this.customDataList = builder.customDataList;
        }

        public void populateCmcdDataMap(ArrayListMultimap<String, String> cmcdDataMap) {
            ArrayList<String> keyValuePairs = new ArrayList<String>();
            if (this.maximumRequestedThroughputKbps != -2147483647) {
                keyValuePairs.add("rtp=" + this.maximumRequestedThroughputKbps);
            }
            if (this.bufferStarvation) {
                keyValuePairs.add("bs");
            }
            keyValuePairs.addAll((Collection<String>)this.customDataList);
            if (!keyValuePairs.isEmpty()) {
                cmcdDataMap.putAll((Object)"CMCD-Status", keyValuePairs);
            }
        }

        public static final class Builder {
            private int maximumRequestedThroughputKbps = -2147483647;
            private boolean bufferStarvation;
            private ImmutableList<String> customDataList = ImmutableList.of();

            @CanIgnoreReturnValue
            public Builder setMaximumRequestedThroughputKbps(int maximumRequestedThroughputKbps) {
                Assertions.checkArgument((maximumRequestedThroughputKbps >= 0 || maximumRequestedThroughputKbps == -2147483647 ? 1 : 0) != 0);
                this.maximumRequestedThroughputKbps = maximumRequestedThroughputKbps == -2147483647 ? maximumRequestedThroughputKbps : (maximumRequestedThroughputKbps + 50) / 100 * 100;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setBufferStarvation(boolean bufferStarvation) {
                this.bufferStarvation = bufferStarvation;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomDataList(List<String> customDataList) {
                this.customDataList = ImmutableList.copyOf(customDataList);
                return this;
            }

            public CmcdStatus build() {
                return new CmcdStatus(this);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    public static @interface ObjectType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    public static @interface StreamType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    public static @interface StreamingFormat {
    }

    public static final class Factory {
        public static final String STREAMING_FORMAT_DASH = "d";
        public static final String STREAMING_FORMAT_HLS = "h";
        public static final String STREAMING_FORMAT_SS = "s";
        public static final String STREAM_TYPE_VOD = "v";
        public static final String STREAM_TYPE_LIVE = "l";
        public static final String OBJECT_TYPE_INIT_SEGMENT = "i";
        public static final String OBJECT_TYPE_AUDIO_ONLY = "a";
        public static final String OBJECT_TYPE_VIDEO_ONLY = "v";
        public static final String OBJECT_TYPE_MUXED_AUDIO_AND_VIDEO = "av";
        private static final Pattern CUSTOM_KEY_NAME_PATTERN = Pattern.compile(".*-.*");
        private final CmcdConfiguration cmcdConfiguration;
        private final ExoTrackSelection trackSelection;
        private final long bufferedDurationUs;
        private final float playbackRate;
        private final String streamingFormat;
        private final boolean isLive;
        private final boolean didRebuffer;
        private final boolean isBufferEmpty;
        private long chunkDurationUs;
        @Nullable
        private String objectType;
        @Nullable
        private String nextObjectRequest;
        @Nullable
        private String nextRangeRequest;

        public Factory(CmcdConfiguration cmcdConfiguration, ExoTrackSelection trackSelection, long bufferedDurationUs, float playbackRate, String streamingFormat, boolean isLive, boolean didRebuffer, boolean isBufferEmpty) {
            Assertions.checkArgument((bufferedDurationUs >= 0L ? 1 : 0) != 0);
            Assertions.checkArgument((playbackRate > 0.0f ? 1 : 0) != 0);
            this.cmcdConfiguration = cmcdConfiguration;
            this.trackSelection = trackSelection;
            this.bufferedDurationUs = bufferedDurationUs;
            this.playbackRate = playbackRate;
            this.streamingFormat = streamingFormat;
            this.isLive = isLive;
            this.didRebuffer = didRebuffer;
            this.isBufferEmpty = isBufferEmpty;
            this.chunkDurationUs = -9223372036854775807L;
        }

        @Nullable
        public static String getObjectType(ExoTrackSelection trackSelection) {
            Assertions.checkArgument((trackSelection != null ? 1 : 0) != 0);
            int trackType = MimeTypes.getTrackType((String)trackSelection.getSelectedFormat().sampleMimeType);
            if (trackType == -1) {
                trackType = MimeTypes.getTrackType((String)trackSelection.getSelectedFormat().containerMimeType);
            }
            if (trackType == 1) {
                return OBJECT_TYPE_AUDIO_ONLY;
            }
            if (trackType == 2) {
                return "v";
            }
            return null;
        }

        @CanIgnoreReturnValue
        public Factory setChunkDurationUs(long chunkDurationUs) {
            Assertions.checkArgument((chunkDurationUs >= 0L ? 1 : 0) != 0);
            this.chunkDurationUs = chunkDurationUs;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setObjectType(@Nullable String objectType) {
            this.objectType = objectType;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setNextObjectRequest(@Nullable String nextObjectRequest) {
            this.nextObjectRequest = nextObjectRequest;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setNextRangeRequest(@Nullable String nextRangeRequest) {
            this.nextRangeRequest = nextRangeRequest;
            return this;
        }

        public CmcdData createCmcdData() {
            ImmutableListMultimap<String, String> customData = this.cmcdConfiguration.requestConfig.getCustomData();
            for (String headerKey : customData.keySet()) {
                this.validateCustomDataListFormat((List<String>)customData.get((Object)headerKey));
            }
            int bitrateKbps = Util.ceilDivide((int)this.trackSelection.getSelectedFormat().bitrate, (int)1000);
            CmcdObject.Builder cmcdObject = new CmcdObject.Builder();
            if (!this.getIsInitSegment()) {
                if (this.cmcdConfiguration.isBitrateLoggingAllowed()) {
                    cmcdObject.setBitrateKbps(bitrateKbps);
                }
                if (this.cmcdConfiguration.isTopBitrateLoggingAllowed()) {
                    TrackGroup trackGroup = this.trackSelection.getTrackGroup();
                    int topBitrate = this.trackSelection.getSelectedFormat().bitrate;
                    for (int i = 0; i < trackGroup.length; ++i) {
                        topBitrate = Math.max(topBitrate, trackGroup.getFormat((int)i).bitrate);
                    }
                    cmcdObject.setTopBitrateKbps(Util.ceilDivide((int)topBitrate, (int)1000));
                }
                if (this.cmcdConfiguration.isObjectDurationLoggingAllowed()) {
                    cmcdObject.setObjectDurationMs(Util.usToMs((long)this.chunkDurationUs));
                }
            }
            if (this.cmcdConfiguration.isObjectTypeLoggingAllowed()) {
                cmcdObject.setObjectType(this.objectType);
            }
            if (customData.containsKey((Object)"CMCD-Object")) {
                cmcdObject.setCustomDataList((List<String>)customData.get((Object)"CMCD-Object"));
            }
            CmcdRequest.Builder cmcdRequest = new CmcdRequest.Builder();
            if (!this.getIsInitSegment() && this.cmcdConfiguration.isBufferLengthLoggingAllowed()) {
                cmcdRequest.setBufferLengthMs(Util.usToMs((long)this.bufferedDurationUs));
            }
            if (this.cmcdConfiguration.isMeasuredThroughputLoggingAllowed() && this.trackSelection.getLatestBitrateEstimate() != -2147483647L) {
                cmcdRequest.setMeasuredThroughputInKbps(Util.ceilDivide((long)this.trackSelection.getLatestBitrateEstimate(), (long)1000L));
            }
            if (this.cmcdConfiguration.isDeadlineLoggingAllowed()) {
                cmcdRequest.setDeadlineMs(Util.usToMs((long)((long)((float)this.bufferedDurationUs / this.playbackRate))));
            }
            if (this.cmcdConfiguration.isStartupLoggingAllowed()) {
                cmcdRequest.setStartup(this.didRebuffer || this.isBufferEmpty);
            }
            if (this.cmcdConfiguration.isNextObjectRequestLoggingAllowed()) {
                cmcdRequest.setNextObjectRequest(this.nextObjectRequest);
            }
            if (this.cmcdConfiguration.isNextRangeRequestLoggingAllowed()) {
                cmcdRequest.setNextRangeRequest(this.nextRangeRequest);
            }
            if (customData.containsKey((Object)"CMCD-Request")) {
                cmcdRequest.setCustomDataList((List<String>)customData.get((Object)"CMCD-Request"));
            }
            CmcdSession.Builder cmcdSession = new CmcdSession.Builder();
            if (this.cmcdConfiguration.isContentIdLoggingAllowed()) {
                cmcdSession.setContentId(this.cmcdConfiguration.contentId);
            }
            if (this.cmcdConfiguration.isSessionIdLoggingAllowed()) {
                cmcdSession.setSessionId(this.cmcdConfiguration.sessionId);
            }
            if (this.cmcdConfiguration.isStreamingFormatLoggingAllowed()) {
                cmcdSession.setStreamingFormat(this.streamingFormat);
            }
            if (this.cmcdConfiguration.isStreamTypeLoggingAllowed()) {
                cmcdSession.setStreamType(this.isLive ? STREAM_TYPE_LIVE : "v");
            }
            if (this.cmcdConfiguration.isPlaybackRateLoggingAllowed()) {
                cmcdSession.setPlaybackRate(this.playbackRate);
            }
            if (customData.containsKey((Object)"CMCD-Session")) {
                cmcdSession.setCustomDataList((List<String>)customData.get((Object)"CMCD-Session"));
            }
            CmcdStatus.Builder cmcdStatus = new CmcdStatus.Builder();
            if (this.cmcdConfiguration.isMaximumRequestThroughputLoggingAllowed()) {
                cmcdStatus.setMaximumRequestedThroughputKbps(this.cmcdConfiguration.requestConfig.getRequestedMaximumThroughputKbps(bitrateKbps));
            }
            if (this.cmcdConfiguration.isBufferStarvationLoggingAllowed()) {
                cmcdStatus.setBufferStarvation(this.didRebuffer);
            }
            if (customData.containsKey((Object)"CMCD-Status")) {
                cmcdStatus.setCustomDataList((List<String>)customData.get((Object)"CMCD-Status"));
            }
            return new CmcdData(cmcdObject.build(), cmcdRequest.build(), cmcdSession.build(), cmcdStatus.build(), this.cmcdConfiguration.dataTransmissionMode);
        }

        private boolean getIsInitSegment() {
            return this.objectType != null && this.objectType.equals(OBJECT_TYPE_INIT_SEGMENT);
        }

        private void validateCustomDataListFormat(List<String> customDataList) {
            for (String customData : customDataList) {
                String key = Util.split((String)customData, (String)"=")[0];
                Assertions.checkState((boolean)CUSTOM_KEY_NAME_PATTERN.matcher(key).matches());
            }
        }
    }
}

