/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.upstream;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.NetworkTypeObserver;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.upstream.BandwidthMeter;
import androidx.media3.exoplayer.upstream.SlidingPercentile;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;

@UnstableApi
public final class DefaultBandwidthMeter
implements BandwidthMeter,
TransferListener {
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_WIFI = ImmutableList.of((Object)4300000L, (Object)3200000L, (Object)2400000L, (Object)1700000L, (Object)860000L);
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_2G = ImmutableList.of((Object)1500000L, (Object)980000L, (Object)750000L, (Object)520000L, (Object)290000L);
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_3G = ImmutableList.of((Object)2000000L, (Object)1300000L, (Object)1000000L, (Object)860000L, (Object)610000L);
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_4G = ImmutableList.of((Object)2500000L, (Object)1700000L, (Object)1200000L, (Object)970000L, (Object)680000L);
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_5G_NSA = ImmutableList.of((Object)4700000L, (Object)2800000L, (Object)0x200B20L, (Object)1700000L, (Object)980000L);
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_5G_SA = ImmutableList.of((Object)2700000L, (Object)2000000L, (Object)1600000L, (Object)1300000L, (Object)1000000L);
    public static final long DEFAULT_INITIAL_BITRATE_ESTIMATE = 1000000L;
    public static final int DEFAULT_SLIDING_WINDOW_MAX_WEIGHT = 2000;
    private static final int COUNTRY_GROUP_INDEX_WIFI = 0;
    private static final int COUNTRY_GROUP_INDEX_2G = 1;
    private static final int COUNTRY_GROUP_INDEX_3G = 2;
    private static final int COUNTRY_GROUP_INDEX_4G = 3;
    private static final int COUNTRY_GROUP_INDEX_5G_NSA = 4;
    private static final int COUNTRY_GROUP_INDEX_5G_SA = 5;
    @Nullable
    private static DefaultBandwidthMeter singletonInstance;
    private static final int ELAPSED_MILLIS_FOR_ESTIMATE = 2000;
    private static final int BYTES_TRANSFERRED_FOR_ESTIMATE = 524288;
    private final ImmutableMap<Integer, Long> initialBitrateEstimates;
    private final BandwidthMeter.EventListener.EventDispatcher eventDispatcher;
    private final Clock clock;
    private final boolean resetOnNetworkTypeChange;
    @GuardedBy(value="this")
    private final SlidingPercentile slidingPercentile;
    @GuardedBy(value="this")
    private int streamCount;
    @GuardedBy(value="this")
    private long sampleStartTimeMs;
    @GuardedBy(value="this")
    private long sampleBytesTransferred;
    @GuardedBy(value="this")
    private long totalElapsedTimeMs;
    @GuardedBy(value="this")
    private long totalBytesTransferred;
    @GuardedBy(value="this")
    private long bitrateEstimate;
    @GuardedBy(value="this")
    private long lastReportedBitrateEstimate;
    private int networkType;
    private boolean networkTypeOverrideSet;
    private int networkTypeOverride;

    public static synchronized DefaultBandwidthMeter getSingletonInstance(Context context) {
        if (singletonInstance == null) {
            singletonInstance = new Builder(context).build();
        }
        return singletonInstance;
    }

    private DefaultBandwidthMeter(@Nullable Context context, Map<Integer, Long> initialBitrateEstimates, int maxWeight, Clock clock, boolean resetOnNetworkTypeChange) {
        this.initialBitrateEstimates = ImmutableMap.copyOf(initialBitrateEstimates);
        this.eventDispatcher = new BandwidthMeter.EventListener.EventDispatcher();
        this.slidingPercentile = new SlidingPercentile(maxWeight);
        this.clock = clock;
        this.resetOnNetworkTypeChange = resetOnNetworkTypeChange;
        if (context != null) {
            NetworkTypeObserver networkTypeObserver = NetworkTypeObserver.getInstance((Context)context);
            this.networkType = networkTypeObserver.getNetworkType();
            this.bitrateEstimate = this.getInitialBitrateEstimateForNetworkType(this.networkType);
            networkTypeObserver.register(this::onNetworkTypeChanged);
        } else {
            this.networkType = 0;
            this.bitrateEstimate = this.getInitialBitrateEstimateForNetworkType(0);
        }
    }

    public synchronized void setNetworkTypeOverride(int networkType) {
        this.networkTypeOverride = networkType;
        this.networkTypeOverrideSet = true;
        this.onNetworkTypeChanged(networkType);
    }

    @Override
    public synchronized long getBitrateEstimate() {
        return this.bitrateEstimate;
    }

    @Override
    public TransferListener getTransferListener() {
        return this;
    }

    @Override
    public void addEventListener(Handler eventHandler, BandwidthMeter.EventListener eventListener) {
        Assertions.checkNotNull((Object)eventHandler);
        Assertions.checkNotNull((Object)eventListener);
        this.eventDispatcher.addListener(eventHandler, eventListener);
    }

    @Override
    public void removeEventListener(BandwidthMeter.EventListener eventListener) {
        this.eventDispatcher.removeListener(eventListener);
    }

    public void onTransferInitializing(DataSource source, DataSpec dataSpec, boolean isNetwork) {
    }

    public synchronized void onTransferStart(DataSource source, DataSpec dataSpec, boolean isNetwork) {
        if (!DefaultBandwidthMeter.isTransferAtFullNetworkSpeed(dataSpec, isNetwork)) {
            return;
        }
        if (this.streamCount == 0) {
            this.sampleStartTimeMs = this.clock.elapsedRealtime();
        }
        ++this.streamCount;
    }

    public synchronized void onBytesTransferred(DataSource source, DataSpec dataSpec, boolean isNetwork, int bytesTransferred) {
        if (!DefaultBandwidthMeter.isTransferAtFullNetworkSpeed(dataSpec, isNetwork)) {
            return;
        }
        this.sampleBytesTransferred += (long)bytesTransferred;
    }

    public synchronized void onTransferEnd(DataSource source, DataSpec dataSpec, boolean isNetwork) {
        if (!DefaultBandwidthMeter.isTransferAtFullNetworkSpeed(dataSpec, isNetwork)) {
            return;
        }
        Assertions.checkState((this.streamCount > 0 ? 1 : 0) != 0);
        long nowMs = this.clock.elapsedRealtime();
        int sampleElapsedTimeMs = (int)(nowMs - this.sampleStartTimeMs);
        this.totalElapsedTimeMs += (long)sampleElapsedTimeMs;
        this.totalBytesTransferred += this.sampleBytesTransferred;
        if (sampleElapsedTimeMs > 0) {
            float bitsPerSecond = (float)this.sampleBytesTransferred * 8000.0f / (float)sampleElapsedTimeMs;
            this.slidingPercentile.addSample((int)Math.sqrt(this.sampleBytesTransferred), bitsPerSecond);
            if (this.totalElapsedTimeMs >= 2000L || this.totalBytesTransferred >= 524288L) {
                this.bitrateEstimate = (long)this.slidingPercentile.getPercentile(0.5f);
            }
            this.maybeNotifyBandwidthSample(sampleElapsedTimeMs, this.sampleBytesTransferred, this.bitrateEstimate);
            this.sampleStartTimeMs = nowMs;
            this.sampleBytesTransferred = 0L;
        }
        --this.streamCount;
    }

    private synchronized void onNetworkTypeChanged(int networkType) {
        if (this.networkType != 0 && !this.resetOnNetworkTypeChange) {
            return;
        }
        if (this.networkTypeOverrideSet) {
            networkType = this.networkTypeOverride;
        }
        if (this.networkType == networkType) {
            return;
        }
        this.networkType = networkType;
        if (networkType == 1 || networkType == 0 || networkType == 8) {
            return;
        }
        this.bitrateEstimate = this.getInitialBitrateEstimateForNetworkType(networkType);
        long nowMs = this.clock.elapsedRealtime();
        int sampleElapsedTimeMs = this.streamCount > 0 ? (int)(nowMs - this.sampleStartTimeMs) : 0;
        this.maybeNotifyBandwidthSample(sampleElapsedTimeMs, this.sampleBytesTransferred, this.bitrateEstimate);
        this.sampleStartTimeMs = nowMs;
        this.sampleBytesTransferred = 0L;
        this.totalBytesTransferred = 0L;
        this.totalElapsedTimeMs = 0L;
        this.slidingPercentile.reset();
    }

    @GuardedBy(value="this")
    private void maybeNotifyBandwidthSample(int elapsedMs, long bytesTransferred, long bitrateEstimate) {
        if (elapsedMs == 0 && bytesTransferred == 0L && bitrateEstimate == this.lastReportedBitrateEstimate) {
            return;
        }
        this.lastReportedBitrateEstimate = bitrateEstimate;
        this.eventDispatcher.bandwidthSample(elapsedMs, bytesTransferred, bitrateEstimate);
    }

    private long getInitialBitrateEstimateForNetworkType(int networkType) {
        Long initialBitrateEstimate = (Long)this.initialBitrateEstimates.get((Object)networkType);
        if (initialBitrateEstimate == null) {
            initialBitrateEstimate = (Long)this.initialBitrateEstimates.get((Object)0);
        }
        if (initialBitrateEstimate == null) {
            initialBitrateEstimate = 1000000L;
        }
        return initialBitrateEstimate;
    }

    private static boolean isTransferAtFullNetworkSpeed(DataSpec dataSpec, boolean isNetwork) {
        return isNetwork && !dataSpec.isFlagSet(8);
    }

    private static int[] getInitialBitrateCountryGroupAssignment(String country) {
        switch (country) {
            case "AE": {
                return new int[]{1, 4, 2, 3, 4, 1};
            }
            case "AL": {
                return new int[]{1, 1, 1, 2, 2, 2};
            }
            case "AO": {
                return new int[]{3, 4, 4, 3, 2, 2};
            }
            case "AR": {
                return new int[]{2, 2, 2, 2, 1, 2};
            }
            case "AS": {
                return new int[]{2, 2, 3, 3, 2, 2};
            }
            case "AU": {
                return new int[]{0, 3, 1, 1, 3, 0};
            }
            case "AW": {
                return new int[]{2, 2, 3, 4, 2, 2};
            }
            case "BD": {
                return new int[]{2, 1, 3, 2, 4, 2};
            }
            case "BE": {
                return new int[]{0, 0, 1, 0, 1, 2};
            }
            case "BH": {
                return new int[]{1, 3, 1, 3, 4, 2};
            }
            case "BJ": {
                return new int[]{4, 4, 2, 3, 2, 2};
            }
            case "BM": {
                return new int[]{0, 2, 0, 0, 2, 2};
            }
            case "BN": {
                return new int[]{3, 2, 0, 0, 2, 2};
            }
            case "BO": {
                return new int[]{1, 2, 4, 4, 2, 2};
            }
            case "BR": {
                return new int[]{1, 1, 1, 1, 2, 4};
            }
            case "BS": {
                return new int[]{3, 2, 1, 1, 2, 2};
            }
            case "BT": {
                return new int[]{3, 1, 2, 2, 3, 2};
            }
            case "BW": {
                return new int[]{3, 2, 1, 0, 2, 2};
            }
            case "BY": {
                return new int[]{1, 2, 3, 3, 2, 2};
            }
            case "CF": {
                return new int[]{4, 2, 4, 2, 2, 2};
            }
            case "CH": {
                return new int[]{0, 1, 0, 0, 0, 2};
            }
            case "AG": 
            case "CI": {
                return new int[]{2, 4, 3, 4, 2, 2};
            }
            case "BZ": 
            case "CK": {
                return new int[]{2, 2, 2, 1, 2, 2};
            }
            case "CN": {
                return new int[]{2, 0, 1, 1, 3, 1};
            }
            case "CO": {
                return new int[]{2, 3, 3, 2, 2, 2};
            }
            case "CV": {
                return new int[]{2, 3, 0, 1, 2, 2};
            }
            case "CY": {
                return new int[]{1, 0, 1, 0, 0, 2};
            }
            case "CZ": {
                return new int[]{0, 0, 2, 0, 1, 2};
            }
            case "DE": {
                return new int[]{0, 1, 4, 2, 2, 1};
            }
            case "DK": {
                return new int[]{0, 0, 2, 0, 0, 2};
            }
            case "EC": {
                return new int[]{1, 3, 2, 1, 2, 2};
            }
            case "ES": {
                return new int[]{0, 0, 0, 0, 1, 0};
            }
            case "ET": {
                return new int[]{4, 3, 4, 4, 4, 2};
            }
            case "FI": {
                return new int[]{0, 0, 0, 1, 0, 2};
            }
            case "FJ": {
                return new int[]{3, 2, 2, 3, 2, 2};
            }
            case "FM": {
                return new int[]{4, 2, 4, 0, 2, 2};
            }
            case "FO": {
                return new int[]{0, 2, 2, 0, 2, 2};
            }
            case "FR": {
                return new int[]{1, 1, 1, 1, 0, 2};
            }
            case "GA": {
                return new int[]{3, 4, 0, 0, 2, 2};
            }
            case "GB": {
                return new int[]{1, 1, 3, 2, 2, 2};
            }
            case "GD": {
                return new int[]{2, 2, 0, 0, 2, 2};
            }
            case "GE": {
                return new int[]{1, 1, 0, 2, 2, 2};
            }
            case "GF": {
                return new int[]{3, 2, 3, 3, 2, 2};
            }
            case "GG": {
                return new int[]{0, 2, 1, 1, 2, 2};
            }
            case "GH": {
                return new int[]{3, 3, 3, 2, 2, 2};
            }
            case "GN": {
                return new int[]{3, 4, 4, 2, 2, 2};
            }
            case "GP": {
                return new int[]{2, 1, 1, 3, 2, 2};
            }
            case "GR": {
                return new int[]{1, 0, 0, 0, 1, 2};
            }
            case "GT": {
                return new int[]{2, 1, 2, 1, 2, 2};
            }
            case "GU": {
                return new int[]{2, 2, 4, 3, 3, 2};
            }
            case "GW": {
                return new int[]{4, 4, 1, 2, 2, 2};
            }
            case "GY": {
                return new int[]{3, 1, 1, 3, 2, 2};
            }
            case "HK": {
                return new int[]{0, 1, 0, 1, 1, 0};
            }
            case "ID": {
                return new int[]{3, 1, 3, 3, 2, 4};
            }
            case "IE": {
                return new int[]{1, 1, 1, 1, 1, 2};
            }
            case "IL": {
                return new int[]{1, 2, 2, 3, 4, 2};
            }
            case "IN": {
                return new int[]{1, 1, 3, 2, 2, 3};
            }
            case "IO": {
                return new int[]{3, 2, 2, 0, 2, 2};
            }
            case "IQ": {
                return new int[]{3, 2, 3, 2, 2, 2};
            }
            case "IR": {
                return new int[]{4, 2, 3, 3, 4, 3};
            }
            case "IT": {
                return new int[]{0, 1, 1, 2, 1, 2};
            }
            case "GI": 
            case "IM": 
            case "JE": {
                return new int[]{0, 2, 0, 1, 2, 2};
            }
            case "JM": {
                return new int[]{2, 4, 3, 1, 2, 2};
            }
            case "JP": {
                return new int[]{0, 3, 2, 3, 4, 2};
            }
            case "KE": {
                return new int[]{3, 2, 1, 1, 1, 2};
            }
            case "KG": {
                return new int[]{2, 1, 1, 2, 2, 2};
            }
            case "KH": {
                return new int[]{1, 0, 4, 2, 2, 2};
            }
            case "KR": {
                return new int[]{0, 2, 2, 4, 4, 4};
            }
            case "HR": 
            case "KW": {
                return new int[]{1, 0, 0, 0, 0, 2};
            }
            case "KZ": {
                return new int[]{2, 1, 2, 2, 3, 2};
            }
            case "LA": {
                return new int[]{1, 2, 1, 3, 2, 2};
            }
            case "LB": {
                return new int[]{3, 1, 1, 2, 2, 2};
            }
            case "LC": {
                return new int[]{2, 2, 1, 1, 2, 2};
            }
            case "DO": 
            case "LR": {
                return new int[]{3, 4, 4, 4, 2, 2};
            }
            case "LT": {
                return new int[]{0, 1, 0, 1, 0, 2};
            }
            case "LU": {
                return new int[]{4, 0, 3, 2, 1, 3};
            }
            case "MA": {
                return new int[]{3, 3, 1, 1, 2, 2};
            }
            case "GL": 
            case "MC": {
                return new int[]{1, 2, 2, 0, 2, 2};
            }
            case "MD": {
                return new int[]{1, 0, 0, 0, 2, 2};
            }
            case "ME": {
                return new int[]{2, 0, 0, 1, 3, 2};
            }
            case "MF": {
                return new int[]{1, 2, 2, 3, 2, 2};
            }
            case "CG": 
            case "EG": 
            case "MG": {
                return new int[]{3, 4, 3, 3, 2, 2};
            }
            case "MK": {
                return new int[]{1, 0, 0, 1, 3, 2};
            }
            case "CD": 
            case "ML": {
                return new int[]{3, 3, 2, 2, 2, 2};
            }
            case "LK": 
            case "MM": {
                return new int[]{3, 2, 3, 3, 4, 2};
            }
            case "MN": {
                return new int[]{2, 0, 2, 2, 2, 2};
            }
            case "MO": {
                return new int[]{0, 2, 4, 4, 3, 1};
            }
            case "MQ": {
                return new int[]{2, 1, 2, 3, 2, 2};
            }
            case "CM": 
            case "MR": {
                return new int[]{4, 3, 3, 4, 2, 2};
            }
            case "MU": {
                return new int[]{3, 1, 0, 2, 2, 2};
            }
            case "MV": {
                return new int[]{3, 2, 1, 3, 4, 2};
            }
            case "MW": {
                return new int[]{3, 2, 2, 1, 2, 2};
            }
            case "MX": {
                return new int[]{2, 4, 4, 4, 3, 2};
            }
            case "MY": {
                return new int[]{1, 0, 4, 1, 1, 0};
            }
            case "NA": {
                return new int[]{3, 4, 3, 2, 2, 2};
            }
            case "NG": {
                return new int[]{3, 4, 2, 1, 2, 2};
            }
            case "CR": 
            case "NI": {
                return new int[]{2, 4, 4, 4, 2, 2};
            }
            case "NL": {
                return new int[]{2, 1, 4, 3, 0, 4};
            }
            case "NO": {
                return new int[]{0, 0, 3, 0, 0, 2};
            }
            case "NP": {
                return new int[]{2, 2, 4, 3, 2, 2};
            }
            case "NZ": {
                return new int[]{0, 0, 1, 2, 4, 2};
            }
            case "OM": {
                return new int[]{2, 3, 1, 2, 4, 2};
            }
            case "AM": 
            case "PA": {
                return new int[]{2, 3, 2, 3, 2, 2};
            }
            case "PE": {
                return new int[]{1, 2, 4, 4, 3, 2};
            }
            case "PF": {
                return new int[]{2, 2, 3, 1, 2, 2};
            }
            case "LS": 
            case "PG": {
                return new int[]{4, 3, 3, 3, 2, 2};
            }
            case "PH": {
                return new int[]{2, 1, 2, 3, 2, 1};
            }
            case "PK": {
                return new int[]{3, 3, 3, 3, 2, 2};
            }
            case "PL": {
                return new int[]{1, 0, 2, 2, 4, 4};
            }
            case "PR": {
                return new int[]{2, 0, 2, 1, 2, 0};
            }
            case "PS": {
                return new int[]{3, 4, 1, 3, 2, 2};
            }
            case "PW": {
                return new int[]{2, 2, 4, 1, 2, 2};
            }
            case "BL": 
            case "MP": 
            case "PY": {
                return new int[]{1, 2, 2, 2, 2, 2};
            }
            case "QA": {
                return new int[]{1, 4, 4, 4, 4, 2};
            }
            case "RE": {
                return new int[]{0, 3, 2, 3, 1, 2};
            }
            case "RO": {
                return new int[]{0, 0, 1, 1, 3, 2};
            }
            case "RS": {
                return new int[]{1, 0, 0, 1, 2, 2};
            }
            case "RU": {
                return new int[]{1, 0, 0, 1, 3, 3};
            }
            case "RW": {
                return new int[]{3, 3, 2, 0, 2, 2};
            }
            case "SA": {
                return new int[]{3, 1, 1, 2, 2, 0};
            }
            case "AT": 
            case "EE": 
            case "HU": 
            case "IS": 
            case "LV": 
            case "MT": 
            case "SE": {
                return new int[]{0, 0, 0, 0, 0, 2};
            }
            case "SG": {
                return new int[]{2, 3, 3, 3, 1, 1};
            }
            case "AQ": 
            case "ER": 
            case "NU": 
            case "SC": 
            case "SH": {
                return new int[]{4, 2, 2, 2, 2, 2};
            }
            case "BG": 
            case "PT": 
            case "SI": {
                return new int[]{0, 0, 0, 0, 1, 2};
            }
            case "FK": 
            case "NF": 
            case "SJ": {
                return new int[]{3, 2, 2, 2, 2, 2};
            }
            case "SK": {
                return new int[]{0, 1, 1, 1, 2, 2};
            }
            case "AZ": 
            case "DJ": 
            case "LY": 
            case "SL": {
                return new int[]{4, 2, 3, 3, 2, 2};
            }
            case "SN": {
                return new int[]{4, 4, 3, 2, 2, 2};
            }
            case "SO": {
                return new int[]{2, 2, 3, 4, 4, 2};
            }
            case "SR": {
                return new int[]{2, 4, 4, 1, 2, 2};
            }
            case "GM": 
            case "SS": {
                return new int[]{4, 3, 2, 4, 2, 2};
            }
            case "ST": {
                return new int[]{2, 2, 1, 2, 2, 2};
            }
            case "SV": {
                return new int[]{2, 3, 2, 1, 2, 2};
            }
            case "AF": 
            case "SZ": {
                return new int[]{4, 4, 3, 4, 2, 2};
            }
            case "TC": {
                return new int[]{3, 2, 1, 2, 2, 2};
            }
            case "BF": 
            case "SD": 
            case "SY": 
            case "TD": {
                return new int[]{4, 3, 4, 4, 2, 2};
            }
            case "TG": {
                return new int[]{3, 4, 1, 0, 2, 2};
            }
            case "CL": 
            case "TH": {
                return new int[]{0, 1, 2, 2, 2, 2};
            }
            case "DZ": 
            case "TJ": {
                return new int[]{3, 3, 4, 4, 2, 2};
            }
            case "CU": 
            case "KI": 
            case "NR": 
            case "TL": {
                return new int[]{4, 2, 4, 4, 2, 2};
            }
            case "TN": {
                return new int[]{3, 1, 1, 1, 2, 2};
            }
            case "TO": {
                return new int[]{3, 2, 4, 3, 2, 2};
            }
            case "BA": 
            case "JO": 
            case "TR": {
                return new int[]{1, 1, 1, 1, 2, 2};
            }
            case "TT": {
                return new int[]{2, 4, 1, 0, 2, 2};
            }
            case "TW": {
                return new int[]{0, 0, 0, 0, 0, 0};
            }
            case "TZ": {
                return new int[]{3, 4, 2, 1, 3, 2};
            }
            case "CA": 
            case "UA": {
                return new int[]{0, 2, 1, 2, 3, 3};
            }
            case "UG": {
                return new int[]{3, 3, 2, 3, 4, 2};
            }
            case "US": {
                return new int[]{2, 2, 4, 1, 3, 1};
            }
            case "UY": {
                return new int[]{2, 1, 1, 2, 1, 2};
            }
            case "UZ": {
                return new int[]{1, 2, 3, 4, 3, 2};
            }
            case "AX": 
            case "CX": 
            case "LI": 
            case "MS": 
            case "PM": 
            case "SM": 
            case "VA": {
                return new int[]{0, 2, 2, 2, 2, 2};
            }
            case "AD": 
            case "AI": 
            case "BB": 
            case "BQ": 
            case "CW": 
            case "DM": 
            case "KN": 
            case "KY": 
            case "SX": 
            case "VC": {
                return new int[]{1, 2, 0, 0, 2, 2};
            }
            case "VG": {
                return new int[]{2, 2, 1, 1, 2, 4};
            }
            case "VI": {
                return new int[]{0, 2, 1, 2, 2, 2};
            }
            case "VN": {
                return new int[]{0, 0, 1, 2, 2, 2};
            }
            case "KM": 
            case "VU": {
                return new int[]{4, 3, 3, 2, 2, 2};
            }
            case "MH": 
            case "TM": 
            case "TV": 
            case "WF": {
                return new int[]{4, 2, 2, 4, 2, 2};
            }
            case "MZ": 
            case "WS": {
                return new int[]{3, 1, 2, 2, 2, 2};
            }
            case "XK": {
                return new int[]{1, 2, 1, 1, 2, 2};
            }
            case "BI": 
            case "GQ": 
            case "HT": 
            case "NE": 
            case "VE": 
            case "YE": {
                return new int[]{4, 4, 4, 4, 2, 2};
            }
            case "NC": 
            case "YT": {
                return new int[]{2, 3, 3, 4, 2, 2};
            }
            case "ZA": {
                return new int[]{2, 4, 2, 1, 1, 2};
            }
            case "ZM": {
                return new int[]{4, 4, 4, 3, 2, 2};
            }
            case "SB": 
            case "ZW": {
                return new int[]{4, 2, 4, 3, 2, 2};
            }
        }
        return new int[]{2, 2, 2, 2, 2, 2};
    }

    public static final class Builder {
        @Nullable
        private final Context context;
        private Map<Integer, Long> initialBitrateEstimates;
        private int slidingWindowMaxWeight;
        private Clock clock;
        private boolean resetOnNetworkTypeChange;

        public Builder(Context context) {
            this.context = context == null ? null : context.getApplicationContext();
            this.initialBitrateEstimates = Builder.getInitialBitrateEstimatesForCountry(Util.getCountryCode((Context)context));
            this.slidingWindowMaxWeight = 2000;
            this.clock = Clock.DEFAULT;
            this.resetOnNetworkTypeChange = true;
        }

        @CanIgnoreReturnValue
        public Builder setSlidingWindowMaxWeight(int slidingWindowMaxWeight) {
            this.slidingWindowMaxWeight = slidingWindowMaxWeight;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInitialBitrateEstimate(long initialBitrateEstimate) {
            for (Integer networkType : this.initialBitrateEstimates.keySet()) {
                this.setInitialBitrateEstimate(networkType, initialBitrateEstimate);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInitialBitrateEstimate(int networkType, long initialBitrateEstimate) {
            this.initialBitrateEstimates.put(networkType, initialBitrateEstimate);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInitialBitrateEstimate(String countryCode) {
            this.initialBitrateEstimates = Builder.getInitialBitrateEstimatesForCountry(Ascii.toUpperCase((String)countryCode));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setResetOnNetworkTypeChange(boolean resetOnNetworkTypeChange) {
            this.resetOnNetworkTypeChange = resetOnNetworkTypeChange;
            return this;
        }

        public DefaultBandwidthMeter build() {
            return new DefaultBandwidthMeter(this.context, this.initialBitrateEstimates, this.slidingWindowMaxWeight, this.clock, this.resetOnNetworkTypeChange);
        }

        private static Map<Integer, Long> getInitialBitrateEstimatesForCountry(String countryCode) {
            int[] groupIndices = DefaultBandwidthMeter.getInitialBitrateCountryGroupAssignment(countryCode);
            HashMap<Integer, Long> result = new HashMap<Integer, Long>(8);
            result.put(0, 1000000L);
            result.put(2, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_WIFI.get(groupIndices[0]));
            result.put(3, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_2G.get(groupIndices[1]));
            result.put(4, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_3G.get(groupIndices[2]));
            result.put(5, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_4G.get(groupIndices[3]));
            result.put(10, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_5G_NSA.get(groupIndices[4]));
            result.put(9, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_5G_SA.get(groupIndices[5]));
            result.put(7, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_WIFI.get(groupIndices[0]));
            return result;
        }
    }
}

