/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.util;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Metadata;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.Timeline;
import androidx.media3.common.Tracks;
import androidx.media3.common.VideoSize;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.DecoderCounters;
import androidx.media3.exoplayer.DecoderReuseEvaluation;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.audio.AudioSink;
import androidx.media3.exoplayer.source.LoadEventInfo;
import androidx.media3.exoplayer.source.MediaLoadData;
import androidx.media3.exoplayer.trackselection.MappingTrackSelector;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;

public class EventLogger
implements AnalyticsListener {
    private static final String DEFAULT_TAG = "EventLogger";
    private static final int MAX_TIMELINE_ITEM_LINES = 3;
    private static final NumberFormat TIME_FORMAT = NumberFormat.getInstance(Locale.US);
    private final String tag;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private final long startTimeMs;

    public EventLogger() {
        this(DEFAULT_TAG);
    }

    public EventLogger(String tag) {
        this.tag = tag;
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        this.startTimeMs = SystemClock.elapsedRealtime();
    }

    @Deprecated
    @UnstableApi
    public EventLogger(@Nullable MappingTrackSelector trackSelector) {
        this(DEFAULT_TAG);
    }

    @Deprecated
    @UnstableApi
    public EventLogger(@Nullable MappingTrackSelector trackSelector, String tag) {
        this(tag);
    }

    @Override
    @UnstableApi
    public void onIsLoadingChanged(AnalyticsListener.EventTime eventTime, boolean isLoading) {
        this.logd(eventTime, "loading", Boolean.toString(isLoading));
    }

    @Override
    @UnstableApi
    public void onPlaybackStateChanged(AnalyticsListener.EventTime eventTime, int state) {
        this.logd(eventTime, "state", EventLogger.getStateString(state));
    }

    @Override
    @UnstableApi
    public void onPlayWhenReadyChanged(AnalyticsListener.EventTime eventTime, boolean playWhenReady, int reason) {
        this.logd(eventTime, "playWhenReady", playWhenReady + ", " + EventLogger.getPlayWhenReadyChangeReasonString(reason));
    }

    @Override
    @UnstableApi
    public void onPlaybackSuppressionReasonChanged(AnalyticsListener.EventTime eventTime, int playbackSuppressionReason) {
        this.logd(eventTime, "playbackSuppressionReason", EventLogger.getPlaybackSuppressionReasonString(playbackSuppressionReason));
    }

    @Override
    @UnstableApi
    public void onIsPlayingChanged(AnalyticsListener.EventTime eventTime, boolean isPlaying) {
        this.logd(eventTime, "isPlaying", Boolean.toString(isPlaying));
    }

    @Override
    @UnstableApi
    public void onRepeatModeChanged(AnalyticsListener.EventTime eventTime, int repeatMode) {
        this.logd(eventTime, "repeatMode", EventLogger.getRepeatModeString(repeatMode));
    }

    @Override
    @UnstableApi
    public void onShuffleModeChanged(AnalyticsListener.EventTime eventTime, boolean shuffleModeEnabled) {
        this.logd(eventTime, "shuffleModeEnabled", Boolean.toString(shuffleModeEnabled));
    }

    @Override
    @UnstableApi
    public void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
        StringBuilder builder = new StringBuilder();
        builder.append("reason=").append(EventLogger.getDiscontinuityReasonString(reason)).append(", PositionInfo:old [").append("mediaItem=").append(oldPosition.mediaItemIndex).append(", period=").append(oldPosition.periodIndex).append(", pos=").append(oldPosition.positionMs);
        if (oldPosition.adGroupIndex != -1) {
            builder.append(", contentPos=").append(oldPosition.contentPositionMs).append(", adGroup=").append(oldPosition.adGroupIndex).append(", ad=").append(oldPosition.adIndexInAdGroup);
        }
        builder.append("], PositionInfo:new [").append("mediaItem=").append(newPosition.mediaItemIndex).append(", period=").append(newPosition.periodIndex).append(", pos=").append(newPosition.positionMs);
        if (newPosition.adGroupIndex != -1) {
            builder.append(", contentPos=").append(newPosition.contentPositionMs).append(", adGroup=").append(newPosition.adGroupIndex).append(", ad=").append(newPosition.adIndexInAdGroup);
        }
        builder.append("]");
        this.logd(eventTime, "positionDiscontinuity", builder.toString());
    }

    @Override
    @UnstableApi
    public void onPlaybackParametersChanged(AnalyticsListener.EventTime eventTime, PlaybackParameters playbackParameters) {
        this.logd(eventTime, "playbackParameters", playbackParameters.toString());
    }

    @Override
    @UnstableApi
    public void onTimelineChanged(AnalyticsListener.EventTime eventTime, int reason) {
        int i;
        int periodCount = eventTime.timeline.getPeriodCount();
        int windowCount = eventTime.timeline.getWindowCount();
        this.logd("timeline [" + this.getEventTimeString(eventTime) + ", periodCount=" + periodCount + ", windowCount=" + windowCount + ", reason=" + EventLogger.getTimelineChangeReasonString(reason));
        for (i = 0; i < Math.min(periodCount, 3); ++i) {
            eventTime.timeline.getPeriod(i, this.period);
            this.logd("  period [" + EventLogger.getTimeString(this.period.getDurationMs()) + "]");
        }
        if (periodCount > 3) {
            this.logd("  ...");
        }
        for (i = 0; i < Math.min(windowCount, 3); ++i) {
            eventTime.timeline.getWindow(i, this.window);
            this.logd("  window [" + EventLogger.getTimeString(this.window.getDurationMs()) + ", seekable=" + this.window.isSeekable + ", dynamic=" + this.window.isDynamic + "]");
        }
        if (windowCount > 3) {
            this.logd("  ...");
        }
        this.logd("]");
    }

    @Override
    @UnstableApi
    public void onMediaItemTransition(AnalyticsListener.EventTime eventTime, @Nullable MediaItem mediaItem, int reason) {
        this.logd("mediaItem [" + this.getEventTimeString(eventTime) + ", reason=" + EventLogger.getMediaItemTransitionReasonString(reason) + "]");
    }

    @Override
    @UnstableApi
    public void onPlayerError(AnalyticsListener.EventTime eventTime, PlaybackException error) {
        this.loge(eventTime, "playerFailed", (Throwable)error);
    }

    @Override
    @UnstableApi
    public void onTracksChanged(AnalyticsListener.EventTime eventTime, Tracks tracks) {
        this.logd("tracks [" + this.getEventTimeString(eventTime));
        ImmutableList trackGroups = tracks.getGroups();
        for (int groupIndex = 0; groupIndex < trackGroups.size(); ++groupIndex) {
            Tracks.Group trackGroup = (Tracks.Group)trackGroups.get(groupIndex);
            this.logd("  group [");
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                String status = EventLogger.getTrackStatusString(trackGroup.isTrackSelected(trackIndex));
                String formatSupport = Util.getFormatSupportString((int)trackGroup.getTrackSupport(trackIndex));
                this.logd("    " + status + " Track:" + trackIndex + ", " + Format.toLogString((Format)trackGroup.getTrackFormat(trackIndex)) + ", supported=" + formatSupport);
            }
            this.logd("  ]");
        }
        boolean loggedMetadata = false;
        for (int groupIndex = 0; !loggedMetadata && groupIndex < trackGroups.size(); ++groupIndex) {
            Tracks.Group trackGroup = (Tracks.Group)trackGroups.get(groupIndex);
            for (int trackIndex = 0; !loggedMetadata && trackIndex < trackGroup.length; ++trackIndex) {
                Metadata metadata;
                if (!trackGroup.isTrackSelected(trackIndex) || (metadata = trackGroup.getTrackFormat((int)trackIndex).metadata) == null || metadata.length() <= 0) continue;
                this.logd("  Metadata [");
                this.printMetadata(metadata, "    ");
                this.logd("  ]");
                loggedMetadata = true;
            }
        }
        this.logd("]");
    }

    @Override
    @UnstableApi
    public void onMetadata(AnalyticsListener.EventTime eventTime, Metadata metadata) {
        this.logd("metadata [" + this.getEventTimeString(eventTime));
        this.printMetadata(metadata, "  ");
        this.logd("]");
    }

    @Override
    @UnstableApi
    public void onAudioEnabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
        this.logd(eventTime, "audioEnabled");
    }

    @Override
    @UnstableApi
    public void onAudioDecoderInitialized(AnalyticsListener.EventTime eventTime, String decoderName, long initializedTimestampMs, long initializationDurationMs) {
        this.logd(eventTime, "audioDecoderInitialized", decoderName);
    }

    @Override
    @UnstableApi
    public void onAudioInputFormatChanged(AnalyticsListener.EventTime eventTime, Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
        this.logd(eventTime, "audioInputFormat", Format.toLogString((Format)format));
    }

    @Override
    @UnstableApi
    public void onAudioUnderrun(AnalyticsListener.EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
        this.loge(eventTime, "audioTrackUnderrun", bufferSize + ", " + bufferSizeMs + ", " + elapsedSinceLastFeedMs, null);
    }

    @Override
    @UnstableApi
    public void onAudioDecoderReleased(AnalyticsListener.EventTime eventTime, String decoderName) {
        this.logd(eventTime, "audioDecoderReleased", decoderName);
    }

    @Override
    @UnstableApi
    public void onAudioDisabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
        this.logd(eventTime, "audioDisabled");
    }

    @Override
    @UnstableApi
    public void onAudioSessionIdChanged(AnalyticsListener.EventTime eventTime, int audioSessionId) {
        this.logd(eventTime, "audioSessionId", Integer.toString(audioSessionId));
    }

    @Override
    @UnstableApi
    public void onAudioAttributesChanged(AnalyticsListener.EventTime eventTime, AudioAttributes audioAttributes) {
        this.logd(eventTime, "audioAttributes", audioAttributes.contentType + "," + audioAttributes.flags + "," + audioAttributes.usage + "," + audioAttributes.allowedCapturePolicy);
    }

    @Override
    @UnstableApi
    public void onSkipSilenceEnabledChanged(AnalyticsListener.EventTime eventTime, boolean skipSilenceEnabled) {
        this.logd(eventTime, "skipSilenceEnabled", Boolean.toString(skipSilenceEnabled));
    }

    @Override
    @UnstableApi
    public void onVolumeChanged(AnalyticsListener.EventTime eventTime, float volume) {
        this.logd(eventTime, "volume", Float.toString(volume));
    }

    @Override
    @UnstableApi
    public void onAudioTrackInitialized(AnalyticsListener.EventTime eventTime, AudioSink.AudioTrackConfig audioTrackConfig) {
        this.logd(eventTime, "audioTrackInit", EventLogger.getAudioTrackConfigString(audioTrackConfig));
    }

    @Override
    @UnstableApi
    public void onAudioTrackReleased(AnalyticsListener.EventTime eventTime, AudioSink.AudioTrackConfig audioTrackConfig) {
        this.logd(eventTime, "audioTrackReleased", EventLogger.getAudioTrackConfigString(audioTrackConfig));
    }

    @Override
    @UnstableApi
    public void onVideoEnabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
        this.logd(eventTime, "videoEnabled");
    }

    @Override
    @UnstableApi
    public void onVideoDecoderInitialized(AnalyticsListener.EventTime eventTime, String decoderName, long initializedTimestampMs, long initializationDurationMs) {
        this.logd(eventTime, "videoDecoderInitialized", decoderName);
    }

    @Override
    @UnstableApi
    public void onVideoInputFormatChanged(AnalyticsListener.EventTime eventTime, Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
        this.logd(eventTime, "videoInputFormat", Format.toLogString((Format)format));
    }

    @Override
    @UnstableApi
    public void onDroppedVideoFrames(AnalyticsListener.EventTime eventTime, int droppedFrames, long elapsedMs) {
        this.logd(eventTime, "droppedFrames", Integer.toString(droppedFrames));
    }

    @Override
    @UnstableApi
    public void onVideoDecoderReleased(AnalyticsListener.EventTime eventTime, String decoderName) {
        this.logd(eventTime, "videoDecoderReleased", decoderName);
    }

    @Override
    @UnstableApi
    public void onVideoDisabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
        this.logd(eventTime, "videoDisabled");
    }

    @Override
    @UnstableApi
    public void onRenderedFirstFrame(AnalyticsListener.EventTime eventTime, Object output, long renderTimeMs) {
        this.logd(eventTime, "renderedFirstFrame", String.valueOf(output));
    }

    @Override
    @UnstableApi
    public void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, VideoSize videoSize) {
        this.logd(eventTime, "videoSize", videoSize.width + ", " + videoSize.height);
    }

    @Override
    @UnstableApi
    public void onLoadStarted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @Override
    @UnstableApi
    public void onLoadError(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        this.printInternalError(eventTime, "loadError", error);
    }

    @Override
    @UnstableApi
    public void onLoadCanceled(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @Override
    @UnstableApi
    public void onLoadCompleted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @Override
    @UnstableApi
    public void onBandwidthEstimate(AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
    }

    @Override
    @UnstableApi
    public void onSurfaceSizeChanged(AnalyticsListener.EventTime eventTime, int width, int height) {
        this.logd(eventTime, "surfaceSize", width + ", " + height);
    }

    @Override
    @UnstableApi
    public void onUpstreamDiscarded(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
        this.logd(eventTime, "upstreamDiscarded", Format.toLogString((Format)mediaLoadData.trackFormat));
    }

    @Override
    @UnstableApi
    public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
        this.logd(eventTime, "downstreamFormat", Format.toLogString((Format)mediaLoadData.trackFormat));
    }

    @Override
    @UnstableApi
    public void onDrmSessionAcquired(AnalyticsListener.EventTime eventTime, int state) {
        this.logd(eventTime, "drmSessionAcquired", "state=" + state);
    }

    @Override
    @UnstableApi
    public void onDrmSessionManagerError(AnalyticsListener.EventTime eventTime, Exception error) {
        this.printInternalError(eventTime, "drmSessionManagerError", error);
    }

    @Override
    @UnstableApi
    public void onDrmKeysRestored(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmKeysRestored");
    }

    @Override
    @UnstableApi
    public void onDrmKeysRemoved(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmKeysRemoved");
    }

    @Override
    @UnstableApi
    public void onDrmKeysLoaded(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmKeysLoaded");
    }

    @Override
    @UnstableApi
    public void onDrmSessionReleased(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmSessionReleased");
    }

    @UnstableApi
    protected void logd(String msg) {
        Log.d((String)this.tag, (String)msg);
    }

    @UnstableApi
    protected void loge(String msg) {
        Log.e((String)this.tag, (String)msg);
    }

    private void logd(AnalyticsListener.EventTime eventTime, String eventName) {
        this.logd(this.getEventString(eventTime, eventName, null, null));
    }

    private void logd(AnalyticsListener.EventTime eventTime, String eventName, String eventDescription) {
        this.logd(this.getEventString(eventTime, eventName, eventDescription, null));
    }

    private void loge(AnalyticsListener.EventTime eventTime, String eventName, @Nullable Throwable throwable) {
        this.loge(this.getEventString(eventTime, eventName, null, throwable));
    }

    private void loge(AnalyticsListener.EventTime eventTime, String eventName, String eventDescription, @Nullable Throwable throwable) {
        this.loge(this.getEventString(eventTime, eventName, eventDescription, throwable));
    }

    private void printInternalError(AnalyticsListener.EventTime eventTime, String type, Exception e) {
        this.loge(eventTime, "internalError", type, e);
    }

    private void printMetadata(Metadata metadata, String prefix) {
        for (int i = 0; i < metadata.length(); ++i) {
            this.logd(prefix + metadata.get(i));
        }
    }

    private String getEventString(AnalyticsListener.EventTime eventTime, String eventName, @Nullable String eventDescription, @Nullable Throwable throwable) {
        String throwableString;
        String eventString = eventName + " [" + this.getEventTimeString(eventTime);
        if (throwable instanceof PlaybackException) {
            eventString = eventString + ", errorCode=" + ((PlaybackException)throwable).getErrorCodeName();
        }
        if (eventDescription != null) {
            eventString = eventString + ", " + eventDescription;
        }
        if (!TextUtils.isEmpty((CharSequence)(throwableString = Log.getThrowableString((Throwable)throwable)))) {
            eventString = eventString + "\n  " + throwableString.replace("\n", "\n  ") + '\n';
        }
        eventString = eventString + "]";
        return eventString;
    }

    private String getEventTimeString(AnalyticsListener.EventTime eventTime) {
        String windowPeriodString = "window=" + eventTime.windowIndex;
        if (eventTime.mediaPeriodId != null) {
            windowPeriodString = windowPeriodString + ", period=" + eventTime.timeline.getIndexOfPeriod(eventTime.mediaPeriodId.periodUid);
            if (eventTime.mediaPeriodId.isAd()) {
                windowPeriodString = windowPeriodString + ", adGroup=" + eventTime.mediaPeriodId.adGroupIndex;
                windowPeriodString = windowPeriodString + ", ad=" + eventTime.mediaPeriodId.adIndexInAdGroup;
            }
        }
        return "eventTime=" + EventLogger.getTimeString(eventTime.realtimeMs - this.startTimeMs) + ", mediaPos=" + EventLogger.getTimeString(eventTime.eventPlaybackPositionMs) + ", " + windowPeriodString;
    }

    private static String getTimeString(long timeMs) {
        return timeMs == -9223372036854775807L ? "?" : TIME_FORMAT.format((float)timeMs / 1000.0f);
    }

    private static String getStateString(int state) {
        switch (state) {
            case 2: {
                return "BUFFERING";
            }
            case 4: {
                return "ENDED";
            }
            case 1: {
                return "IDLE";
            }
            case 3: {
                return "READY";
            }
        }
        return "?";
    }

    private static String getTrackStatusString(boolean selected) {
        return selected ? "[X]" : "[ ]";
    }

    private static String getRepeatModeString(int repeatMode) {
        switch (repeatMode) {
            case 0: {
                return "OFF";
            }
            case 1: {
                return "ONE";
            }
            case 2: {
                return "ALL";
            }
        }
        return "?";
    }

    private static String getDiscontinuityReasonString(int reason) {
        switch (reason) {
            case 0: {
                return "AUTO_TRANSITION";
            }
            case 1: {
                return "SEEK";
            }
            case 2: {
                return "SEEK_ADJUSTMENT";
            }
            case 4: {
                return "REMOVE";
            }
            case 3: {
                return "SKIP";
            }
            case 5: {
                return "INTERNAL";
            }
            case 6: {
                return "SILENCE_SKIP";
            }
        }
        return "?";
    }

    private static String getTimelineChangeReasonString(int reason) {
        switch (reason) {
            case 1: {
                return "SOURCE_UPDATE";
            }
            case 0: {
                return "PLAYLIST_CHANGED";
            }
        }
        return "?";
    }

    private static String getMediaItemTransitionReasonString(int reason) {
        switch (reason) {
            case 1: {
                return "AUTO";
            }
            case 3: {
                return "PLAYLIST_CHANGED";
            }
            case 0: {
                return "REPEAT";
            }
            case 2: {
                return "SEEK";
            }
        }
        return "?";
    }

    private static String getPlaybackSuppressionReasonString(int playbackSuppressionReason) {
        switch (playbackSuppressionReason) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "TRANSIENT_AUDIO_FOCUS_LOSS";
            }
        }
        return "?";
    }

    private static String getPlayWhenReadyChangeReasonString(int reason) {
        switch (reason) {
            case 3: {
                return "AUDIO_BECOMING_NOISY";
            }
            case 2: {
                return "AUDIO_FOCUS_LOSS";
            }
            case 4: {
                return "REMOTE";
            }
            case 1: {
                return "USER_REQUEST";
            }
            case 5: {
                return "END_OF_MEDIA_ITEM";
            }
        }
        return "?";
    }

    private static String getAudioTrackConfigString(AudioSink.AudioTrackConfig audioTrackConfig) {
        return audioTrackConfig.encoding + "," + audioTrackConfig.channelConfig + "," + audioTrackConfig.sampleRate + "," + audioTrackConfig.tunneling + "," + audioTrackConfig.offload + "," + audioTrackConfig.bufferSize;
    }

    static {
        TIME_FORMAT.setMinimumFractionDigits(2);
        TIME_FORMAT.setMaximumFractionDigits(2);
        TIME_FORMAT.setGroupingUsed(false);
    }
}

