/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Looper;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.FloatRange;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DebugViewProvider;
import androidx.media3.common.Effect;
import androidx.media3.common.Format;
import androidx.media3.common.FrameInfo;
import androidx.media3.common.PreviewingVideoGraph;
import androidx.media3.common.SurfaceInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.VideoFrameProcessor;
import androidx.media3.common.VideoGraph;
import androidx.media3.common.VideoSize;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.HandlerWrapper;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.TimestampIterator;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.video.VideoFrameMetadataListener;
import androidx.media3.exoplayer.video.VideoFrameReleaseControl;
import androidx.media3.exoplayer.video.VideoFrameRenderControl;
import androidx.media3.exoplayer.video.VideoSink;
import androidx.media3.exoplayer.video.VideoSinkProvider;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CompositingVideoSinkProvider
implements VideoSinkProvider,
VideoGraph.Listener,
VideoFrameRenderControl.FrameRenderer {
    private static final int STATE_CREATED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_RELEASED = 2;
    private static final Executor NO_OP_EXECUTOR = runnable -> {};
    private final Context context;
    private final PreviewingVideoGraph.Factory previewingVideoGraphFactory;
    private Clock clock;
    private @MonotonicNonNull VideoFrameReleaseControl videoFrameReleaseControl;
    private @MonotonicNonNull VideoFrameRenderControl videoFrameRenderControl;
    private @MonotonicNonNull Format outputFormat;
    private @MonotonicNonNull VideoFrameMetadataListener videoFrameMetadataListener;
    private @MonotonicNonNull HandlerWrapper handler;
    private @MonotonicNonNull PreviewingVideoGraph videoGraph;
    private @MonotonicNonNull VideoSinkImpl videoSinkImpl;
    private @MonotonicNonNull List<Effect> videoEffects;
    @Nullable
    private Pair<Surface, Size> currentSurfaceAndSize;
    private VideoSink.Listener listener;
    private Executor listenerExecutor;
    private int pendingFlushCount;
    private int state;

    private CompositingVideoSinkProvider(Builder builder) {
        this.context = builder.context;
        this.previewingVideoGraphFactory = (PreviewingVideoGraph.Factory)Assertions.checkStateNotNull((Object)builder.previewingVideoGraphFactory);
        this.clock = Clock.DEFAULT;
        this.listener = VideoSink.Listener.NO_OP;
        this.listenerExecutor = NO_OP_EXECUTOR;
        this.state = 0;
    }

    @Override
    public void initialize(Format sourceFormat) throws VideoSink.VideoSinkException {
        ColorInfo inputColorInfo;
        Assertions.checkState((this.state == 0 ? 1 : 0) != 0);
        Assertions.checkStateNotNull(this.videoEffects);
        Assertions.checkState((this.videoFrameRenderControl != null && this.videoFrameReleaseControl != null ? 1 : 0) != 0);
        this.handler = this.clock.createHandler((Looper)Assertions.checkStateNotNull((Object)Looper.myLooper()), null);
        ColorInfo outputColorInfo = inputColorInfo = CompositingVideoSinkProvider.getAdjustedInputColorInfo(sourceFormat.colorInfo);
        if (inputColorInfo.colorTransfer == 7) {
            outputColorInfo = inputColorInfo.buildUpon().setColorTransfer(6).build();
        }
        try {
            CompositingVideoSinkProvider thisRef = this;
            this.videoGraph = this.previewingVideoGraphFactory.create(this.context, inputColorInfo, outputColorInfo, DebugViewProvider.NONE, (VideoGraph.Listener)thisRef, arg_0 -> ((HandlerWrapper)this.handler).post(arg_0), (List)ImmutableList.of(), 0L);
            if (this.currentSurfaceAndSize != null) {
                Surface surface = (Surface)this.currentSurfaceAndSize.first;
                Size size = (Size)this.currentSurfaceAndSize.second;
                this.maybeSetOutputSurfaceInfo(surface, size.getWidth(), size.getHeight());
            }
            this.videoSinkImpl = new VideoSinkImpl(this.context, this, this.videoGraph);
        }
        catch (VideoFrameProcessingException e) {
            throw new VideoSink.VideoSinkException(e, sourceFormat);
        }
        this.videoSinkImpl.setVideoEffects((List)Assertions.checkNotNull(this.videoEffects));
        this.state = 1;
    }

    @Override
    public boolean isInitialized() {
        return this.state == 1;
    }

    @Override
    public void release() {
        if (this.state == 2) {
            return;
        }
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
        if (this.videoGraph != null) {
            this.videoGraph.release();
        }
        this.currentSurfaceAndSize = null;
        this.state = 2;
    }

    @Override
    public VideoSink getSink() {
        return (VideoSink)Assertions.checkStateNotNull((Object)this.videoSinkImpl);
    }

    @Override
    public void setVideoEffects(List<Effect> videoEffects) {
        this.videoEffects = videoEffects;
        if (this.isInitialized()) {
            ((VideoSinkImpl)Assertions.checkStateNotNull((Object)this.videoSinkImpl)).setVideoEffects(videoEffects);
        }
    }

    @Override
    public void setPendingVideoEffects(List<Effect> videoEffects) {
        this.videoEffects = videoEffects;
        if (this.isInitialized()) {
            ((VideoSinkImpl)Assertions.checkStateNotNull((Object)this.videoSinkImpl)).setPendingVideoEffects(videoEffects);
        }
    }

    @Override
    public void setStreamOffsetUs(long streamOffsetUs) {
        ((VideoSinkImpl)Assertions.checkStateNotNull((Object)this.videoSinkImpl)).setStreamOffsetUs(streamOffsetUs);
    }

    @Override
    public void setOutputSurfaceInfo(Surface outputSurface, Size outputResolution) {
        if (this.currentSurfaceAndSize != null && ((Surface)this.currentSurfaceAndSize.first).equals(outputSurface) && ((Size)this.currentSurfaceAndSize.second).equals((Object)outputResolution)) {
            return;
        }
        this.currentSurfaceAndSize = Pair.create((Object)outputSurface, (Object)outputResolution);
        this.maybeSetOutputSurfaceInfo(outputSurface, outputResolution.getWidth(), outputResolution.getHeight());
    }

    @Override
    public void setVideoFrameReleaseControl(VideoFrameReleaseControl videoFrameReleaseControl) {
        Assertions.checkState((!this.isInitialized() ? 1 : 0) != 0);
        this.videoFrameReleaseControl = videoFrameReleaseControl;
        this.videoFrameRenderControl = new VideoFrameRenderControl(this, videoFrameReleaseControl);
    }

    @Override
    public void clearOutputSurfaceInfo() {
        this.maybeSetOutputSurfaceInfo(null, Size.UNKNOWN.getWidth(), Size.UNKNOWN.getHeight());
        this.currentSurfaceAndSize = null;
    }

    @Override
    public void setVideoFrameMetadataListener(VideoFrameMetadataListener videoFrameMetadataListener) {
        this.videoFrameMetadataListener = videoFrameMetadataListener;
    }

    @Override
    @Nullable
    public VideoFrameReleaseControl getVideoFrameReleaseControl() {
        return this.videoFrameReleaseControl;
    }

    @Override
    public void setClock(Clock clock) {
        Assertions.checkState((!this.isInitialized() ? 1 : 0) != 0);
        this.clock = clock;
    }

    public void onOutputSizeChanged(int width, int height) {
        ((VideoFrameRenderControl)Assertions.checkStateNotNull((Object)this.videoFrameRenderControl)).onOutputSizeChanged(width, height);
    }

    public void onOutputFrameAvailableForRendering(long presentationTimeUs) {
        if (this.pendingFlushCount > 0) {
            return;
        }
        ((VideoFrameRenderControl)Assertions.checkStateNotNull((Object)this.videoFrameRenderControl)).onOutputFrameAvailableForRendering(presentationTimeUs);
    }

    public void onEnded(long finalFramePresentationTimeUs) {
        throw new UnsupportedOperationException();
    }

    public void onError(VideoFrameProcessingException exception) {
        VideoSink.Listener currentListener = this.listener;
        this.listenerExecutor.execute(() -> {
            VideoSinkImpl videoSink = (VideoSinkImpl)Assertions.checkStateNotNull((Object)this.videoSinkImpl);
            currentListener.onError(videoSink, new VideoSink.VideoSinkException(exception, (Format)Assertions.checkStateNotNull((Object)videoSink.inputFormat)));
        });
    }

    @Override
    public void onVideoSizeChanged(VideoSize videoSize) {
        this.outputFormat = new Format.Builder().setWidth(videoSize.width).setHeight(videoSize.height).setSampleMimeType("video/raw").build();
        VideoSinkImpl videoSink = (VideoSinkImpl)Assertions.checkStateNotNull((Object)this.videoSinkImpl);
        VideoSink.Listener currentListener = this.listener;
        this.listenerExecutor.execute(() -> currentListener.onVideoSizeChanged(videoSink, videoSize));
    }

    @Override
    public void renderFrame(long renderTimeNs, long presentationTimeUs, long streamOffsetUs, boolean isFirstFrame) {
        if (isFirstFrame && this.listenerExecutor != NO_OP_EXECUTOR) {
            VideoSinkImpl videoSink = (VideoSinkImpl)Assertions.checkStateNotNull((Object)this.videoSinkImpl);
            VideoSink.Listener currentListener = this.listener;
            this.listenerExecutor.execute(() -> currentListener.onFirstFrameRendered(videoSink));
        }
        if (this.videoFrameMetadataListener != null) {
            Format format = this.outputFormat == null ? new Format.Builder().build() : this.outputFormat;
            this.videoFrameMetadataListener.onVideoFrameAboutToBeRendered(presentationTimeUs - streamOffsetUs, this.clock.nanoTime(), format, null);
        }
        ((PreviewingVideoGraph)Assertions.checkStateNotNull((Object)this.videoGraph)).renderOutputFrame(renderTimeNs);
    }

    @Override
    public void dropFrame() {
        VideoSink.Listener currentListener = this.listener;
        this.listenerExecutor.execute(() -> currentListener.onFrameDropped((VideoSink)Assertions.checkStateNotNull((Object)this.videoSinkImpl)));
        ((PreviewingVideoGraph)Assertions.checkStateNotNull((Object)this.videoGraph)).renderOutputFrame(-2L);
    }

    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (this.pendingFlushCount == 0) {
            ((VideoFrameRenderControl)Assertions.checkStateNotNull((Object)this.videoFrameRenderControl)).render(positionUs, elapsedRealtimeUs);
        }
    }

    @Nullable
    public Surface getOutputSurface() {
        return this.currentSurfaceAndSize != null ? (Surface)this.currentSurfaceAndSize.first : null;
    }

    private void setListener(VideoSink.Listener listener, Executor executor) {
        if (Objects.equals(listener, this.listener)) {
            Assertions.checkState((boolean)Objects.equals(executor, this.listenerExecutor));
            return;
        }
        this.listener = listener;
        this.listenerExecutor = executor;
    }

    private void maybeSetOutputSurfaceInfo(@Nullable Surface surface, int width, int height) {
        if (this.videoGraph != null) {
            SurfaceInfo surfaceInfo = surface != null ? new SurfaceInfo(surface, width, height) : null;
            this.videoGraph.setOutputSurfaceInfo(surfaceInfo);
            ((VideoFrameReleaseControl)Assertions.checkNotNull((Object)this.videoFrameReleaseControl)).setOutputSurface(surface);
        }
    }

    private boolean isReady() {
        return this.pendingFlushCount == 0 && ((VideoFrameRenderControl)Assertions.checkStateNotNull((Object)this.videoFrameRenderControl)).isReady();
    }

    private boolean hasReleasedFrame(long presentationTimeUs) {
        return this.pendingFlushCount == 0 && ((VideoFrameRenderControl)Assertions.checkStateNotNull((Object)this.videoFrameRenderControl)).hasReleasedFrame(presentationTimeUs);
    }

    private void flush() {
        ++this.pendingFlushCount;
        ((VideoFrameRenderControl)Assertions.checkStateNotNull((Object)this.videoFrameRenderControl)).flush();
        ((HandlerWrapper)Assertions.checkStateNotNull((Object)this.handler)).post(this::flushInternal);
    }

    private void flushInternal() {
        --this.pendingFlushCount;
        if (this.pendingFlushCount > 0) {
            return;
        }
        if (this.pendingFlushCount < 0) {
            throw new IllegalStateException(String.valueOf(this.pendingFlushCount));
        }
        ((VideoFrameRenderControl)Assertions.checkStateNotNull((Object)this.videoFrameRenderControl)).flush();
    }

    private void setPlaybackSpeed(float speed) {
        ((VideoFrameRenderControl)Assertions.checkStateNotNull((Object)this.videoFrameRenderControl)).setPlaybackSpeed(speed);
    }

    private void onStreamOffsetChange(long bufferPresentationTimeUs, long streamOffsetUs) {
        ((VideoFrameRenderControl)Assertions.checkStateNotNull((Object)this.videoFrameRenderControl)).onStreamOffsetChange(bufferPresentationTimeUs, streamOffsetUs);
    }

    private static ColorInfo getAdjustedInputColorInfo(@Nullable ColorInfo inputColorInfo) {
        return inputColorInfo != null && ColorInfo.isTransferHdr((ColorInfo)inputColorInfo) ? inputColorInfo : ColorInfo.SDR_BT709_LIMITED;
    }

    public static final class Builder {
        private final Context context;
        private // Could not load outer class - annotation placement on inner may be incorrect
        @MonotonicNonNull VideoFrameProcessor.Factory videoFrameProcessorFactory;
        private // Could not load outer class - annotation placement on inner may be incorrect
        @MonotonicNonNull PreviewingVideoGraph.Factory previewingVideoGraphFactory;
        private boolean built;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setVideoFrameProcessorFactory(VideoFrameProcessor.Factory videoFrameProcessorFactory) {
            this.videoFrameProcessorFactory = videoFrameProcessorFactory;
            return this;
        }

        public Builder setPreviewingVideoGraphFactory(PreviewingVideoGraph.Factory previewingVideoGraphFactory) {
            this.previewingVideoGraphFactory = previewingVideoGraphFactory;
            return this;
        }

        public CompositingVideoSinkProvider build() {
            Assertions.checkState((!this.built ? 1 : 0) != 0);
            if (this.previewingVideoGraphFactory == null) {
                if (this.videoFrameProcessorFactory == null) {
                    this.videoFrameProcessorFactory = new ReflectiveDefaultVideoFrameProcessorFactory();
                }
                this.previewingVideoGraphFactory = new ReflectivePreviewingSingleInputVideoGraphFactory(this.videoFrameProcessorFactory);
            }
            CompositingVideoSinkProvider compositingVideoSinkProvider = new CompositingVideoSinkProvider(this);
            this.built = true;
            return compositingVideoSinkProvider;
        }
    }

    private static final class VideoSinkImpl
    implements VideoSink {
        private final Context context;
        private final CompositingVideoSinkProvider compositingVideoSinkProvider;
        private final VideoFrameProcessor videoFrameProcessor;
        private final int videoFrameProcessorMaxPendingFrameCount;
        private final ArrayList<Effect> videoEffects;
        @Nullable
        private Effect rotationEffect;
        @Nullable
        private Format inputFormat;
        private int inputType;
        private long inputStreamOffsetUs;
        private boolean pendingInputStreamOffsetChange;
        private long finalBufferPresentationTimeUs;
        private long lastBufferPresentationTimeUs;
        private boolean hasRegisteredFirstInputStream;
        private long pendingInputStreamBufferPresentationTimeUs;

        public VideoSinkImpl(Context context, CompositingVideoSinkProvider compositingVideoSinkProvider, PreviewingVideoGraph videoGraph) throws VideoFrameProcessingException {
            this.context = context;
            this.compositingVideoSinkProvider = compositingVideoSinkProvider;
            this.videoFrameProcessorMaxPendingFrameCount = Util.getMaxPendingFramesCountForMediaCodecDecoders((Context)context);
            int videoGraphInputId = videoGraph.registerInput();
            this.videoFrameProcessor = videoGraph.getProcessor(videoGraphInputId);
            this.videoEffects = new ArrayList();
            this.finalBufferPresentationTimeUs = -9223372036854775807L;
            this.lastBufferPresentationTimeUs = -9223372036854775807L;
        }

        @Override
        public void flush() {
            this.videoFrameProcessor.flush();
            this.hasRegisteredFirstInputStream = false;
            this.finalBufferPresentationTimeUs = -9223372036854775807L;
            this.lastBufferPresentationTimeUs = -9223372036854775807L;
            this.compositingVideoSinkProvider.flush();
        }

        @Override
        public boolean isReady() {
            return this.compositingVideoSinkProvider.isReady();
        }

        @Override
        public boolean isEnded() {
            return this.finalBufferPresentationTimeUs != -9223372036854775807L && this.compositingVideoSinkProvider.hasReleasedFrame(this.finalBufferPresentationTimeUs);
        }

        @Override
        public void registerInputStream(int inputType, Format format) {
            switch (inputType) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported input type " + inputType);
                }
            }
            if (inputType == 1 && Util.SDK_INT < 21 && format.rotationDegrees != -1 && format.rotationDegrees != 0) {
                if (this.rotationEffect == null || this.inputFormat == null || this.inputFormat.rotationDegrees != format.rotationDegrees) {
                    this.rotationEffect = ScaleAndRotateAccessor.createRotationEffect(format.rotationDegrees);
                }
            } else {
                this.rotationEffect = null;
            }
            this.inputType = inputType;
            this.inputFormat = format;
            if (!this.hasRegisteredFirstInputStream) {
                this.maybeRegisterInputStream();
                this.hasRegisteredFirstInputStream = true;
                this.pendingInputStreamBufferPresentationTimeUs = -9223372036854775807L;
            } else {
                Assertions.checkState((this.lastBufferPresentationTimeUs != -9223372036854775807L ? 1 : 0) != 0);
                this.pendingInputStreamBufferPresentationTimeUs = this.lastBufferPresentationTimeUs;
            }
        }

        @Override
        public void setListener(VideoSink.Listener listener, Executor executor) {
            this.compositingVideoSinkProvider.setListener(listener, executor);
        }

        @Override
        public boolean isFrameDropAllowedOnInput() {
            return Util.isFrameDropAllowedOnSurfaceInput((Context)this.context);
        }

        @Override
        public Surface getInputSurface() {
            return this.videoFrameProcessor.getInputSurface();
        }

        @Override
        public long registerInputFrame(long framePresentationTimeUs, boolean isLastFrame) {
            Assertions.checkState((this.videoFrameProcessorMaxPendingFrameCount != -1 ? 1 : 0) != 0);
            if (this.pendingInputStreamBufferPresentationTimeUs != -9223372036854775807L) {
                if (this.compositingVideoSinkProvider.hasReleasedFrame(this.pendingInputStreamBufferPresentationTimeUs)) {
                    this.maybeRegisterInputStream();
                    this.pendingInputStreamBufferPresentationTimeUs = -9223372036854775807L;
                } else {
                    return -9223372036854775807L;
                }
            }
            if (this.videoFrameProcessor.getPendingInputFrameCount() >= this.videoFrameProcessorMaxPendingFrameCount) {
                return -9223372036854775807L;
            }
            if (!this.videoFrameProcessor.registerInputFrame()) {
                return -9223372036854775807L;
            }
            long bufferPresentationTimeUs = framePresentationTimeUs + this.inputStreamOffsetUs;
            if (this.pendingInputStreamOffsetChange) {
                this.compositingVideoSinkProvider.onStreamOffsetChange(bufferPresentationTimeUs, this.inputStreamOffsetUs);
                this.pendingInputStreamOffsetChange = false;
            }
            this.lastBufferPresentationTimeUs = bufferPresentationTimeUs;
            if (isLastFrame) {
                this.finalBufferPresentationTimeUs = bufferPresentationTimeUs;
            }
            return bufferPresentationTimeUs * 1000L;
        }

        @Override
        public boolean queueBitmap(Bitmap inputBitmap, TimestampIterator timestampIterator) {
            return ((VideoFrameProcessor)Assertions.checkStateNotNull((Object)this.videoFrameProcessor)).queueInputBitmap(inputBitmap, timestampIterator);
        }

        @Override
        public void render(long positionUs, long elapsedRealtimeUs) throws VideoSink.VideoSinkException {
            try {
                this.compositingVideoSinkProvider.render(positionUs, elapsedRealtimeUs);
            }
            catch (ExoPlaybackException e) {
                throw new VideoSink.VideoSinkException((Throwable)((Object)e), this.inputFormat != null ? this.inputFormat : new Format.Builder().build());
            }
        }

        @Override
        public void setPlaybackSpeed(@FloatRange(from=0.0, fromInclusive=false) float speed) {
            this.compositingVideoSinkProvider.setPlaybackSpeed(speed);
        }

        public void setVideoEffects(List<Effect> videoEffects) {
            this.setPendingVideoEffects(videoEffects);
            this.maybeRegisterInputStream();
        }

        public void setPendingVideoEffects(List<Effect> videoEffects) {
            this.videoEffects.clear();
            this.videoEffects.addAll(videoEffects);
        }

        public void setStreamOffsetUs(long streamOffsetUs) {
            this.pendingInputStreamOffsetChange = this.inputStreamOffsetUs != streamOffsetUs;
            this.inputStreamOffsetUs = streamOffsetUs;
        }

        private void maybeRegisterInputStream() {
            if (this.inputFormat == null) {
                return;
            }
            ArrayList<Effect> effects = new ArrayList<Effect>();
            if (this.rotationEffect != null) {
                effects.add(this.rotationEffect);
            }
            effects.addAll(this.videoEffects);
            Format inputFormat = (Format)Assertions.checkNotNull((Object)this.inputFormat);
            this.videoFrameProcessor.registerInputStream(this.inputType, effects, new FrameInfo.Builder(CompositingVideoSinkProvider.getAdjustedInputColorInfo(inputFormat.colorInfo), inputFormat.width, inputFormat.height).setPixelWidthHeightRatio(inputFormat.pixelWidthHeightRatio).build());
        }

        private static final class ScaleAndRotateAccessor {
            private static @MonotonicNonNull Constructor<?> scaleAndRotateTransformationBuilderConstructor;
            private static @MonotonicNonNull Method setRotationMethod;
            private static @MonotonicNonNull Method buildScaleAndRotateTransformationMethod;

            private ScaleAndRotateAccessor() {
            }

            public static Effect createRotationEffect(float rotationDegrees) {
                try {
                    ScaleAndRotateAccessor.prepare();
                    Object builder = scaleAndRotateTransformationBuilderConstructor.newInstance(new Object[0]);
                    setRotationMethod.invoke(builder, Float.valueOf(rotationDegrees));
                    return (Effect)Assertions.checkNotNull((Object)buildScaleAndRotateTransformationMethod.invoke(builder, new Object[0]));
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }

            @EnsuresNonNull(value={"scaleAndRotateTransformationBuilderConstructor", "setRotationMethod", "buildScaleAndRotateTransformationMethod"})
            private static void prepare() throws NoSuchMethodException, ClassNotFoundException {
                if (scaleAndRotateTransformationBuilderConstructor == null || setRotationMethod == null || buildScaleAndRotateTransformationMethod == null) {
                    Class<?> scaleAndRotateTransformationBuilderClass = Class.forName("androidx.media3.effect.ScaleAndRotateTransformation$Builder");
                    scaleAndRotateTransformationBuilderConstructor = scaleAndRotateTransformationBuilderClass.getConstructor(new Class[0]);
                    setRotationMethod = scaleAndRotateTransformationBuilderClass.getMethod("setRotationDegrees", Float.TYPE);
                    buildScaleAndRotateTransformationMethod = scaleAndRotateTransformationBuilderClass.getMethod("build", new Class[0]);
                }
            }
        }
    }

    private static final class ReflectiveDefaultVideoFrameProcessorFactory
    implements VideoFrameProcessor.Factory {
        private static final Supplier<VideoFrameProcessor.Factory> VIDEO_FRAME_PROCESSOR_FACTORY_SUPPLIER = Suppliers.memoize(() -> {
            try {
                Class<?> defaultVideoFrameProcessorFactoryBuilderClass = Class.forName("androidx.media3.effect.DefaultVideoFrameProcessor$Factory$Builder");
                Object builder = defaultVideoFrameProcessorFactoryBuilderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return (VideoFrameProcessor.Factory)Assertions.checkNotNull((Object)defaultVideoFrameProcessorFactoryBuilderClass.getMethod("build", new Class[0]).invoke(builder, new Object[0]));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });

        private ReflectiveDefaultVideoFrameProcessorFactory() {
        }

        public VideoFrameProcessor create(Context context, DebugViewProvider debugViewProvider, ColorInfo outputColorInfo, boolean renderFramesAutomatically, Executor listenerExecutor, VideoFrameProcessor.Listener listener) throws VideoFrameProcessingException {
            return ((VideoFrameProcessor.Factory)VIDEO_FRAME_PROCESSOR_FACTORY_SUPPLIER.get()).create(context, debugViewProvider, outputColorInfo, renderFramesAutomatically, listenerExecutor, listener);
        }
    }

    private static final class ReflectivePreviewingSingleInputVideoGraphFactory
    implements PreviewingVideoGraph.Factory {
        private final VideoFrameProcessor.Factory videoFrameProcessorFactory;

        public ReflectivePreviewingSingleInputVideoGraphFactory(VideoFrameProcessor.Factory videoFrameProcessorFactory) {
            this.videoFrameProcessorFactory = videoFrameProcessorFactory;
        }

        public PreviewingVideoGraph create(Context context, ColorInfo inputColorInfo, ColorInfo outputColorInfo, DebugViewProvider debugViewProvider, VideoGraph.Listener listener, Executor listenerExecutor, List<Effect> compositionEffects, long initialTimestampOffsetUs) throws VideoFrameProcessingException {
            try {
                Class<?> previewingSingleInputVideoGraphFactoryClass = Class.forName("androidx.media3.effect.PreviewingSingleInputVideoGraph$Factory");
                PreviewingVideoGraph.Factory factory = (PreviewingVideoGraph.Factory)previewingSingleInputVideoGraphFactoryClass.getConstructor(VideoFrameProcessor.Factory.class).newInstance(this.videoFrameProcessorFactory);
                return factory.create(context, inputColorInfo, outputColorInfo, debugViewProvider, listener, listenerExecutor, compositionEffects, initialTimestampOffsetUs);
            }
            catch (Exception e) {
                throw VideoFrameProcessingException.from((Exception)e);
            }
        }
    }
}

