/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video;

import android.os.Handler;
import android.os.SystemClock;
import android.view.Surface;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.VideoSize;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.TimedValueQueue;
import androidx.media3.common.util.TraceUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.CryptoConfig;
import androidx.media3.decoder.Decoder;
import androidx.media3.decoder.DecoderException;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.decoder.VideoDecoderOutputBuffer;
import androidx.media3.exoplayer.BaseRenderer;
import androidx.media3.exoplayer.DecoderCounters;
import androidx.media3.exoplayer.DecoderReuseEvaluation;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.FormatHolder;
import androidx.media3.exoplayer.drm.DrmSession;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.video.VideoDecoderOutputBufferRenderer;
import androidx.media3.exoplayer.video.VideoFrameMetadataListener;
import androidx.media3.exoplayer.video.VideoRendererEventListener;

@UnstableApi
public abstract class DecoderVideoRenderer
extends BaseRenderer {
    private static final String TAG = "DecoderVideoRenderer";
    private static final int REINITIALIZATION_STATE_NONE = 0;
    private static final int REINITIALIZATION_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REINITIALIZATION_STATE_WAIT_END_OF_STREAM = 2;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final VideoRendererEventListener.EventDispatcher eventDispatcher;
    private final TimedValueQueue<Format> formatQueue;
    private final DecoderInputBuffer flagsOnlyBuffer;
    @Nullable
    private Format inputFormat;
    @Nullable
    private Format outputFormat;
    @Nullable
    private Decoder<DecoderInputBuffer, ? extends VideoDecoderOutputBuffer, ? extends DecoderException> decoder;
    @Nullable
    private DecoderInputBuffer inputBuffer;
    @Nullable
    private VideoDecoderOutputBuffer outputBuffer;
    private int outputMode;
    @Nullable
    private Object output;
    @Nullable
    private Surface outputSurface;
    @Nullable
    private VideoDecoderOutputBufferRenderer outputBufferRenderer;
    @Nullable
    private VideoFrameMetadataListener frameMetadataListener;
    @Nullable
    private DrmSession decoderDrmSession;
    @Nullable
    private DrmSession sourceDrmSession;
    private int decoderReinitializationState;
    private boolean decoderReceivedBuffers;
    private int firstFrameState;
    private long initialPositionUs;
    private long joiningDeadlineMs;
    private boolean waitingForFirstSampleInFormat;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    @Nullable
    private VideoSize reportedVideoSize;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int buffersInCodecCount;
    private long lastRenderTimeUs;
    private long outputStreamOffsetUs;
    protected DecoderCounters decoderCounters;

    protected DecoderVideoRenderer(long allowedJoiningTimeMs, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        super(2);
        this.allowedJoiningTimeMs = allowedJoiningTimeMs;
        this.maxDroppedFramesToNotify = maxDroppedFramesToNotify;
        this.joiningDeadlineMs = -9223372036854775807L;
        this.formatQueue = new TimedValueQueue();
        this.flagsOnlyBuffer = DecoderInputBuffer.newNoDataInstance();
        this.eventDispatcher = new VideoRendererEventListener.EventDispatcher(eventHandler, eventListener);
        this.decoderReinitializationState = 0;
        this.outputMode = -1;
        this.firstFrameState = 0;
        this.decoderCounters = new DecoderCounters();
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (this.outputStreamEnded) {
            return;
        }
        if (this.inputFormat == null) {
            FormatHolder formatHolder = this.getFormatHolder();
            this.flagsOnlyBuffer.clear();
            int result = this.readSource(formatHolder, this.flagsOnlyBuffer, 2);
            if (result == -5) {
                this.onInputFormatChanged(formatHolder);
            } else {
                if (result == -4) {
                    Assertions.checkState((boolean)this.flagsOnlyBuffer.isEndOfStream());
                    this.inputStreamEnded = true;
                    this.outputStreamEnded = true;
                    return;
                }
                return;
            }
        }
        this.maybeInitDecoder();
        if (this.decoder != null) {
            try {
                TraceUtil.beginSection((String)"drainAndFeed");
                while (this.drainOutputBuffer(positionUs, elapsedRealtimeUs)) {
                }
                while (this.feedInputBuffer()) {
                }
                TraceUtil.endSection();
            }
            catch (DecoderException e) {
                Log.e((String)TAG, (String)"Video codec error", (Throwable)e);
                this.eventDispatcher.videoCodecError((Exception)((Object)e));
                throw this.createRendererException(e, this.inputFormat, 4003);
            }
            this.decoderCounters.ensureUpdated();
        }
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        if (!(this.inputFormat == null || !this.isSourceReady() && this.outputBuffer == null || this.firstFrameState != 3 && this.hasOutput())) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
        if (messageType == 1) {
            this.setOutput(message);
        } else if (messageType == 7) {
            this.frameMetadataListener = (VideoFrameMetadataListener)message;
        } else {
            super.handleMessage(messageType, message);
        }
    }

    @Override
    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
        this.decoderCounters = new DecoderCounters();
        this.eventDispatcher.enabled(this.decoderCounters);
        this.firstFrameState = mayRenderStartOfStream ? 1 : 0;
    }

    @Override
    public void enableMayRenderStartOfStream() {
        if (this.firstFrameState == 0) {
            this.firstFrameState = 1;
        }
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        this.lowerFirstFrameState(1);
        this.initialPositionUs = -9223372036854775807L;
        this.consecutiveDroppedFrameCount = 0;
        if (this.decoder != null) {
            this.flushDecoder();
        }
        if (joining) {
            this.setJoiningDeadlineMs();
        } else {
            this.joiningDeadlineMs = -9223372036854775807L;
        }
        this.formatQueue.clear();
    }

    @Override
    protected void onStarted() {
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
        this.lastRenderTimeUs = Util.msToUs((long)SystemClock.elapsedRealtime());
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
    }

    @Override
    protected void onDisabled() {
        this.inputFormat = null;
        this.reportedVideoSize = null;
        this.lowerFirstFrameState(0);
        try {
            this.setSourceDrmSession(null);
            this.releaseDecoder();
        }
        finally {
            this.eventDispatcher.disabled(this.decoderCounters);
        }
    }

    @Override
    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs, MediaSource.MediaPeriodId mediaPeriodId) throws ExoPlaybackException {
        this.outputStreamOffsetUs = offsetUs;
        super.onStreamChanged(formats, startPositionUs, offsetUs, mediaPeriodId);
    }

    @CallSuper
    protected void flushDecoder() throws ExoPlaybackException {
        this.buffersInCodecCount = 0;
        if (this.decoderReinitializationState != 0) {
            this.releaseDecoder();
            this.maybeInitDecoder();
        } else {
            this.inputBuffer = null;
            if (this.outputBuffer != null) {
                this.outputBuffer.release();
                this.outputBuffer = null;
            }
            Decoder decoder = (Decoder)Assertions.checkNotNull(this.decoder);
            decoder.flush();
            decoder.setOutputStartTimeUs(this.getLastResetPositionUs());
            this.decoderReceivedBuffers = false;
        }
    }

    @CallSuper
    protected void releaseDecoder() {
        this.inputBuffer = null;
        this.outputBuffer = null;
        this.decoderReinitializationState = 0;
        this.decoderReceivedBuffers = false;
        this.buffersInCodecCount = 0;
        if (this.decoder != null) {
            ++this.decoderCounters.decoderReleaseCount;
            this.decoder.release();
            this.eventDispatcher.decoderReleased(this.decoder.getName());
            this.decoder = null;
        }
        this.setDecoderDrmSession(null);
    }

    @CallSuper
    protected void onInputFormatChanged(FormatHolder formatHolder) throws ExoPlaybackException {
        this.waitingForFirstSampleInFormat = true;
        Format newFormat = (Format)Assertions.checkNotNull((Object)formatHolder.format);
        this.setSourceDrmSession(formatHolder.drmSession);
        Format oldFormat = this.inputFormat;
        this.inputFormat = newFormat;
        if (this.decoder == null) {
            this.maybeInitDecoder();
            this.eventDispatcher.inputFormatChanged((Format)Assertions.checkNotNull((Object)this.inputFormat), null);
            return;
        }
        DecoderReuseEvaluation evaluation = this.sourceDrmSession != this.decoderDrmSession ? new DecoderReuseEvaluation(this.decoder.getName(), (Format)Assertions.checkNotNull((Object)oldFormat), newFormat, 0, 128) : this.canReuseDecoder(this.decoder.getName(), (Format)Assertions.checkNotNull((Object)oldFormat), newFormat);
        if (evaluation.result == 0) {
            if (this.decoderReceivedBuffers) {
                this.decoderReinitializationState = 1;
            } else {
                this.releaseDecoder();
                this.maybeInitDecoder();
            }
        }
        this.eventDispatcher.inputFormatChanged((Format)Assertions.checkNotNull((Object)this.inputFormat), evaluation);
    }

    protected void onQueueInputBuffer(DecoderInputBuffer buffer) {
    }

    @CallSuper
    protected void onProcessedOutputBuffer(long presentationTimeUs) {
        --this.buffersInCodecCount;
    }

    protected boolean shouldDropOutputBuffer(long earlyUs, long elapsedRealtimeUs) {
        return DecoderVideoRenderer.isBufferLate(earlyUs);
    }

    protected boolean shouldDropBuffersToKeyframe(long earlyUs, long elapsedRealtimeUs) {
        return DecoderVideoRenderer.isBufferVeryLate(earlyUs);
    }

    protected boolean shouldForceRenderOutputBuffer(long earlyUs, long elapsedSinceLastRenderUs) {
        return DecoderVideoRenderer.isBufferLate(earlyUs) && elapsedSinceLastRenderUs > 100000L;
    }

    protected void skipOutputBuffer(VideoDecoderOutputBuffer outputBuffer) {
        ++this.decoderCounters.skippedOutputBufferCount;
        outputBuffer.release();
    }

    protected void dropOutputBuffer(VideoDecoderOutputBuffer outputBuffer) {
        this.updateDroppedBufferCounters(0, 1);
        outputBuffer.release();
    }

    protected boolean maybeDropBuffersToKeyframe(long positionUs) throws ExoPlaybackException {
        int droppedSourceBufferCount = this.skipSource(positionUs);
        if (droppedSourceBufferCount == 0) {
            return false;
        }
        ++this.decoderCounters.droppedToKeyframeCount;
        this.updateDroppedBufferCounters(droppedSourceBufferCount, this.buffersInCodecCount);
        this.flushDecoder();
        return true;
    }

    protected void updateDroppedBufferCounters(int droppedInputBufferCount, int droppedDecoderBufferCount) {
        this.decoderCounters.droppedInputBufferCount += droppedInputBufferCount;
        int totalDroppedBufferCount = droppedInputBufferCount + droppedDecoderBufferCount;
        this.decoderCounters.droppedBufferCount += totalDroppedBufferCount;
        this.droppedFrames += totalDroppedBufferCount;
        this.consecutiveDroppedFrameCount += totalDroppedBufferCount;
        this.decoderCounters.maxConsecutiveDroppedBufferCount = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.maxConsecutiveDroppedBufferCount);
        if (this.maxDroppedFramesToNotify > 0 && this.droppedFrames >= this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    protected abstract Decoder<DecoderInputBuffer, ? extends VideoDecoderOutputBuffer, ? extends DecoderException> createDecoder(Format var1, @Nullable CryptoConfig var2) throws DecoderException;

    protected void renderOutputBuffer(VideoDecoderOutputBuffer outputBuffer, long presentationTimeUs, Format outputFormat) throws DecoderException {
        boolean renderYuv;
        if (this.frameMetadataListener != null) {
            this.frameMetadataListener.onVideoFrameAboutToBeRendered(presentationTimeUs, this.getClock().nanoTime(), outputFormat, null);
        }
        this.lastRenderTimeUs = Util.msToUs((long)SystemClock.elapsedRealtime());
        int bufferMode = outputBuffer.mode;
        boolean renderSurface = bufferMode == 1 && this.outputSurface != null;
        boolean bl = renderYuv = bufferMode == 0 && this.outputBufferRenderer != null;
        if (!renderYuv && !renderSurface) {
            this.dropOutputBuffer(outputBuffer);
        } else {
            this.maybeNotifyVideoSizeChanged(outputBuffer.width, outputBuffer.height);
            if (renderYuv) {
                ((VideoDecoderOutputBufferRenderer)Assertions.checkNotNull((Object)this.outputBufferRenderer)).setOutputBuffer(outputBuffer);
            } else {
                this.renderOutputBufferToSurface(outputBuffer, (Surface)Assertions.checkNotNull((Object)this.outputSurface));
            }
            this.consecutiveDroppedFrameCount = 0;
            ++this.decoderCounters.renderedOutputBufferCount;
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    protected abstract void renderOutputBufferToSurface(VideoDecoderOutputBuffer var1, Surface var2) throws DecoderException;

    protected final void setOutput(@Nullable Object output) {
        if (output instanceof Surface) {
            this.outputSurface = (Surface)output;
            this.outputBufferRenderer = null;
            this.outputMode = 1;
        } else if (output instanceof VideoDecoderOutputBufferRenderer) {
            this.outputSurface = null;
            this.outputBufferRenderer = (VideoDecoderOutputBufferRenderer)output;
            this.outputMode = 0;
        } else {
            output = null;
            this.outputSurface = null;
            this.outputBufferRenderer = null;
            this.outputMode = -1;
        }
        if (this.output != output) {
            this.output = output;
            if (output != null) {
                if (this.decoder != null) {
                    this.setDecoderOutputMode(this.outputMode);
                }
                this.onOutputChanged();
            } else {
                this.onOutputRemoved();
            }
        } else if (output != null) {
            this.onOutputReset();
        }
    }

    protected abstract void setDecoderOutputMode(int var1);

    protected DecoderReuseEvaluation canReuseDecoder(String decoderName, Format oldFormat, Format newFormat) {
        return new DecoderReuseEvaluation(decoderName, oldFormat, newFormat, 0, 1);
    }

    private void setSourceDrmSession(@Nullable DrmSession session) {
        DrmSession.replaceSession(this.sourceDrmSession, session);
        this.sourceDrmSession = session;
    }

    private void setDecoderDrmSession(@Nullable DrmSession session) {
        DrmSession.replaceSession(this.decoderDrmSession, session);
        this.decoderDrmSession = session;
    }

    private void maybeInitDecoder() throws ExoPlaybackException {
        DrmSession.DrmSessionException drmError;
        if (this.decoder != null) {
            return;
        }
        this.setDecoderDrmSession(this.sourceDrmSession);
        CryptoConfig cryptoConfig = null;
        if (this.decoderDrmSession != null && (cryptoConfig = this.decoderDrmSession.getCryptoConfig()) == null && (drmError = this.decoderDrmSession.getError()) == null) {
            return;
        }
        try {
            long decoderInitializingTimestamp = SystemClock.elapsedRealtime();
            this.decoder = this.createDecoder((Format)Assertions.checkNotNull((Object)this.inputFormat), cryptoConfig);
            this.decoder.setOutputStartTimeUs(this.getLastResetPositionUs());
            this.setDecoderOutputMode(this.outputMode);
            long decoderInitializedTimestamp = SystemClock.elapsedRealtime();
            this.eventDispatcher.decoderInitialized(((Decoder)Assertions.checkNotNull(this.decoder)).getName(), decoderInitializedTimestamp, decoderInitializedTimestamp - decoderInitializingTimestamp);
            ++this.decoderCounters.decoderInitCount;
        }
        catch (DecoderException e) {
            Log.e((String)TAG, (String)"Video codec error", (Throwable)e);
            this.eventDispatcher.videoCodecError((Exception)((Object)e));
            throw this.createRendererException(e, this.inputFormat, 4001);
        }
        catch (OutOfMemoryError e) {
            throw this.createRendererException(e, this.inputFormat, 4001);
        }
    }

    private boolean feedInputBuffer() throws DecoderException, ExoPlaybackException {
        if (this.decoder == null || this.decoderReinitializationState == 2 || this.inputStreamEnded) {
            return false;
        }
        if (this.inputBuffer == null) {
            this.inputBuffer = (DecoderInputBuffer)this.decoder.dequeueInputBuffer();
            if (this.inputBuffer == null) {
                return false;
            }
        }
        DecoderInputBuffer inputBuffer = (DecoderInputBuffer)Assertions.checkNotNull((Object)this.inputBuffer);
        if (this.decoderReinitializationState == 1) {
            inputBuffer.setFlags(4);
            ((Decoder)Assertions.checkNotNull(this.decoder)).queueInputBuffer((Object)inputBuffer);
            this.inputBuffer = null;
            this.decoderReinitializationState = 2;
            return false;
        }
        FormatHolder formatHolder = this.getFormatHolder();
        switch (this.readSource(formatHolder, inputBuffer, 0)) {
            case -3: {
                return false;
            }
            case -5: {
                this.onInputFormatChanged(formatHolder);
                return true;
            }
            case -4: {
                if (inputBuffer.isEndOfStream()) {
                    this.inputStreamEnded = true;
                    ((Decoder)Assertions.checkNotNull(this.decoder)).queueInputBuffer((Object)inputBuffer);
                    this.inputBuffer = null;
                    return false;
                }
                if (this.waitingForFirstSampleInFormat) {
                    this.formatQueue.add(inputBuffer.timeUs, (Object)((Format)Assertions.checkNotNull((Object)this.inputFormat)));
                    this.waitingForFirstSampleInFormat = false;
                }
                if (inputBuffer.timeUs < this.getLastResetPositionUs()) {
                    inputBuffer.addFlag(Integer.MIN_VALUE);
                }
                inputBuffer.flip();
                inputBuffer.format = this.inputFormat;
                this.onQueueInputBuffer(inputBuffer);
                ((Decoder)Assertions.checkNotNull(this.decoder)).queueInputBuffer((Object)inputBuffer);
                ++this.buffersInCodecCount;
                this.decoderReceivedBuffers = true;
                ++this.decoderCounters.queuedInputBufferCount;
                this.inputBuffer = null;
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private boolean drainOutputBuffer(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException, DecoderException {
        if (this.outputBuffer == null) {
            this.outputBuffer = (VideoDecoderOutputBuffer)((Decoder)Assertions.checkNotNull(this.decoder)).dequeueOutputBuffer();
            if (this.outputBuffer == null) {
                return false;
            }
            this.decoderCounters.skippedOutputBufferCount += this.outputBuffer.skippedOutputBufferCount;
            this.buffersInCodecCount -= this.outputBuffer.skippedOutputBufferCount;
        }
        if (this.outputBuffer.isEndOfStream()) {
            if (this.decoderReinitializationState == 2) {
                this.releaseDecoder();
                this.maybeInitDecoder();
            } else {
                this.outputBuffer.release();
                this.outputBuffer = null;
                this.outputStreamEnded = true;
            }
            return false;
        }
        boolean processedOutputBuffer = this.processOutputBuffer(positionUs, elapsedRealtimeUs);
        if (processedOutputBuffer) {
            this.onProcessedOutputBuffer(((VideoDecoderOutputBuffer)Assertions.checkNotNull((Object)this.outputBuffer)).timeUs);
            this.outputBuffer = null;
        }
        return processedOutputBuffer;
    }

    private boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException, DecoderException {
        boolean isStarted;
        if (this.initialPositionUs == -9223372036854775807L) {
            this.initialPositionUs = positionUs;
        }
        VideoDecoderOutputBuffer outputBuffer = (VideoDecoderOutputBuffer)Assertions.checkNotNull((Object)this.outputBuffer);
        long bufferTimeUs = outputBuffer.timeUs;
        long earlyUs = bufferTimeUs - positionUs;
        if (!this.hasOutput()) {
            if (DecoderVideoRenderer.isBufferLate(earlyUs)) {
                this.skipOutputBuffer(outputBuffer);
                return true;
            }
            return false;
        }
        Format format = (Format)this.formatQueue.pollFloor(bufferTimeUs);
        if (format != null) {
            this.outputFormat = format;
        } else if (this.outputFormat == null) {
            this.outputFormat = (Format)this.formatQueue.pollFirst();
        }
        long presentationTimeUs = bufferTimeUs - this.outputStreamOffsetUs;
        if (this.shouldForceRender(earlyUs)) {
            this.renderOutputBuffer(outputBuffer, presentationTimeUs, (Format)Assertions.checkNotNull((Object)this.outputFormat));
            return true;
        }
        boolean bl = isStarted = this.getState() == 2;
        if (!isStarted || positionUs == this.initialPositionUs) {
            return false;
        }
        if (this.shouldDropBuffersToKeyframe(earlyUs, elapsedRealtimeUs) && this.maybeDropBuffersToKeyframe(positionUs)) {
            return false;
        }
        if (this.shouldDropOutputBuffer(earlyUs, elapsedRealtimeUs)) {
            this.dropOutputBuffer(outputBuffer);
            return true;
        }
        if (earlyUs < 30000L) {
            this.renderOutputBuffer(outputBuffer, presentationTimeUs, (Format)Assertions.checkNotNull((Object)this.outputFormat));
            return true;
        }
        return false;
    }

    private boolean shouldForceRender(long earlyUs) {
        boolean isStarted = this.getState() == 2;
        switch (this.firstFrameState) {
            case 0: {
                return isStarted;
            }
            case 1: {
                return true;
            }
            case 3: {
                long elapsedSinceLastRenderUs = Util.msToUs((long)SystemClock.elapsedRealtime()) - this.lastRenderTimeUs;
                return isStarted && this.shouldForceRenderOutputBuffer(earlyUs, elapsedSinceLastRenderUs);
            }
        }
        throw new IllegalStateException();
    }

    private boolean hasOutput() {
        return this.outputMode != -1;
    }

    private void onOutputChanged() {
        this.maybeRenotifyVideoSizeChanged();
        this.lowerFirstFrameState(1);
        if (this.getState() == 2) {
            this.setJoiningDeadlineMs();
        }
    }

    private void onOutputRemoved() {
        this.reportedVideoSize = null;
        this.lowerFirstFrameState(1);
    }

    private void onOutputReset() {
        this.maybeRenotifyVideoSizeChanged();
        this.maybeRenotifyRenderedFirstFrame();
    }

    private void setJoiningDeadlineMs() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    private void lowerFirstFrameState(int firstFrameState) {
        this.firstFrameState = Math.min(this.firstFrameState, firstFrameState);
    }

    private void maybeNotifyRenderedFirstFrame() {
        if (this.firstFrameState != 3) {
            this.firstFrameState = 3;
            if (this.output != null) {
                this.eventDispatcher.renderedFirstFrame(this.output);
            }
        }
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.firstFrameState == 3 && this.output != null) {
            this.eventDispatcher.renderedFirstFrame(this.output);
        }
    }

    private void maybeNotifyVideoSizeChanged(int width, int height) {
        if (this.reportedVideoSize == null || this.reportedVideoSize.width != width || this.reportedVideoSize.height != height) {
            this.reportedVideoSize = new VideoSize(width, height);
            this.eventDispatcher.videoSizeChanged(this.reportedVideoSize);
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedVideoSize != null) {
            this.eventDispatcher.videoSizeChanged(this.reportedVideoSize);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long now = SystemClock.elapsedRealtime();
            long elapsedMs = now - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.droppedFrames(this.droppedFrames, elapsedMs);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = now;
        }
    }

    private static boolean isBufferLate(long earlyUs) {
        return earlyUs < -30000L;
    }

    private static boolean isBufferVeryLate(long earlyUs) {
        return earlyUs < -500000L;
    }
}

