/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Pair;
import android.view.Display;
import android.view.Surface;
import androidx.annotation.CallSuper;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Effect;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.VideoSize;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.MediaFormatUtil;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.TraceUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.DecoderReuseEvaluation;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.FormatHolder;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.mediacodec.MediaCodecAdapter;
import androidx.media3.exoplayer.mediacodec.MediaCodecDecoderException;
import androidx.media3.exoplayer.mediacodec.MediaCodecInfo;
import androidx.media3.exoplayer.mediacodec.MediaCodecRenderer;
import androidx.media3.exoplayer.mediacodec.MediaCodecSelector;
import androidx.media3.exoplayer.mediacodec.MediaCodecUtil;
import androidx.media3.exoplayer.video.CompositingVideoSinkProvider;
import androidx.media3.exoplayer.video.MediaCodecVideoDecoderException;
import androidx.media3.exoplayer.video.PlaceholderSurface;
import androidx.media3.exoplayer.video.VideoFrameMetadataListener;
import androidx.media3.exoplayer.video.VideoFrameReleaseControl;
import androidx.media3.exoplayer.video.VideoRendererEventListener;
import androidx.media3.exoplayer.video.VideoSink;
import androidx.media3.exoplayer.video.VideoSinkProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.ByteBuffer;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public class MediaCodecVideoRenderer
extends MediaCodecRenderer
implements VideoFrameReleaseControl.FrameTimingEvaluator {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private static final float INITIAL_FORMAT_MAX_INPUT_SIZE_SCALE_FACTOR = 1.5f;
    private static final long TUNNELING_EOS_PRESENTATION_TIME_US = Long.MAX_VALUE;
    private static final int HEVC_MAX_INPUT_SIZE_THRESHOLD = 0x200000;
    private static final long MIN_EARLY_US_LATE_THRESHOLD = -30000L;
    private static final long MIN_EARLY_US_VERY_LATE_THRESHOLD = -500000L;
    private static boolean evaluatedDeviceNeedsSetOutputSurfaceWorkaround;
    private static boolean deviceNeedsSetOutputSurfaceWorkaround;
    private final Context context;
    private final VideoSinkProvider videoSinkProvider;
    private final VideoRendererEventListener.EventDispatcher eventDispatcher;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsNoPostProcessWorkaround;
    private final VideoFrameReleaseControl videoFrameReleaseControl;
    private final VideoFrameReleaseControl.FrameReleaseInfo videoFrameReleaseInfo;
    private @MonotonicNonNull CodecMaxValues codecMaxValues;
    private boolean codecNeedsSetOutputSurfaceWorkaround;
    private boolean codecHandlesHdr10PlusOutOfBandMetadata;
    @Nullable
    private Surface displaySurface;
    @Nullable
    private Size outputResolution;
    @Nullable
    private PlaceholderSurface placeholderSurface;
    private boolean haveReportedFirstFrameRenderedForCurrentSurface;
    private int scalingMode;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int buffersInCodecCount;
    private long totalVideoFrameProcessingOffsetUs;
    private int videoFrameProcessingOffsetCount;
    private long lastFrameReleaseTimeNs;
    private VideoSize decodedVideoSize;
    @Nullable
    private VideoSize reportedVideoSize;
    private boolean hasEffects;
    private boolean hasInitializedPlayback;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    @Nullable
    OnFrameRenderedListenerV23 tunnelingOnFrameRenderedListener;
    @Nullable
    private VideoFrameMetadataListener frameMetadataListener;
    @Nullable
    private VideoSink videoSink;

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector) {
        this(context, mediaCodecSelector, 0L);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs) {
        this(context, mediaCodecSelector, allowedJoiningTimeMs, null, null, 0);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        this(context, MediaCodecAdapter.Factory.DEFAULT, mediaCodecSelector, allowedJoiningTimeMs, false, eventHandler, eventListener, maxDroppedFramesToNotify, 30.0f);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        this(context, MediaCodecAdapter.Factory.DEFAULT, mediaCodecSelector, allowedJoiningTimeMs, enableDecoderFallback, eventHandler, eventListener, maxDroppedFramesToNotify, 30.0f);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecAdapter.Factory codecAdapterFactory, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        this(context, codecAdapterFactory, mediaCodecSelector, allowedJoiningTimeMs, enableDecoderFallback, eventHandler, eventListener, maxDroppedFramesToNotify, 30.0f);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecAdapter.Factory codecAdapterFactory, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify, float assumedMinimumCodecOperatingRate) {
        this(context, codecAdapterFactory, mediaCodecSelector, allowedJoiningTimeMs, enableDecoderFallback, eventHandler, eventListener, maxDroppedFramesToNotify, assumedMinimumCodecOperatingRate, null);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecAdapter.Factory codecAdapterFactory, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify, float assumedMinimumCodecOperatingRate, @Nullable VideoSinkProvider videoSinkProvider) {
        super(2, codecAdapterFactory, mediaCodecSelector, enableDecoderFallback, assumedMinimumCodecOperatingRate);
        this.maxDroppedFramesToNotify = maxDroppedFramesToNotify;
        this.context = context.getApplicationContext();
        this.eventDispatcher = new VideoRendererEventListener.EventDispatcher(eventHandler, eventListener);
        if (videoSinkProvider == null) {
            videoSinkProvider = new CompositingVideoSinkProvider.Builder(this.context).build();
        }
        if (videoSinkProvider.getVideoFrameReleaseControl() == null) {
            MediaCodecVideoRenderer thisRef = this;
            videoSinkProvider.setVideoFrameReleaseControl(new VideoFrameReleaseControl(this.context, thisRef, allowedJoiningTimeMs));
        }
        this.videoSinkProvider = videoSinkProvider;
        this.videoFrameReleaseControl = (VideoFrameReleaseControl)Assertions.checkStateNotNull((Object)this.videoSinkProvider.getVideoFrameReleaseControl());
        this.videoFrameReleaseInfo = new VideoFrameReleaseControl.FrameReleaseInfo();
        this.deviceNeedsNoPostProcessWorkaround = MediaCodecVideoRenderer.deviceNeedsNoPostProcessWorkaround();
        this.scalingMode = 1;
        this.decodedVideoSize = VideoSize.UNKNOWN;
        this.tunnelingAudioSessionId = 0;
        this.reportedVideoSize = null;
    }

    @Override
    public boolean shouldForceReleaseFrame(long earlyUs, long elapsedSinceLastReleaseUs) {
        return this.shouldForceRenderOutputBuffer(earlyUs, elapsedSinceLastReleaseUs);
    }

    @Override
    public boolean shouldDropFrame(long earlyUs, long elapsedRealtimeUs, boolean isLastFrame) {
        return this.shouldDropOutputBuffer(earlyUs, elapsedRealtimeUs, isLastFrame);
    }

    @Override
    public boolean shouldIgnoreFrame(long earlyUs, long positionUs, long elapsedRealtimeUs, boolean isLastFrame, boolean treatDroppedBuffersAsSkipped) throws ExoPlaybackException {
        return this.shouldDropBuffersToKeyframe(earlyUs, elapsedRealtimeUs, isLastFrame) && this.maybeDropBuffersToKeyframe(positionUs, treatDroppedBuffersAsSkipped);
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    protected int supportsFormat(MediaCodecSelector mediaCodecSelector, Format format) throws MediaCodecUtil.DecoderQueryException {
        MediaCodecInfo tunnelingDecoderInfo;
        List<MediaCodecInfo> tunnelingDecoderInfos;
        int decoderSupport;
        String mimeType = format.sampleMimeType;
        if (!MimeTypes.isVideo((String)mimeType)) {
            return RendererCapabilities.create(0);
        }
        DrmInitData drmInitData = format.drmInitData;
        boolean requiresSecureDecryption = drmInitData != null;
        List<MediaCodecInfo> decoderInfos = MediaCodecVideoRenderer.getDecoderInfos(this.context, mediaCodecSelector, format, requiresSecureDecryption, false);
        if (requiresSecureDecryption && decoderInfos.isEmpty()) {
            decoderInfos = MediaCodecVideoRenderer.getDecoderInfos(this.context, mediaCodecSelector, format, false, false);
        }
        if (decoderInfos.isEmpty()) {
            return RendererCapabilities.create(1);
        }
        if (!MediaCodecVideoRenderer.supportsFormatDrm(format)) {
            return RendererCapabilities.create(2);
        }
        MediaCodecInfo decoderInfo = decoderInfos.get(0);
        boolean isFormatSupported = decoderInfo.isFormatSupported(format);
        boolean isPreferredDecoder = true;
        if (!isFormatSupported) {
            for (int i = 1; i < decoderInfos.size(); ++i) {
                MediaCodecInfo otherDecoderInfo = decoderInfos.get(i);
                if (!otherDecoderInfo.isFormatSupported(format)) continue;
                decoderInfo = otherDecoderInfo;
                isFormatSupported = true;
                isPreferredDecoder = false;
                break;
            }
        }
        int formatSupport = isFormatSupported ? 4 : 3;
        int adaptiveSupport = decoderInfo.isSeamlessAdaptationSupported(format) ? 16 : 8;
        int hardwareAccelerationSupport = decoderInfo.hardwareAccelerated ? 64 : 0;
        int n = decoderSupport = isPreferredDecoder ? 128 : 0;
        if (Util.SDK_INT >= 26 && "video/dolby-vision".equals(format.sampleMimeType) && !Api26.doesDisplaySupportDolbyVision(this.context)) {
            decoderSupport = 256;
        }
        int tunnelingSupport = 0;
        if (isFormatSupported && !(tunnelingDecoderInfos = MediaCodecVideoRenderer.getDecoderInfos(this.context, mediaCodecSelector, format, requiresSecureDecryption, true)).isEmpty() && (tunnelingDecoderInfo = MediaCodecUtil.getDecoderInfosSortedByFormatSupport(tunnelingDecoderInfos, format).get(0)).isFormatSupported(format) && tunnelingDecoderInfo.isSeamlessAdaptationSupported(format)) {
            tunnelingSupport = 32;
        }
        return RendererCapabilities.create(formatSupport, adaptiveSupport, tunnelingSupport, hardwareAccelerationSupport, decoderSupport);
    }

    @Override
    protected List<MediaCodecInfo> getDecoderInfos(MediaCodecSelector mediaCodecSelector, Format format, boolean requiresSecureDecoder) throws MediaCodecUtil.DecoderQueryException {
        return MediaCodecUtil.getDecoderInfosSortedByFormatSupport(MediaCodecVideoRenderer.getDecoderInfos(this.context, mediaCodecSelector, format, requiresSecureDecoder, this.tunneling), format);
    }

    private static List<MediaCodecInfo> getDecoderInfos(Context context, MediaCodecSelector mediaCodecSelector, Format format, boolean requiresSecureDecoder, boolean requiresTunnelingDecoder) throws MediaCodecUtil.DecoderQueryException {
        List<MediaCodecInfo> alternativeDecoderInfos;
        if (format.sampleMimeType == null) {
            return ImmutableList.of();
        }
        if (Util.SDK_INT >= 26 && "video/dolby-vision".equals(format.sampleMimeType) && !Api26.doesDisplaySupportDolbyVision(context) && !(alternativeDecoderInfos = MediaCodecUtil.getAlternativeDecoderInfos(mediaCodecSelector, format, requiresSecureDecoder, requiresTunnelingDecoder)).isEmpty()) {
            return alternativeDecoderInfos;
        }
        return MediaCodecUtil.getDecoderInfosSoftMatch(mediaCodecSelector, format, requiresSecureDecoder, requiresTunnelingDecoder);
    }

    @Override
    protected void onInit() {
        super.onInit();
        Clock clock = this.getClock();
        this.videoFrameReleaseControl.setClock(clock);
        this.videoSinkProvider.setClock(clock);
    }

    @Override
    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
        super.onEnabled(joining, mayRenderStartOfStream);
        boolean tunneling = this.getConfiguration().tunneling;
        Assertions.checkState((!tunneling || this.tunnelingAudioSessionId != 0 ? 1 : 0) != 0);
        if (this.tunneling != tunneling) {
            this.tunneling = tunneling;
            this.releaseCodec();
        }
        this.eventDispatcher.enabled(this.decoderCounters);
        this.videoFrameReleaseControl.onEnabled(mayRenderStartOfStream);
    }

    @Override
    public void enableMayRenderStartOfStream() {
        this.videoFrameReleaseControl.allowReleaseFirstFrameBeforeStarted();
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        if (this.videoSink != null) {
            this.videoSink.flush();
        }
        super.onPositionReset(positionUs, joining);
        if (this.videoSinkProvider.isInitialized()) {
            this.videoSinkProvider.setStreamOffsetUs(this.getOutputStreamOffsetUs());
        }
        this.videoFrameReleaseControl.reset();
        if (joining) {
            this.videoFrameReleaseControl.join();
        }
        this.maybeUpdateOnFrameRenderedListener();
        this.consecutiveDroppedFrameCount = 0;
    }

    @Override
    public boolean isEnded() {
        return super.isEnded() && (this.videoSink == null || this.videoSink.isEnded());
    }

    @Override
    public boolean isReady() {
        boolean readyToReleaseFrames;
        boolean bl = readyToReleaseFrames = super.isReady() && (this.videoSink == null || this.videoSink.isReady());
        if (readyToReleaseFrames && (this.placeholderSurface != null && this.displaySurface == this.placeholderSurface || this.getCodec() == null || this.tunneling)) {
            return true;
        }
        return this.videoFrameReleaseControl.isReady(readyToReleaseFrames);
    }

    @Override
    protected void onStarted() {
        long elapsedRealtimeMs;
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = elapsedRealtimeMs = this.getClock().elapsedRealtime();
        this.totalVideoFrameProcessingOffsetUs = 0L;
        this.videoFrameProcessingOffsetCount = 0;
        this.videoFrameReleaseControl.onStarted();
    }

    @Override
    protected void onStopped() {
        this.maybeNotifyDroppedFrames();
        this.maybeNotifyVideoFrameProcessingOffset();
        this.videoFrameReleaseControl.onStopped();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.reportedVideoSize = null;
        this.videoFrameReleaseControl.onDisabled();
        this.maybeUpdateOnFrameRenderedListener();
        this.haveReportedFirstFrameRenderedForCurrentSurface = false;
        this.tunnelingOnFrameRenderedListener = null;
        try {
            super.onDisabled();
        }
        finally {
            this.eventDispatcher.disabled(this.decoderCounters);
            this.eventDispatcher.videoSizeChanged(VideoSize.UNKNOWN);
        }
    }

    @Override
    @TargetApi(value=17)
    protected void onReset() {
        try {
            super.onReset();
        }
        finally {
            this.hasInitializedPlayback = false;
            if (this.placeholderSurface != null) {
                this.releasePlaceholderSurface();
            }
        }
    }

    @Override
    protected void onRelease() {
        super.onRelease();
        if (this.videoSinkProvider.isInitialized()) {
            this.videoSinkProvider.release();
        }
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
        switch (messageType) {
            case 1: {
                this.setOutput(message);
                break;
            }
            case 4: {
                this.scalingMode = (Integer)Assertions.checkNotNull((Object)message);
                MediaCodecAdapter codec = this.getCodec();
                if (codec == null) break;
                codec.setVideoScalingMode(this.scalingMode);
                break;
            }
            case 5: {
                this.videoFrameReleaseControl.setChangeFrameRateStrategy((Integer)Assertions.checkNotNull((Object)message));
                break;
            }
            case 7: {
                this.frameMetadataListener = (VideoFrameMetadataListener)Assertions.checkNotNull((Object)message);
                this.videoSinkProvider.setVideoFrameMetadataListener(this.frameMetadataListener);
                break;
            }
            case 10: {
                int tunnelingAudioSessionId = (Integer)Assertions.checkNotNull((Object)message);
                if (this.tunnelingAudioSessionId == tunnelingAudioSessionId) break;
                this.tunnelingAudioSessionId = tunnelingAudioSessionId;
                if (!this.tunneling) break;
                this.releaseCodec();
                break;
            }
            case 13: {
                List videoEffects = (List)Assertions.checkNotNull((Object)message);
                this.setVideoEffects(videoEffects);
                break;
            }
            case 14: {
                this.outputResolution = (Size)Assertions.checkNotNull((Object)message);
                if (!this.videoSinkProvider.isInitialized() || ((Size)Assertions.checkNotNull((Object)this.outputResolution)).getWidth() == 0 || ((Size)Assertions.checkNotNull((Object)this.outputResolution)).getHeight() == 0 || this.displaySurface == null) break;
                this.videoSinkProvider.setOutputSurfaceInfo(this.displaySurface, (Size)Assertions.checkNotNull((Object)this.outputResolution));
                break;
            }
            default: {
                super.handleMessage(messageType, message);
            }
        }
    }

    private void setOutput(@Nullable Object output) throws ExoPlaybackException {
        Surface displaySurface;
        Surface surface = displaySurface = output instanceof Surface ? (Surface)output : null;
        if (displaySurface == null) {
            if (this.placeholderSurface != null) {
                displaySurface = this.placeholderSurface;
            } else {
                MediaCodecInfo codecInfo = this.getCodecInfo();
                if (codecInfo != null && this.shouldUsePlaceholderSurface(codecInfo)) {
                    this.placeholderSurface = PlaceholderSurface.newInstanceV17(this.context, codecInfo.secure);
                    displaySurface = this.placeholderSurface;
                }
            }
        }
        if (this.displaySurface != displaySurface) {
            this.displaySurface = displaySurface;
            this.videoFrameReleaseControl.setOutputSurface(displaySurface);
            this.haveReportedFirstFrameRenderedForCurrentSurface = false;
            int state = this.getState();
            MediaCodecAdapter codec = this.getCodec();
            if (codec != null && !this.videoSinkProvider.isInitialized()) {
                if (Util.SDK_INT >= 23 && displaySurface != null && !this.codecNeedsSetOutputSurfaceWorkaround) {
                    this.setOutputSurfaceV23(codec, displaySurface);
                } else {
                    this.releaseCodec();
                    this.maybeInitCodecOrBypass();
                }
            }
            if (displaySurface != null && displaySurface != this.placeholderSurface) {
                this.maybeRenotifyVideoSizeChanged();
                if (state == 2) {
                    this.videoFrameReleaseControl.join();
                }
                if (this.videoSinkProvider.isInitialized()) {
                    this.videoSinkProvider.setOutputSurfaceInfo(displaySurface, Size.UNKNOWN);
                }
            } else {
                this.reportedVideoSize = null;
                if (this.videoSinkProvider.isInitialized()) {
                    this.videoSinkProvider.clearOutputSurfaceInfo();
                }
            }
            this.maybeUpdateOnFrameRenderedListener();
        } else if (displaySurface != null && displaySurface != this.placeholderSurface) {
            this.maybeRenotifyVideoSizeChanged();
            this.maybeRenotifyRenderedFirstFrame();
        }
    }

    @Override
    protected boolean shouldInitCodec(MediaCodecInfo codecInfo) {
        return this.displaySurface != null || this.shouldUsePlaceholderSurface(codecInfo);
    }

    @Override
    protected boolean getCodecNeedsEosPropagation() {
        return this.tunneling && Util.SDK_INT < 23;
    }

    @Override
    @TargetApi(value=17)
    protected MediaCodecAdapter.Configuration getMediaCodecConfiguration(MediaCodecInfo codecInfo, Format format, @Nullable MediaCrypto crypto, float codecOperatingRate) {
        if (this.placeholderSurface != null && this.placeholderSurface.secure != codecInfo.secure) {
            this.releasePlaceholderSurface();
        }
        String codecMimeType = codecInfo.codecMimeType;
        this.codecMaxValues = this.getCodecMaxValues(codecInfo, format, this.getStreamFormats());
        MediaFormat mediaFormat = this.getMediaFormat(format, codecMimeType, this.codecMaxValues, codecOperatingRate, this.deviceNeedsNoPostProcessWorkaround, this.tunneling ? this.tunnelingAudioSessionId : 0);
        if (this.displaySurface == null) {
            if (!this.shouldUsePlaceholderSurface(codecInfo)) {
                throw new IllegalStateException();
            }
            if (this.placeholderSurface == null) {
                this.placeholderSurface = PlaceholderSurface.newInstanceV17(this.context, codecInfo.secure);
            }
            this.displaySurface = this.placeholderSurface;
        }
        this.maybeSetKeyAllowFrameDrop(mediaFormat);
        return MediaCodecAdapter.Configuration.createForVideoDecoding(codecInfo, mediaFormat, format, this.videoSink != null ? this.videoSink.getInputSurface() : this.displaySurface, crypto);
    }

    private void maybeSetKeyAllowFrameDrop(MediaFormat mediaFormat) {
        if (this.videoSink != null && !this.videoSink.isFrameDropAllowedOnInput()) {
            mediaFormat.setInteger("allow-frame-drop", 0);
        }
    }

    @Override
    protected DecoderReuseEvaluation canReuseCodec(MediaCodecInfo codecInfo, Format oldFormat, Format newFormat) {
        DecoderReuseEvaluation evaluation = codecInfo.canReuseCodec(oldFormat, newFormat);
        int discardReasons = evaluation.discardReasons;
        CodecMaxValues codecMaxValues = (CodecMaxValues)Assertions.checkNotNull((Object)this.codecMaxValues);
        if (newFormat.width > codecMaxValues.width || newFormat.height > codecMaxValues.height) {
            discardReasons |= 0x100;
        }
        if (MediaCodecVideoRenderer.getMaxInputSize(codecInfo, newFormat) > codecMaxValues.inputSize) {
            discardReasons |= 0x40;
        }
        return new DecoderReuseEvaluation(codecInfo.name, oldFormat, newFormat, discardReasons != 0 ? 0 : evaluation.result, discardReasons);
    }

    @Override
    @CallSuper
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        super.render(positionUs, elapsedRealtimeUs);
        if (this.videoSink != null) {
            try {
                this.videoSink.render(positionUs, elapsedRealtimeUs);
            }
            catch (VideoSink.VideoSinkException e) {
                throw this.createRendererException(e, e.format, 7001);
            }
        }
    }

    @Override
    @CallSuper
    protected void resetCodecStateForFlush() {
        super.resetCodecStateForFlush();
        this.buffersInCodecCount = 0;
    }

    @Override
    public void setPlaybackSpeed(float currentPlaybackSpeed, float targetPlaybackSpeed) throws ExoPlaybackException {
        super.setPlaybackSpeed(currentPlaybackSpeed, targetPlaybackSpeed);
        this.videoFrameReleaseControl.setPlaybackSpeed(currentPlaybackSpeed);
        if (this.videoSink != null) {
            this.videoSink.setPlaybackSpeed(currentPlaybackSpeed);
        }
    }

    public static int getCodecMaxInputSize(MediaCodecInfo codecInfo, Format format) {
        int width = format.width;
        int height = format.height;
        if (width == -1 || height == -1) {
            return -1;
        }
        String sampleMimeType = (String)Assertions.checkNotNull((Object)format.sampleMimeType);
        if ("video/dolby-vision".equals(sampleMimeType)) {
            int profile;
            sampleMimeType = "video/hevc";
            Pair<Integer, Integer> codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel(format);
            if (codecProfileAndLevel != null && ((profile = ((Integer)codecProfileAndLevel.first).intValue()) == 512 || profile == 1 || profile == 2)) {
                sampleMimeType = "video/avc";
            }
        }
        switch (sampleMimeType) {
            case "video/3gpp": 
            case "video/mp4v-es": 
            case "video/av01": 
            case "video/x-vnd.on2.vp8": {
                return MediaCodecVideoRenderer.getMaxSampleSize(width * height, 2);
            }
            case "video/hevc": {
                return Math.max(0x200000, MediaCodecVideoRenderer.getMaxSampleSize(width * height, 2));
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(Util.MODEL) || "Amazon".equals(Util.MANUFACTURER) && ("KFSOWI".equals(Util.MODEL) || "AFTS".equals(Util.MODEL) && codecInfo.secure)) {
                    return -1;
                }
                int maxPixels = Util.ceilDivide((int)width, (int)16) * Util.ceilDivide((int)height, (int)16) * 16 * 16;
                return MediaCodecVideoRenderer.getMaxSampleSize(maxPixels, 2);
            }
            case "video/x-vnd.on2.vp9": {
                return MediaCodecVideoRenderer.getMaxSampleSize(width * height, 4);
            }
        }
        return -1;
    }

    @Override
    protected float getCodecOperatingRateV23(float targetPlaybackSpeed, Format format, Format[] streamFormats) {
        float maxFrameRate = -1.0f;
        for (Format streamFormat : streamFormats) {
            float streamFrameRate = streamFormat.frameRate;
            if (streamFrameRate == -1.0f) continue;
            maxFrameRate = Math.max(maxFrameRate, streamFrameRate);
        }
        return maxFrameRate == -1.0f ? -1.0f : maxFrameRate * targetPlaybackSpeed;
    }

    @Override
    @CallSuper
    protected void onReadyToInitializeCodec(Format format) throws ExoPlaybackException {
        if (this.hasEffects && !this.hasInitializedPlayback && !this.videoSinkProvider.isInitialized()) {
            try {
                this.videoSinkProvider.initialize(format);
                this.videoSinkProvider.setStreamOffsetUs(this.getOutputStreamOffsetUs());
                if (this.frameMetadataListener != null) {
                    this.videoSinkProvider.setVideoFrameMetadataListener(this.frameMetadataListener);
                }
                if (this.displaySurface != null && this.outputResolution != null) {
                    this.videoSinkProvider.setOutputSurfaceInfo(this.displaySurface, this.outputResolution);
                }
            }
            catch (VideoSink.VideoSinkException e) {
                throw this.createRendererException(e, format, 7000);
            }
        }
        if (this.videoSink == null && this.videoSinkProvider.isInitialized()) {
            this.videoSink = this.videoSinkProvider.getSink();
            this.videoSink.setListener(new VideoSink.Listener(){

                @Override
                public void onFirstFrameRendered(VideoSink videoSink) {
                    Assertions.checkStateNotNull((Object)MediaCodecVideoRenderer.this.displaySurface);
                    MediaCodecVideoRenderer.this.notifyRenderedFirstFrame();
                }

                @Override
                public void onFrameDropped(VideoSink videoSink) {
                    MediaCodecVideoRenderer.this.updateDroppedBufferCounters(0, 1);
                }

                @Override
                public void onVideoSizeChanged(VideoSink videoSink, VideoSize videoSize) {
                }

                @Override
                public void onError(VideoSink videoSink, VideoSink.VideoSinkException videoSinkException) {
                    MediaCodecVideoRenderer.this.setPendingPlaybackException(MediaCodecVideoRenderer.this.createRendererException(videoSinkException, videoSinkException.format, 7001));
                }
            }, MoreExecutors.directExecutor());
        }
        this.hasInitializedPlayback = true;
    }

    public void setVideoEffects(List<Effect> effects) {
        this.videoSinkProvider.setVideoEffects(effects);
        this.hasEffects = true;
    }

    @Override
    protected void onCodecInitialized(String name, MediaCodecAdapter.Configuration configuration, long initializedTimestampMs, long initializationDurationMs) {
        this.eventDispatcher.decoderInitialized(name, initializedTimestampMs, initializationDurationMs);
        this.codecNeedsSetOutputSurfaceWorkaround = this.codecNeedsSetOutputSurfaceWorkaround(name);
        this.codecHandlesHdr10PlusOutOfBandMetadata = ((MediaCodecInfo)Assertions.checkNotNull((Object)this.getCodecInfo())).isHdr10PlusOutOfBandMetadataSupported();
        if (Util.SDK_INT >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new OnFrameRenderedListenerV23((MediaCodecAdapter)Assertions.checkNotNull((Object)this.getCodec()));
        }
    }

    @Override
    protected void onCodecReleased(String name) {
        this.eventDispatcher.decoderReleased(name);
    }

    @Override
    protected void onCodecError(Exception codecError) {
        Log.e((String)TAG, (String)"Video codec error", (Throwable)codecError);
        this.eventDispatcher.videoCodecError(codecError);
    }

    @Override
    @Nullable
    protected DecoderReuseEvaluation onInputFormatChanged(FormatHolder formatHolder) throws ExoPlaybackException {
        DecoderReuseEvaluation evaluation = super.onInputFormatChanged(formatHolder);
        this.eventDispatcher.inputFormatChanged((Format)Assertions.checkNotNull((Object)formatHolder.format), evaluation);
        return evaluation;
    }

    @Override
    @CallSuper
    protected void onQueueInputBuffer(DecoderInputBuffer buffer) throws ExoPlaybackException {
        if (!this.tunneling) {
            ++this.buffersInCodecCount;
        }
        if (Util.SDK_INT < 23 && this.tunneling) {
            this.onProcessedTunneledBuffer(buffer.timeUs);
        }
    }

    @Override
    protected int getCodecBufferFlags(DecoderInputBuffer buffer) {
        if (Util.SDK_INT >= 34 && this.tunneling && buffer.timeUs < this.getLastResetPositionUs()) {
            return 32;
        }
        return 0;
    }

    @Override
    protected void onOutputFormatChanged(Format format, @Nullable MediaFormat mediaFormat) {
        int height;
        int width;
        MediaCodecAdapter codec = this.getCodec();
        if (codec != null) {
            codec.setVideoScalingMode(this.scalingMode);
        }
        int unappliedRotationDegrees = 0;
        if (this.tunneling) {
            width = format.width;
            height = format.height;
        } else {
            Assertions.checkNotNull((Object)mediaFormat);
            boolean hasCrop = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
            width = hasCrop ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
            height = hasCrop ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        }
        float pixelWidthHeightRatio = format.pixelWidthHeightRatio;
        if (MediaCodecVideoRenderer.codecAppliesRotation()) {
            if (format.rotationDegrees == 90 || format.rotationDegrees == 270) {
                int rotatedHeight = width;
                width = height;
                height = rotatedHeight;
                pixelWidthHeightRatio = 1.0f / pixelWidthHeightRatio;
            }
        } else if (this.videoSink == null) {
            unappliedRotationDegrees = format.rotationDegrees;
        }
        this.decodedVideoSize = new VideoSize(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
        this.videoFrameReleaseControl.setFrameRate(format.frameRate);
        if (this.videoSink != null && mediaFormat != null) {
            this.onReadyToRegisterVideoSinkInputStream();
            ((VideoSink)Assertions.checkNotNull((Object)this.videoSink)).registerInputStream(1, format.buildUpon().setWidth(width).setHeight(height).setRotationDegrees(unappliedRotationDegrees).setPixelWidthHeightRatio(pixelWidthHeightRatio).build());
        }
    }

    protected void onReadyToRegisterVideoSinkInputStream() {
    }

    @Override
    @TargetApi(value=29)
    protected void handleInputBufferSupplementalData(DecoderInputBuffer buffer) throws ExoPlaybackException {
        if (!this.codecHandlesHdr10PlusOutOfBandMetadata) {
            return;
        }
        ByteBuffer data = (ByteBuffer)Assertions.checkNotNull((Object)buffer.supplementalData);
        if (data.remaining() >= 7) {
            byte ituTT35CountryCode = data.get();
            short ituTT35TerminalProviderCode = data.getShort();
            short ituTT35TerminalProviderOrientedCode = data.getShort();
            byte applicationIdentifier = data.get();
            byte applicationVersion = data.get();
            data.position(0);
            if (ituTT35CountryCode == -75 && ituTT35TerminalProviderCode == 60 && ituTT35TerminalProviderOrientedCode == 1 && applicationIdentifier == 4 && (applicationVersion == 0 || applicationVersion == 1)) {
                byte[] hdr10PlusInfo = new byte[data.remaining()];
                data.get(hdr10PlusInfo);
                data.position(0);
                MediaCodecVideoRenderer.setHdr10PlusInfoV29((MediaCodecAdapter)Assertions.checkNotNull((Object)this.getCodec()), hdr10PlusInfo);
            }
        }
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, @Nullable MediaCodecAdapter codec, @Nullable ByteBuffer buffer, int bufferIndex, int bufferFlags, int sampleCount, long bufferPresentationTimeUs, boolean isDecodeOnlyBuffer, boolean isLastBuffer, Format format) throws ExoPlaybackException {
        Assertions.checkNotNull((Object)codec);
        long outputStreamOffsetUs = this.getOutputStreamOffsetUs();
        long presentationTimeUs = bufferPresentationTimeUs - outputStreamOffsetUs;
        int frameReleaseAction = this.videoFrameReleaseControl.getFrameReleaseAction(bufferPresentationTimeUs, positionUs, elapsedRealtimeUs, this.getOutputStreamStartPositionUs(), isLastBuffer, this.videoFrameReleaseInfo);
        if (isDecodeOnlyBuffer && !isLastBuffer) {
            this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
            return true;
        }
        if (this.displaySurface == this.placeholderSurface) {
            if (this.videoFrameReleaseInfo.getEarlyUs() < 30000L) {
                this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
                this.updateVideoFrameProcessingOffsetCounters(this.videoFrameReleaseInfo.getEarlyUs());
                return true;
            }
            return false;
        }
        if (this.videoSink != null) {
            try {
                this.videoSink.render(positionUs, elapsedRealtimeUs);
            }
            catch (VideoSink.VideoSinkException e) {
                throw this.createRendererException(e, e.format, 7001);
            }
            long releaseTimeNs = this.videoSink.registerInputFrame(presentationTimeUs, isLastBuffer);
            if (releaseTimeNs == -9223372036854775807L) {
                return false;
            }
            this.renderOutputBuffer(codec, bufferIndex, presentationTimeUs, releaseTimeNs);
            return true;
        }
        switch (frameReleaseAction) {
            case 0: {
                long releaseTimeNs = this.getClock().nanoTime();
                this.notifyFrameMetadataListener(presentationTimeUs, releaseTimeNs, format);
                this.renderOutputBuffer(codec, bufferIndex, presentationTimeUs, releaseTimeNs);
                this.updateVideoFrameProcessingOffsetCounters(this.videoFrameReleaseInfo.getEarlyUs());
                return true;
            }
            case 3: {
                this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
                this.updateVideoFrameProcessingOffsetCounters(this.videoFrameReleaseInfo.getEarlyUs());
                return true;
            }
            case 2: {
                this.dropOutputBuffer(codec, bufferIndex, presentationTimeUs);
                this.updateVideoFrameProcessingOffsetCounters(this.videoFrameReleaseInfo.getEarlyUs());
                return true;
            }
            case 4: 
            case 5: {
                return false;
            }
            case 1: {
                return this.maybeReleaseFrame((MediaCodecAdapter)Assertions.checkStateNotNull((Object)codec), bufferIndex, presentationTimeUs, format);
            }
        }
        throw new IllegalStateException(String.valueOf(frameReleaseAction));
    }

    private boolean maybeReleaseFrame(MediaCodecAdapter codec, int bufferIndex, long presentationTimeUs, Format format) {
        long releaseTimeNs = this.videoFrameReleaseInfo.getReleaseTimeNs();
        long earlyUs = this.videoFrameReleaseInfo.getEarlyUs();
        if (Util.SDK_INT >= 21) {
            if (this.shouldSkipBuffersWithIdenticalReleaseTime() && releaseTimeNs == this.lastFrameReleaseTimeNs) {
                this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
            } else {
                this.notifyFrameMetadataListener(presentationTimeUs, releaseTimeNs, format);
                this.renderOutputBufferV21(codec, bufferIndex, presentationTimeUs, releaseTimeNs);
            }
            this.updateVideoFrameProcessingOffsetCounters(earlyUs);
            this.lastFrameReleaseTimeNs = releaseTimeNs;
            return true;
        }
        if (earlyUs < 30000L) {
            if (earlyUs > 11000L) {
                try {
                    Thread.sleep((earlyUs - 10000L) / 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            this.notifyFrameMetadataListener(presentationTimeUs, releaseTimeNs, format);
            this.renderOutputBuffer(codec, bufferIndex, presentationTimeUs);
            this.updateVideoFrameProcessingOffsetCounters(earlyUs);
            return true;
        }
        return false;
    }

    private void notifyFrameMetadataListener(long presentationTimeUs, long releaseTimeNs, Format format) {
        if (this.frameMetadataListener != null) {
            this.frameMetadataListener.onVideoFrameAboutToBeRendered(presentationTimeUs, releaseTimeNs, format, this.getCodecOutputMediaFormat());
        }
    }

    protected void onProcessedTunneledBuffer(long presentationTimeUs) throws ExoPlaybackException {
        this.updateOutputFormatForTime(presentationTimeUs);
        this.maybeNotifyVideoSizeChanged(this.decodedVideoSize);
        ++this.decoderCounters.renderedOutputBufferCount;
        this.maybeNotifyRenderedFirstFrame();
        this.onProcessedOutputBuffer(presentationTimeUs);
    }

    private void onProcessedTunneledEndOfStream() {
        this.setPendingOutputEndOfStream();
    }

    @Override
    @CallSuper
    protected void onProcessedOutputBuffer(long presentationTimeUs) {
        super.onProcessedOutputBuffer(presentationTimeUs);
        if (!this.tunneling) {
            --this.buffersInCodecCount;
        }
    }

    @Override
    protected void onProcessedStreamChange() {
        super.onProcessedStreamChange();
        this.videoFrameReleaseControl.onProcessedStreamChange();
        this.maybeUpdateOnFrameRenderedListener();
        if (this.videoSinkProvider.isInitialized()) {
            this.videoSinkProvider.setStreamOffsetUs(this.getOutputStreamOffsetUs());
        }
    }

    protected boolean shouldDropOutputBuffer(long earlyUs, long elapsedRealtimeUs, boolean isLastBuffer) {
        return earlyUs < -30000L && !isLastBuffer;
    }

    protected boolean shouldDropBuffersToKeyframe(long earlyUs, long elapsedRealtimeUs, boolean isLastBuffer) {
        return earlyUs < -500000L && !isLastBuffer;
    }

    protected boolean shouldSkipBuffersWithIdenticalReleaseTime() {
        return true;
    }

    protected boolean shouldForceRenderOutputBuffer(long earlyUs, long elapsedSinceLastRenderUs) {
        return earlyUs < -30000L && elapsedSinceLastRenderUs > 100000L;
    }

    protected void skipOutputBuffer(MediaCodecAdapter codec, int index, long presentationTimeUs) {
        TraceUtil.beginSection((String)"skipVideoBuffer");
        codec.releaseOutputBuffer(index, false);
        TraceUtil.endSection();
        ++this.decoderCounters.skippedOutputBufferCount;
    }

    protected void dropOutputBuffer(MediaCodecAdapter codec, int index, long presentationTimeUs) {
        TraceUtil.beginSection((String)"dropVideoBuffer");
        codec.releaseOutputBuffer(index, false);
        TraceUtil.endSection();
        this.updateDroppedBufferCounters(0, 1);
    }

    protected boolean maybeDropBuffersToKeyframe(long positionUs, boolean treatDroppedBuffersAsSkipped) throws ExoPlaybackException {
        int droppedSourceBufferCount = this.skipSource(positionUs);
        if (droppedSourceBufferCount == 0) {
            return false;
        }
        if (treatDroppedBuffersAsSkipped) {
            this.decoderCounters.skippedInputBufferCount += droppedSourceBufferCount;
            this.decoderCounters.skippedOutputBufferCount += this.buffersInCodecCount;
        } else {
            ++this.decoderCounters.droppedToKeyframeCount;
            this.updateDroppedBufferCounters(droppedSourceBufferCount, this.buffersInCodecCount);
        }
        this.flushOrReinitializeCodec();
        if (this.videoSink != null) {
            this.videoSink.flush();
        }
        return true;
    }

    protected void updateDroppedBufferCounters(int droppedInputBufferCount, int droppedDecoderBufferCount) {
        this.decoderCounters.droppedInputBufferCount += droppedInputBufferCount;
        int totalDroppedBufferCount = droppedInputBufferCount + droppedDecoderBufferCount;
        this.decoderCounters.droppedBufferCount += totalDroppedBufferCount;
        this.droppedFrames += totalDroppedBufferCount;
        this.consecutiveDroppedFrameCount += totalDroppedBufferCount;
        this.decoderCounters.maxConsecutiveDroppedBufferCount = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.maxConsecutiveDroppedBufferCount);
        if (this.maxDroppedFramesToNotify > 0 && this.droppedFrames >= this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    protected void updateVideoFrameProcessingOffsetCounters(long processingOffsetUs) {
        this.decoderCounters.addVideoFrameProcessingOffset(processingOffsetUs);
        this.totalVideoFrameProcessingOffsetUs += processingOffsetUs;
        ++this.videoFrameProcessingOffsetCount;
    }

    private void renderOutputBuffer(MediaCodecAdapter codec, int index, long presentationTimeUs, long releaseTimeNs) {
        if (Util.SDK_INT >= 21) {
            this.renderOutputBufferV21(codec, index, presentationTimeUs, releaseTimeNs);
        } else {
            this.renderOutputBuffer(codec, index, presentationTimeUs);
        }
    }

    protected void renderOutputBuffer(MediaCodecAdapter codec, int index, long presentationTimeUs) {
        TraceUtil.beginSection((String)"releaseOutputBuffer");
        codec.releaseOutputBuffer(index, true);
        TraceUtil.endSection();
        ++this.decoderCounters.renderedOutputBufferCount;
        this.consecutiveDroppedFrameCount = 0;
        if (this.videoSink == null) {
            this.maybeNotifyVideoSizeChanged(this.decodedVideoSize);
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    @RequiresApi(value=21)
    protected void renderOutputBufferV21(MediaCodecAdapter codec, int index, long presentationTimeUs, long releaseTimeNs) {
        TraceUtil.beginSection((String)"releaseOutputBuffer");
        codec.releaseOutputBuffer(index, releaseTimeNs);
        TraceUtil.endSection();
        ++this.decoderCounters.renderedOutputBufferCount;
        this.consecutiveDroppedFrameCount = 0;
        if (this.videoSink == null) {
            this.maybeNotifyVideoSizeChanged(this.decodedVideoSize);
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    private boolean shouldUsePlaceholderSurface(MediaCodecInfo codecInfo) {
        return Util.SDK_INT >= 23 && !this.tunneling && !this.codecNeedsSetOutputSurfaceWorkaround(codecInfo.name) && (!codecInfo.secure || PlaceholderSurface.isSecureSupported(this.context));
    }

    @RequiresApi(value=17)
    private void releasePlaceholderSurface() {
        if (this.displaySurface == this.placeholderSurface) {
            this.displaySurface = null;
        }
        if (this.placeholderSurface != null) {
            this.placeholderSurface.release();
            this.placeholderSurface = null;
        }
    }

    private void maybeUpdateOnFrameRenderedListener() {
        MediaCodecAdapter codec;
        if (Util.SDK_INT >= 23 && this.tunneling && (codec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new OnFrameRenderedListenerV23(codec);
        }
    }

    private void maybeNotifyRenderedFirstFrame() {
        if (this.videoFrameReleaseControl.onFrameReleasedIsFirstFrame() && this.displaySurface != null) {
            this.notifyRenderedFirstFrame();
        }
    }

    @RequiresNonNull(value={"displaySurface"})
    private void notifyRenderedFirstFrame() {
        this.eventDispatcher.renderedFirstFrame(this.displaySurface);
        this.haveReportedFirstFrameRenderedForCurrentSurface = true;
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.displaySurface != null && this.haveReportedFirstFrameRenderedForCurrentSurface) {
            this.eventDispatcher.renderedFirstFrame(this.displaySurface);
        }
    }

    private void maybeNotifyVideoSizeChanged(VideoSize newOutputSize) {
        if (!newOutputSize.equals((Object)VideoSize.UNKNOWN) && !newOutputSize.equals((Object)this.reportedVideoSize)) {
            this.reportedVideoSize = newOutputSize;
            this.eventDispatcher.videoSizeChanged(this.reportedVideoSize);
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedVideoSize != null) {
            this.eventDispatcher.videoSizeChanged(this.reportedVideoSize);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long now = this.getClock().elapsedRealtime();
            long elapsedMs = now - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.droppedFrames(this.droppedFrames, elapsedMs);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = now;
        }
    }

    private void maybeNotifyVideoFrameProcessingOffset() {
        if (this.videoFrameProcessingOffsetCount != 0) {
            this.eventDispatcher.reportVideoFrameProcessingOffset(this.totalVideoFrameProcessingOffsetUs, this.videoFrameProcessingOffsetCount);
            this.totalVideoFrameProcessingOffsetUs = 0L;
            this.videoFrameProcessingOffsetCount = 0;
        }
    }

    @RequiresApi(value=29)
    private static void setHdr10PlusInfoV29(MediaCodecAdapter codec, byte[] hdr10PlusInfo) {
        Bundle codecParameters = new Bundle();
        codecParameters.putByteArray("hdr10-plus-info", hdr10PlusInfo);
        codec.setParameters(codecParameters);
    }

    @RequiresApi(value=23)
    protected void setOutputSurfaceV23(MediaCodecAdapter codec, Surface surface) {
        codec.setOutputSurface(surface);
    }

    @RequiresApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int tunnelingAudioSessionId) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", tunnelingAudioSessionId);
    }

    @SuppressLint(value={"InlinedApi"})
    @TargetApi(value=21)
    protected MediaFormat getMediaFormat(Format format, String codecMimeType, CodecMaxValues codecMaxValues, float codecOperatingRate, boolean deviceNeedsNoPostProcessWorkaround, int tunnelingAudioSessionId) {
        Pair<Integer, Integer> codecProfileAndLevel;
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", codecMimeType);
        mediaFormat.setInteger("width", format.width);
        mediaFormat.setInteger("height", format.height);
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        MediaFormatUtil.maybeSetFloat((MediaFormat)mediaFormat, (String)"frame-rate", (float)format.frameRate);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"rotation-degrees", (int)format.rotationDegrees);
        MediaFormatUtil.maybeSetColorInfo((MediaFormat)mediaFormat, (ColorInfo)format.colorInfo);
        if ("video/dolby-vision".equals(format.sampleMimeType) && (codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel(format)) != null) {
            MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"profile", (int)((Integer)codecProfileAndLevel.first));
        }
        mediaFormat.setInteger("max-width", codecMaxValues.width);
        mediaFormat.setInteger("max-height", codecMaxValues.height);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"max-input-size", (int)codecMaxValues.inputSize);
        if (Util.SDK_INT >= 23) {
            mediaFormat.setInteger("priority", 0);
            if (codecOperatingRate != -1.0f) {
                mediaFormat.setFloat("operating-rate", codecOperatingRate);
            }
        }
        if (deviceNeedsNoPostProcessWorkaround) {
            mediaFormat.setInteger("no-post-process", 1);
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (tunnelingAudioSessionId != 0) {
            MediaCodecVideoRenderer.configureTunnelingV21(mediaFormat, tunnelingAudioSessionId);
        }
        return mediaFormat;
    }

    protected CodecMaxValues getCodecMaxValues(MediaCodecInfo codecInfo, Format format, Format[] streamFormats) {
        int maxWidth = format.width;
        int maxHeight = format.height;
        int maxInputSize = MediaCodecVideoRenderer.getMaxInputSize(codecInfo, format);
        if (streamFormats.length == 1) {
            int codecMaxInputSize;
            if (maxInputSize != -1 && (codecMaxInputSize = MediaCodecVideoRenderer.getCodecMaxInputSize(codecInfo, format)) != -1) {
                int scaledMaxInputSize = (int)((float)maxInputSize * 1.5f);
                maxInputSize = Math.min(scaledMaxInputSize, codecMaxInputSize);
            }
            return new CodecMaxValues(maxWidth, maxHeight, maxInputSize);
        }
        boolean haveUnknownDimensions = false;
        for (Format streamFormat : streamFormats) {
            if (format.colorInfo != null && streamFormat.colorInfo == null) {
                streamFormat = streamFormat.buildUpon().setColorInfo(format.colorInfo).build();
            }
            if (codecInfo.canReuseCodec((Format)format, (Format)streamFormat).result == 0) continue;
            haveUnknownDimensions |= streamFormat.width == -1 || streamFormat.height == -1;
            maxWidth = Math.max(maxWidth, streamFormat.width);
            maxHeight = Math.max(maxHeight, streamFormat.height);
            maxInputSize = Math.max(maxInputSize, MediaCodecVideoRenderer.getMaxInputSize(codecInfo, streamFormat));
        }
        if (haveUnknownDimensions) {
            Log.w((String)TAG, (String)("Resolutions unknown. Codec max resolution: " + maxWidth + "x" + maxHeight));
            Point codecMaxSize = MediaCodecVideoRenderer.getCodecMaxSize(codecInfo, format);
            if (codecMaxSize != null) {
                maxWidth = Math.max(maxWidth, codecMaxSize.x);
                maxHeight = Math.max(maxHeight, codecMaxSize.y);
                maxInputSize = Math.max(maxInputSize, MediaCodecVideoRenderer.getCodecMaxInputSize(codecInfo, format.buildUpon().setWidth(maxWidth).setHeight(maxHeight).build()));
                Log.w((String)TAG, (String)("Codec max resolution adjusted to: " + maxWidth + "x" + maxHeight));
            }
        }
        return new CodecMaxValues(maxWidth, maxHeight, maxInputSize);
    }

    @Override
    protected MediaCodecDecoderException createDecoderException(Throwable cause, @Nullable MediaCodecInfo codecInfo) {
        return new MediaCodecVideoDecoderException(cause, codecInfo, this.displaySurface);
    }

    @Nullable
    private static Point getCodecMaxSize(MediaCodecInfo codecInfo, Format format) {
        boolean isVerticalVideo = format.height > format.width;
        int formatLongEdgePx = isVerticalVideo ? format.height : format.width;
        int formatShortEdgePx = isVerticalVideo ? format.width : format.height;
        float aspectRatio = (float)formatShortEdgePx / (float)formatLongEdgePx;
        for (int longEdgePx : STANDARD_LONG_EDGE_VIDEO_PX) {
            int shortEdgePx = (int)((float)longEdgePx * aspectRatio);
            if (longEdgePx <= formatLongEdgePx || shortEdgePx <= formatShortEdgePx) {
                return null;
            }
            if (Util.SDK_INT >= 21) {
                Point alignedSize = codecInfo.alignVideoSizeV21(isVerticalVideo ? shortEdgePx : longEdgePx, isVerticalVideo ? longEdgePx : shortEdgePx);
                float frameRate = format.frameRate;
                if (alignedSize == null || !codecInfo.isVideoSizeAndRateSupportedV21(alignedSize.x, alignedSize.y, frameRate)) continue;
                return alignedSize;
            }
            try {
                longEdgePx = Util.ceilDivide((int)longEdgePx, (int)16) * 16;
                shortEdgePx = Util.ceilDivide((int)shortEdgePx, (int)16) * 16;
                if (longEdgePx * shortEdgePx > MediaCodecUtil.maxH264DecodableFrameSize()) continue;
                return new Point(isVerticalVideo ? shortEdgePx : longEdgePx, isVerticalVideo ? longEdgePx : shortEdgePx);
            }
            catch (MediaCodecUtil.DecoderQueryException e) {
                return null;
            }
        }
        return null;
    }

    protected static int getMaxInputSize(MediaCodecInfo codecInfo, Format format) {
        if (format.maxInputSize != -1) {
            int totalInitializationDataSize = 0;
            int initializationDataCount = format.initializationData.size();
            for (int i = 0; i < initializationDataCount; ++i) {
                totalInitializationDataSize += ((byte[])format.initializationData.get(i)).length;
            }
            return format.maxInputSize + totalInitializationDataSize;
        }
        return MediaCodecVideoRenderer.getCodecMaxInputSize(codecInfo, format);
    }

    private static boolean codecAppliesRotation() {
        return Util.SDK_INT >= 21;
    }

    private static boolean deviceNeedsNoPostProcessWorkaround() {
        return "NVIDIA".equals(Util.MANUFACTURER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean codecNeedsSetOutputSurfaceWorkaround(String name) {
        if (name.startsWith("OMX.google")) {
            return false;
        }
        Class<MediaCodecVideoRenderer> clazz = MediaCodecVideoRenderer.class;
        synchronized (MediaCodecVideoRenderer.class) {
            if (!evaluatedDeviceNeedsSetOutputSurfaceWorkaround) {
                deviceNeedsSetOutputSurfaceWorkaround = MediaCodecVideoRenderer.evaluateDeviceNeedsSetOutputSurfaceWorkaround();
                evaluatedDeviceNeedsSetOutputSurfaceWorkaround = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return deviceNeedsSetOutputSurfaceWorkaround;
        }
    }

    @Nullable
    protected Surface getSurface() {
        return this.displaySurface;
    }

    private static int getMaxSampleSize(int pixelCount, int minCompressionRatio) {
        return pixelCount * 3 / (2 * minCompressionRatio);
    }

    private static boolean evaluateDeviceNeedsSetOutputSurfaceWorkaround() {
        if (Util.SDK_INT <= 28) {
            switch (Util.DEVICE) {
                case "aquaman": 
                case "dangal": 
                case "dangalUHD": 
                case "dangalFHD": 
                case "magnolia": 
                case "machuca": 
                case "once": 
                case "oneday": {
                    return true;
                }
            }
        }
        if (Util.SDK_INT <= 27 && "HWEML".equals(Util.DEVICE)) {
            return true;
        }
        switch (Util.MODEL) {
            case "AFTA": 
            case "AFTN": 
            case "AFTR": 
            case "AFTEU011": 
            case "AFTEU014": 
            case "AFTEUFF014": 
            case "AFTJMST12": 
            case "AFTKMST12": 
            case "AFTSO001": {
                return true;
            }
        }
        if (Util.SDK_INT <= 26) {
            switch (Util.DEVICE) {
                case "1601": 
                case "1713": 
                case "1714": 
                case "601LV": 
                case "602LV": 
                case "A10-70F": 
                case "A10-70L": 
                case "A1601": 
                case "A2016a40": 
                case "A7000-a": 
                case "A7000plus": 
                case "A7010a48": 
                case "A7020a48": 
                case "AquaPowerM": 
                case "ASUS_X00AD_2": 
                case "Aura_Note_2": 
                case "b5": 
                case "BLACK-1X": 
                case "BRAVIA_ATV2": 
                case "BRAVIA_ATV3_4K": 
                case "C1": 
                case "ComioS1": 
                case "CP8676_I02": 
                case "CPH1609": 
                case "CPH1715": 
                case "CPY83_I00": 
                case "cv1": 
                case "cv3": 
                case "deb": 
                case "DM-01K": 
                case "E5643": 
                case "ELUGA_A3_Pro": 
                case "ELUGA_Note": 
                case "ELUGA_Prim": 
                case "ELUGA_Ray_X": 
                case "EverStar_S": 
                case "F01H": 
                case "F01J": 
                case "F02H": 
                case "F03H": 
                case "F04H": 
                case "F04J": 
                case "F3111": 
                case "F3113": 
                case "F3116": 
                case "F3211": 
                case "F3213": 
                case "F3215": 
                case "F3311": 
                case "flo": 
                case "fugu": 
                case "GiONEE_CBL7513": 
                case "GiONEE_GBL7319": 
                case "GIONEE_GBL7360": 
                case "GIONEE_SWW1609": 
                case "GIONEE_SWW1627": 
                case "GIONEE_SWW1631": 
                case "GIONEE_WBL5708": 
                case "GIONEE_WBL7365": 
                case "GIONEE_WBL7519": 
                case "griffin": 
                case "htc_e56ml_dtul": 
                case "hwALE-H": 
                case "HWBLN-H": 
                case "HWCAM-H": 
                case "HWVNS-H": 
                case "HWWAS-H": 
                case "i9031": 
                case "iball8735_9806": 
                case "Infinix-X572": 
                case "iris60": 
                case "itel_S41": 
                case "j2xlteins": 
                case "JGZ": 
                case "K50a40": 
                case "kate": 
                case "l5460": 
                case "le_x6": 
                case "LS-5017": 
                case "M04": 
                case "M5c": 
                case "manning": 
                case "marino_f": 
                case "MEIZU_M5": 
                case "mh": 
                case "mido": 
                case "MX6": 
                case "namath": 
                case "nicklaus_f": 
                case "NX541J": 
                case "NX573J": 
                case "OnePlus5T": 
                case "p212": 
                case "P681": 
                case "P85": 
                case "pacificrim": 
                case "panell_d": 
                case "panell_dl": 
                case "panell_ds": 
                case "panell_dt": 
                case "PB2-670M": 
                case "PGN528": 
                case "PGN610": 
                case "PGN611": 
                case "Phantom6": 
                case "Pixi4-7_3G": 
                case "Pixi5-10_4G": 
                case "PLE": 
                case "PRO7S": 
                case "Q350": 
                case "Q4260": 
                case "Q427": 
                case "Q4310": 
                case "Q5": 
                case "QM16XE_U": 
                case "QX1": 
                case "RAIJIN": 
                case "santoni": 
                case "Slate_Pro": 
                case "SVP-DTV15": 
                case "s905x018": 
                case "taido_row": 
                case "TB3-730F": 
                case "TB3-730X": 
                case "TB3-850F": 
                case "TB3-850M": 
                case "tcl_eu": 
                case "V1": 
                case "V23GB": 
                case "V5": 
                case "vernee_M5": 
                case "watson": 
                case "whyred": 
                case "woods_f": 
                case "woods_fn": 
                case "X3_HK": 
                case "XE2X": 
                case "XT1663": 
                case "Z12_PRO": 
                case "Z80": {
                    return true;
                }
            }
            switch (Util.MODEL) {
                case "JSN-L21": {
                    return true;
                }
            }
        }
        return false;
    }

    @RequiresApi(value=26)
    private static final class Api26 {
        private Api26() {
        }

        @DoNotInline
        public static boolean doesDisplaySupportDolbyVision(Context context) {
            Display display;
            boolean supportsDolbyVision = false;
            DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
            Display display2 = display = displayManager != null ? displayManager.getDisplay(0) : null;
            if (display != null && display.isHdr()) {
                int[] supportedHdrTypes;
                for (int hdrType : supportedHdrTypes = display.getHdrCapabilities().getSupportedHdrTypes()) {
                    if (hdrType != 1) continue;
                    supportsDolbyVision = true;
                    break;
                }
            }
            return supportsDolbyVision;
        }
    }

    @RequiresApi(value=23)
    private final class OnFrameRenderedListenerV23
    implements MediaCodecAdapter.OnFrameRenderedListener,
    Handler.Callback {
        private static final int HANDLE_FRAME_RENDERED = 0;
        private final Handler handler = Util.createHandlerForCurrentLooper((Handler.Callback)this);

        public OnFrameRenderedListenerV23(MediaCodecAdapter codec) {
            codec.setOnFrameRenderedListener(this, this.handler);
        }

        @Override
        public void onFrameRendered(MediaCodecAdapter codec, long presentationTimeUs, long nanoTime) {
            if (Util.SDK_INT < 30) {
                Message message = Message.obtain((Handler)this.handler, (int)0, (int)((int)(presentationTimeUs >> 32)), (int)((int)presentationTimeUs));
                this.handler.sendMessageAtFrontOfQueue(message);
            } else {
                this.handleFrameRendered(presentationTimeUs);
            }
        }

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    this.handleFrameRendered(Util.toLong((int)message.arg1, (int)message.arg2));
                    return true;
                }
            }
            return false;
        }

        private void handleFrameRendered(long presentationTimeUs) {
            if (this != MediaCodecVideoRenderer.this.tunnelingOnFrameRenderedListener || MediaCodecVideoRenderer.this.getCodec() == null) {
                return;
            }
            if (presentationTimeUs == Long.MAX_VALUE) {
                MediaCodecVideoRenderer.this.onProcessedTunneledEndOfStream();
            } else {
                try {
                    MediaCodecVideoRenderer.this.onProcessedTunneledBuffer(presentationTimeUs);
                }
                catch (ExoPlaybackException e) {
                    MediaCodecVideoRenderer.this.setPendingPlaybackException(e);
                }
            }
        }
    }

    protected static final class CodecMaxValues {
        public final int width;
        public final int height;
        public final int inputSize;

        public CodecMaxValues(int width, int height, int inputSize) {
            this.width = width;
            this.height = height;
            this.inputSize = inputSize;
        }
    }
}

