/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video;

import android.content.Context;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.video.VideoFrameReleaseHelper;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@UnstableApi
public final class VideoFrameReleaseControl {
    public static final int FRAME_RELEASE_IMMEDIATELY = 0;
    public static final int FRAME_RELEASE_SCHEDULED = 1;
    public static final int FRAME_RELEASE_DROP = 2;
    public static final int FRAME_RELEASE_SKIP = 3;
    public static final int FRAME_RELEASE_IGNORE = 4;
    public static final int FRAME_RELEASE_TRY_AGAIN_LATER = 5;
    private static final long MAX_EARLY_US_THRESHOLD = 50000L;
    private final FrameTimingEvaluator frameTimingEvaluator;
    private final VideoFrameReleaseHelper frameReleaseHelper;
    private final long allowedJoiningTimeMs;
    private boolean started;
    private int firstFrameState;
    private long initialPositionUs;
    private long lastReleaseRealtimeUs;
    private long lastPresentationTimeUs;
    private long joiningDeadlineMs;
    private float playbackSpeed;
    private Clock clock;

    public VideoFrameReleaseControl(Context applicationContext, FrameTimingEvaluator frameTimingEvaluator, long allowedJoiningTimeMs) {
        this.frameTimingEvaluator = frameTimingEvaluator;
        this.allowedJoiningTimeMs = allowedJoiningTimeMs;
        this.frameReleaseHelper = new VideoFrameReleaseHelper(applicationContext);
        this.firstFrameState = 0;
        this.initialPositionUs = -9223372036854775807L;
        this.lastPresentationTimeUs = -9223372036854775807L;
        this.joiningDeadlineMs = -9223372036854775807L;
        this.playbackSpeed = 1.0f;
        this.clock = Clock.DEFAULT;
    }

    public void onEnabled(boolean releaseFirstFrameBeforeStarted) {
        this.firstFrameState = releaseFirstFrameBeforeStarted ? 1 : 0;
    }

    public void onDisabled() {
        this.lowerFirstFrameState(0);
    }

    public void onStarted() {
        this.started = true;
        this.lastReleaseRealtimeUs = Util.msToUs((long)this.clock.elapsedRealtime());
        this.frameReleaseHelper.onStarted();
    }

    public void onStopped() {
        this.started = false;
        this.joiningDeadlineMs = -9223372036854775807L;
        this.frameReleaseHelper.onStopped();
    }

    public void onProcessedStreamChange() {
        this.lowerFirstFrameState(2);
    }

    public void setOutputSurface(@Nullable Surface outputSurface) {
        this.frameReleaseHelper.onSurfaceChanged(outputSurface);
        this.lowerFirstFrameState(1);
    }

    public void setFrameRate(float frameRate) {
        this.frameReleaseHelper.onFormatChanged(frameRate);
    }

    public boolean onFrameReleasedIsFirstFrame() {
        boolean firstFrame = this.firstFrameState != 3;
        this.firstFrameState = 3;
        this.lastReleaseRealtimeUs = Util.msToUs((long)this.clock.elapsedRealtime());
        return firstFrame;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void allowReleaseFirstFrameBeforeStarted() {
        if (this.firstFrameState == 0) {
            this.firstFrameState = 1;
        }
    }

    public boolean isReady(boolean rendererReady) {
        if (rendererReady && this.firstFrameState == 3) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (this.clock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    public void join() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? this.clock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    public int getFrameReleaseAction(long presentationTimeUs, long positionUs, long elapsedRealtimeUs, long outputStreamStartPositionUs, boolean isLastFrame, FrameReleaseInfo frameReleaseInfo) throws ExoPlaybackException {
        boolean treatDropAsSkip;
        frameReleaseInfo.reset();
        if (this.initialPositionUs == -9223372036854775807L) {
            this.initialPositionUs = positionUs;
        }
        if (this.lastPresentationTimeUs != presentationTimeUs) {
            this.frameReleaseHelper.onNextFrame(presentationTimeUs);
            this.lastPresentationTimeUs = presentationTimeUs;
        }
        frameReleaseInfo.earlyUs = this.calculateEarlyTimeUs(positionUs, elapsedRealtimeUs, presentationTimeUs);
        if (this.shouldForceRelease(positionUs, frameReleaseInfo.earlyUs, outputStreamStartPositionUs)) {
            return 0;
        }
        if (!this.started || positionUs == this.initialPositionUs) {
            return 5;
        }
        long systemTimeNs = this.clock.nanoTime();
        frameReleaseInfo.releaseTimeNs = this.frameReleaseHelper.adjustReleaseTime(systemTimeNs + frameReleaseInfo.earlyUs * 1000L);
        frameReleaseInfo.earlyUs = (frameReleaseInfo.releaseTimeNs - systemTimeNs) / 1000L;
        boolean bl = treatDropAsSkip = this.joiningDeadlineMs != -9223372036854775807L;
        if (this.frameTimingEvaluator.shouldIgnoreFrame(frameReleaseInfo.earlyUs, positionUs, elapsedRealtimeUs, isLastFrame, treatDropAsSkip)) {
            return 4;
        }
        if (this.frameTimingEvaluator.shouldDropFrame(frameReleaseInfo.earlyUs, elapsedRealtimeUs, isLastFrame)) {
            return treatDropAsSkip ? 3 : 2;
        }
        if (frameReleaseInfo.earlyUs > 50000L) {
            return 5;
        }
        return 1;
    }

    public void reset() {
        this.frameReleaseHelper.onPositionReset();
        this.lastPresentationTimeUs = -9223372036854775807L;
        this.initialPositionUs = -9223372036854775807L;
        this.lowerFirstFrameState(1);
        this.joiningDeadlineMs = -9223372036854775807L;
    }

    public void setChangeFrameRateStrategy(int changeFrameRateStrategy) {
        this.frameReleaseHelper.setChangeFrameRateStrategy(changeFrameRateStrategy);
    }

    public void setPlaybackSpeed(float speed) {
        this.playbackSpeed = speed;
        this.frameReleaseHelper.onPlaybackSpeed(speed);
    }

    private void lowerFirstFrameState(int firstFrameState) {
        this.firstFrameState = Math.min(this.firstFrameState, firstFrameState);
    }

    private long calculateEarlyTimeUs(long positionUs, long elapsedRealtimeUs, long framePresentationTimeUs) {
        long earlyUs = (long)((double)(framePresentationTimeUs - positionUs) / (double)this.playbackSpeed);
        if (this.started) {
            earlyUs -= Util.msToUs((long)this.clock.elapsedRealtime()) - elapsedRealtimeUs;
        }
        return earlyUs;
    }

    private boolean shouldForceRelease(long positionUs, long earlyUs, long outputStreamStartPositionUs) {
        if (this.joiningDeadlineMs != -9223372036854775807L) {
            return false;
        }
        switch (this.firstFrameState) {
            case 0: {
                return this.started;
            }
            case 1: {
                return true;
            }
            case 2: {
                return positionUs >= outputStreamStartPositionUs;
            }
            case 3: {
                long elapsedTimeSinceLastReleaseUs = Util.msToUs((long)this.clock.elapsedRealtime()) - this.lastReleaseRealtimeUs;
                return this.started && this.frameTimingEvaluator.shouldForceReleaseFrame(earlyUs, elapsedTimeSinceLastReleaseUs);
            }
        }
        throw new IllegalStateException();
    }

    public static interface FrameTimingEvaluator {
        public boolean shouldForceReleaseFrame(long var1, long var3);

        public boolean shouldDropFrame(long var1, long var3, boolean var5);

        public boolean shouldIgnoreFrame(long var1, long var3, long var5, boolean var7, boolean var8) throws ExoPlaybackException;
    }

    public static class FrameReleaseInfo {
        private long earlyUs = -9223372036854775807L;
        private long releaseTimeNs = -9223372036854775807L;

        public long getEarlyUs() {
            return this.earlyUs;
        }

        public long getReleaseTimeNs() {
            return this.releaseTimeNs;
        }

        private void reset() {
            this.earlyUs = -9223372036854775807L;
            this.releaseTimeNs = -9223372036854775807L;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    @UnstableApi
    public static @interface FrameReleaseAction {
    }
}

