/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video;

import androidx.annotation.FloatRange;
import androidx.annotation.Nullable;
import androidx.media3.common.VideoSize;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.LongArrayQueue;
import androidx.media3.common.util.TimedValueQueue;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.video.VideoFrameReleaseControl;

final class VideoFrameRenderControl {
    private final FrameRenderer frameRenderer;
    private final VideoFrameReleaseControl videoFrameReleaseControl;
    private final VideoFrameReleaseControl.FrameReleaseInfo videoFrameReleaseInfo;
    private final TimedValueQueue<VideoSize> videoSizeChanges;
    private final TimedValueQueue<Long> streamOffsets;
    private final LongArrayQueue presentationTimestampsUs;
    @Nullable
    private VideoSize pendingOutputVideoSize;
    private VideoSize reportedVideoSize;
    private long outputStreamOffsetUs;
    private long lastPresentationTimeUs;

    public VideoFrameRenderControl(FrameRenderer frameRenderer, VideoFrameReleaseControl videoFrameReleaseControl) {
        this.frameRenderer = frameRenderer;
        this.videoFrameReleaseControl = videoFrameReleaseControl;
        this.videoFrameReleaseInfo = new VideoFrameReleaseControl.FrameReleaseInfo();
        this.videoSizeChanges = new TimedValueQueue();
        this.streamOffsets = new TimedValueQueue();
        this.presentationTimestampsUs = new LongArrayQueue();
        this.reportedVideoSize = VideoSize.UNKNOWN;
        this.lastPresentationTimeUs = -9223372036854775807L;
    }

    public void flush() {
        this.presentationTimestampsUs.clear();
        this.lastPresentationTimeUs = -9223372036854775807L;
        if (this.streamOffsets.size() > 0) {
            long lastStreamOffset = VideoFrameRenderControl.getLastAndClear(this.streamOffsets);
            this.streamOffsets.add(0L, (Object)lastStreamOffset);
        }
        if (this.pendingOutputVideoSize == null) {
            if (this.videoSizeChanges.size() > 0) {
                this.pendingOutputVideoSize = VideoFrameRenderControl.getLastAndClear(this.videoSizeChanges);
            }
        } else {
            this.videoSizeChanges.clear();
        }
    }

    public boolean isReady() {
        return this.videoFrameReleaseControl.isReady(true);
    }

    public boolean hasReleasedFrame(long presentationTimeUs) {
        return this.lastPresentationTimeUs != -9223372036854775807L && this.lastPresentationTimeUs >= presentationTimeUs;
    }

    public void setPlaybackSpeed(@FloatRange(from=0.0, fromInclusive=false) float speed) {
        Assertions.checkArgument((speed > 0.0f ? 1 : 0) != 0);
        this.videoFrameReleaseControl.setPlaybackSpeed(speed);
    }

    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        block5: while (!this.presentationTimestampsUs.isEmpty()) {
            long presentationTimeUs = this.presentationTimestampsUs.element();
            if (this.maybeUpdateOutputStreamOffset(presentationTimeUs)) {
                this.videoFrameReleaseControl.onProcessedStreamChange();
            }
            int frameReleaseAction = this.videoFrameReleaseControl.getFrameReleaseAction(presentationTimeUs, positionUs, elapsedRealtimeUs, this.outputStreamOffsetUs, false, this.videoFrameReleaseInfo);
            switch (frameReleaseAction) {
                case 5: {
                    return;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.lastPresentationTimeUs = presentationTimeUs;
                    this.dropFrame();
                    continue block5;
                }
                case 0: 
                case 1: {
                    this.lastPresentationTimeUs = presentationTimeUs;
                    this.renderFrame(frameReleaseAction == 0);
                    continue block5;
                }
            }
            throw new IllegalStateException(String.valueOf(frameReleaseAction));
        }
    }

    public void onOutputSizeChanged(int width, int height) {
        VideoSize newVideoSize = new VideoSize(width, height);
        if (!Util.areEqual((Object)this.pendingOutputVideoSize, (Object)newVideoSize)) {
            this.pendingOutputVideoSize = newVideoSize;
        }
    }

    public void onOutputFrameAvailableForRendering(long presentationTimeUs) {
        if (this.pendingOutputVideoSize != null) {
            this.videoSizeChanges.add(presentationTimeUs, (Object)this.pendingOutputVideoSize);
            this.pendingOutputVideoSize = null;
        }
        this.presentationTimestampsUs.add(presentationTimeUs);
    }

    public void onStreamOffsetChange(long presentationTimeUs, long streamOffsetUs) {
        this.streamOffsets.add(presentationTimeUs, (Object)streamOffsetUs);
    }

    private void dropFrame() {
        Assertions.checkStateNotNull((Object)this.presentationTimestampsUs.remove());
        this.frameRenderer.dropFrame();
    }

    private void renderFrame(boolean shouldRenderImmediately) {
        long presentationTimeUs = (Long)Assertions.checkStateNotNull((Object)this.presentationTimestampsUs.remove());
        boolean videoSizeUpdated = this.maybeUpdateVideoSize(presentationTimeUs);
        if (videoSizeUpdated) {
            this.frameRenderer.onVideoSizeChanged(this.reportedVideoSize);
        }
        long renderTimeNs = shouldRenderImmediately ? -1L : this.videoFrameReleaseInfo.getReleaseTimeNs();
        this.frameRenderer.renderFrame(renderTimeNs, presentationTimeUs, this.outputStreamOffsetUs, this.videoFrameReleaseControl.onFrameReleasedIsFirstFrame());
    }

    private boolean maybeUpdateOutputStreamOffset(long presentationTimeUs) {
        Long newOutputStreamOffsetUs = (Long)this.streamOffsets.pollFloor(presentationTimeUs);
        if (newOutputStreamOffsetUs != null && newOutputStreamOffsetUs != this.outputStreamOffsetUs) {
            this.outputStreamOffsetUs = newOutputStreamOffsetUs;
            return true;
        }
        return false;
    }

    private boolean maybeUpdateVideoSize(long presentationTimeUs) {
        VideoSize videoSize = (VideoSize)this.videoSizeChanges.pollFloor(presentationTimeUs);
        if (videoSize == null) {
            return false;
        }
        if (!videoSize.equals((Object)VideoSize.UNKNOWN) && !videoSize.equals((Object)this.reportedVideoSize)) {
            this.reportedVideoSize = videoSize;
            return true;
        }
        return false;
    }

    private static <T> T getLastAndClear(TimedValueQueue<T> queue) {
        Assertions.checkArgument((queue.size() > 0 ? 1 : 0) != 0);
        while (queue.size() > 1) {
            queue.pollFirst();
        }
        return (T)Assertions.checkNotNull((Object)queue.pollFirst());
    }

    static interface FrameRenderer {
        public void onVideoSizeChanged(VideoSize var1);

        public void renderFrame(long var1, long var3, long var5, boolean var7);

        public void dropFrame();
    }
}

