/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video;

import android.graphics.Bitmap;
import android.view.Surface;
import androidx.annotation.FloatRange;
import androidx.media3.common.Format;
import androidx.media3.common.VideoSize;
import androidx.media3.common.util.TimestampIterator;
import androidx.media3.common.util.UnstableApi;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.Executor;

@UnstableApi
public interface VideoSink {
    public static final int INPUT_TYPE_SURFACE = 1;
    public static final int INPUT_TYPE_BITMAP = 2;

    public void setListener(Listener var1, Executor var2);

    public void flush();

    public boolean isReady();

    public boolean isEnded();

    public boolean isFrameDropAllowedOnInput();

    public Surface getInputSurface();

    public void setPlaybackSpeed(@FloatRange(from=0.0, fromInclusive=false) float var1);

    public void registerInputStream(int var1, Format var2);

    public long registerInputFrame(long var1, boolean var3);

    public boolean queueBitmap(Bitmap var1, TimestampIterator var2);

    public void render(long var1, long var3) throws VideoSinkException;

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface InputType {
    }

    public static interface Listener {
        public static final Listener NO_OP = new Listener(){

            @Override
            public void onFirstFrameRendered(VideoSink videoSink) {
            }

            @Override
            public void onFrameDropped(VideoSink videoSink) {
            }

            @Override
            public void onVideoSizeChanged(VideoSink videoSink, VideoSize videoSize) {
            }

            @Override
            public void onError(VideoSink videoSink, VideoSinkException videoSinkException) {
            }
        };

        public void onFirstFrameRendered(VideoSink var1);

        public void onFrameDropped(VideoSink var1);

        public void onVideoSizeChanged(VideoSink var1, VideoSize var2);

        public void onError(VideoSink var1, VideoSinkException var2);
    }

    public static final class VideoSinkException
    extends Exception {
        public final Format format;

        public VideoSinkException(Throwable cause, Format format) {
            super(cause);
            this.format = format;
        }
    }
}

