/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video.spherical;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.BaseRenderer;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.FormatHolder;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.video.spherical.CameraMotionListener;
import java.nio.ByteBuffer;

@UnstableApi
public final class CameraMotionRenderer
extends BaseRenderer {
    private static final String TAG = "CameraMotionRenderer";
    private static final int SAMPLE_WINDOW_DURATION_US = 100000;
    private final DecoderInputBuffer buffer = new DecoderInputBuffer(1);
    private final ParsableByteArray scratch = new ParsableByteArray();
    private long offsetUs;
    @Nullable
    private CameraMotionListener listener;
    private long lastTimestampUs;

    public CameraMotionRenderer() {
        super(6);
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public int supportsFormat(Format format) {
        return "application/x-camera-motion".equals(format.sampleMimeType) ? RendererCapabilities.create(4) : RendererCapabilities.create(0);
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
        if (messageType == 8) {
            this.listener = (CameraMotionListener)message;
        } else {
            super.handleMessage(messageType, message);
        }
    }

    @Override
    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs, MediaSource.MediaPeriodId mediaPeriodId) {
        this.offsetUs = offsetUs;
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) {
        this.lastTimestampUs = Long.MIN_VALUE;
        this.resetListener();
    }

    @Override
    protected void onDisabled() {
        this.resetListener();
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) {
        while (!this.hasReadStreamToEnd() && this.lastTimestampUs < positionUs + 100000L) {
            boolean isDecodeOnly;
            this.buffer.clear();
            FormatHolder formatHolder = this.getFormatHolder();
            int result = this.readSource(formatHolder, this.buffer, 0);
            if (result != -4 || this.buffer.isEndOfStream()) {
                return;
            }
            this.lastTimestampUs = this.buffer.timeUs;
            boolean bl = isDecodeOnly = this.lastTimestampUs < this.getLastResetPositionUs();
            if (this.listener == null || isDecodeOnly) continue;
            this.buffer.flip();
            float[] rotation = this.parseMetadata((ByteBuffer)Util.castNonNull((Object)this.buffer.data));
            if (rotation == null) continue;
            ((CameraMotionListener)Util.castNonNull((Object)this.listener)).onCameraMotion(this.lastTimestampUs - this.offsetUs, rotation);
        }
    }

    @Override
    public boolean isEnded() {
        return this.hasReadStreamToEnd();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Nullable
    private float[] parseMetadata(ByteBuffer data) {
        if (data.remaining() != 16) {
            return null;
        }
        this.scratch.reset(data.array(), data.limit());
        this.scratch.setPosition(data.arrayOffset() + 4);
        float[] result = new float[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = Float.intBitsToFloat(this.scratch.readLittleEndianInt());
        }
        return result;
    }

    private void resetListener() {
        if (this.listener != null) {
            this.listener.onCameraMotionReset();
        }
    }
}

