/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.annotation.Nullable;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Format;
import androidx.media3.common.util.ParsableBitArray;
import androidx.media3.common.util.UnstableApi;
import java.nio.ByteBuffer;
import java.util.Arrays;

@UnstableApi
public final class DtsUtil {
    public static final int DTS_MAX_RATE_BYTES_PER_SECOND = 192000;
    public static final int DTS_HD_MAX_RATE_BYTES_PER_SECOND = 2250000;
    private static final int SYNC_VALUE_BE = 2147385345;
    private static final int SYNC_VALUE_14B_BE = 536864768;
    private static final int SYNC_VALUE_LE = -25230976;
    private static final int SYNC_VALUE_14B_LE = -14745368;
    private static final byte FIRST_BYTE_BE = 127;
    private static final byte FIRST_BYTE_14B_BE = 31;
    private static final byte FIRST_BYTE_LE = -2;
    private static final byte FIRST_BYTE_14B_LE = -1;
    private static final int[] CHANNELS_BY_AMODE = new int[]{1, 2, 2, 2, 2, 3, 3, 4, 4, 5, 6, 6, 6, 7, 8, 8};
    private static final int[] SAMPLE_RATE_BY_SFREQ = new int[]{-1, 8000, 16000, 32000, -1, -1, 11025, 22050, 44100, -1, -1, 12000, 24000, 48000, -1, -1};
    private static final int[] TWICE_BITRATE_KBPS_BY_RATE = new int[]{64, 112, 128, 192, 224, 256, 384, 448, 512, 640, 768, 896, 1024, 1152, 1280, 1536, 1920, 2048, 2304, 2560, 2688, 2816, 2823, 2944, 3072, 3840, 4096, 6144, 7680};

    public static boolean isSyncWord(int word) {
        return word == 2147385345 || word == -25230976 || word == 536864768 || word == -14745368;
    }

    public static Format parseDtsFormat(byte[] frame, @Nullable String trackId, @Nullable String language, @Nullable DrmInitData drmInitData) {
        ParsableBitArray frameBits = DtsUtil.getNormalizedFrameHeader(frame);
        frameBits.skipBits(60);
        int amode = frameBits.readBits(6);
        int channelCount = CHANNELS_BY_AMODE[amode];
        int sfreq = frameBits.readBits(4);
        int sampleRate = SAMPLE_RATE_BY_SFREQ[sfreq];
        int rate = frameBits.readBits(5);
        int bitrate = rate >= TWICE_BITRATE_KBPS_BY_RATE.length ? -1 : TWICE_BITRATE_KBPS_BY_RATE[rate] * 1000 / 2;
        frameBits.skipBits(10);
        return new Format.Builder().setId(trackId).setSampleMimeType("audio/vnd.dts").setAverageBitrate(bitrate).setChannelCount(channelCount += frameBits.readBits(2) > 0 ? 1 : 0).setSampleRate(sampleRate).setDrmInitData(drmInitData).setLanguage(language).build();
    }

    public static int parseDtsAudioSampleCount(byte[] data) {
        int nblks;
        switch (data[0]) {
            case -2: {
                nblks = (data[5] & 1) << 6 | (data[4] & 0xFC) >> 2;
                break;
            }
            case -1: {
                nblks = (data[4] & 7) << 4 | (data[7] & 0x3C) >> 2;
                break;
            }
            case 31: {
                nblks = (data[5] & 7) << 4 | (data[6] & 0x3C) >> 2;
                break;
            }
            default: {
                nblks = (data[4] & 1) << 6 | (data[5] & 0xFC) >> 2;
            }
        }
        return (nblks + 1) * 32;
    }

    public static int parseDtsAudioSampleCount(ByteBuffer buffer) {
        int nblks;
        int position = buffer.position();
        switch (buffer.get(position)) {
            case -2: {
                nblks = (buffer.get(position + 5) & 1) << 6 | (buffer.get(position + 4) & 0xFC) >> 2;
                break;
            }
            case -1: {
                nblks = (buffer.get(position + 4) & 7) << 4 | (buffer.get(position + 7) & 0x3C) >> 2;
                break;
            }
            case 31: {
                nblks = (buffer.get(position + 5) & 7) << 4 | (buffer.get(position + 6) & 0x3C) >> 2;
                break;
            }
            default: {
                nblks = (buffer.get(position + 4) & 1) << 6 | (buffer.get(position + 5) & 0xFC) >> 2;
            }
        }
        return (nblks + 1) * 32;
    }

    public static int getDtsFrameSize(byte[] data) {
        int fsize;
        boolean uses14BitPerWord = false;
        switch (data[0]) {
            case 31: {
                fsize = ((data[6] & 3) << 12 | (data[7] & 0xFF) << 4 | (data[8] & 0x3C) >> 2) + 1;
                uses14BitPerWord = true;
                break;
            }
            case -2: {
                fsize = ((data[4] & 3) << 12 | (data[7] & 0xFF) << 4 | (data[6] & 0xF0) >> 4) + 1;
                break;
            }
            case -1: {
                fsize = ((data[7] & 3) << 12 | (data[6] & 0xFF) << 4 | (data[9] & 0x3C) >> 2) + 1;
                uses14BitPerWord = true;
                break;
            }
            default: {
                fsize = ((data[5] & 3) << 12 | (data[6] & 0xFF) << 4 | (data[7] & 0xF0) >> 4) + 1;
            }
        }
        return uses14BitPerWord ? fsize * 16 / 14 : fsize;
    }

    private static ParsableBitArray getNormalizedFrameHeader(byte[] frameHeader) {
        if (frameHeader[0] == 127) {
            return new ParsableBitArray(frameHeader);
        }
        if (DtsUtil.isLittleEndianFrameHeader(frameHeader = Arrays.copyOf(frameHeader, frameHeader.length))) {
            for (int i = 0; i < frameHeader.length - 1; i += 2) {
                byte temp = frameHeader[i];
                frameHeader[i] = frameHeader[i + 1];
                frameHeader[i + 1] = temp;
            }
        }
        ParsableBitArray frameBits = new ParsableBitArray(frameHeader);
        if (frameHeader[0] == 31) {
            ParsableBitArray scratchBits = new ParsableBitArray(frameHeader);
            while (scratchBits.bitsLeft() >= 16) {
                scratchBits.skipBits(2);
                frameBits.putInt(scratchBits.readBits(14), 14);
            }
        }
        frameBits.reset(frameHeader);
        return frameBits;
    }

    private static boolean isLittleEndianFrameHeader(byte[] frameHeader) {
        return frameHeader[0] == -2 || frameHeader[0] == -1;
    }

    private DtsUtil() {
    }
}

