/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import android.net.Uri;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.FileTypes;
import androidx.media3.common.Format;
import androidx.media3.common.util.TimestampAdjuster;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorsFactory;
import androidx.media3.extractor.amr.AmrExtractor;
import androidx.media3.extractor.avi.AviExtractor;
import androidx.media3.extractor.flac.FlacExtractor;
import androidx.media3.extractor.flv.FlvExtractor;
import androidx.media3.extractor.jpeg.JpegExtractor;
import androidx.media3.extractor.mkv.MatroskaExtractor;
import androidx.media3.extractor.mp3.Mp3Extractor;
import androidx.media3.extractor.mp4.FragmentedMp4Extractor;
import androidx.media3.extractor.mp4.Mp4Extractor;
import androidx.media3.extractor.ogg.OggExtractor;
import androidx.media3.extractor.ts.Ac3Extractor;
import androidx.media3.extractor.ts.Ac4Extractor;
import androidx.media3.extractor.ts.AdtsExtractor;
import androidx.media3.extractor.ts.DefaultTsPayloadReaderFactory;
import androidx.media3.extractor.ts.PsExtractor;
import androidx.media3.extractor.ts.TsExtractor;
import androidx.media3.extractor.wav.WavExtractor;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@UnstableApi
public final class DefaultExtractorsFactory
implements ExtractorsFactory {
    private static final int[] DEFAULT_EXTRACTOR_ORDER = new int[]{5, 4, 12, 8, 3, 10, 9, 11, 6, 2, 0, 1, 7, 16, 15, 14};
    private static final ExtensionLoader FLAC_EXTENSION_LOADER = new ExtensionLoader(DefaultExtractorsFactory::getFlacExtractorConstructor);
    private static final ExtensionLoader MIDI_EXTENSION_LOADER = new ExtensionLoader(DefaultExtractorsFactory::getMidiExtractorConstructor);
    private boolean constantBitrateSeekingEnabled;
    private boolean constantBitrateSeekingAlwaysEnabled;
    private int adtsFlags;
    private int amrFlags;
    private int flacFlags;
    private int matroskaFlags;
    private int mp4Flags;
    private int fragmentedMp4Flags;
    private int mp3Flags;
    private int tsMode = 1;
    private int tsFlags;
    private ImmutableList<Format> tsSubtitleFormats = ImmutableList.of();
    private int tsTimestampSearchBytes = 112800;

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setConstantBitrateSeekingEnabled(boolean constantBitrateSeekingEnabled) {
        this.constantBitrateSeekingEnabled = constantBitrateSeekingEnabled;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setConstantBitrateSeekingAlwaysEnabled(boolean constantBitrateSeekingAlwaysEnabled) {
        this.constantBitrateSeekingAlwaysEnabled = constantBitrateSeekingAlwaysEnabled;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setAdtsExtractorFlags(int flags) {
        this.adtsFlags = flags;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setAmrExtractorFlags(int flags) {
        this.amrFlags = flags;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setFlacExtractorFlags(int flags) {
        this.flacFlags = flags;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setMatroskaExtractorFlags(int flags) {
        this.matroskaFlags = flags;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setMp4ExtractorFlags(int flags) {
        this.mp4Flags = flags;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setFragmentedMp4ExtractorFlags(int flags) {
        this.fragmentedMp4Flags = flags;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setMp3ExtractorFlags(int flags) {
        this.mp3Flags = flags;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setTsExtractorMode(int mode) {
        this.tsMode = mode;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setTsExtractorFlags(int flags) {
        this.tsFlags = flags;
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setTsSubtitleFormats(List<Format> subtitleFormats) {
        this.tsSubtitleFormats = ImmutableList.copyOf(subtitleFormats);
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized DefaultExtractorsFactory setTsExtractorTimestampSearchBytes(int timestampSearchBytes) {
        this.tsTimestampSearchBytes = timestampSearchBytes;
        return this;
    }

    @Override
    public synchronized Extractor[] createExtractors() {
        return this.createExtractors(Uri.EMPTY, new HashMap<String, List<String>>());
    }

    @Override
    public synchronized Extractor[] createExtractors(Uri uri, Map<String, List<String>> responseHeaders) {
        int uriInferredFileType;
        ArrayList<Extractor> extractors = new ArrayList<Extractor>(DEFAULT_EXTRACTOR_ORDER.length);
        int responseHeadersInferredFileType = FileTypes.inferFileTypeFromResponseHeaders(responseHeaders);
        if (responseHeadersInferredFileType != -1) {
            this.addExtractorsForFileType(responseHeadersInferredFileType, extractors);
        }
        if ((uriInferredFileType = FileTypes.inferFileTypeFromUri((Uri)uri)) != -1 && uriInferredFileType != responseHeadersInferredFileType) {
            this.addExtractorsForFileType(uriInferredFileType, extractors);
        }
        for (int fileType : DEFAULT_EXTRACTOR_ORDER) {
            if (fileType == responseHeadersInferredFileType || fileType == uriInferredFileType) continue;
            this.addExtractorsForFileType(fileType, extractors);
        }
        return extractors.toArray(new Extractor[extractors.size()]);
    }

    private void addExtractorsForFileType(int fileType, List<Extractor> extractors) {
        switch (fileType) {
            case 0: {
                extractors.add(new Ac3Extractor());
                break;
            }
            case 1: {
                extractors.add(new Ac4Extractor());
                break;
            }
            case 2: {
                extractors.add(new AdtsExtractor(this.adtsFlags | (this.constantBitrateSeekingEnabled ? 1 : 0) | (this.constantBitrateSeekingAlwaysEnabled ? 2 : 0)));
                break;
            }
            case 3: {
                extractors.add(new AmrExtractor(this.amrFlags | (this.constantBitrateSeekingEnabled ? 1 : 0) | (this.constantBitrateSeekingAlwaysEnabled ? 2 : 0)));
                break;
            }
            case 4: {
                Extractor flacExtractor = FLAC_EXTENSION_LOADER.getExtractor(this.flacFlags);
                if (flacExtractor != null) {
                    extractors.add(flacExtractor);
                    break;
                }
                extractors.add(new FlacExtractor(this.flacFlags));
                break;
            }
            case 5: {
                extractors.add(new FlvExtractor());
                break;
            }
            case 6: {
                extractors.add(new MatroskaExtractor(this.matroskaFlags));
                break;
            }
            case 7: {
                extractors.add(new Mp3Extractor(this.mp3Flags | (this.constantBitrateSeekingEnabled ? 1 : 0) | (this.constantBitrateSeekingAlwaysEnabled ? 2 : 0)));
                break;
            }
            case 8: {
                extractors.add(new FragmentedMp4Extractor(this.fragmentedMp4Flags));
                extractors.add(new Mp4Extractor(this.mp4Flags));
                break;
            }
            case 9: {
                extractors.add(new OggExtractor());
                break;
            }
            case 10: {
                extractors.add(new PsExtractor());
                break;
            }
            case 11: {
                extractors.add(new TsExtractor(this.tsMode, new TimestampAdjuster(0L), new DefaultTsPayloadReaderFactory(this.tsFlags, (List<Format>)this.tsSubtitleFormats), this.tsTimestampSearchBytes));
                break;
            }
            case 12: {
                extractors.add(new WavExtractor());
                break;
            }
            case 14: {
                extractors.add(new JpegExtractor());
                break;
            }
            case 15: {
                Extractor midiExtractor = MIDI_EXTENSION_LOADER.getExtractor(new Object[0]);
                if (midiExtractor == null) break;
                extractors.add(midiExtractor);
                break;
            }
            case 16: {
                extractors.add(new AviExtractor());
                break;
            }
        }
    }

    private static Constructor<? extends Extractor> getMidiExtractorConstructor() throws ClassNotFoundException, NoSuchMethodException {
        return Class.forName("androidx.media3.decoder.midi.MidiExtractor").asSubclass(Extractor.class).getConstructor(new Class[0]);
    }

    @Nullable
    private static Constructor<? extends Extractor> getFlacExtractorConstructor() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        boolean isFlacNativeLibraryAvailable = Boolean.TRUE.equals(Class.forName("androidx.media3.decoder.flac.FlacLibrary").getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]));
        if (isFlacNativeLibraryAvailable) {
            return Class.forName("androidx.media3.decoder.flac.FlacExtractor").asSubclass(Extractor.class).getConstructor(Integer.TYPE);
        }
        return null;
    }

    private static final class ExtensionLoader {
        private final ConstructorSupplier constructorSupplier;
        private final AtomicBoolean extensionLoaded;
        @GuardedBy(value="extensionLoaded")
        @Nullable
        private Constructor<? extends Extractor> extractorConstructor;

        public ExtensionLoader(ConstructorSupplier constructorSupplier) {
            this.constructorSupplier = constructorSupplier;
            this.extensionLoaded = new AtomicBoolean(false);
        }

        @Nullable
        public Extractor getExtractor(Object ... constructorParams) {
            Constructor<? extends Extractor> extractorConstructor = this.maybeLoadExtractorConstructor();
            if (extractorConstructor == null) {
                return null;
            }
            try {
                return extractorConstructor.newInstance(constructorParams);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected error creating extractor", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Constructor<? extends Extractor> maybeLoadExtractorConstructor() {
            AtomicBoolean atomicBoolean = this.extensionLoaded;
            synchronized (atomicBoolean) {
                if (this.extensionLoaded.get()) {
                    return this.extractorConstructor;
                }
                try {
                    return this.constructorSupplier.getConstructor();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (Exception e) {
                    throw new RuntimeException("Error instantiating extension", e);
                }
                this.extensionLoaded.set(true);
                return this.extractorConstructor;
            }
        }

        public static interface ConstructorSupplier {
            @Nullable
            public Constructor<? extends Extractor> getConstructor() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException;
        }
    }
}

