/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.media3.common.util.UnstableApi;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

@UnstableApi
public class OpusUtil {
    public static final int SAMPLE_RATE = 48000;
    public static final int MAX_BYTES_PER_SECOND = 63750;
    private static final int DEFAULT_SEEK_PRE_ROLL_SAMPLES = 3840;
    private static final int FULL_CODEC_INITIALIZATION_DATA_BUFFER_COUNT = 3;

    private OpusUtil() {
    }

    public static int getChannelCount(byte[] header) {
        return header[9] & 0xFF;
    }

    public static List<byte[]> buildInitializationData(byte[] header) {
        int preSkipSamples = OpusUtil.getPreSkipSamples(header);
        long preSkipNanos = OpusUtil.sampleCountToNanoseconds(preSkipSamples);
        long seekPreRollNanos = OpusUtil.sampleCountToNanoseconds(3840L);
        ArrayList<byte[]> initializationData = new ArrayList<byte[]>(3);
        initializationData.add(header);
        initializationData.add(OpusUtil.buildNativeOrderByteArray(preSkipNanos));
        initializationData.add(OpusUtil.buildNativeOrderByteArray(seekPreRollNanos));
        return initializationData;
    }

    public static int parsePacketAudioSampleCount(ByteBuffer buffer) {
        long packetDurationUs = OpusUtil.getPacketDurationUs(buffer.get(0), buffer.limit() > 1 ? buffer.get(1) : (byte)0);
        return (int)(packetDurationUs * 48000L / 1000000L);
    }

    public static long getPacketDurationUs(byte[] buffer) {
        return OpusUtil.getPacketDurationUs(buffer[0], buffer.length > 1 ? buffer[1] : (byte)0);
    }

    private static long getPacketDurationUs(byte packetByte0, byte packetByte1) {
        int frames;
        int toc = packetByte0 & 0xFF;
        switch (toc & 3) {
            case 0: {
                frames = 1;
                break;
            }
            case 1: 
            case 2: {
                frames = 2;
                break;
            }
            default: {
                frames = packetByte1 & 0x3F;
            }
        }
        int config = toc >> 3;
        int length = config & 3;
        int frameDurationUs = config >= 16 ? 2500 << length : (config >= 12 ? 10000 << (length & 1) : (length == 3 ? 60000 : 10000 << length));
        return (long)frames * (long)frameDurationUs;
    }

    private static int getPreSkipSamples(byte[] header) {
        return (header[11] & 0xFF) << 8 | header[10] & 0xFF;
    }

    private static byte[] buildNativeOrderByteArray(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(value).array();
    }

    private static long sampleCountToNanoseconds(long sampleCount) {
        return sampleCount * 1000000000L / 48000L;
    }
}

