/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.ui;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.Player;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.SystemClock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.util.List;
import java.util.concurrent.TimeUnit;

@UnstableApi
public final class WearUnsuitableOutputPlaybackSuppressionResolverListener
implements Player.Listener {
    private static final String OUTPUT_SWITCHER_INTENT_ACTION_NAME = "com.android.settings.panel.action.MEDIA_OUTPUT";
    private static final String EXTRA_OUTPUT_SWITCHER_PACKAGE_NAME = "com.android.settings.panel.extra.PACKAGE_NAME";
    private static final String EXTRA_BLUETOOTH_SETTINGS_CLOSE_ON_CONNECT = "EXTRA_CLOSE_ON_CONNECT";
    private static final String EXTRA_BLUETOOTH_SETTINGS_CONNECTION_ONLY = "EXTRA_CONNECTION_ONLY";
    private static final String EXTRA_BLUETOOTH_SETTINGS_FILTER_TYPE = "android.bluetooth.devicepicker.extra.FILTER_TYPE";
    private static final int FILTER_TYPE_AUDIO = 1;
    public static final long DEFAULT_PLAYBACK_SUPPRESSION_AUTO_RESUME_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(5L);
    private final Context applicationContext;
    private final long autoResumeTimeoutAfterUnsuitableOutputSuppressionMs;
    private final Clock clock;
    private long unsuitableOutputPlaybackSuppressionStartRealtimeMs;

    public WearUnsuitableOutputPlaybackSuppressionResolverListener(Context context) {
        this(context, DEFAULT_PLAYBACK_SUPPRESSION_AUTO_RESUME_TIMEOUT_MS);
    }

    public WearUnsuitableOutputPlaybackSuppressionResolverListener(Context context, @IntRange(from=0L) long autoResumeTimeoutMs) {
        this(context, autoResumeTimeoutMs, SystemClock.DEFAULT);
    }

    @VisibleForTesting
    WearUnsuitableOutputPlaybackSuppressionResolverListener(Context context, @IntRange(from=0L) long autoResumeTimeoutMs, Clock clock) {
        Assertions.checkArgument((autoResumeTimeoutMs >= 0L ? 1 : 0) != 0);
        this.applicationContext = context.getApplicationContext();
        this.autoResumeTimeoutAfterUnsuitableOutputSuppressionMs = autoResumeTimeoutMs;
        this.clock = clock;
        this.unsuitableOutputPlaybackSuppressionStartRealtimeMs = -9223372036854775807L;
    }

    public void onEvents(Player player, Player.Events events) {
        if (!Util.isWear((Context)this.applicationContext)) {
            return;
        }
        if ((events.contains(6) || events.contains(5)) && player.getPlayWhenReady() && player.getPlaybackSuppressionReason() == 3) {
            player.pause();
            this.unsuitableOutputPlaybackSuppressionStartRealtimeMs = this.clock.elapsedRealtime();
            if (events.contains(5)) {
                WearUnsuitableOutputPlaybackSuppressionResolverListener.launchSystemMediaOutputSwitcherUi(this.applicationContext);
            }
        } else if (events.contains(6) && player.getPlaybackSuppressionReason() == 0 && this.unsuitableOutputPlaybackSuppressionStartRealtimeMs != -9223372036854775807L && this.clock.elapsedRealtime() - this.unsuitableOutputPlaybackSuppressionStartRealtimeMs < this.autoResumeTimeoutAfterUnsuitableOutputSuppressionMs) {
            this.unsuitableOutputPlaybackSuppressionStartRealtimeMs = -9223372036854775807L;
            player.play();
        }
    }

    private static void launchSystemMediaOutputSwitcherUi(Context context) {
        Intent outputSwitcherLaunchIntent = new Intent(OUTPUT_SWITCHER_INTENT_ACTION_NAME).addFlags(0x10000000).putExtra(EXTRA_OUTPUT_SWITCHER_PACKAGE_NAME, context.getPackageName());
        ComponentName outputSwitcherSystemComponentName = WearUnsuitableOutputPlaybackSuppressionResolverListener.getSystemOrSystemUpdatedAppComponent(context, outputSwitcherLaunchIntent);
        if (outputSwitcherSystemComponentName != null) {
            outputSwitcherLaunchIntent.setComponent(outputSwitcherSystemComponentName);
            context.startActivity(outputSwitcherLaunchIntent);
        } else {
            Intent bluetoothSettingsLaunchIntent = new Intent("android.settings.BLUETOOTH_SETTINGS").addFlags(0x10008000).putExtra(EXTRA_BLUETOOTH_SETTINGS_CLOSE_ON_CONNECT, true).putExtra(EXTRA_BLUETOOTH_SETTINGS_CONNECTION_ONLY, true).putExtra(EXTRA_BLUETOOTH_SETTINGS_FILTER_TYPE, 1);
            ComponentName bluetoothSettingsSystemComponentName = WearUnsuitableOutputPlaybackSuppressionResolverListener.getSystemOrSystemUpdatedAppComponent(context, bluetoothSettingsLaunchIntent);
            if (bluetoothSettingsSystemComponentName != null) {
                bluetoothSettingsLaunchIntent.setComponent(bluetoothSettingsSystemComponentName);
                context.startActivity(bluetoothSettingsLaunchIntent);
            }
        }
    }

    @Nullable
    private static ComponentName getSystemOrSystemUpdatedAppComponent(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List resolveInfos = packageManager.queryIntentActivities(intent, 0);
        for (ResolveInfo resolveInfo : resolveInfos) {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || activityInfo.applicationInfo == null) continue;
            ApplicationInfo appInfo = activityInfo.applicationInfo;
            int systemAndUpdatedSystemAppFlags = 129;
            if ((systemAndUpdatedSystemAppFlags & appInfo.flags) == 0) continue;
            return new ComponentName(activityInfo.packageName, activityInfo.name);
        }
        return null;
    }
}

