/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.view.FrameMetrics;
import android.view.View;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.metrics.performance.PerformanceMetricsState;
import androidx.metrics.performance.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001J$\u0010\u0014\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u001c"}, d2={"Landroidx/metrics/performance/DelegatingFrameMetricsListener;", "Landroid/view/Window$OnFrameMetricsAvailableListener;", "delegates", "", "(Ljava/util/List;)V", "getDelegates", "()Ljava/util/List;", "iterating", "", "getIterating", "()Z", "setIterating", "(Z)V", "toBeAdded", "getToBeAdded", "toBeRemoved", "getToBeRemoved", "add", "", "delegate", "onFrameMetricsAvailable", "window", "Landroid/view/Window;", "frameMetrics", "Landroid/view/FrameMetrics;", "dropCount", "", "remove", "metrics-performance_release"})
@RequiresApi(value=24)
final class DelegatingFrameMetricsListener
implements Window.OnFrameMetricsAvailableListener {
    @NotNull
    private final List<Window.OnFrameMetricsAvailableListener> delegates;
    private boolean iterating;
    @NotNull
    private final List<Window.OnFrameMetricsAvailableListener> toBeAdded;
    @NotNull
    private final List<Window.OnFrameMetricsAvailableListener> toBeRemoved;

    public DelegatingFrameMetricsListener(@NotNull List<Window.OnFrameMetricsAvailableListener> delegates) {
        Intrinsics.checkNotNullParameter(delegates, (String)"delegates");
        this.delegates = delegates;
        this.toBeAdded = new ArrayList();
        this.toBeRemoved = new ArrayList();
    }

    @NotNull
    public final List<Window.OnFrameMetricsAvailableListener> getDelegates() {
        return this.delegates;
    }

    public final boolean getIterating() {
        return this.iterating;
    }

    public final void setIterating(boolean bl) {
        this.iterating = bl;
    }

    @NotNull
    public final List<Window.OnFrameMetricsAvailableListener> getToBeAdded() {
        return this.toBeAdded;
    }

    @NotNull
    public final List<Window.OnFrameMetricsAvailableListener> getToBeRemoved() {
        return this.toBeRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameMetricsAvailable(@Nullable Window window, @Nullable FrameMetrics frameMetrics, int dropCount) {
        block12: {
            DelegatingFrameMetricsListener delegatingFrameMetricsListener = this;
            synchronized (delegatingFrameMetricsListener) {
                boolean bl = false;
                this.iterating = true;
                for (Window.OnFrameMetricsAvailableListener delegate : this.delegates) {
                    delegate.onFrameMetricsAvailable(window, frameMetrics, dropCount);
                }
                if (!((Collection)this.toBeAdded).isEmpty()) {
                    for (Window.OnFrameMetricsAvailableListener delegate : this.toBeAdded) {
                        this.delegates.add(delegate);
                    }
                    this.toBeAdded.clear();
                }
                if (!((Collection)this.toBeRemoved).isEmpty()) {
                    boolean delegatesNonEmpty = !((Collection)this.delegates).isEmpty();
                    for (Window.OnFrameMetricsAvailableListener delegate : this.toBeRemoved) {
                        this.delegates.remove(delegate);
                    }
                    this.toBeRemoved.clear();
                    if (delegatesNonEmpty && this.delegates.isEmpty()) {
                        Window window2;
                        Window window3 = window;
                        if (window3 != null) {
                            window3.removeOnFrameMetricsAvailableListener((Window.OnFrameMetricsAvailableListener)this);
                        }
                        if ((window2 = window) != null && (window2 = window2.getDecorView()) != null) {
                            window2.setTag(R.id.metricsDelegator, null);
                        }
                    }
                }
                this.iterating = false;
                Unit unit = Unit.INSTANCE;
            }
            if (window == null) break block12;
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
            PerformanceMetricsState.Holder holder = PerformanceMetricsState.Companion.getHolderForHierarchy(view);
            PerformanceMetricsState performanceMetricsState = holder.getState();
            if (performanceMetricsState != null) {
                performanceMetricsState.cleanupSingleFrameStates$metrics_performance_release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull Window.OnFrameMetricsAvailableListener delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        DelegatingFrameMetricsListener delegatingFrameMetricsListener = this;
        synchronized (delegatingFrameMetricsListener) {
            boolean bl = false;
            boolean bl2 = this.iterating ? this.toBeAdded.add(delegate) : this.delegates.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull Window.OnFrameMetricsAvailableListener delegate, @NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        DelegatingFrameMetricsListener delegatingFrameMetricsListener = this;
        synchronized (delegatingFrameMetricsListener) {
            Boolean bl;
            boolean bl2 = false;
            if (this.iterating) {
                bl = this.toBeRemoved.add(delegate);
            } else {
                boolean delegatesNonEmpty = !((Collection)this.delegates).isEmpty();
                this.delegates.remove(delegate);
                if (delegatesNonEmpty && this.delegates.isEmpty()) {
                    window.removeOnFrameMetricsAvailableListener((Window.OnFrameMetricsAvailableListener)this);
                    window.getDecorView().setTag(R.id.metricsDelegator, null);
                }
                bl = Unit.INSTANCE;
            }
            Boolean bl3 = bl;
        }
    }
}

