/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.view.Choreographer;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.RequiresApi;
import androidx.metrics.performance.DelegatingOnPreDrawListener;
import androidx.metrics.performance.FrameData;
import androidx.metrics.performance.JankStats;
import androidx.metrics.performance.JankStatsApi16Impl;
import androidx.metrics.performance.JankStatsBaseImpl;
import androidx.metrics.performance.OnFrameListenerDelegate;
import androidx.metrics.performance.PerformanceMetricsState;
import androidx.metrics.performance.R;
import androidx.metrics.performance.StateInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000m\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0016\b\u0011\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J+\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0019H\u0010\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020#2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J%\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020#H\u0010\u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020#H\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\f\u0010/\u001a\u00020\u001e*\u00020\u0005H\u0002J\u0014\u00100\u001a\u00020,*\u00020\u00052\u0006\u00101\u001a\u00020 H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00062"}, d2={"Landroidx/metrics/performance/JankStatsApi16Impl;", "Landroidx/metrics/performance/JankStatsBaseImpl;", "jankStats", "Landroidx/metrics/performance/JankStats;", "view", "Landroid/view/View;", "(Landroidx/metrics/performance/JankStats;Landroid/view/View;)V", "choreographer", "Landroid/view/Choreographer;", "getChoreographer", "()Landroid/view/Choreographer;", "decorViewRef", "Ljava/lang/ref/WeakReference;", "getDecorViewRef$metrics_performance_release", "()Ljava/lang/ref/WeakReference;", "frameData", "Landroidx/metrics/performance/FrameData;", "metricsStateHolder", "Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "getMetricsStateHolder", "()Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "onFrameListenerDelegate", "androidx/metrics/performance/JankStatsApi16Impl$onFrameListenerDelegate$1", "Landroidx/metrics/performance/JankStatsApi16Impl$onFrameListenerDelegate$1;", "stateInfo", "", "Landroidx/metrics/performance/StateInfo;", "getStateInfo", "()Ljava/util/List;", "createDelegatingOnDrawListener", "Landroidx/metrics/performance/DelegatingOnPreDrawListener;", "delegates", "Landroidx/metrics/performance/OnFrameListenerDelegate;", "createDelegatingOnDrawListener$metrics_performance_release", "getExpectedFrameDuration", "", "getFrameData", "startTime", "uiDuration", "expectedDuration", "getFrameData$metrics_performance_release", "getFrameStartTime", "getFrameStartTime$metrics_performance_release", "setupFrameTimer", "", "enable", "", "getOrCreateOnPreDrawListenerDelegator", "removeOnPreDrawListenerDelegate", "delegate", "metrics-performance_release"})
@RequiresApi(value=16)
public class JankStatsApi16Impl
extends JankStatsBaseImpl {
    @NotNull
    private final WeakReference<View> decorViewRef;
    @NotNull
    private final Choreographer choreographer;
    @NotNull
    private final PerformanceMetricsState.Holder metricsStateHolder;
    @NotNull
    private final List<StateInfo> stateInfo;
    @NotNull
    private final FrameData frameData;
    @NotNull
    private final onFrameListenerDelegate.1 onFrameListenerDelegate;

    public JankStatsApi16Impl(@NotNull JankStats jankStats, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)jankStats, (String)"jankStats");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super(jankStats);
        this.decorViewRef = new WeakReference<View>(view);
        Choreographer choreographer = Choreographer.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)choreographer, (String)"getInstance()");
        this.choreographer = choreographer;
        this.metricsStateHolder = PerformanceMetricsState.Companion.getHolderForHierarchy(view);
        this.stateInfo = new ArrayList();
        this.frameData = new FrameData(0L, 0L, false, this.stateInfo);
        this.onFrameListenerDelegate = new OnFrameListenerDelegate(jankStats, this){
            final /* synthetic */ JankStats $jankStats;
            final /* synthetic */ JankStatsApi16Impl this$0;
            {
                this.$jankStats = $jankStats;
                this.this$0 = $receiver;
            }

            public void onFrame(long startTime, long uiDuration, long expectedDuration) {
                this.$jankStats.logFrameData$metrics_performance_release(this.this$0.getFrameData$metrics_performance_release(startTime, uiDuration, (long)((float)expectedDuration * this.$jankStats.getJankHeuristicMultiplier())));
            }
        };
    }

    @NotNull
    public final WeakReference<View> getDecorViewRef$metrics_performance_release() {
        return this.decorViewRef;
    }

    @NotNull
    public final Choreographer getChoreographer() {
        return this.choreographer;
    }

    @NotNull
    public final PerformanceMetricsState.Holder getMetricsStateHolder() {
        return this.metricsStateHolder;
    }

    @NotNull
    public final List<StateInfo> getStateInfo() {
        return this.stateInfo;
    }

    @Override
    public void setupFrameTimer(boolean enable) {
        block2: {
            View decorView;
            View view = decorView = (View)this.decorViewRef.get();
            if (view == null) break block2;
            View it = view;
            boolean bl = false;
            if (enable) {
                DelegatingOnPreDrawListener delegates = this.getOrCreateOnPreDrawListenerDelegator(decorView);
                delegates.add(this.onFrameListenerDelegate);
            } else {
                this.removeOnPreDrawListenerDelegate(decorView, this.onFrameListenerDelegate);
            }
        }
    }

    @NotNull
    public FrameData getFrameData$metrics_performance_release(long startTime, long uiDuration, long expectedDuration) {
        PerformanceMetricsState performanceMetricsState = this.metricsStateHolder.getState();
        if (performanceMetricsState != null) {
            performanceMetricsState.getIntervalStates$metrics_performance_release(startTime, startTime + uiDuration, this.stateInfo);
        }
        boolean isJank = uiDuration > expectedDuration;
        this.frameData.update$metrics_performance_release(startTime, uiDuration, isJank);
        return this.frameData;
    }

    private final void removeOnPreDrawListenerDelegate(View $this$removeOnPreDrawListenerDelegate, OnFrameListenerDelegate delegate) {
        block0: {
            DelegatingOnPreDrawListener delegator;
            DelegatingOnPreDrawListener delegatingOnPreDrawListener = delegator = (DelegatingOnPreDrawListener)$this$removeOnPreDrawListenerDelegate.getTag(R.id.metricsDelegator);
            if (delegatingOnPreDrawListener == null) break block0;
            ViewTreeObserver viewTreeObserver = $this$removeOnPreDrawListenerDelegate.getViewTreeObserver();
            Intrinsics.checkNotNullExpressionValue((Object)viewTreeObserver, (String)"viewTreeObserver");
            delegatingOnPreDrawListener.remove(delegate, viewTreeObserver);
        }
    }

    private final DelegatingOnPreDrawListener getOrCreateOnPreDrawListenerDelegator(View $this$getOrCreateOnPreDrawListenerDelegator) {
        DelegatingOnPreDrawListener delegator = (DelegatingOnPreDrawListener)$this$getOrCreateOnPreDrawListenerDelegator.getTag(R.id.metricsDelegator);
        if (delegator == null) {
            List delegates = new ArrayList();
            delegator = this.createDelegatingOnDrawListener$metrics_performance_release($this$getOrCreateOnPreDrawListenerDelegator, this.choreographer, delegates);
            $this$getOrCreateOnPreDrawListenerDelegator.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)delegator);
            $this$getOrCreateOnPreDrawListenerDelegator.setTag(R.id.metricsDelegator, (Object)delegator);
        }
        return delegator;
    }

    @NotNull
    public DelegatingOnPreDrawListener createDelegatingOnDrawListener$metrics_performance_release(@NotNull View view, @NotNull Choreographer choreographer, @NotNull List<OnFrameListenerDelegate> delegates) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)choreographer, (String)"choreographer");
        Intrinsics.checkNotNullParameter(delegates, (String)"delegates");
        return new DelegatingOnPreDrawListener(view, choreographer, delegates);
    }

    public final long getFrameStartTime$metrics_performance_release() {
        Object object = DelegatingOnPreDrawListener.Companion.getChoreographerLastFrameTimeField().get(this.choreographer);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (Long)object;
    }

    public final long getExpectedFrameDuration(@Nullable View view) {
        return DelegatingOnPreDrawListener.Companion.getExpectedFrameDuration(view);
    }
}

