/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.navigation.NavArgument;
import androidx.navigation.NavType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NavDeepLink {
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^[a-zA-Z]+[+\\w\\-.]*:");
    private final ArrayList<String> mArguments = new ArrayList();
    private final Pattern mPattern;
    private final boolean mExactDeepLink;
    private final boolean mIsParameterizedQuery;
    private final Map<String, ParamQuery> mParamArgMap = new HashMap<String, ParamQuery>();

    NavDeepLink(@NonNull String uri) {
        Uri parameterizedUri = Uri.parse((String)uri);
        this.mIsParameterizedQuery = parameterizedUri.getQuery() != null;
        StringBuilder uriRegex = new StringBuilder("^");
        if (!SCHEME_PATTERN.matcher(uri).find()) {
            uriRegex.append("http[s]?://");
        }
        Pattern fillInPattern = Pattern.compile("\\{(.+?)\\}");
        if (this.mIsParameterizedQuery) {
            Matcher matcher = Pattern.compile("(\\?)").matcher(uri);
            if (matcher.find()) {
                this.buildPathRegex(uri.substring(0, matcher.start()), uriRegex, fillInPattern);
                uriRegex.append("(.+)?");
            }
            this.mExactDeepLink = false;
            for (String paramName : parameterizedUri.getQueryParameterNames()) {
                StringBuilder argRegex = new StringBuilder();
                String queryParam = parameterizedUri.getQueryParameter(paramName);
                matcher = fillInPattern.matcher(queryParam);
                int appendPos = 0;
                ParamQuery param = new ParamQuery();
                while (matcher.find()) {
                    param.addArgumentName(matcher.group(1));
                    argRegex.append(Pattern.quote(queryParam.substring(appendPos, matcher.start())));
                    argRegex.append("(.+?)?");
                    appendPos = matcher.end();
                }
                if (appendPos < queryParam.length()) {
                    argRegex.append(Pattern.quote(queryParam.substring(appendPos)));
                }
                param.setParamRegex(argRegex.toString().replace(".*", "\\E.*\\Q"));
                this.mParamArgMap.put(paramName, param);
            }
        } else {
            this.mExactDeepLink = this.buildPathRegex(uri, uriRegex, fillInPattern);
        }
        String finalRegex = uriRegex.toString().replace(".*", "\\E.*\\Q");
        this.mPattern = Pattern.compile(finalRegex);
    }

    private boolean buildPathRegex(@NonNull String uri, StringBuilder uriRegex, Pattern fillInPattern) {
        boolean exactDeepLink;
        Matcher matcher = fillInPattern.matcher(uri);
        int appendPos = 0;
        boolean bl = exactDeepLink = !uri.contains(".*");
        while (matcher.find()) {
            String argName = matcher.group(1);
            this.mArguments.add(argName);
            uriRegex.append(Pattern.quote(uri.substring(appendPos, matcher.start())));
            uriRegex.append("(.+?)");
            appendPos = matcher.end();
            exactDeepLink = false;
        }
        if (appendPos < uri.length()) {
            uriRegex.append(Pattern.quote(uri.substring(appendPos)));
        }
        return exactDeepLink;
    }

    boolean matches(@NonNull Uri deepLink) {
        return this.mPattern.matcher(deepLink.toString()).matches();
    }

    boolean isExactDeepLink() {
        return this.mExactDeepLink;
    }

    @Nullable
    Bundle getMatchingArguments(@NonNull Uri deepLink, @NonNull Map<String, NavArgument> arguments) {
        Matcher matcher = this.mPattern.matcher(deepLink.toString());
        if (!matcher.matches()) {
            return null;
        }
        Bundle bundle = new Bundle();
        int size = this.mArguments.size();
        for (int index = 0; index < size; ++index) {
            NavArgument argument;
            String value;
            String argumentName = this.mArguments.get(index);
            if (!this.parseArgument(bundle, argumentName, value = Uri.decode((String)matcher.group(index + 1)), argument = arguments.get(argumentName))) continue;
            return null;
        }
        if (this.mIsParameterizedQuery) {
            for (String paramName : this.mParamArgMap.keySet()) {
                Matcher argMatcher = null;
                ParamQuery storedParam = this.mParamArgMap.get(paramName);
                String inputParams = deepLink.getQueryParameter(paramName);
                if (inputParams != null && !(argMatcher = Pattern.compile(storedParam.getParamRegex()).matcher(inputParams)).matches()) {
                    return null;
                }
                for (int index = 0; index < storedParam.size(); ++index) {
                    String argName;
                    NavArgument argument;
                    String value = null;
                    if (argMatcher != null) {
                        value = Uri.decode((String)argMatcher.group(index + 1));
                    }
                    if ((argument = arguments.get(argName = storedParam.getArgumentName(index))) != null && (value == null || value.replaceAll("[{}]", "").equals(argName))) {
                        if (argument.getDefaultValue() != null) {
                            value = argument.getDefaultValue().toString();
                        } else if (argument.isNullable()) {
                            value = "@null";
                        }
                    }
                    if (!this.parseArgument(bundle, argName, value, argument)) continue;
                    return null;
                }
            }
        }
        return bundle;
    }

    private boolean parseArgument(Bundle bundle, String name, String value, NavArgument argument) {
        if (argument != null) {
            NavType<?> type = argument.getType();
            try {
                type.parseAndPut(bundle, name, value);
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        } else {
            bundle.putString(name, value);
        }
        return false;
    }

    private static class ParamQuery {
        private String mParamRegex;
        private ArrayList<String> mArguments = new ArrayList();

        ParamQuery() {
        }

        void setParamRegex(String paramRegex) {
            this.mParamRegex = paramRegex;
        }

        String getParamRegex() {
            return this.mParamRegex;
        }

        void addArgumentName(String name) {
            this.mArguments.add(name);
        }

        String getArgumentName(int index) {
            return this.mArguments.get(index);
        }

        public int size() {
            return this.mArguments.size();
        }
    }
}

