/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.AnyRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.Serializable;

public abstract class NavType<T> {
    private final boolean mNullableAllowed;
    @NonNull
    public static final NavType<Integer> IntType = new NavType<Integer>(false){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @NonNull Integer value) {
            bundle.putInt(key, value.intValue());
        }

        @Override
        public Integer get(@NonNull Bundle bundle, @NonNull String key) {
            return (Integer)bundle.get(key);
        }

        @Override
        @NonNull
        public Integer parseValue(@NonNull String value) {
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(2), 16);
            }
            return Integer.parseInt(value);
        }

        @Override
        @NonNull
        public String getName() {
            return "integer";
        }
    };
    @NonNull
    public static final NavType<Integer> ReferenceType = new NavType<Integer>(false){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @NonNull @AnyRes Integer value) {
            bundle.putInt(key, value.intValue());
        }

        @Override
        @AnyRes
        public Integer get(@NonNull Bundle bundle, @NonNull String key) {
            return (Integer)bundle.get(key);
        }

        @Override
        @NonNull
        public Integer parseValue(@NonNull String value) {
            throw new UnsupportedOperationException("References don't support parsing string values.");
        }

        @Override
        @NonNull
        public String getName() {
            return "reference";
        }
    };
    @NonNull
    public static final NavType<int[]> IntArrayType = new NavType<int[]>(true){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @Nullable int[] value) {
            bundle.putIntArray(key, value);
        }

        @Override
        public int[] get(@NonNull Bundle bundle, @NonNull String key) {
            return (int[])bundle.get(key);
        }

        @Override
        @NonNull
        public int[] parseValue(@NonNull String value) {
            throw new UnsupportedOperationException("Arrays don't support default values.");
        }

        @Override
        @NonNull
        public String getName() {
            return "integer[]";
        }
    };
    @NonNull
    public static final NavType<Long> LongType = new NavType<Long>(false){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @NonNull Long value) {
            bundle.putLong(key, value.longValue());
        }

        @Override
        public Long get(@NonNull Bundle bundle, @NonNull String key) {
            return (Long)bundle.get(key);
        }

        @Override
        @NonNull
        public Long parseValue(@NonNull String value) {
            if (value.endsWith("L")) {
                value = value.substring(0, value.length() - 1);
            }
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            return Long.parseLong(value);
        }

        @Override
        @NonNull
        public String getName() {
            return "long";
        }
    };
    @NonNull
    public static final NavType<long[]> LongArrayType = new NavType<long[]>(true){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @Nullable long[] value) {
            bundle.putLongArray(key, value);
        }

        @Override
        public long[] get(@NonNull Bundle bundle, @NonNull String key) {
            return (long[])bundle.get(key);
        }

        @Override
        @NonNull
        public long[] parseValue(@NonNull String value) {
            throw new UnsupportedOperationException("Arrays don't support default values.");
        }

        @Override
        @NonNull
        public String getName() {
            return "long[]";
        }
    };
    @NonNull
    public static final NavType<Float> FloatType = new NavType<Float>(false){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @NonNull Float value) {
            bundle.putFloat(key, value.floatValue());
        }

        @Override
        public Float get(@NonNull Bundle bundle, @NonNull String key) {
            return (Float)bundle.get(key);
        }

        @Override
        @NonNull
        public Float parseValue(@NonNull String value) {
            return Float.valueOf(Float.parseFloat(value));
        }

        @Override
        @NonNull
        public String getName() {
            return "float";
        }
    };
    @NonNull
    public static final NavType<float[]> FloatArrayType = new NavType<float[]>(true){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @Nullable float[] value) {
            bundle.putFloatArray(key, value);
        }

        @Override
        public float[] get(@NonNull Bundle bundle, @NonNull String key) {
            return (float[])bundle.get(key);
        }

        @Override
        @NonNull
        public float[] parseValue(@NonNull String value) {
            throw new UnsupportedOperationException("Arrays don't support default values.");
        }

        @Override
        @NonNull
        public String getName() {
            return "float[]";
        }
    };
    @NonNull
    public static final NavType<Boolean> BoolType = new NavType<Boolean>(false){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @NonNull Boolean value) {
            bundle.putBoolean(key, value.booleanValue());
        }

        @Override
        public Boolean get(@NonNull Bundle bundle, @NonNull String key) {
            return (Boolean)bundle.get(key);
        }

        @Override
        @NonNull
        public Boolean parseValue(@NonNull String value) {
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            throw new IllegalArgumentException("A boolean NavType only accepts \"true\" or \"false\" values.");
        }

        @Override
        @NonNull
        public String getName() {
            return "boolean";
        }
    };
    @NonNull
    public static final NavType<boolean[]> BoolArrayType = new NavType<boolean[]>(true){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @Nullable boolean[] value) {
            bundle.putBooleanArray(key, value);
        }

        @Override
        public boolean[] get(@NonNull Bundle bundle, @NonNull String key) {
            return (boolean[])bundle.get(key);
        }

        @Override
        @NonNull
        public boolean[] parseValue(@NonNull String value) {
            throw new UnsupportedOperationException("Arrays don't support default values.");
        }

        @Override
        @NonNull
        public String getName() {
            return "boolean[]";
        }
    };
    @NonNull
    public static final NavType<String> StringType = new NavType<String>(true){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @Nullable String value) {
            bundle.putString(key, value);
        }

        @Override
        public String get(@NonNull Bundle bundle, @NonNull String key) {
            return (String)bundle.get(key);
        }

        @Override
        @NonNull
        public String parseValue(@NonNull String value) {
            return value;
        }

        @Override
        @NonNull
        public String getName() {
            return "string";
        }
    };
    @NonNull
    public static final NavType<String[]> StringArrayType = new NavType<String[]>(true){

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @Nullable String[] value) {
            bundle.putStringArray(key, value);
        }

        @Override
        public String[] get(@NonNull Bundle bundle, @NonNull String key) {
            return (String[])bundle.get(key);
        }

        @Override
        @NonNull
        public String[] parseValue(@NonNull String value) {
            throw new UnsupportedOperationException("Arrays don't support default values.");
        }

        @Override
        @NonNull
        public String getName() {
            return "string[]";
        }
    };

    NavType(boolean nullableAllowed) {
        this.mNullableAllowed = nullableAllowed;
    }

    public boolean isNullableAllowed() {
        return this.mNullableAllowed;
    }

    public abstract void put(@NonNull Bundle var1, @NonNull String var2, @Nullable T var3);

    @Nullable
    public abstract T get(@NonNull Bundle var1, @NonNull String var2);

    @NonNull
    public abstract T parseValue(@NonNull String var1);

    @NonNull
    T parseAndPut(@NonNull Bundle bundle, @NonNull String key, @NonNull String value) {
        T parsedValue = this.parseValue(value);
        this.put(bundle, key, parsedValue);
        return parsedValue;
    }

    @NonNull
    public abstract String getName();

    @NonNull
    public String toString() {
        return this.getName();
    }

    @NonNull
    public static NavType<?> fromArgType(@Nullable String type, @Nullable String packageName) {
        if (IntType.getName().equals(type)) {
            return IntType;
        }
        if (IntArrayType.getName().equals(type)) {
            return IntArrayType;
        }
        if (LongType.getName().equals(type)) {
            return LongType;
        }
        if (LongArrayType.getName().equals(type)) {
            return LongArrayType;
        }
        if (BoolType.getName().equals(type)) {
            return BoolType;
        }
        if (BoolArrayType.getName().equals(type)) {
            return BoolArrayType;
        }
        if (StringType.getName().equals(type)) {
            return StringType;
        }
        if (StringArrayType.getName().equals(type)) {
            return StringArrayType;
        }
        if (FloatType.getName().equals(type)) {
            return FloatType;
        }
        if (FloatArrayType.getName().equals(type)) {
            return FloatArrayType;
        }
        if (ReferenceType.getName().equals(type)) {
            return ReferenceType;
        }
        if (type != null && !type.isEmpty()) {
            try {
                String className = type.startsWith(".") && packageName != null ? packageName + type : type;
                if (type.endsWith("[]")) {
                    Class<?> clazz = Class.forName(className = className.substring(0, className.length() - 2));
                    if (Parcelable.class.isAssignableFrom(clazz)) {
                        return new ParcelableArrayType(clazz);
                    }
                    if (Serializable.class.isAssignableFrom(clazz)) {
                        return new SerializableArrayType(clazz);
                    }
                } else {
                    Class<?> clazz = Class.forName(className);
                    if (Parcelable.class.isAssignableFrom(clazz)) {
                        return new ParcelableType(clazz);
                    }
                    if (Enum.class.isAssignableFrom(clazz)) {
                        return new EnumType(clazz);
                    }
                    if (Serializable.class.isAssignableFrom(clazz)) {
                        return new SerializableType(clazz);
                    }
                }
                throw new IllegalArgumentException(className + " is not Serializable or Parcelable.");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return StringType;
    }

    @NonNull
    static NavType inferFromValue(@NonNull String value) {
        try {
            IntType.parseValue(value);
            return IntType;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                LongType.parseValue(value);
                return LongType;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    FloatType.parseValue(value);
                    return FloatType;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        BoolType.parseValue(value);
                        return BoolType;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        return StringType;
                    }
                }
            }
        }
    }

    @NonNull
    static NavType inferFromValueType(@Nullable Object value) {
        if (value instanceof Integer) {
            return IntType;
        }
        if (value instanceof int[]) {
            return IntArrayType;
        }
        if (value instanceof Long) {
            return LongType;
        }
        if (value instanceof long[]) {
            return LongArrayType;
        }
        if (value instanceof Float) {
            return FloatType;
        }
        if (value instanceof float[]) {
            return FloatArrayType;
        }
        if (value instanceof Boolean) {
            return BoolType;
        }
        if (value instanceof boolean[]) {
            return BoolArrayType;
        }
        if (value instanceof String || value == null) {
            return StringType;
        }
        if (value instanceof String[]) {
            return StringArrayType;
        }
        if (value.getClass().isArray() && Parcelable.class.isAssignableFrom(value.getClass().getComponentType())) {
            return new ParcelableArrayType(value.getClass().getComponentType());
        }
        if (value.getClass().isArray() && Serializable.class.isAssignableFrom(value.getClass().getComponentType())) {
            return new SerializableArrayType(value.getClass().getComponentType());
        }
        if (value instanceof Parcelable) {
            return new ParcelableType(value.getClass());
        }
        if (value instanceof Enum) {
            return new EnumType(value.getClass());
        }
        if (value instanceof Serializable) {
            return new SerializableType(value.getClass());
        }
        throw new IllegalArgumentException("Object of type " + value.getClass().getName() + " is not supported for navigation arguments.");
    }

    public static final class SerializableArrayType<D extends Serializable>
    extends NavType<D[]> {
        @NonNull
        private final Class<D[]> mArrayType;

        public SerializableArrayType(@NonNull Class<D> type) {
            super(true);
            Class<?> arrayType;
            if (!Serializable.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException(type + " does not implement Serializable.");
            }
            try {
                arrayType = Class.forName("[L" + type.getName() + ";");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.mArrayType = arrayType;
        }

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @Nullable D[] value) {
            this.mArrayType.cast(value);
            bundle.putSerializable(key, value);
        }

        @Override
        @Nullable
        public D[] get(@NonNull Bundle bundle, @NonNull String key) {
            return (Serializable[])bundle.get(key);
        }

        @Override
        @NonNull
        public D[] parseValue(@NonNull String value) {
            throw new UnsupportedOperationException("Arrays don't support default values.");
        }

        @Override
        @NonNull
        public String getName() {
            return this.mArrayType.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializableArrayType that = (SerializableArrayType)o;
            return this.mArrayType.equals(that.mArrayType);
        }

        public int hashCode() {
            return this.mArrayType.hashCode();
        }
    }

    public static final class EnumType<D extends Enum>
    extends SerializableType<D> {
        @NonNull
        private final Class<D> mType;

        public EnumType(@NonNull Class<D> type) {
            super(false, type);
            if (!type.isEnum()) {
                throw new IllegalArgumentException(type + " is not an Enum type.");
            }
            this.mType = type;
        }

        @Override
        @NonNull
        public D parseValue(@NonNull String value) {
            for (Enum constant : (Enum[])this.mType.getEnumConstants()) {
                if (!constant.name().equals(value)) continue;
                return (D)constant;
            }
            throw new IllegalArgumentException("Enum value " + value + " not found for type " + this.mType.getName() + ".");
        }

        @Override
        @NonNull
        public String getName() {
            return this.mType.getName();
        }
    }

    public static class SerializableType<D extends Serializable>
    extends NavType<D> {
        @NonNull
        private final Class<D> mType;

        public SerializableType(@NonNull Class<D> type) {
            super(true);
            if (!Serializable.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException(type + " does not implement Serializable.");
            }
            if (type.isEnum()) {
                throw new IllegalArgumentException(type + " is an Enum. You should use EnumType instead.");
            }
            this.mType = type;
        }

        SerializableType(boolean nullableAllowed, @NonNull Class<D> type) {
            super(nullableAllowed);
            if (!Serializable.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException(type + " does not implement Serializable.");
            }
            this.mType = type;
        }

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @Nullable D value) {
            this.mType.cast(value);
            bundle.putSerializable(key, value);
        }

        @Override
        @Nullable
        public D get(@NonNull Bundle bundle, @NonNull String key) {
            return (D)((Serializable)bundle.get(key));
        }

        @Override
        @NonNull
        public D parseValue(@NonNull String value) {
            throw new UnsupportedOperationException("Serializables don't support default values.");
        }

        @Override
        @NonNull
        public String getName() {
            return this.mType.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SerializableType)) {
                return false;
            }
            SerializableType that = (SerializableType)o;
            return this.mType.equals(that.mType);
        }

        public int hashCode() {
            return this.mType.hashCode();
        }
    }

    public static final class ParcelableArrayType<D extends Parcelable>
    extends NavType<D[]> {
        @NonNull
        private final Class<D[]> mArrayType;

        public ParcelableArrayType(@NonNull Class<D> type) {
            super(true);
            Class<?> arrayType;
            if (!Parcelable.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException(type + " does not implement Parcelable.");
            }
            try {
                arrayType = Class.forName("[L" + type.getName() + ";");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.mArrayType = arrayType;
        }

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @Nullable D[] value) {
            this.mArrayType.cast(value);
            bundle.putParcelableArray(key, value);
        }

        @Override
        @Nullable
        public D[] get(@NonNull Bundle bundle, @NonNull String key) {
            return (Parcelable[])bundle.get(key);
        }

        @Override
        @NonNull
        public D[] parseValue(@NonNull String value) {
            throw new UnsupportedOperationException("Arrays don't support default values.");
        }

        @Override
        @NonNull
        public String getName() {
            return this.mArrayType.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParcelableArrayType that = (ParcelableArrayType)o;
            return this.mArrayType.equals(that.mArrayType);
        }

        public int hashCode() {
            return this.mArrayType.hashCode();
        }
    }

    public static final class ParcelableType<D>
    extends NavType<D> {
        @NonNull
        private final Class<D> mType;

        public ParcelableType(@NonNull Class<D> type) {
            super(true);
            if (!Parcelable.class.isAssignableFrom(type) && !Serializable.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException(type + " does not implement Parcelable or Serializable.");
            }
            this.mType = type;
        }

        @Override
        public void put(@NonNull Bundle bundle, @NonNull String key, @Nullable D value) {
            this.mType.cast(value);
            if (value == null || value instanceof Parcelable) {
                bundle.putParcelable(key, (Parcelable)value);
            } else if (value instanceof Serializable) {
                bundle.putSerializable(key, (Serializable)value);
            }
        }

        @Override
        @Nullable
        public D get(@NonNull Bundle bundle, @NonNull String key) {
            return (D)bundle.get(key);
        }

        @Override
        @NonNull
        public D parseValue(@NonNull String value) {
            throw new UnsupportedOperationException("Parcelables don't support default values.");
        }

        @Override
        @NonNull
        public String getName() {
            return this.mType.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParcelableType that = (ParcelableType)o;
            return this.mType.equals(that.mType);
        }

        public int hashCode() {
            return this.mType.hashCode();
        }
    }
}

