/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.HasDefaultViewModelProviderFactory;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateViewModelFactory;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.NavDestination;
import androidx.navigation.NavViewModelStoreProvider;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryController;
import androidx.savedstate.SavedStateRegistryOwner;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0003BCDBS\b\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0011J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0007J\u0012\u0010=\u001a\u00020:2\b\u0010>\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u00020\nH\u0007J\b\u0010A\u001a\u00020:H\u0007R\u001e\u0010\t\u001a\u0004\u0018\u00010\n@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010%\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001f8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010*\u001a\u00020+8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u001b\u001a\u0004\b,\u0010-R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Landroidx/navigation/NavBackStackEntry;", "Landroidx/lifecycle/LifecycleOwner;", "Landroidx/lifecycle/ViewModelStoreOwner;", "Landroidx/lifecycle/HasDefaultViewModelProviderFactory;", "Landroidx/savedstate/SavedStateRegistryOwner;", "context", "Landroid/content/Context;", "destination", "Landroidx/navigation/NavDestination;", "arguments", "Landroid/os/Bundle;", "navControllerLifecycleOwner", "viewModelStoreProvider", "Landroidx/navigation/NavViewModelStoreProvider;", "id", "", "savedState", "(Landroid/content/Context;Landroidx/navigation/NavDestination;Landroid/os/Bundle;Landroidx/lifecycle/LifecycleOwner;Landroidx/navigation/NavViewModelStoreProvider;Ljava/lang/String;Landroid/os/Bundle;)V", "getArguments", "()Landroid/os/Bundle;", "setArguments", "(Landroid/os/Bundle;)V", "defaultFactory", "Landroidx/lifecycle/SavedStateViewModelFactory;", "getDefaultFactory", "()Landroidx/lifecycle/SavedStateViewModelFactory;", "defaultFactory$delegate", "Lkotlin/Lazy;", "getDestination", "()Landroidx/navigation/NavDestination;", "hostLifecycleState", "Landroidx/lifecycle/Lifecycle$State;", "getId", "()Ljava/lang/String;", "lifecycle", "Landroidx/lifecycle/LifecycleRegistry;", "maxState", "maxLifecycle", "getMaxLifecycle", "()Landroidx/lifecycle/Lifecycle$State;", "setMaxLifecycle", "(Landroidx/lifecycle/Lifecycle$State;)V", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "getSavedStateHandle", "()Landroidx/lifecycle/SavedStateHandle;", "savedStateHandle$delegate", "savedStateRegistryController", "Landroidx/savedstate/SavedStateRegistryController;", "getDefaultViewModelProviderFactory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "getLifecycle", "Landroidx/lifecycle/Lifecycle;", "getSavedStateRegistry", "Landroidx/savedstate/SavedStateRegistry;", "getViewModelStore", "Landroidx/lifecycle/ViewModelStore;", "handleLifecycleEvent", "", "event", "Landroidx/lifecycle/Lifecycle$Event;", "replaceArguments", "newArgs", "saveState", "outBundle", "updateState", "Companion", "NavResultSavedStateFactory", "SavedStateViewModel", "navigation-common_release"})
public final class NavBackStackEntry
implements LifecycleOwner,
ViewModelStoreOwner,
HasDefaultViewModelProviderFactory,
SavedStateRegistryOwner {
    private LifecycleRegistry lifecycle;
    private final SavedStateRegistryController savedStateRegistryController;
    private Lifecycle.State hostLifecycleState;
    private final Lazy defaultFactory$delegate;
    @NotNull
    private final Lazy savedStateHandle$delegate;
    @NotNull
    private Lifecycle.State maxLifecycle;
    private final Context context;
    @NotNull
    private final NavDestination destination;
    @Nullable
    private Bundle arguments;
    private final NavViewModelStoreProvider viewModelStoreProvider;
    @NotNull
    private final String id;
    private final Bundle savedState;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final SavedStateViewModelFactory getDefaultFactory() {
        Lazy lazy = this.defaultFactory$delegate;
        NavBackStackEntry navBackStackEntry = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SavedStateViewModelFactory)lazy.getValue();
    }

    @NotNull
    public final SavedStateHandle getSavedStateHandle() {
        Lazy lazy = this.savedStateHandle$delegate;
        NavBackStackEntry navBackStackEntry = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SavedStateHandle)lazy.getValue();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void replaceArguments(@Nullable Bundle newArgs) {
        this.arguments = newArgs;
    }

    @NotNull
    public Lifecycle getLifecycle() {
        return (Lifecycle)this.lifecycle;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final Lifecycle.State getMaxLifecycle() {
        return this.maxLifecycle;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void setMaxLifecycle(@NotNull Lifecycle.State maxState) {
        Intrinsics.checkNotNullParameter((Object)maxState, (String)"maxState");
        if (this.maxLifecycle == Lifecycle.State.INITIALIZED) {
            this.savedStateRegistryController.performRestore(this.savedState);
        }
        this.maxLifecycle = maxState;
        this.updateState();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void handleLifecycleEvent(@NotNull Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Lifecycle.State state = event.getTargetState();
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"event.targetState");
        this.hostLifecycleState = state;
        this.updateState();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void updateState() {
        if (this.hostLifecycleState.ordinal() < this.maxLifecycle.ordinal()) {
            this.lifecycle.setCurrentState(this.hostLifecycleState);
        } else {
            this.lifecycle.setCurrentState(this.maxLifecycle);
        }
    }

    @NotNull
    public ViewModelStore getViewModelStore() {
        boolean bl = this.lifecycle.getCurrentState().isAtLeast(Lifecycle.State.CREATED);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "You cannot access the NavBackStackEntry's ViewModels until it is added to the NavController's back stack (i.e., the Lifecycle of the NavBackStackEntry reaches the CREATED state).";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        NavViewModelStoreProvider navViewModelStoreProvider = this.viewModelStoreProvider;
        bl2 = false;
        bl3 = false;
        if (navViewModelStoreProvider == null) {
            boolean bl5 = false;
            String string = "You must call setViewModelStore() on your NavHostController before accessing the ViewModelStore of a navigation graph.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.viewModelStoreProvider.getViewModelStore(this.id);
    }

    @NotNull
    public ViewModelProvider.Factory getDefaultViewModelProviderFactory() {
        return (ViewModelProvider.Factory)this.getDefaultFactory();
    }

    @NotNull
    public SavedStateRegistry getSavedStateRegistry() {
        SavedStateRegistry savedStateRegistry = this.savedStateRegistryController.getSavedStateRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)savedStateRegistry, (String)"savedStateRegistryController.savedStateRegistry");
        return savedStateRegistry;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void saveState(@NotNull Bundle outBundle) {
        Intrinsics.checkNotNullParameter((Object)outBundle, (String)"outBundle");
        this.savedStateRegistryController.performSave(outBundle);
    }

    @NotNull
    public final NavDestination getDestination() {
        return this.destination;
    }

    @Nullable
    public final Bundle getArguments() {
        return this.arguments;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void setArguments(@Nullable Bundle bundle) {
        this.arguments = bundle;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    private NavBackStackEntry(Context context, NavDestination destination, Bundle arguments, LifecycleOwner navControllerLifecycleOwner, NavViewModelStoreProvider viewModelStoreProvider, String id, Bundle savedState) {
        this.context = context;
        this.destination = destination;
        this.arguments = arguments;
        this.viewModelStoreProvider = viewModelStoreProvider;
        this.id = id;
        this.savedState = savedState;
        this.lifecycle = new LifecycleRegistry((LifecycleOwner)this);
        SavedStateRegistryController savedStateRegistryController = SavedStateRegistryController.create((SavedStateRegistryOwner)this);
        Intrinsics.checkNotNullExpressionValue((Object)savedStateRegistryController, (String)"SavedStateRegistryController.create(this)");
        this.savedStateRegistryController = savedStateRegistryController;
        this.hostLifecycleState = Lifecycle.State.CREATED;
        this.defaultFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SavedStateViewModelFactory>(this){
            final /* synthetic */ NavBackStackEntry this$0;

            @NotNull
            public final SavedStateViewModelFactory invoke() {
                Context context = NavBackStackEntry.access$getContext$p(this.this$0);
                Object object = context != null ? context.getApplicationContext() : null;
                if (!(object instanceof Application)) {
                    object = null;
                }
                return new SavedStateViewModelFactory((Application)object, (SavedStateRegistryOwner)this.this$0, this.this$0.getArguments());
            }
            {
                this.this$0 = navBackStackEntry;
                super(0);
            }
        }));
        this.savedStateHandle$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SavedStateHandle>(this){
            final /* synthetic */ NavBackStackEntry this$0;

            @NotNull
            public final SavedStateHandle invoke() {
                boolean bl = NavBackStackEntry.access$getLifecycle$p(this.this$0).getCurrentState().isAtLeast(Lifecycle.State.CREATED);
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "You cannot access the NavBackStackEntry's SavedStateHandle until it is added to the NavController's back stack (i.e., the Lifecycle of the NavBackStackEntry reaches the CREATED state).";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return ((SavedStateViewModel)new ViewModelProvider((ViewModelStoreOwner)this.this$0, (ViewModelProvider.Factory)new NavResultSavedStateFactory(this.this$0, null)).get(SavedStateViewModel.class)).getHandle();
            }
            {
                this.this$0 = navBackStackEntry;
                super(0);
            }
        }));
        this.maxLifecycle = Lifecycle.State.INITIALIZED;
        if (navControllerLifecycleOwner != null) {
            Lifecycle lifecycle = navControllerLifecycleOwner.getLifecycle();
            Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"navControllerLifecycleOwner.lifecycle");
            Lifecycle.State state = lifecycle.getCurrentState();
            Intrinsics.checkNotNullExpressionValue((Object)state, (String)"navControllerLifecycleOwner.lifecycle.currentState");
            this.hostLifecycleState = state;
        }
    }

    /* synthetic */ NavBackStackEntry(Context context, NavDestination navDestination, Bundle bundle, LifecycleOwner lifecycleOwner, NavViewModelStoreProvider navViewModelStoreProvider, String string, Bundle bundle2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bundle = null;
        }
        if ((n & 8) != 0) {
            lifecycleOwner = null;
        }
        if ((n & 0x10) != 0) {
            navViewModelStoreProvider = null;
        }
        if ((n & 0x20) != 0) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UUID.randomUUID().toString()");
            string = string2;
        }
        if ((n & 0x40) != 0) {
            bundle2 = null;
        }
        this(context, navDestination, bundle, lifecycleOwner, navViewModelStoreProvider, string, bundle2);
    }

    public static final /* synthetic */ Context access$getContext$p(NavBackStackEntry $this) {
        return $this.context;
    }

    public static final /* synthetic */ LifecycleRegistry access$getLifecycle$p(NavBackStackEntry $this) {
        return $this.lifecycle;
    }

    public static final /* synthetic */ void access$setLifecycle$p(NavBackStackEntry $this, LifecycleRegistry lifecycleRegistry) {
        $this.lifecycle = lifecycleRegistry;
    }

    public /* synthetic */ NavBackStackEntry(Context context, NavDestination destination, Bundle arguments, LifecycleOwner navControllerLifecycleOwner, NavViewModelStoreProvider viewModelStoreProvider, String id, Bundle savedState, DefaultConstructorMarker $constructor_marker) {
        this(context, destination, arguments, navControllerLifecycleOwner, viewModelStoreProvider, id, savedState);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J7\u0010\u0007\u001a\u0002H\b\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Landroidx/navigation/NavBackStackEntry$NavResultSavedStateFactory;", "Landroidx/lifecycle/AbstractSavedStateViewModelFactory;", "owner", "Landroidx/savedstate/SavedStateRegistryOwner;", "defaultArgs", "Landroid/os/Bundle;", "(Landroidx/savedstate/SavedStateRegistryOwner;Landroid/os/Bundle;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "key", "", "modelClass", "Ljava/lang/Class;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "(Ljava/lang/String;Ljava/lang/Class;Landroidx/lifecycle/SavedStateHandle;)Landroidx/lifecycle/ViewModel;", "navigation-common_release"})
    private static final class NavResultSavedStateFactory
    extends AbstractSavedStateViewModelFactory {
        protected <T extends ViewModel> T create(@NotNull String key, @NotNull Class<T> modelClass, @NotNull SavedStateHandle handle) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            return (T)((Object)new SavedStateViewModel(handle));
        }

        public NavResultSavedStateFactory(@NotNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner, defaultArgs);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/NavBackStackEntry$SavedStateViewModel;", "Landroidx/lifecycle/ViewModel;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "(Landroidx/lifecycle/SavedStateHandle;)V", "getHandle", "()Landroidx/lifecycle/SavedStateHandle;", "navigation-common_release"})
    private static final class SavedStateViewModel
    extends ViewModel {
        @NotNull
        private final SavedStateHandle handle;

        @NotNull
        public final SavedStateHandle getHandle() {
            return this.handle;
        }

        public SavedStateViewModel(@NotNull SavedStateHandle handle) {
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            this.handle = handle;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0007\u00a8\u0006\u0012"}, d2={"Landroidx/navigation/NavBackStackEntry$Companion;", "", "()V", "create", "Landroidx/navigation/NavBackStackEntry;", "context", "Landroid/content/Context;", "destination", "Landroidx/navigation/NavDestination;", "arguments", "Landroid/os/Bundle;", "navControllerLifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "viewModelStoreProvider", "Landroidx/navigation/NavViewModelStoreProvider;", "id", "", "savedState", "navigation-common_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final NavBackStackEntry create(@Nullable Context context, @NotNull NavDestination destination, @Nullable Bundle arguments, @Nullable LifecycleOwner navControllerLifecycleOwner, @Nullable NavViewModelStoreProvider viewModelStoreProvider, @NotNull String id, @Nullable Bundle savedState) {
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new NavBackStackEntry(context, destination, arguments, navControllerLifecycleOwner, viewModelStoreProvider, id, savedState, null);
        }

        public static /* synthetic */ NavBackStackEntry create$default(Companion companion, Context context, NavDestination navDestination, Bundle bundle, LifecycleOwner lifecycleOwner, NavViewModelStoreProvider navViewModelStoreProvider, String string, Bundle bundle2, int n, Object object) {
            if ((n & 4) != 0) {
                bundle = null;
            }
            if ((n & 8) != 0) {
                lifecycleOwner = null;
            }
            if ((n & 0x10) != 0) {
                navViewModelStoreProvider = null;
            }
            if ((n & 0x20) != 0) {
                String string2 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UUID.randomUUID().toString()");
                string = string2;
            }
            if ((n & 0x40) != 0) {
                bundle2 = null;
            }
            return companion.create(context, navDestination, bundle, lifecycleOwner, navViewModelStoreProvider, string, bundle2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

