/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Bundle;
import android.util.AttributeSet;
import androidx.annotation.CallSuper;
import androidx.annotation.IdRes;
import androidx.annotation.RestrictTo;
import androidx.collection.SparseArrayCompat;
import androidx.navigation.NavAction;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLink;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavGraph;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.common.R;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 U2\u00020\u0001:\u0003TUVB\u0017\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\nJ\u000e\u00104\u001a\u0002012\u0006\u00105\u001a\u00020\u0014J\u000e\u00104\u001a\u0002012\u0006\u00106\u001a\u00020\u0006J\u0014\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u000108H\u0007J\u0014\u0010:\u001a\u00020;2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u0000H\u0007J\u0012\u0010=\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010\u0018\u001a\u00020\u0019J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010B\u001a\u00020CH\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020CH\u0017J\u0018\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0017J\u0018\u0010L\u001a\u0002012\b\b\u0001\u0010M\u001a\u00020\u00192\u0006\u0010N\u001a\u00020\rJ\u001a\u0010L\u001a\u0002012\b\b\u0001\u0010M\u001a\u00020\u00192\b\b\u0001\u0010O\u001a\u00020\u0019J\u0010\u0010P\u001a\u0002012\b\b\u0001\u0010M\u001a\u00020\u0019J\u000e\u0010Q\u001a\u0002012\u0006\u00102\u001a\u00020\u0006J\b\u0010R\u001a\u00020?H\u0017J\b\u0010S\u001a\u00020\u0006H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00068WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0017R(\u0010(\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R(\u0010-\u001a\u0004\u0018\u00010\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0017\"\u0004\b/\u0010\u0007\u00a8\u0006W"}, d2={"Landroidx/navigation/NavDestination;", "", "navigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "navigatorName", "", "(Ljava/lang/String;)V", "_arguments", "", "Landroidx/navigation/NavArgument;", "actions", "Landroidx/collection/SparseArrayCompat;", "Landroidx/navigation/NavAction;", "arguments", "", "getArguments", "()Ljava/util/Map;", "deepLinks", "", "Landroidx/navigation/NavDeepLink;", "displayName", "getDisplayName", "()Ljava/lang/String;", "id", "", "getId", "()I", "setId", "(I)V", "idName", "label", "", "getLabel", "()Ljava/lang/CharSequence;", "setLabel", "(Ljava/lang/CharSequence;)V", "getNavigatorName", "<set-?>", "Landroidx/navigation/NavGraph;", "parent", "getParent", "()Landroidx/navigation/NavGraph;", "setParent", "(Landroidx/navigation/NavGraph;)V", "route", "getRoute", "setRoute", "addArgument", "", "argumentName", "argument", "addDeepLink", "navDeepLink", "uriPattern", "addInDefaultArgs", "Landroid/os/Bundle;", "args", "buildDeepLinkIds", "", "previousDestination", "getAction", "hasDeepLink", "", "deepLink", "Landroid/net/Uri;", "deepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "matchDeepLink", "Landroidx/navigation/NavDestination$DeepLinkMatch;", "navDeepLinkRequest", "onInflate", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "putAction", "actionId", "action", "destId", "removeAction", "removeArgument", "supportsActions", "toString", "ClassType", "Companion", "DeepLinkMatch", "navigation-common_release"})
public class NavDestination {
    @Nullable
    private NavGraph parent;
    private String idName;
    @Nullable
    private CharSequence label;
    private final List<NavDeepLink> deepLinks;
    private final SparseArrayCompat<NavAction> actions;
    private Map<String, NavArgument> _arguments;
    private int id;
    @Nullable
    private String route;
    @NotNull
    private final String navigatorName;
    private static final Map<String, Class<?>> classes;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final NavGraph getParent() {
        return this.parent;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void setParent(@Nullable NavGraph navGraph) {
        this.parent = navGraph;
    }

    @Nullable
    public final CharSequence getLabel() {
        return this.label;
    }

    public final void setLabel(@Nullable CharSequence charSequence) {
        this.label = charSequence;
    }

    @NotNull
    public final Map<String, NavArgument> getArguments() {
        return MapsKt.toMap(this._arguments);
    }

    @CallSuper
    public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.Navigator);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.resources.obtain\u2026s, R.styleable.Navigator)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray array = $this$use$iv;
        boolean bl = false;
        this.setRoute(array.getString(R.styleable.Navigator_route));
        if (array.hasValue(R.styleable.Navigator_android_id)) {
            this.setId(array.getResourceId(R.styleable.Navigator_android_id, 0));
            this.idName = Companion.getDisplayName(context, this.id);
        }
        this.label = array.getText(R.styleable.Navigator_android_label);
        Unit unit = Unit.INSTANCE;
        boolean bl2 = false;
        boolean bl3 = false;
        Unit it$iv = unit;
        boolean bl4 = false;
        $this$use$iv.recycle();
    }

    @IdRes
    public final int getId() {
        return this.id;
    }

    public final void setId(int id) {
        this.id = id;
        this.idName = null;
    }

    @Nullable
    public final String getRoute() {
        return this.route;
    }

    public final void setRoute(@Nullable String route) {
        Object v0;
        Collection collection;
        boolean bl;
        block5: {
            if (route == null) {
                this.setId(0);
            } else {
                CharSequence charSequence = route;
                boolean bl2 = false;
                boolean bl3 = !StringsKt.isBlank((CharSequence)charSequence);
                bl2 = false;
                bl = false;
                if (!bl3) {
                    boolean bl4 = false;
                    String string = "Cannot have an empty route";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                String internalRoute = Companion.createRoute(route);
                this.setId(internalRoute.hashCode());
                this.addDeepLink(internalRoute);
            }
            collection = this.deepLinks;
            Iterable $this$firstOrNull$iv = this.deepLinks;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NavDeepLink it = (NavDeepLink)element$iv;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)it.getUriPattern(), (Object)Companion.createRoute(this.route))) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        Object var3_6 = v0;
        bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(var3_6);
        this.route = route;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public String getDisplayName() {
        String string = this.idName;
        if (string == null) {
            string = String.valueOf(this.id);
        }
        return string;
    }

    public boolean hasDeepLink(@NotNull Uri deepLink) {
        Intrinsics.checkNotNullParameter((Object)deepLink, (String)"deepLink");
        return this.hasDeepLink(new NavDeepLinkRequest(deepLink, null, null));
    }

    public boolean hasDeepLink(@NotNull NavDeepLinkRequest deepLinkRequest) {
        Intrinsics.checkNotNullParameter((Object)deepLinkRequest, (String)"deepLinkRequest");
        return this.matchDeepLink(deepLinkRequest) != null;
    }

    public final void addDeepLink(@NotNull String uriPattern) {
        Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
        this.addDeepLink(new NavDeepLink.Builder().setUriPattern(uriPattern).build());
    }

    public final void addDeepLink(@NotNull NavDeepLink navDeepLink) {
        Intrinsics.checkNotNullParameter((Object)navDeepLink, (String)"navDeepLink");
        this.deepLinks.add(navDeepLink);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public DeepLinkMatch matchDeepLink(@NotNull NavDeepLinkRequest navDeepLinkRequest) {
        Intrinsics.checkNotNullParameter((Object)navDeepLinkRequest, (String)"navDeepLinkRequest");
        if (this.deepLinks.isEmpty()) {
            return null;
        }
        DeepLinkMatch bestMatch = null;
        for (NavDeepLink deepLink : this.deepLinks) {
            int mimeTypeMatchLevel;
            Uri uri = navDeepLinkRequest.getUri();
            Bundle matchingArguments = uri != null ? deepLink.getMatchingArguments(uri, this.getArguments()) : null;
            String requestAction = navDeepLinkRequest.getAction();
            boolean matchingAction = requestAction != null && Intrinsics.areEqual((Object)requestAction, (Object)deepLink.getAction());
            String mimeType = navDeepLinkRequest.getMimeType();
            int n = mimeTypeMatchLevel = mimeType != null ? deepLink.getMimeTypeMatchRating(mimeType) : -1;
            if (matchingArguments == null && !matchingAction && mimeTypeMatchLevel <= -1) continue;
            DeepLinkMatch newMatch = new DeepLinkMatch(this, matchingArguments, deepLink.isExactDeepLink(), matchingAction, mimeTypeMatchLevel);
            if (bestMatch != null && newMatch.compareTo(bestMatch) <= 0) continue;
            bestMatch = newMatch;
        }
        return bestMatch;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final int[] buildDeepLinkIds(@Nullable NavDestination previousDestination) {
        void $this$mapTo$iv$iv;
        NavGraph parent;
        ArrayDeque hierarchy = new ArrayDeque();
        NavDestination current = this;
        do {
            NavDestination navDestination = current;
            Intrinsics.checkNotNull((Object)navDestination);
            parent = navDestination.parent;
            NavDestination navDestination2 = previousDestination;
            if ((navDestination2 != null ? navDestination2.parent : null) != null) {
                NavGraph navGraph = previousDestination.parent;
                Intrinsics.checkNotNull((Object)navGraph);
                if (navGraph.findNode(current.id) == current) {
                    hierarchy.addFirst((Object)current);
                    break;
                }
            }
            if (parent != null && parent.getStartDestinationId() == current.id) continue;
            hierarchy.addFirst((Object)current);
        } while ((current = (NavDestination)parent) != null);
        Iterable $this$map$iv = CollectionsKt.toList((Iterable)((Iterable)hierarchy));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NavDestination navDestination = (NavDestination)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.id;
            collection.add(n);
        }
        return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
    }

    public static /* synthetic */ int[] buildDeepLinkIds$default(NavDestination navDestination, NavDestination navDestination2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildDeepLinkIds");
        }
        if ((n & 1) != 0) {
            navDestination2 = null;
        }
        return navDestination.buildDeepLinkIds(navDestination2);
    }

    @JvmOverloads
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final int[] buildDeepLinkIds() {
        return NavDestination.buildDeepLinkIds$default(this, null, 1, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean supportsActions() {
        return true;
    }

    @Nullable
    public final NavAction getAction(@IdRes int id) {
        NavAction destination = this.actions.isEmpty() ? null : (NavAction)this.actions.get(id);
        NavAction navAction = destination;
        if (navAction == null) {
            NavGraph navGraph = this.parent;
            if (navGraph != null) {
                NavGraph navGraph2 = navGraph;
                boolean bl = false;
                boolean bl2 = false;
                NavGraph $this$run = navGraph2;
                boolean bl3 = false;
                navAction = $this$run.getAction(id);
            } else {
                navAction = null;
            }
        }
        return navAction;
    }

    public final void putAction(@IdRes int actionId, @IdRes int destId) {
        this.putAction(actionId, new NavAction(destId, null, null, 6, null));
    }

    public final void putAction(@IdRes int actionId, @NotNull NavAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (!this.supportsActions()) {
            throw (Throwable)new UnsupportedOperationException("Cannot add action " + actionId + " to " + this + " as it does not support actions, " + "indicating that it is a terminal destination in your navigation graph and " + "will never trigger actions.");
        }
        boolean bl = actionId != 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot have an action with actionId 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.actions.put(actionId, (Object)action);
    }

    public final void removeAction(@IdRes int actionId) {
        this.actions.remove(actionId);
    }

    public final void addArgument(@NotNull String argumentName, @NotNull NavArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        this._arguments.put(argumentName, argument);
    }

    public final void removeArgument(@NotNull String argumentName) {
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        this._arguments.remove(argumentName);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Bundle addInDefaultArgs(@Nullable Bundle args) {
        Object key;
        boolean bl;
        if (args == null) {
            Map<String, NavArgument> map = this._arguments;
            boolean bl2 = false;
            boolean bl3 = false;
            if (map == null || map.isEmpty()) {
                return null;
            }
        }
        Bundle defaultArgs = new Bundle();
        Object object = this._arguments;
        boolean bl4 = false;
        Iterator<Map.Entry<String, NavArgument>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, NavArgument> entry;
            Map.Entry<String, NavArgument> entry2 = entry = iterator2.next();
            bl = false;
            object = entry2.getKey();
            entry2 = entry;
            bl = false;
            NavArgument value = entry2.getValue();
            value.putDefaultValue((String)key, defaultArgs);
        }
        if (args != null) {
            defaultArgs.putAll(args);
            key = this._arguments;
            boolean value = false;
            iterator2 = key.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, NavArgument> entry;
                Map.Entry<String, NavArgument> entry3 = entry = iterator2.next();
                bl = false;
                key = entry3.getKey();
                entry3 = entry;
                bl = false;
                NavArgument value2 = entry3.getValue();
                boolean bl5 = value2.verify((String)key, defaultArgs);
                bl = false;
                boolean bl6 = false;
                if (bl5) continue;
                boolean bl7 = false;
                String string = "Wrong argument type for '" + (String)key + "' in argument bundle. " + value2.getType().getName() + ' ' + "expected.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        return defaultArgs;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        if (this.idName == null) {
            sb.append("0x");
            sb.append(Integer.toHexString(this.id));
        } else {
            sb.append(this.idName);
        }
        sb.append(")");
        CharSequence charSequence = this.route;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            sb.append(" route=");
            sb.append(this.route);
        }
        if (this.label != null) {
            sb.append(" label=");
            sb.append(this.label);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final String getNavigatorName() {
        return this.navigatorName;
    }

    public NavDestination(@NotNull String navigatorName) {
        Intrinsics.checkNotNullParameter((Object)navigatorName, (String)"navigatorName");
        this.navigatorName = navigatorName;
        boolean bl = false;
        this.deepLinks = new ArrayList();
        this.actions = new SparseArrayCompat();
        bl = false;
        this._arguments = new LinkedHashMap();
    }

    public NavDestination(@NotNull Navigator<? extends NavDestination> navigator) {
        Intrinsics.checkNotNullParameter(navigator, (String)"navigator");
        this(NavigatorProvider.Companion.getNameForNavigator$navigation_common_release(navigator.getClass()));
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        classes = new LinkedHashMap();
    }

    @JvmStatic
    @NotNull
    protected static final <C> Class<? extends C> parseClassFromName(@NotNull Context context, @NotNull String name, @NotNull Class<? extends C> expectedClassType) {
        return Companion.parseClassFromName(context, name, expectedClassType);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final <C> Class<? extends C> parseClassFromNameInternal(@NotNull Context context, @NotNull String name, @NotNull Class<? extends C> expectedClassType) {
        return Companion.parseClassFromNameInternal(context, name, expectedClassType);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final String getDisplayName(@NotNull Context context, int id) {
        return Companion.getDisplayName(context, id);
    }

    @Retention(value=AnnotationRetention.BINARY)
    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.ANNOTATION_CLASS, AnnotationTarget.CLASS})
    @java.lang.annotation.Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0002\u0018\u00002\u00020\u0001B\f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003R\u0013\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/navigation/NavDestination$ClassType;", "", "value", "Lkotlin/reflect/KClass;", "()Ljava/lang/Class;", "navigation-common_release"})
    public static @interface ClassType {
        public Class<?> value();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/navigation/NavDestination$DeepLinkMatch;", "", "destination", "Landroidx/navigation/NavDestination;", "matchingArgs", "Landroid/os/Bundle;", "isExactDeepLink", "", "hasMatchingAction", "mimeTypeMatchLevel", "", "(Landroidx/navigation/NavDestination;Landroid/os/Bundle;ZZI)V", "getDestination", "()Landroidx/navigation/NavDestination;", "getMatchingArgs", "()Landroid/os/Bundle;", "compareTo", "other", "navigation-common_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class DeepLinkMatch
    implements Comparable<DeepLinkMatch> {
        @NotNull
        private final NavDestination destination;
        @Nullable
        private final Bundle matchingArgs;
        private final boolean isExactDeepLink;
        private final boolean hasMatchingAction;
        private final int mimeTypeMatchLevel;

        @Override
        public int compareTo(@NotNull DeepLinkMatch other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this.isExactDeepLink && !other.isExactDeepLink) {
                return 1;
            }
            if (!this.isExactDeepLink && other.isExactDeepLink) {
                return -1;
            }
            if (this.matchingArgs != null && other.matchingArgs == null) {
                return 1;
            }
            if (this.matchingArgs == null && other.matchingArgs != null) {
                return -1;
            }
            if (this.matchingArgs != null) {
                int n = this.matchingArgs.size();
                Bundle bundle = other.matchingArgs;
                Intrinsics.checkNotNull((Object)bundle);
                int sizeDifference = n - bundle.size();
                if (sizeDifference > 0) {
                    return 1;
                }
                if (sizeDifference < 0) {
                    return -1;
                }
            }
            if (this.hasMatchingAction && !other.hasMatchingAction) {
                return 1;
            }
            if (!this.hasMatchingAction && other.hasMatchingAction) {
                return -1;
            }
            return this.mimeTypeMatchLevel - other.mimeTypeMatchLevel;
        }

        @NotNull
        public final NavDestination getDestination() {
            return this.destination;
        }

        @Nullable
        public final Bundle getMatchingArgs() {
            return this.matchingArgs;
        }

        public DeepLinkMatch(@NotNull NavDestination destination, @Nullable Bundle matchingArgs, boolean isExactDeepLink, boolean hasMatchingAction, int mimeTypeMatchLevel) {
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            this.destination = destination;
            this.matchingArgs = matchingArgs;
            this.isExactDeepLink = isExactDeepLink;
            this.hasMatchingAction = hasMatchingAction;
            this.mimeTypeMatchLevel = mimeTypeMatchLevel;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J:\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u000f0\u0006\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0010\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u000f0\u0006H\u0005J:\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u000f0\u0006\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0010\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u000f0\u0006H\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/navigation/NavDestination$Companion;", "", "()V", "classes", "", "", "Ljava/lang/Class;", "createRoute", "route", "getDisplayName", "context", "Landroid/content/Context;", "id", "", "parseClassFromName", "C", "name", "expectedClassType", "parseClassFromNameInternal", "navigation-common_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        protected final <C> Class<? extends C> parseClassFromName(@NotNull Context context, @NotNull String name, @NotNull Class<? extends C> expectedClassType) {
            Class<?> clazz;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(expectedClassType, (String)"expectedClassType");
            String innerName = name;
            if (innerName.charAt(0) == '.') {
                innerName = context.getPackageName() + innerName;
            }
            if ((clazz = (Class<?>)classes.get(innerName)) == null) {
                try {
                    clazz = Class.forName(innerName, true, context.getClassLoader());
                    Map map = classes;
                    Class<?> clazz2 = clazz;
                    Intrinsics.checkNotNullExpressionValue(clazz2, (String)"clazz");
                    map.put(name, clazz2);
                }
                catch (ClassNotFoundException e) {
                    throw (Throwable)new IllegalArgumentException(e);
                }
            }
            boolean bl = expectedClassType.isAssignableFrom(clazz);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = innerName + " must be a subclass of " + expectedClassType;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return clazz;
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final <C> Class<? extends C> parseClassFromNameInternal(@NotNull Context context, @NotNull String name, @NotNull Class<? extends C> expectedClassType) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(expectedClassType, (String)"expectedClassType");
            return this.parseClassFromName(context, name, expectedClassType);
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final String getDisplayName(@NotNull Context context, int id) {
            String string;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (id <= 0xFFFFFF) {
                string = String.valueOf(id);
            } else {
                String string2;
                try {
                    string2 = context.getResources().getResourceName(id);
                }
                catch (Resources.NotFoundException e) {
                    string2 = String.valueOf(id);
                }
                String string3 = string2;
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"try {\n                co\u2026.toString()\n            }");
            }
            return string;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final String createRoute(@Nullable String route) {
            return route != null ? "android-app://androidx.navigation/" + route : "";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

