/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="navigation")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0002H\u0016J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J*\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/navigation/NavGraphNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/NavGraph;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "(Landroidx/navigation/NavigatorProvider;)V", "createDestination", "navigate", "", "entry", "Landroidx/navigation/NavBackStackEntry;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "entries", "", "navigation-common_release"})
public class NavGraphNavigator
extends Navigator<NavGraph> {
    private final NavigatorProvider navigatorProvider;

    @Override
    @NotNull
    public NavGraph createDestination() {
        return new NavGraph(this);
    }

    @Override
    public void navigate(@NotNull List<NavBackStackEntry> entries, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        for (NavBackStackEntry entry : entries) {
            this.navigate(entry, navOptions, navigatorExtras);
        }
    }

    private final void navigate(NavBackStackEntry entry, NavOptions navOptions, Navigator.Extras navigatorExtras) {
        NavDestination navDestination = entry.getDestination();
        if (navDestination == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavGraph");
        }
        NavGraph destination = (NavGraph)navDestination;
        Bundle args = entry.getArguments();
        int startId = destination.getStartDestinationId();
        String startRoute = destination.getStartDestinationRoute();
        boolean bl = startId != 0 || startRoute != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "no start destination defined via app:startDestination for " + destination.getDisplayName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        NavDestination startDestination = startRoute != null ? destination.findNode(startRoute, false) : destination.findNode(startId, false);
        bl2 = false;
        bl3 = false;
        if (startDestination == null) {
            boolean bl5 = false;
            String dest = destination.getStartDestDisplayName();
            throw (Throwable)new IllegalArgumentException("navigation destination " + dest + " is not a direct child of this NavGraph");
        }
        Object navigator = this.navigatorProvider.getNavigator(startDestination.getNavigatorName());
        NavBackStackEntry startDestinationEntry = this.getState().createBackStackEntry(startDestination, startDestination.addInDefaultArgs(args));
        ((Navigator)navigator).navigate(CollectionsKt.listOf((Object)startDestinationEntry), navOptions, navigatorExtras);
    }

    public NavGraphNavigator(@NotNull NavigatorProvider navigatorProvider) {
        Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
        this.navigatorProvider = navigatorProvider;
    }
}

