/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.AnyRes;
import androidx.annotation.RestrictTo;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0006\u0019\u001a\u001b\u001c\u001d\u001eB\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u00a6\u0002\u00a2\u0006\u0002\u0010\u000fJ%\u0010\u0010\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\u0014J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Landroidx/navigation/NavType;", "T", "", "isNullableAllowed", "", "(Z)V", "()Z", "name", "", "getName", "()Ljava/lang/String;", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)Ljava/lang/Object;", "parseAndPut", "value", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "parseValue", "(Ljava/lang/String;)Ljava/lang/Object;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/lang/Object;)V", "toString", "Companion", "EnumType", "ParcelableArrayType", "ParcelableType", "SerializableArrayType", "SerializableType", "navigation-common_release"})
public abstract class NavType<T> {
    private final boolean isNullableAllowed;
    @JvmField
    @NotNull
    public static final NavType<Integer> IntType;
    @JvmField
    @NotNull
    public static final NavType<Integer> ReferenceType;
    @JvmField
    @NotNull
    public static final NavType<int[]> IntArrayType;
    @JvmField
    @NotNull
    public static final NavType<Long> LongType;
    @JvmField
    @NotNull
    public static final NavType<long[]> LongArrayType;
    @JvmField
    @NotNull
    public static final NavType<Float> FloatType;
    @JvmField
    @NotNull
    public static final NavType<float[]> FloatArrayType;
    @JvmField
    @NotNull
    public static final NavType<Boolean> BoolType;
    @JvmField
    @NotNull
    public static final NavType<boolean[]> BoolArrayType;
    @JvmField
    @NotNull
    public static final NavType<String> StringType;
    @JvmField
    @NotNull
    public static final NavType<String[]> StringArrayType;
    @NotNull
    public static final Companion Companion;

    public abstract void put(@NotNull Bundle var1, @NotNull String var2, T var3);

    @Nullable
    public abstract T get(@NotNull Bundle var1, @NotNull String var2);

    public abstract T parseValue(@NotNull String var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final T parseAndPut(@NotNull Bundle bundle, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        T parsedValue = this.parseValue(value);
        this.put(bundle, key, parsedValue);
        return parsedValue;
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public String toString() {
        return this.getName();
    }

    public boolean isNullableAllowed() {
        return this.isNullableAllowed;
    }

    public NavType(boolean isNullableAllowed) {
        this.isNullableAllowed = isNullableAllowed;
    }

    static {
        Companion = new Companion(null);
        IntType = new NavType<Integer>(false){

            @NotNull
            public String getName() {
                return "integer";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, int value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                bundle.putInt(key, value);
            }

            @NotNull
            public Integer get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Object object = bundle.get(key);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                return (Integer)object;
            }

            @NotNull
            public Integer parseValue(@NotNull String value) {
                int n;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (StringsKt.startsWith$default((String)value, (String)"0x", (boolean)false, (int)2, null)) {
                    String string = value;
                    int n2 = 2;
                    boolean bl = false;
                    String string2 = string.substring(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    string = string2;
                    n2 = 16;
                    bl = false;
                    n = Integer.parseInt(string, CharsKt.checkRadix((int)n2));
                } else {
                    String string = value;
                    boolean bl = false;
                    n = Integer.parseInt(string);
                }
                return n;
            }
        };
        ReferenceType = new NavType<Integer>(false){

            @NotNull
            public String getName() {
                return "reference";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, @AnyRes int value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                bundle.putInt(key, value);
            }

            @AnyRes
            @NotNull
            public Integer get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Object object = bundle.get(key);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                return (Integer)object;
            }

            @NotNull
            public Integer parseValue(@NotNull String value) {
                int n;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (StringsKt.startsWith$default((String)value, (String)"0x", (boolean)false, (int)2, null)) {
                    String string = value;
                    int n2 = 2;
                    boolean bl = false;
                    String string2 = string.substring(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    string = string2;
                    n2 = 16;
                    bl = false;
                    n = Integer.parseInt(string, CharsKt.checkRadix((int)n2));
                } else {
                    String string = value;
                    boolean bl = false;
                    n = Integer.parseInt(string);
                }
                return n;
            }
        };
        IntArrayType = new NavType<int[]>(true){

            @NotNull
            public String getName() {
                return "integer[]";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable int[] value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                bundle.putIntArray(key, value);
            }

            @Nullable
            public int[] get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (int[])bundle.get(key);
            }

            @NotNull
            public int[] parseValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                throw (Throwable)new UnsupportedOperationException("Arrays don't support default values.");
            }
        };
        LongType = new NavType<Long>(false){

            @NotNull
            public String getName() {
                return "long";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, long value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                bundle.putLong(key, value);
            }

            @NotNull
            public Long get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Object object = bundle.get(key);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                return (Long)object;
            }

            @NotNull
            public Long parseValue(@NotNull String value) {
                long l;
                int n;
                int n2;
                String string;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String localValue = value;
                if (StringsKt.endsWith$default((String)value, (String)"L", (boolean)false, (int)2, null)) {
                    string = localValue;
                    n2 = 0;
                    n = value.length() - 1;
                    boolean bl = false;
                    String string2 = string.substring(n2, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    localValue = string2;
                }
                if (StringsKt.startsWith$default((String)value, (String)"0x", (boolean)false, (int)2, null)) {
                    string = localValue;
                    n2 = 2;
                    n = 0;
                    String string3 = string;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    string = string4;
                    n2 = 16;
                    n = 0;
                    l = Long.parseLong(string, CharsKt.checkRadix((int)n2));
                } else {
                    string = localValue;
                    n2 = 0;
                    l = Long.parseLong(string);
                }
                return l;
            }
        };
        LongArrayType = new NavType<long[]>(true){

            @NotNull
            public String getName() {
                return "long[]";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable long[] value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                bundle.putLongArray(key, value);
            }

            @Nullable
            public long[] get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (long[])bundle.get(key);
            }

            @NotNull
            public long[] parseValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                throw (Throwable)new UnsupportedOperationException("Arrays don't support default values.");
            }
        };
        FloatType = new NavType<Float>(false){

            @NotNull
            public String getName() {
                return "float";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, float value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                bundle.putFloat(key, value);
            }

            @NotNull
            public Float get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Object object = bundle.get(key);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                return (Float)object;
            }

            @NotNull
            public Float parseValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = value;
                boolean bl = false;
                return Float.valueOf(Float.parseFloat(string));
            }
        };
        FloatArrayType = new NavType<float[]>(true){

            @NotNull
            public String getName() {
                return "float[]";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable float[] value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                bundle.putFloatArray(key, value);
            }

            @Nullable
            public float[] get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (float[])bundle.get(key);
            }

            @NotNull
            public float[] parseValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                throw (Throwable)new UnsupportedOperationException("Arrays don't support default values.");
            }
        };
        BoolType = new NavType<Boolean>(false){

            @NotNull
            public String getName() {
                return "boolean";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, boolean value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                bundle.putBoolean(key, value);
            }

            @Nullable
            public Boolean get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (Boolean)bundle.get(key);
            }

            @NotNull
            public Boolean parseValue(@NotNull String value) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                switch (value) {
                    case "true": {
                        bl = true;
                        break;
                    }
                    case "false": {
                        bl = false;
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalArgumentException("A boolean NavType only accepts \"true\" or \"false\" values.");
                    }
                }
                return bl;
            }
        };
        BoolArrayType = new NavType<boolean[]>(true){

            @NotNull
            public String getName() {
                return "boolean[]";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable boolean[] value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                bundle.putBooleanArray(key, value);
            }

            @Nullable
            public boolean[] get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (boolean[])bundle.get(key);
            }

            @NotNull
            public boolean[] parseValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                throw (Throwable)new UnsupportedOperationException("Arrays don't support default values.");
            }
        };
        StringType = new NavType<String>(true){

            @NotNull
            public String getName() {
                return "string";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable String value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                bundle.putString(key, value);
            }

            @Nullable
            public String get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (String)bundle.get(key);
            }

            @NotNull
            public String parseValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value;
            }
        };
        StringArrayType = new NavType<String[]>(true){

            @NotNull
            public String getName() {
                return "string[]";
            }

            public void put(@NotNull Bundle bundle, @NotNull String key, @NotNull String[] value) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                bundle.putStringArray(key, value);
            }

            @NotNull
            public String[] get(@NotNull Bundle bundle, @NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Object object = bundle.get(key);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                }
                return (String[])object;
            }

            @NotNull
            public String[] parseValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                throw (Throwable)new UnsupportedOperationException("Arrays don't support default values.");
            }
        };
    }

    @JvmStatic
    @NotNull
    public static NavType<?> fromArgType(@Nullable String type, @Nullable String packageName) {
        return Companion.fromArgType(type, packageName);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final NavType<Object> inferFromValue(@NotNull String value) {
        return Companion.inferFromValue(value);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final NavType<Object> inferFromValueType(@Nullable Object value) {
        return Companion.inferFromValueType(value);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J \u0010\u000e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0015\u0010\u0015\u001a\u00028\u00012\u0006\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0017J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/navigation/NavType$ParcelableType;", "D", "Landroidx/navigation/NavType;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "name", "", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)Ljava/lang/Object;", "hashCode", "", "parseValue", "value", "(Ljava/lang/String;)Ljava/lang/Object;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/lang/Object;)V", "navigation-common_release"})
    public static final class ParcelableType<D>
    extends NavType<D> {
        private final Class<D> type;

        @Override
        @NotNull
        public String getName() {
            String string = this.type.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name");
            return string;
        }

        @Override
        public void put(@NotNull Bundle bundle, @NotNull String key, D value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.type.cast(value);
            if (value == null || value instanceof Parcelable) {
                bundle.putParcelable(key, (Parcelable)value);
            } else if (value instanceof Serializable) {
                bundle.putSerializable(key, (Serializable)value);
            }
        }

        @Override
        @Nullable
        public D get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (D)bundle.get(key);
        }

        @Override
        public D parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw (Throwable)new UnsupportedOperationException("Parcelables don't support default values.");
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
                return false;
            }
            ParcelableType that = (ParcelableType)other;
            return Intrinsics.areEqual(this.type, that.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public ParcelableType(@NotNull Class<D> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(true);
            boolean bl = Parcelable.class.isAssignableFrom(type) || Serializable.class.isAssignableFrom(type);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = type + " does not implement Parcelable or Serializable.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.type = type;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J&\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u001dR\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Landroidx/navigation/NavType$ParcelableArrayType;", "D", "Landroid/os/Parcelable;", "Landroidx/navigation/NavType;", "", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "arrayType", "name", "", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)[Landroid/os/Parcelable;", "hashCode", "", "parseValue", "value", "(Ljava/lang/String;)[Landroid/os/Parcelable;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;[Landroid/os/Parcelable;)V", "navigation-common_release"})
    public static final class ParcelableArrayType<D extends Parcelable>
    extends NavType<D[]> {
        private final Class<D[]> arrayType;

        @Override
        @NotNull
        public String getName() {
            String string = this.arrayType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arrayType.name");
            return string;
        }

        @Override
        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable D[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.arrayType.cast(value);
            bundle.putParcelableArray(key, value);
        }

        @Override
        @Nullable
        public D[] get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (Parcelable[])bundle.get(key);
        }

        @Override
        @NotNull
        public D[] parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw (Throwable)new UnsupportedOperationException("Arrays don't support default values.");
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
                return false;
            }
            ParcelableArrayType that = (ParcelableArrayType)other;
            return Intrinsics.areEqual(this.arrayType, that.arrayType);
        }

        public int hashCode() {
            return this.arrayType.hashCode();
        }

        public ParcelableArrayType(@NotNull Class<D> type) {
            Class<?> clazz;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(true);
            boolean bl = Parcelable.class.isAssignableFrom(type);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = type + " does not implement Parcelable.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            try {
                Class<?> clazz2 = Class.forName("[L" + type.getName() + ';');
                if (clazz2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<kotlin.Array<D>>");
                }
                clazz = clazz2;
            }
            catch (ClassNotFoundException e) {
                throw (Throwable)new RuntimeException(e);
            }
            Class<?> arrayType = clazz;
            this.arrayType = arrayType;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J \u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0015\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0019\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/navigation/NavType$SerializableType;", "D", "Ljava/io/Serializable;", "Landroidx/navigation/NavType;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "nullableAllowed", "", "(ZLjava/lang/Class;)V", "name", "", "getName", "()Ljava/lang/String;", "equals", "other", "", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)Ljava/io/Serializable;", "hashCode", "", "parseValue", "value", "(Ljava/lang/String;)Ljava/io/Serializable;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/io/Serializable;)V", "navigation-common_release"})
    public static class SerializableType<D extends Serializable>
    extends NavType<D> {
        private final Class<D> type;

        @Override
        @NotNull
        public String getName() {
            String string = this.type.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name");
            return string;
        }

        @Override
        public void put(@NotNull Bundle bundle, @NotNull String key, @NotNull D value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.type.cast(value);
            bundle.putSerializable(key, value);
        }

        @Override
        @Nullable
        public D get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (D)((Serializable)bundle.get(key));
        }

        @Override
        @NotNull
        public D parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw (Throwable)new UnsupportedOperationException("Serializables don't support default values.");
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializableType)) {
                return false;
            }
            return Intrinsics.areEqual(this.type, ((SerializableType)other).type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public SerializableType(@NotNull Class<D> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(true);
            boolean bl = Serializable.class.isAssignableFrom(type);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = type + " does not implement Serializable.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = !type.isEnum();
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = type + " is an Enum. You should use EnumType instead.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.type = type;
        }

        public SerializableType(boolean nullableAllowed, @NotNull Class<D> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(nullableAllowed);
            boolean bl = Serializable.class.isAssignableFrom(type);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = type + " does not implement Serializable.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.type = type;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000*\f\b\u0001\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u00028\u00012\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/navigation/NavType$EnumType;", "D", "", "Landroidx/navigation/NavType$SerializableType;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "name", "", "getName", "()Ljava/lang/String;", "parseValue", "value", "(Ljava/lang/String;)Ljava/lang/Enum;", "navigation-common_release"})
    public static final class EnumType<D extends Enum<?>>
    extends SerializableType<D> {
        private final Class<D> type;

        @Override
        @NotNull
        public String getName() {
            String string = this.type.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name");
            return string;
        }

        @Override
        @NotNull
        public D parseValue(@NotNull String value) {
            Object v1;
            block2: {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                D[] DArray = this.type.getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(DArray, (String)"type.enumConstants");
                D[] $this$firstOrNull$iv = DArray;
                boolean $i$f$firstOrNull = false;
                for (D element$iv : $this$firstOrNull$iv) {
                    Enum constant = (Enum)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)constant.name(), (String)value, (boolean)true)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            Enum enum_ = v1;
            if (enum_ == null) {
                throw (Throwable)new IllegalArgumentException("Enum value " + value + " not found for type " + this.type.getName() + '.');
            }
            return (D)enum_;
        }

        public EnumType(@NotNull Class<D> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(false, type);
            boolean bl = type.isEnum();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = type + " is not an Enum type.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.type = type;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J&\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u001dR\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Landroidx/navigation/NavType$SerializableArrayType;", "D", "Ljava/io/Serializable;", "Landroidx/navigation/NavType;", "", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "arrayType", "name", "", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)[Ljava/io/Serializable;", "hashCode", "", "parseValue", "value", "(Ljava/lang/String;)[Ljava/io/Serializable;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;[Ljava/io/Serializable;)V", "navigation-common_release"})
    public static final class SerializableArrayType<D extends Serializable>
    extends NavType<D[]> {
        private final Class<D[]> arrayType;

        @Override
        @NotNull
        public String getName() {
            String string = this.arrayType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arrayType.name");
            return string;
        }

        @Override
        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable D[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.arrayType.cast(value);
            bundle.putSerializable(key, (Serializable)value);
        }

        @Override
        @Nullable
        public D[] get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (Serializable[])bundle.get(key);
        }

        @Override
        @NotNull
        public D[] parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw (Throwable)new UnsupportedOperationException("Arrays don't support default values.");
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
                return false;
            }
            SerializableArrayType that = (SerializableArrayType)other;
            return Intrinsics.areEqual(this.arrayType, that.arrayType);
        }

        public int hashCode() {
            return this.arrayType.hashCode();
        }

        public SerializableArrayType(@NotNull Class<D> type) {
            Class<?> clazz;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(true);
            boolean bl = Serializable.class.isAssignableFrom(type);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = type + " does not implement Serializable.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            try {
                Class<?> clazz2 = Class.forName("[L" + type.getName() + ';');
                if (clazz2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<kotlin.Array<D>>");
                }
                clazz = clazz2;
            }
            catch (ClassNotFoundException e) {
                throw (Throwable)new RuntimeException(e);
            }
            Class<?> arrayType = clazz;
            this.arrayType = arrayType;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017H\u0017J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u0017H\u0007J\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0007R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/navigation/NavType$Companion;", "", "()V", "BoolArrayType", "Landroidx/navigation/NavType;", "", "BoolType", "", "FloatArrayType", "", "FloatType", "", "IntArrayType", "", "IntType", "", "LongArrayType", "", "LongType", "", "ReferenceType", "StringArrayType", "", "", "StringType", "fromArgType", "type", "packageName", "inferFromValue", "value", "inferFromValueType", "navigation-common_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public NavType<?> fromArgType(@Nullable String type, @Nullable String packageName) {
            if (Intrinsics.areEqual((Object)IntType.getName(), (Object)type)) {
                return IntType;
            }
            if (Intrinsics.areEqual((Object)IntArrayType.getName(), (Object)type)) {
                return IntArrayType;
            }
            if (Intrinsics.areEqual((Object)LongType.getName(), (Object)type)) {
                return LongType;
            }
            if (Intrinsics.areEqual((Object)LongArrayType.getName(), (Object)type)) {
                return LongArrayType;
            }
            if (Intrinsics.areEqual((Object)BoolType.getName(), (Object)type)) {
                return BoolType;
            }
            if (Intrinsics.areEqual((Object)BoolArrayType.getName(), (Object)type)) {
                return BoolArrayType;
            }
            if (Intrinsics.areEqual((Object)StringType.getName(), (Object)type)) {
                return StringType;
            }
            if (Intrinsics.areEqual((Object)StringArrayType.getName(), (Object)type)) {
                return StringArrayType;
            }
            if (Intrinsics.areEqual((Object)FloatType.getName(), (Object)type)) {
                return FloatType;
            }
            if (Intrinsics.areEqual((Object)FloatArrayType.getName(), (Object)type)) {
                return FloatArrayType;
            }
            if (Intrinsics.areEqual((Object)ReferenceType.getName(), (Object)type)) {
                return ReferenceType;
            }
            CharSequence charSequence = type;
            boolean bl = false;
            int n = 0;
            if (!(charSequence == null || charSequence.length() == 0)) {
                try {
                    String className = null;
                    String string = className = StringsKt.startsWith$default((String)type, (String)".", (boolean)false, (int)2, null) && packageName != null ? packageName + type : type;
                    if (StringsKt.endsWith$default((String)type, (String)"[]", (boolean)false, (int)2, null)) {
                        String string2 = className;
                        n = 0;
                        int n2 = className.length() - 2;
                        boolean bl2 = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring(n, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        className = string4;
                        Class<?> clazz = Class.forName(className);
                        if (Parcelable.class.isAssignableFrom(clazz)) {
                            Class<?> clazz2 = clazz;
                            if (clazz2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<android.os.Parcelable>");
                            }
                            return new ParcelableArrayType(clazz2);
                        }
                        if (Serializable.class.isAssignableFrom(clazz)) {
                            Class<?> clazz3 = clazz;
                            if (clazz3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<java.io.Serializable>");
                            }
                            return new SerializableArrayType(clazz3);
                        }
                    } else {
                        Class<?> clazz = Class.forName(className);
                        if (Parcelable.class.isAssignableFrom(clazz)) {
                            Class<?> clazz4 = clazz;
                            if (clazz4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<kotlin.Any?>");
                            }
                            return new ParcelableType(clazz4);
                        }
                        if (Enum.class.isAssignableFrom(clazz)) {
                            Class<?> clazz5 = clazz;
                            if (clazz5 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<kotlin.Enum<*>>");
                            }
                            return new EnumType(clazz5);
                        }
                        if (Serializable.class.isAssignableFrom(clazz)) {
                            Class<?> clazz6 = clazz;
                            if (clazz6 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<java.io.Serializable>");
                            }
                            return new SerializableType(clazz6);
                        }
                    }
                    throw (Throwable)new IllegalArgumentException(className + " is not Serializable or Parcelable.");
                }
                catch (ClassNotFoundException e) {
                    throw (Throwable)new RuntimeException(e);
                }
            }
            return StringType;
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final NavType<Object> inferFromValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                IntType.parseValue(value);
                NavType<Object> navType = IntType;
                if (navType == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                }
                return navType;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    LongType.parseValue(value);
                    NavType<Object> navType = LongType;
                    if (navType == null) {
                        throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                    }
                    return navType;
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        FloatType.parseValue(value);
                        NavType<Object> navType = FloatType;
                        if (navType == null) {
                            throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                        }
                        return navType;
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        try {
                            BoolType.parseValue(value);
                            NavType<Object> navType = BoolType;
                            if (navType == null) {
                                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                            }
                            return navType;
                        }
                        catch (IllegalArgumentException illegalArgumentException4) {
                            NavType<Object> navType = StringType;
                            if (navType == null) {
                                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                            }
                            return navType;
                        }
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final NavType<Object> inferFromValueType(@Nullable Object value) {
            NavType navType;
            if (value instanceof Integer) {
                NavType navType2 = IntType;
                navType = navType2;
                if (navType2 != null) return navType;
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
            }
            if (value instanceof int[]) {
                NavType<int[]> navType3 = IntArrayType;
                navType = navType3;
                if (navType3 != null) return navType;
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
            }
            if (value instanceof Long) {
                NavType<Long> navType4 = LongType;
                navType = navType4;
                if (navType4 != null) return navType;
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
            }
            if (value instanceof long[]) {
                NavType<long[]> navType5 = LongArrayType;
                navType = navType5;
                if (navType5 != null) return navType;
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
            }
            if (value instanceof Float) {
                NavType<Float> navType6 = FloatType;
                navType = navType6;
                if (navType6 != null) return navType;
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
            }
            if (value instanceof float[]) {
                NavType<float[]> navType7 = FloatArrayType;
                navType = navType7;
                if (navType7 != null) return navType;
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
            }
            if (value instanceof Boolean) {
                NavType<Boolean> navType8 = BoolType;
                navType = navType8;
                if (navType8 != null) return navType;
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
            }
            if (value instanceof boolean[]) {
                NavType<boolean[]> navType9 = BoolArrayType;
                navType = navType9;
                if (navType9 != null) return navType;
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
            }
            if (value instanceof String || value == null) {
                NavType<String> navType10 = StringType;
                navType = navType10;
                if (navType10 != null) return navType;
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
            }
            if (value instanceof Object[] && (Object[])value instanceof String[]) {
                NavType<String[]> navType11 = StringArrayType;
                navType = navType11;
                if (navType11 != null) return navType;
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
            }
            if (value.getClass().isArray()) {
                Class<?> clazz = value.getClass().getComponentType();
                Intrinsics.checkNotNull(clazz);
                if (Parcelable.class.isAssignableFrom(clazz)) {
                    Class<?> clazz2 = value.getClass().getComponentType();
                    if (clazz2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<android.os.Parcelable>");
                    }
                    navType = new ParcelableArrayType(clazz2);
                    return navType;
                }
            }
            if (value.getClass().isArray()) {
                Class<?> clazz = value.getClass().getComponentType();
                Intrinsics.checkNotNull(clazz);
                if (Serializable.class.isAssignableFrom(clazz)) {
                    Class<?> clazz3 = value.getClass().getComponentType();
                    if (clazz3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<java.io.Serializable>");
                    }
                    navType = new SerializableArrayType(clazz3);
                    return navType;
                }
            }
            if (value instanceof Parcelable) {
                navType = new ParcelableType(((Parcelable)value).getClass());
                return navType;
            }
            if (value instanceof Enum) {
                navType = new EnumType(((Enum)value).getClass());
                return navType;
            }
            if (!(value instanceof Serializable)) throw (Throwable)new IllegalArgumentException("Object of type " + value.getClass().getName() + " is not supported for navigation " + "arguments.");
            navType = new SerializableType(((Serializable)value).getClass());
            return navType;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

