/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 62\u00020\u0001:\u00045678B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\b\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ$\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\u0006\u0010 \u001a\u00020\u0016H\u0002J(\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010&0%H\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\u0003H\u0007J\u0012\u0010)\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010*\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010+\u001a\u00020\u000e2\b\u0010\u0002\u001a\u0004\u0018\u00010$H\u0002J\u0015\u0010,\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020$H\u0000\u00a2\u0006\u0002\b-J\u0015\u0010,\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b-J*\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\b\u00104\u001a\u0004\u0018\u00010&H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\n\u00a8\u00069"}, d2={"Landroidx/navigation/NavDeepLink;", "", "uri", "", "(Ljava/lang/String;)V", "uriPattern", "action", "mimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "arguments", "", "<set-?>", "", "isExactDeepLink", "()Z", "setExactDeepLink$navigation_common_release", "(Z)V", "isParameterizedQuery", "getMimeType", "mimeTypePattern", "Ljava/util/regex/Pattern;", "paramArgMap", "", "Landroidx/navigation/NavDeepLink$ParamQuery;", "pattern", "getUriPattern", "buildPathRegex", "uriRegex", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "fillInPattern", "getMatchingArguments", "Landroid/os/Bundle;", "deepLink", "Landroid/net/Uri;", "", "Landroidx/navigation/NavArgument;", "getMimeTypeMatchRating", "", "matchAction", "matchMimeType", "matchUri", "matches", "matches$navigation_common_release", "deepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "parseArgument", "bundle", "name", "value", "argument", "Builder", "Companion", "MimeType", "ParamQuery", "navigation-common_release"})
public final class NavDeepLink {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String uriPattern;
    @Nullable
    private final String action;
    @Nullable
    private final String mimeType;
    @NotNull
    private final List<String> arguments;
    @NotNull
    private final Map<String, ParamQuery> paramArgMap;
    @Nullable
    private Pattern pattern;
    private boolean isParameterizedQuery;
    @Nullable
    private Pattern mimeTypePattern;
    private boolean isExactDeepLink;
    @Deprecated
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^[a-zA-Z]+[+\\w\\-.]*:");

    public NavDeepLink(@Nullable String uriPattern, @Nullable String action, @Nullable String mimeType) {
        this.uriPattern = uriPattern;
        this.action = action;
        this.mimeType = mimeType;
        boolean bl = false;
        this.arguments = new ArrayList();
        bl = false;
        this.paramArgMap = new LinkedHashMap();
        if (this.uriPattern != null) {
            Object object;
            Uri parameterizedUri = Uri.parse((String)this.uriPattern);
            this.isParameterizedQuery = parameterizedUri.getQuery() != null;
            StringBuilder uriRegex = new StringBuilder("^");
            if (!SCHEME_PATTERN.matcher(this.uriPattern).find()) {
                uriRegex.append("http[s]?://");
            }
            Pattern fillInPattern = Pattern.compile("\\{(.+?)\\}");
            if (this.isParameterizedQuery) {
                Matcher matcher = Pattern.compile("(\\?)").matcher(this.uriPattern);
                if (matcher.find()) {
                    object = this.uriPattern;
                    int n = 0;
                    int n2 = matcher.start();
                    boolean bl2 = false;
                    Object object2 = object;
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string = ((String)object2).substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Intrinsics.checkNotNullExpressionValue((Object)fillInPattern, (String)"fillInPattern");
                    this.buildPathRegex(string, uriRegex, fillInPattern);
                }
                this.isExactDeepLink = false;
                for (String paramName : parameterizedUri.getQueryParameterNames()) {
                    boolean bl3;
                    int n;
                    Object object3;
                    StringBuilder argRegex = new StringBuilder();
                    String string = parameterizedUri.getQueryParameter(paramName);
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    String queryParam = string;
                    matcher = fillInPattern.matcher(queryParam);
                    int appendPos = 0;
                    ParamQuery param = new ParamQuery();
                    while (matcher.find()) {
                        object3 = matcher.group(1);
                        if (object3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        param.addArgumentName((String)object3);
                        object3 = queryParam;
                        n = matcher.start();
                        bl3 = false;
                        String string2 = ((String)object3).substring(appendPos, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        argRegex.append(Pattern.quote(string2));
                        argRegex.append("(.+?)?");
                        appendPos = matcher.end();
                    }
                    if (appendPos < queryParam.length()) {
                        object3 = queryParam;
                        n = 0;
                        String string3 = ((String)object3).substring(appendPos);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        argRegex.append(Pattern.quote(string3));
                    }
                    object3 = argRegex.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"argRegex.toString()");
                    param.setParamRegex(StringsKt.replace$default((String)object3, (String)".*", (String)"\\E.*\\Q", (boolean)false, (int)4, null));
                    object3 = this.paramArgMap;
                    Intrinsics.checkNotNullExpressionValue((Object)paramName, (String)"paramName");
                    String string4 = paramName;
                    bl3 = false;
                    object3.put(string4, param);
                }
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)fillInPattern, (String)"fillInPattern");
                this.isExactDeepLink = this.buildPathRegex(this.uriPattern, uriRegex, fillInPattern);
            }
            object = uriRegex.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uriRegex.toString()");
            String finalRegex = StringsKt.replace$default((String)object, (String)".*", (String)"\\E.*\\Q", (boolean)false, (int)4, null);
            this.pattern = Pattern.compile(finalRegex, 2);
        }
        if (this.mimeType != null) {
            Pattern mimeTypePattern = Pattern.compile("^[\\s\\S]+/[\\s\\S]+$");
            Matcher mimeTypeMatcher = mimeTypePattern.matcher(this.mimeType);
            boolean fillInPattern = mimeTypeMatcher.matches();
            boolean finalRegex = false;
            boolean bl4 = false;
            if (!fillInPattern) {
                boolean bl5 = false;
                String string = "The given mimeType " + this.getMimeType() + " does not match to required \"type/subtype\" format";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            MimeType splitMimeType = new MimeType(this.mimeType);
            String mimeTypeRegex = "^(" + splitMimeType.getType() + "|[*]+)/(" + splitMimeType.getSubType() + "|[*]+)$";
            String finalRegex2 = StringsKt.replace$default((String)mimeTypeRegex, (String)"*|[*]", (String)"[\\s\\S]", (boolean)false, (int)4, null);
            this.mimeTypePattern = Pattern.compile(finalRegex2);
        }
    }

    @Nullable
    public final String getUriPattern() {
        return this.uriPattern;
    }

    @Nullable
    public final String getAction() {
        return this.action;
    }

    @Nullable
    public final String getMimeType() {
        return this.mimeType;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isExactDeepLink() {
        return this.isExactDeepLink;
    }

    public final void setExactDeepLink$navigation_common_release(boolean bl) {
        this.isExactDeepLink = bl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public NavDeepLink(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(uri, null, null);
    }

    private final boolean buildPathRegex(String uri, StringBuilder uriRegex, Pattern fillInPattern) {
        boolean exactDeepLink;
        Matcher matcher = fillInPattern.matcher(uri);
        int appendPos = 0;
        boolean bl = exactDeepLink = !StringsKt.contains$default((CharSequence)uri, (CharSequence)".*", (boolean)false, (int)2, null);
        while (matcher.find()) {
            String string = matcher.group(1);
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String argName = string;
            this.arguments.add(argName);
            string = uri;
            int n = matcher.start();
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(appendPos, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            uriRegex.append(Pattern.quote(string3));
            uriRegex.append("([^/]+?)");
            appendPos = matcher.end();
            exactDeepLink = false;
        }
        if (appendPos < uri.length()) {
            String string = uri;
            boolean bl3 = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(appendPos);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            uriRegex.append(Pattern.quote(string5));
        }
        uriRegex.append("($|(\\?(.)*))");
        return exactDeepLink;
    }

    public final boolean matches$navigation_common_release(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.matches$navigation_common_release(new NavDeepLinkRequest(uri, null, null));
    }

    public final boolean matches$navigation_common_release(@NotNull NavDeepLinkRequest deepLinkRequest) {
        Intrinsics.checkNotNullParameter((Object)deepLinkRequest, (String)"deepLinkRequest");
        if (!this.matchUri(deepLinkRequest.getUri())) {
            return false;
        }
        return !this.matchAction(deepLinkRequest.getAction()) ? false : this.matchMimeType(deepLinkRequest.getMimeType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchUri(Uri uri) {
        if (uri == null == (this.pattern != null)) {
            return false;
        }
        if (uri == null) return true;
        Pattern pattern = this.pattern;
        Intrinsics.checkNotNull((Object)pattern);
        if (!pattern.matcher(uri.toString()).matches()) return false;
        return true;
    }

    private final boolean matchAction(String action) {
        return action == null == (this.action != null) ? false : action == null || Intrinsics.areEqual((Object)this.action, (Object)action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchMimeType(String mimeType) {
        if (mimeType == null == (this.mimeType != null)) {
            return false;
        }
        if (mimeType == null) return true;
        Pattern pattern = this.mimeTypePattern;
        Intrinsics.checkNotNull((Object)pattern);
        if (!pattern.matcher(mimeType).matches()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final int getMimeTypeMatchRating(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        if (this.mimeType == null) return -1;
        Pattern pattern = this.mimeTypePattern;
        Intrinsics.checkNotNull((Object)pattern);
        if (!pattern.matcher(mimeType).matches()) {
            return -1;
        }
        int n = new MimeType(this.mimeType).compareTo(new MimeType(mimeType));
        return n;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Bundle getMatchingArguments(@NotNull Uri deepLink, @NotNull Map<String, NavArgument> arguments) {
        Intrinsics.checkNotNullParameter((Object)deepLink, (String)"deepLink");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Pattern pattern = this.pattern;
        Intrinsics.checkNotNull((Object)pattern);
        Matcher matcher = pattern.matcher(deepLink.toString());
        if (!matcher.matches()) {
            return null;
        }
        Bundle bundle = new Bundle();
        int n = 0;
        int size = this.arguments.size();
        if (n < size) {
            do {
                int index = n++;
                String argumentName = this.arguments.get(index);
                String value = Uri.decode((String)matcher.group(index + 1));
                NavArgument argument = arguments.get(argumentName);
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                if (!this.parseArgument(bundle, argumentName, value, argument)) continue;
                return null;
            } while (n < size);
        }
        if (this.isParameterizedQuery) {
            for (String paramName : this.paramArgMap.keySet()) {
                Matcher argMatcher = null;
                ParamQuery storedParam = this.paramArgMap.get(paramName);
                String inputParams = deepLink.getQueryParameter(paramName);
                if (inputParams != null) {
                    Intrinsics.checkNotNull((Object)storedParam);
                    argMatcher = Pattern.compile(storedParam.getParamRegex()).matcher(inputParams);
                    if (!argMatcher.matches()) {
                        return null;
                    }
                }
                int n2 = 0;
                Intrinsics.checkNotNull((Object)storedParam);
                int n3 = storedParam.size();
                if (n2 >= n3) continue;
                do {
                    int index = n2++;
                    String value = null;
                    if (argMatcher != null) {
                        value = Uri.decode((String)argMatcher.group(index + 1));
                    }
                    String argName = storedParam.getArgumentName(index);
                    NavArgument argument = arguments.get(argName);
                    if (value == null) continue;
                    CharSequence charSequence = value;
                    String string = "[{}]";
                    boolean bl = false;
                    string = new Regex(string);
                    String string2 = "";
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)string.replace(charSequence, string2), (Object)argName) || !this.parseArgument(bundle, argName, value, argument)) continue;
                    return null;
                } while (n2 < n3);
            }
        }
        return bundle;
    }

    private final boolean parseArgument(Bundle bundle, String name, String value, NavArgument argument) {
        if (argument != null) {
            NavType<Object> type = argument.getType();
            try {
                type.parseAndPut(bundle, name, value);
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        } else {
            bundle.putString(name, value);
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Landroidx/navigation/NavDeepLink$ParamQuery;", "", "()V", "arguments", "", "", "paramRegex", "getParamRegex", "()Ljava/lang/String;", "setParamRegex", "(Ljava/lang/String;)V", "addArgumentName", "", "name", "getArgumentName", "index", "", "size", "navigation-common_release"})
    private static final class ParamQuery {
        @Nullable
        private String paramRegex;
        @NotNull
        private final List<String> arguments;

        public ParamQuery() {
            boolean bl = false;
            this.arguments = new ArrayList();
        }

        @Nullable
        public final String getParamRegex() {
            return this.paramRegex;
        }

        public final void setParamRegex(@Nullable String string) {
            this.paramRegex = string;
        }

        public final void addArgumentName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.arguments.add(name);
        }

        @NotNull
        public final String getArgumentName(int index) {
            return this.arguments.get(index);
        }

        public final int size() {
            return this.arguments.size();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\u0004\u00a8\u0006\u000f"}, d2={"Landroidx/navigation/NavDeepLink$MimeType;", "", "mimeType", "", "(Ljava/lang/String;)V", "subType", "getSubType", "()Ljava/lang/String;", "setSubType", "type", "getType", "setType", "compareTo", "", "other", "navigation-common_release"})
    private static final class MimeType
    implements Comparable<MimeType> {
        @NotNull
        private String type;
        @NotNull
        private String subType;

        public MimeType(@NotNull String mimeType) {
            List list;
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            CharSequence charSequence = mimeType;
            String string = "/";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    boolean bl3 = false;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List typeAndSubType = list;
            this.type = (String)typeAndSubType.get(0);
            this.subType = (String)typeAndSubType.get(1);
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.type = string;
        }

        @NotNull
        public final String getSubType() {
            return this.subType;
        }

        public final void setSubType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.subType = string;
        }

        @Override
        public int compareTo(@NotNull MimeType other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int result = 0;
            if (Intrinsics.areEqual((Object)this.type, (Object)other.type)) {
                result += 2;
            }
            if (Intrinsics.areEqual((Object)this.subType, (Object)other.subType)) {
                int n = result;
                result = n + 1;
            }
            return result;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/navigation/NavDeepLink$Builder;", "", "()V", "action", "", "mimeType", "uriPattern", "build", "Landroidx/navigation/NavDeepLink;", "setAction", "setMimeType", "setUriPattern", "Companion", "navigation-common_release"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String uriPattern;
        @Nullable
        private String action;
        @Nullable
        private String mimeType;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder() {
        }

        @NotNull
        public final Builder setUriPattern(@NotNull String uriPattern) {
            Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
            this.uriPattern = uriPattern;
            return this;
        }

        @NotNull
        public final Builder setAction(@NotNull String action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            CharSequence charSequence = action;
            boolean bl = false;
            boolean bl2 = charSequence.length() > 0;
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "The NavDeepLink cannot have an empty action.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.action = action;
            return this;
        }

        @NotNull
        public final Builder setMimeType(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            this.mimeType = mimeType;
            return this;
        }

        @NotNull
        public final NavDeepLink build() {
            return new NavDeepLink(this.uriPattern, this.action, this.mimeType);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromUriPattern(@NotNull String uriPattern) {
            return Companion.fromUriPattern(uriPattern);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromAction(@NotNull String action) {
            return Companion.fromAction(action);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromMimeType(@NotNull String mimeType) {
            return Companion.fromMimeType(mimeType);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Landroidx/navigation/NavDeepLink$Builder$Companion;", "", "()V", "fromAction", "Landroidx/navigation/NavDeepLink$Builder;", "action", "", "fromMimeType", "mimeType", "fromUriPattern", "uriPattern", "navigation-common_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder fromUriPattern(@NotNull String uriPattern) {
                Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
                Builder builder = new Builder();
                builder.setUriPattern(uriPattern);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromAction(@NotNull String action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                CharSequence charSequence = action;
                boolean bl = false;
                boolean bl2 = charSequence.length() > 0;
                bl = false;
                boolean bl3 = false;
                if (!bl2) {
                    boolean bl4 = false;
                    String string = "The NavDeepLink cannot have an empty action.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                Builder builder = new Builder();
                builder.setAction(action);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromMimeType(@NotNull String mimeType) {
                Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
                Builder builder = new Builder();
                builder.setMimeType(mimeType);
                return builder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/navigation/NavDeepLink$Companion;", "", "()V", "SCHEME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "navigation-common_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

