/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.IdRes;
import androidx.annotation.RestrictTo;
import androidx.collection.SparseArrayCompat;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.Navigator;
import androidx.navigation.common.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 ;2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002:\u0001;B\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0001J\u001f\u0010\"\u001a\u00020\u001e2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010#\"\u00020\u0001\u00a2\u0006\u0002\u0010$J\u0016\u0010\"\u001a\u00020\u001e2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010%J\u0006\u0010&\u001a\u00020\u001eJ\u0012\u0010'\u001a\u0004\u0018\u00010\u00012\b\b\u0001\u0010(\u001a\u00020\u0011J\u001c\u0010'\u001a\u0004\u0018\u00010\u00012\b\b\u0001\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*H\u0007J\u001a\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010+\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0007J\u0012\u0010'\u001a\u0004\u0018\u00010\u00012\b\u0010+\u001a\u0004\u0018\u00010\u0007J\b\u0010,\u001a\u00020\u0011H\u0007J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00010.H\u0086\u0002J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u000202H\u0017J\u0018\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u000e\u00108\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0001J\u000e\u00109\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u00109\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0007J\b\u0010:\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118G@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\t\"\u0004\b\u001b\u0010\u001c\u00a8\u0006<"}, d2={"Landroidx/navigation/NavGraph;", "Landroidx/navigation/NavDestination;", "", "navGraphNavigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "nodes", "Landroidx/collection/SparseArrayCompat;", "getNodes", "()Landroidx/collection/SparseArrayCompat;", "startDestDisplayName", "getStartDestDisplayName", "startDestId", "", "startDestIdName", "startDestinationId", "getStartDestinationId", "()I", "setStartDestinationId", "(I)V", "startDestRoute", "startDestinationRoute", "getStartDestinationRoute", "setStartDestinationRoute", "(Ljava/lang/String;)V", "addAll", "", "other", "addDestination", "node", "addDestinations", "", "([Landroidx/navigation/NavDestination;)V", "", "clear", "findNode", "resId", "searchParents", "", "route", "getStartDestination", "iterator", "", "matchDeepLink", "Landroidx/navigation/NavDestination$DeepLinkMatch;", "navDeepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "onInflate", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "remove", "setStartDestination", "toString", "Companion", "navigation-common_release"})
public class NavGraph
extends NavDestination
implements Iterable<NavDestination>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SparseArrayCompat<NavDestination> nodes;
    private int startDestId;
    @Nullable
    private String startDestIdName;
    @Nullable
    private String startDestinationRoute;

    public NavGraph(@NotNull Navigator<? extends NavGraph> navGraphNavigator) {
        Intrinsics.checkNotNullParameter(navGraphNavigator, (String)"navGraphNavigator");
        super(navGraphNavigator);
        this.nodes = new SparseArrayCompat();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final SparseArrayCompat<NavDestination> getNodes() {
        return this.nodes;
    }

    @Override
    public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super.onInflate(context, attrs);
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.NavGraphNavigator);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.resources.obtainAttributes(\n            attrs,\n            R.styleable.NavGraphNavigator\n        )");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray it = $this$use$iv;
        boolean bl = false;
        this.setStartDestinationId(it.getResourceId(R.styleable.NavGraphNavigator_startDestination, 0));
        this.startDestIdName = NavDestination.Companion.getDisplayName(context, this.startDestId);
        Unit unit = Unit.INSTANCE;
        boolean bl2 = false;
        boolean bl3 = false;
        Unit it$iv = unit;
        boolean bl4 = false;
        $this$use$iv.recycle();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public NavDestination.DeepLinkMatch matchDeepLink(@NotNull NavDeepLinkRequest navDeepLinkRequest) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)navDeepLinkRequest, (String)"navDeepLinkRequest");
        NavDestination.DeepLinkMatch bestMatch = super.matchDeepLink(navDeepLinkRequest);
        Iterable $this$mapNotNull$iv = this;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            NavDestination.DeepLinkMatch deepLinkMatch;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            NavDestination child = (NavDestination)element$iv$iv;
            boolean bl2 = false;
            if (child.matchDeepLink(navDeepLinkRequest) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            NavDestination.DeepLinkMatch it$iv$iv = deepLinkMatch;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        NavDestination.DeepLinkMatch bestChildMatch = (NavDestination.DeepLinkMatch)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        Object[] objectArray = new NavDestination.DeepLinkMatch[]{bestMatch, bestChildMatch};
        return (NavDestination.DeepLinkMatch)CollectionsKt.maxOrNull((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    public final void addDestination(@NotNull NavDestination node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int id = node.getId();
        String innerRoute = node.getRoute();
        boolean bl = id != 0 || innerRoute != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Destinations must have an id or route. Call setId(), setRoute(), or include an android:id or app:route in your navigation XML.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.getRoute() != null) {
            bl = !Intrinsics.areEqual((Object)innerRoute, (Object)this.getRoute());
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Destination " + node + " cannot have the same route as graph " + this;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        bl = id != this.getId();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Destination " + node + " cannot have the same id as graph " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        NavDestination existingDestination = (NavDestination)this.nodes.get(id);
        if (existingDestination == node) {
            return;
        }
        bl2 = node.getParent() == null;
        bl3 = false;
        boolean bl7 = false;
        if (!bl2) {
            boolean bl8 = false;
            String string = "Destination already has a parent set. Call NavGraph.remove() to remove the previous parent.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (existingDestination != null) {
            existingDestination.setParent(null);
        }
        node.setParent(this);
        this.nodes.put(node.getId(), (Object)node);
    }

    public final void addDestinations(@NotNull Collection<? extends NavDestination> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        for (NavDestination navDestination : nodes) {
            if (navDestination == null) continue;
            this.addDestination(navDestination);
        }
    }

    public final void addDestinations(NavDestination ... nodes) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        for (NavDestination node : nodes) {
            this.addDestination(node);
        }
    }

    @Nullable
    public final NavDestination findNode(@IdRes int resId) {
        return this.findNode(resId, true);
    }

    @Nullable
    public final NavDestination findNode(@Nullable String route) {
        CharSequence charSequence = route;
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? this.findNode(route, true) : null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination findNode(@IdRes int resId, boolean searchParents) {
        NavDestination navDestination;
        NavDestination destination = (NavDestination)this.nodes.get(resId);
        NavDestination navDestination2 = destination;
        if (navDestination2 == null) {
            if (searchParents && this.getParent() != null) {
                NavGraph navGraph = this.getParent();
                Intrinsics.checkNotNull((Object)navGraph);
                navDestination = navGraph.findNode(resId);
            } else {
                navDestination = null;
            }
        } else {
            navDestination = navDestination2;
        }
        return navDestination;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination findNode(@NotNull String route, boolean searchParents) {
        NavDestination navDestination;
        NavDestination destination;
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        int id = NavDestination.Companion.createRoute(route).hashCode();
        NavDestination navDestination2 = destination = (NavDestination)this.nodes.get(id);
        if (navDestination2 == null) {
            if (searchParents && this.getParent() != null) {
                NavGraph navGraph = this.getParent();
                Intrinsics.checkNotNull((Object)navGraph);
                navDestination = navGraph.findNode(route);
            } else {
                navDestination = null;
            }
        } else {
            navDestination = navDestination2;
        }
        return navDestination;
    }

    @Override
    @NotNull
    public final Iterator<NavDestination> iterator() {
        return new Iterator<NavDestination>(this){
            private int index;
            private boolean wentToNext;
            final /* synthetic */ NavGraph this$0;
            {
                this.this$0 = $receiver;
                this.index = -1;
            }

            public boolean hasNext() {
                return this.index + 1 < this.this$0.getNodes().size();
            }

            @NotNull
            public NavDestination next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.wentToNext = true;
                iterator.1 var2_1 = this;
                ++var2_1.index;
                Object object = this.this$0.getNodes().valueAt(var2_1.index);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodes.valueAt(++index)");
                return (NavDestination)object;
            }

            public void remove() {
                boolean bl = this.wentToNext;
                int n = 0;
                boolean bl2 = false;
                if (!bl) {
                    boolean bl3 = false;
                    String string = "You must call next() before you can remove an element";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Object object = this.this$0.getNodes();
                n = 0;
                bl2 = false;
                SparseArrayCompat<NavDestination> $this$remove_u24lambda_u2d1 = object;
                boolean bl4 = false;
                ((NavDestination)$this$remove_u24lambda_u2d1.valueAt(this.index)).setParent(null);
                $this$remove_u24lambda_u2d1.removeAt(this.index);
                object = this;
                n = object.index;
                object.index = n + -1;
                this.wentToNext = false;
            }
        };
    }

    public final void addAll(@NotNull NavGraph other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Iterator<NavDestination> iterator2 = other.iterator();
        while (iterator2.hasNext()) {
            NavDestination destination = iterator2.next();
            iterator2.remove();
            this.addDestination(destination);
        }
    }

    public final void remove(@NotNull NavDestination node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int index = this.nodes.indexOfKey(node.getId());
        if (index >= 0) {
            ((NavDestination)this.nodes.valueAt(index)).setParent(null);
            this.nodes.removeAt(index);
        }
    }

    public final void clear() {
        Iterator<NavDestination> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            iterator2.remove();
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public String getDisplayName() {
        return this.getId() != 0 ? super.getDisplayName() : "the root navigation";
    }

    @Deprecated(message="Use getStartDestinationId instead.", replaceWith=@ReplaceWith(expression="startDestinationId", imports={}))
    @IdRes
    public final int getStartDestination() {
        return this.getStartDestinationId();
    }

    @IdRes
    public final int getStartDestinationId() {
        return this.startDestId;
    }

    private final void setStartDestinationId(int startDestId) {
        boolean bl = startDestId != this.getId();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Start destination " + startDestId + " cannot use the same id as the graph " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.startDestinationRoute != null) {
            this.setStartDestinationRoute(null);
        }
        this.startDestId = startDestId;
        this.startDestIdName = null;
    }

    public final void setStartDestination(int startDestId) {
        this.setStartDestinationId(startDestId);
    }

    public final void setStartDestination(@NotNull String startDestRoute) {
        Intrinsics.checkNotNullParameter((Object)startDestRoute, (String)"startDestRoute");
        this.setStartDestinationRoute(startDestRoute);
    }

    @Nullable
    public final String getStartDestinationRoute() {
        return this.startDestinationRoute;
    }

    private final void setStartDestinationRoute(String startDestRoute) {
        int n;
        NavGraph navGraph = this;
        if (startDestRoute == null) {
            n = 0;
        } else {
            boolean bl = !Intrinsics.areEqual((Object)startDestRoute, (Object)this.getRoute());
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                NavGraph navGraph2 = navGraph;
                boolean bl4 = false;
                String string = "Start destination " + startDestRoute + " cannot use the same route as the graph " + this;
                NavGraph navGraph3 = navGraph2;
                String string2 = string;
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            CharSequence charSequence = startDestRoute;
            bl2 = false;
            boolean bl5 = !StringsKt.isBlank((CharSequence)charSequence);
            bl2 = false;
            bl3 = false;
            if (!bl5) {
                NavGraph navGraph4 = navGraph;
                boolean bl6 = false;
                String string = "Cannot have an empty start destination route";
                NavGraph navGraph5 = navGraph4;
                String string3 = string;
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            String internalRoute = NavDestination.Companion.createRoute(startDestRoute);
            n = internalRoute.hashCode();
        }
        navGraph.startDestId = n;
        this.startDestinationRoute = startDestRoute;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final String getStartDestDisplayName() {
        if (this.startDestIdName == null) {
            this.startDestIdName = String.valueOf(this.startDestId);
        }
        String string = this.startDestIdName;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        Object object = this.findNode(this.startDestinationRoute);
        NavDestination startDestination = object == null ? this.findNode(this.getStartDestinationId()) : object;
        sb.append(" startDestination=");
        if (startDestination == null) {
            if (this.startDestinationRoute != null) {
                sb.append(this.startDestinationRoute);
            } else if (this.startDestIdName != null) {
                sb.append(this.startDestIdName);
            } else {
                sb.append(Intrinsics.stringPlus((String)"0x", (Object)Integer.toHexString(this.startDestId)));
            }
        } else {
            sb.append("{");
            sb.append(startDestination.toString());
            sb.append("}");
        }
        object = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
        return object;
    }

    @JvmStatic
    @NotNull
    public static final NavDestination findStartDestination(@NotNull NavGraph $this$findStartDestination) {
        return Companion.findStartDestination($this$findStartDestination);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Landroidx/navigation/NavGraph$Companion;", "", "()V", "findStartDestination", "Landroidx/navigation/NavDestination;", "Landroidx/navigation/NavGraph;", "navigation-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final NavDestination findStartDestination(@NotNull NavGraph $this$findStartDestination) {
            Intrinsics.checkNotNullParameter((Object)$this$findStartDestination, (String)"<this>");
            return (NavDestination)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)$this$findStartDestination.findNode($this$findStartDestination.getStartDestinationId()), (Function1)findStartDestination.1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

