/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\tH\u0007J\u001a\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH&J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0018\u0010#\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0006H\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0006H\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R#\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\r\u00a8\u0006)"}, d2={"Landroidx/navigation/NavigatorState;", "", "()V", "_backStack", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Landroidx/navigation/NavBackStackEntry;", "_transitionsInProgress", "", "Landroidx/navigation/NavigatorState$OnTransitionCompleteListener;", "backStack", "Lkotlinx/coroutines/flow/StateFlow;", "getBackStack", "()Lkotlinx/coroutines/flow/StateFlow;", "backStackLock", "Ljava/util/concurrent/locks/ReentrantLock;", "isNavigating", "", "()Z", "setNavigating", "(Z)V", "transitionsInProgress", "getTransitionsInProgress", "addInProgressTransition", "", "entry", "listener", "createBackStackEntry", "destination", "Landroidx/navigation/NavDestination;", "arguments", "Landroid/os/Bundle;", "pop", "popUpTo", "saveState", "popWithTransition", "push", "backStackEntry", "pushWithTransition", "removeInProgressTransition", "OnTransitionCompleteListener", "navigation-common_release"})
public abstract class NavigatorState {
    @NotNull
    private final ReentrantLock backStackLock = new ReentrantLock(true);
    @NotNull
    private final MutableStateFlow<List<NavBackStackEntry>> _backStack;
    @NotNull
    private final MutableStateFlow<Map<NavBackStackEntry, OnTransitionCompleteListener>> _transitionsInProgress;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private boolean isNavigating;
    @NotNull
    private final StateFlow<List<NavBackStackEntry>> backStack;
    @NotNull
    private final StateFlow<Map<NavBackStackEntry, OnTransitionCompleteListener>> transitionsInProgress;

    public NavigatorState() {
        boolean bl = false;
        this._backStack = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        bl = false;
        this._transitionsInProgress = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
        this.backStack = FlowKt.asStateFlow(this._backStack);
        this.transitionsInProgress = FlowKt.asStateFlow(this._transitionsInProgress);
    }

    public final boolean isNavigating() {
        return this.isNavigating;
    }

    public final void setNavigating(boolean bl) {
        this.isNavigating = bl;
    }

    @NotNull
    public final StateFlow<List<NavBackStackEntry>> getBackStack() {
        return this.backStack;
    }

    @NotNull
    public final StateFlow<Map<NavBackStackEntry, OnTransitionCompleteListener>> getTransitionsInProgress() {
        return this.transitionsInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(@NotNull NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        Lock lock = this.backStackLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            this._backStack.setValue((Object)CollectionsKt.plus((Collection)((Collection)this._backStack.getValue()), (Object)backStackEntry));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public OnTransitionCompleteListener pushWithTransition(@NotNull NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        this.push(backStackEntry);
        return new OnTransitionCompleteListener(this, backStackEntry){
            final /* synthetic */ NavigatorState this$0;
            final /* synthetic */ NavBackStackEntry $backStackEntry;
            {
                this.this$0 = $receiver;
                this.$backStackEntry = $backStackEntry;
            }

            public final void onTransitionComplete() {
                this.this$0.removeInProgressTransition(this.$backStackEntry);
            }
        };
    }

    @NotNull
    public abstract NavBackStackEntry createBackStackEntry(@NotNull NavDestination var1, @Nullable Bundle var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void pop(@NotNull NavBackStackEntry popUpTo2, boolean saveState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo2, (String)"popUpTo");
        Lock lock = this.backStackLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            void $this$takeWhile$iv;
            boolean bl3 = false;
            Iterable iterable = (Iterable)this._backStack.getValue();
            MutableStateFlow<List<NavBackStackEntry>> mutableStateFlow = this._backStack;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                NavBackStackEntry it = (NavBackStackEntry)item$iv;
                boolean bl4 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)popUpTo2))) break;
                list$iv.add(item$iv);
            }
            List list = list$iv;
            mutableStateFlow.setValue((Object)list);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public OnTransitionCompleteListener popWithTransition(@NotNull NavBackStackEntry popUpTo2, boolean saveState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo2, (String)"popUpTo");
        OnTransitionCompleteListener listener2 = new OnTransitionCompleteListener(this, popUpTo2){
            final /* synthetic */ NavigatorState this$0;
            final /* synthetic */ NavBackStackEntry $popUpTo;
            {
                this.this$0 = $receiver;
                this.$popUpTo = $popUpTo;
            }

            public final void onTransitionComplete() {
                this.this$0.removeInProgressTransition(this.$popUpTo);
            }
        };
        this.pop(popUpTo2, saveState);
        return listener2;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void addInProgressTransition(@NotNull NavBackStackEntry entry, @NotNull OnTransitionCompleteListener listener2) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this._transitionsInProgress.setValue((Object)MapsKt.plus((Map)((Map)this._transitionsInProgress.getValue()), (Pair)TuplesKt.to((Object)entry, (Object)listener2)));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void removeInProgressTransition(@NotNull NavBackStackEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this._transitionsInProgress.setValue((Object)MapsKt.minus((Map)((Map)this._transitionsInProgress.getValue()), (Object)entry));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Landroidx/navigation/NavigatorState$OnTransitionCompleteListener;", "", "onTransitionComplete", "", "navigation-common_release"})
    public static interface OnTransitionCompleteListener {
        public void onTransitionComplete();
    }
}

