/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 E2\u00020\u0001:\u0004DEFGB\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\b\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ$\u0010(\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020\u001bH\u0002J\u0013\u0010-\u001a\u00020\u00122\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J(\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u0002022\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010403H\u0007J\u0010\u00105\u001a\u0002062\u0006\u0010\u0007\u001a\u00020\u0003H\u0007J\b\u00107\u001a\u000206H\u0016J\u0012\u00108\u001a\u00020\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u00109\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010:\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u000102H\u0002J\u0015\u0010;\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u000202H\u0000\u00a2\u0006\u0002\b<J\u0015\u0010;\u001a\u00020\u00122\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b<J*\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u00032\b\u0010C\u001a\u0004\u0018\u000104H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010#\u001a\u0004\u0018\u00010\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001f\u001a\u0004\b$\u0010\u001dR\u0010\u0010&\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\n\u00a8\u0006H"}, d2={"Landroidx/navigation/NavDeepLink;", "", "uri", "", "(Ljava/lang/String;)V", "uriPattern", "action", "mimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "arguments", "", "argumentsNames", "", "getArgumentsNames$navigation_common_release", "()Ljava/util/List;", "<set-?>", "", "isExactDeepLink", "()Z", "setExactDeepLink$navigation_common_release", "(Z)V", "isParameterizedQuery", "getMimeType", "mimeTypeFinalRegex", "mimeTypePattern", "Ljava/util/regex/Pattern;", "getMimeTypePattern", "()Ljava/util/regex/Pattern;", "mimeTypePattern$delegate", "Lkotlin/Lazy;", "paramArgMap", "", "Landroidx/navigation/NavDeepLink$ParamQuery;", "pattern", "getPattern", "pattern$delegate", "patternFinalRegex", "getUriPattern", "buildPathRegex", "uriRegex", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "fillInPattern", "equals", "other", "getMatchingArguments", "Landroid/os/Bundle;", "deepLink", "Landroid/net/Uri;", "", "Landroidx/navigation/NavArgument;", "getMimeTypeMatchRating", "", "hashCode", "matchAction", "matchMimeType", "matchUri", "matches", "matches$navigation_common_release", "deepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "parseArgument", "bundle", "name", "value", "argument", "Builder", "Companion", "MimeType", "ParamQuery", "navigation-common_release"})
public final class NavDeepLink {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String uriPattern;
    @Nullable
    private final String action;
    @Nullable
    private final String mimeType;
    @NotNull
    private final List<String> arguments;
    @NotNull
    private final Map<String, ParamQuery> paramArgMap;
    @Nullable
    private String patternFinalRegex;
    @NotNull
    private final Lazy pattern$delegate;
    private boolean isParameterizedQuery;
    @Nullable
    private String mimeTypeFinalRegex;
    @NotNull
    private final Lazy mimeTypePattern$delegate;
    private boolean isExactDeepLink;
    @Deprecated
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^[a-zA-Z]+[+\\w\\-.]*:");

    public NavDeepLink(@Nullable String uriPattern, @Nullable String action, @Nullable String mimeType) {
        this.uriPattern = uriPattern;
        this.action = action;
        this.mimeType = mimeType;
        boolean bl = false;
        this.arguments = new ArrayList();
        bl = false;
        this.paramArgMap = new LinkedHashMap();
        this.pattern$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pattern>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pattern invoke() {
                Pattern pattern2;
                String string = NavDeepLink.access$getPatternFinalRegex$p(this.this$0);
                if (string == null) {
                    pattern2 = null;
                } else {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    pattern2 = Pattern.compile(it, 2);
                }
                return pattern2;
            }
        }));
        this.mimeTypePattern$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pattern>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pattern invoke() {
                Pattern pattern2;
                String string = NavDeepLink.access$getMimeTypeFinalRegex$p(this.this$0);
                if (string == null) {
                    pattern2 = null;
                } else {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    pattern2 = Pattern.compile(it);
                }
                return pattern2;
            }
        }));
        if (this.uriPattern != null) {
            Object matcher;
            Uri parameterizedUri = Uri.parse((String)this.uriPattern);
            this.isParameterizedQuery = parameterizedUri.getQuery() != null;
            StringBuilder uriRegex = new StringBuilder("^");
            if (!SCHEME_PATTERN.matcher(this.uriPattern).find()) {
                uriRegex.append("http[s]?://");
            }
            Pattern fillInPattern = Pattern.compile("\\{(.+?)\\}");
            if (this.isParameterizedQuery) {
                matcher = Pattern.compile("(\\?)").matcher(this.uriPattern);
                if (((Matcher)matcher).find()) {
                    String string = this.uriPattern;
                    int n = 0;
                    int n2 = ((Matcher)matcher).start();
                    boolean bl2 = false;
                    Object object = string;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = ((String)object).substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Intrinsics.checkNotNullExpressionValue((Object)fillInPattern, (String)"fillInPattern");
                    this.isExactDeepLink = this.buildPathRegex(string2, uriRegex, fillInPattern);
                }
                for (String paramName : parameterizedUri.getQueryParameterNames()) {
                    boolean bl3;
                    int n;
                    Object object;
                    StringBuilder argRegex = new StringBuilder();
                    String string = parameterizedUri.getQueryParameter(paramName);
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    String queryParam = string;
                    matcher = fillInPattern.matcher(queryParam);
                    int appendPos = 0;
                    ParamQuery param = new ParamQuery();
                    while (((Matcher)matcher).find()) {
                        object = ((Matcher)matcher).group(1);
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        param.addArgumentName((String)object);
                        object = queryParam;
                        n = ((Matcher)matcher).start();
                        bl3 = false;
                        String string3 = ((String)object).substring(appendPos, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        argRegex.append(Pattern.quote(string3));
                        argRegex.append("(.+?)?");
                        appendPos = ((Matcher)matcher).end();
                    }
                    if (appendPos < queryParam.length()) {
                        object = queryParam;
                        n = 0;
                        String string4 = ((String)object).substring(appendPos);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        argRegex.append(Pattern.quote(string4));
                    }
                    object = argRegex.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"argRegex.toString()");
                    param.setParamRegex(StringsKt.replace$default((String)object, (String)".*", (String)"\\E.*\\Q", (boolean)false, (int)4, null));
                    object = this.paramArgMap;
                    Intrinsics.checkNotNullExpressionValue((Object)paramName, (String)"paramName");
                    String string5 = paramName;
                    bl3 = false;
                    object.put(string5, param);
                }
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)fillInPattern, (String)"fillInPattern");
                this.isExactDeepLink = this.buildPathRegex(this.uriPattern, uriRegex, fillInPattern);
            }
            matcher = uriRegex.toString();
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"uriRegex.toString()");
            this.patternFinalRegex = StringsKt.replace$default((String)matcher, (String)".*", (String)"\\E.*\\Q", (boolean)false, (int)4, null);
        }
        if (this.mimeType != null) {
            Pattern mimeTypePattern2 = Pattern.compile("^[\\s\\S]+/[\\s\\S]+$");
            Matcher mimeTypeMatcher = mimeTypePattern2.matcher(this.mimeType);
            boolean fillInPattern = mimeTypeMatcher.matches();
            boolean matcher = false;
            boolean bl4 = false;
            if (!fillInPattern) {
                boolean bl5 = false;
                String string = "The given mimeType " + this.getMimeType() + " does not match to required \"type/subtype\" format";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            MimeType splitMimeType = new MimeType(this.mimeType);
            String mimeTypeRegex = "^(" + splitMimeType.getType() + "|[*]+)/(" + splitMimeType.getSubType() + "|[*]+)$";
            this.mimeTypeFinalRegex = StringsKt.replace$default((String)mimeTypeRegex, (String)"*|[*]", (String)"[\\s\\S]", (boolean)false, (int)4, null);
        }
    }

    @Nullable
    public final String getUriPattern() {
        return this.uriPattern;
    }

    @Nullable
    public final String getAction() {
        return this.action;
    }

    @Nullable
    public final String getMimeType() {
        return this.mimeType;
    }

    private final Pattern getPattern() {
        Lazy lazy = this.pattern$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Pattern)lazy.getValue();
    }

    private final Pattern getMimeTypePattern() {
        Lazy lazy = this.mimeTypePattern$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Pattern)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getArgumentsNames$navigation_common_release() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.paramArgMap.values();
        Collection collection = this.arguments;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ParamQuery it = (ParamQuery)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getArguments();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isExactDeepLink() {
        return this.isExactDeepLink;
    }

    public final void setExactDeepLink$navigation_common_release(boolean bl) {
        this.isExactDeepLink = bl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public NavDeepLink(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(uri, null, null);
    }

    private final boolean buildPathRegex(String uri, StringBuilder uriRegex, Pattern fillInPattern) {
        boolean exactDeepLink;
        Matcher matcher = fillInPattern.matcher(uri);
        int appendPos = 0;
        boolean bl = exactDeepLink = !StringsKt.contains$default((CharSequence)uri, (CharSequence)".*", (boolean)false, (int)2, null);
        while (matcher.find()) {
            String string = matcher.group(1);
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String argName = string;
            this.arguments.add(argName);
            string = uri;
            int n = matcher.start();
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(appendPos, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            uriRegex.append(Pattern.quote(string3));
            uriRegex.append("([^/]+?)");
            appendPos = matcher.end();
            exactDeepLink = false;
        }
        if (appendPos < uri.length()) {
            String string = uri;
            boolean bl3 = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(appendPos);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            uriRegex.append(Pattern.quote(string5));
        }
        uriRegex.append("($|(\\?(.)*))");
        return exactDeepLink;
    }

    public final boolean matches$navigation_common_release(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.matches$navigation_common_release(new NavDeepLinkRequest(uri, null, null));
    }

    public final boolean matches$navigation_common_release(@NotNull NavDeepLinkRequest deepLinkRequest) {
        Intrinsics.checkNotNullParameter((Object)deepLinkRequest, (String)"deepLinkRequest");
        if (!this.matchUri(deepLinkRequest.getUri())) {
            return false;
        }
        return !this.matchAction(deepLinkRequest.getAction()) ? false : this.matchMimeType(deepLinkRequest.getMimeType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchUri(Uri uri) {
        if (uri == null == (this.getPattern() != null)) {
            return false;
        }
        if (uri == null) return true;
        Pattern pattern2 = this.getPattern();
        Intrinsics.checkNotNull((Object)pattern2);
        if (!pattern2.matcher(uri.toString()).matches()) return false;
        return true;
    }

    private final boolean matchAction(String action) {
        return action == null == (this.action != null) ? false : action == null || Intrinsics.areEqual((Object)this.action, (Object)action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchMimeType(String mimeType) {
        if (mimeType == null == (this.mimeType != null)) {
            return false;
        }
        if (mimeType == null) return true;
        Pattern pattern2 = this.getMimeTypePattern();
        Intrinsics.checkNotNull((Object)pattern2);
        if (!pattern2.matcher(mimeType).matches()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final int getMimeTypeMatchRating(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        if (this.mimeType == null) return -1;
        Pattern pattern2 = this.getMimeTypePattern();
        Intrinsics.checkNotNull((Object)pattern2);
        if (!pattern2.matcher(mimeType).matches()) {
            return -1;
        }
        int n = new MimeType(this.mimeType).compareTo(new MimeType(mimeType));
        return n;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Bundle getMatchingArguments(@NotNull Uri deepLink, @NotNull Map<String, NavArgument> arguments) {
        int n;
        Object storedParam;
        Matcher matcher;
        Intrinsics.checkNotNullParameter((Object)deepLink, (String)"deepLink");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Pattern pattern2 = this.getPattern();
        Matcher matcher2 = matcher = pattern2 == null ? null : pattern2.matcher(deepLink.toString());
        if (matcher == null) {
            return null;
        }
        Matcher matcher3 = matcher;
        if (!matcher3.matches()) {
            return null;
        }
        Bundle bundle = new Bundle();
        int n2 = 0;
        int size = this.arguments.size();
        if (n2 < size) {
            do {
                int index = n2++;
                String argumentName = this.arguments.get(index);
                String value = Uri.decode((String)matcher3.group(index + 1));
                NavArgument argument = arguments.get(argumentName);
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                if (!this.parseArgument(bundle, argumentName, value, argument)) continue;
                return null;
            } while (n2 < size);
        }
        if (this.isParameterizedQuery) {
            for (String paramName : this.paramArgMap.keySet()) {
                Matcher argMatcher = null;
                storedParam = this.paramArgMap.get(paramName);
                String inputParams22 = deepLink.getQueryParameter(paramName);
                if (inputParams22 != null) {
                    Object object = storedParam;
                    Intrinsics.checkNotNull((Object)object);
                    argMatcher = Pattern.compile(((ParamQuery)object).getParamRegex()).matcher(inputParams22);
                    if (!argMatcher.matches()) {
                        return null;
                    }
                }
                n = 0;
                Object object = storedParam;
                Intrinsics.checkNotNull((Object)object);
                int n3 = ((ParamQuery)object).size();
                if (n >= n3) continue;
                do {
                    int index = n++;
                    String value = null;
                    if (argMatcher != null) {
                        value = Uri.decode((String)argMatcher.group(index + 1));
                    }
                    String argName = ((ParamQuery)storedParam).getArgumentName(index);
                    NavArgument argument = arguments.get(argName);
                    if (value == null) continue;
                    CharSequence charSequence = value;
                    String string = "[{}]";
                    boolean bl = false;
                    string = new Regex(string);
                    String string2 = "";
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)string.replace(charSequence, string2), (Object)argName) || !this.parseArgument(bundle, argName, value, argument)) continue;
                    return null;
                } while (n < n3);
            }
        }
        for (Map.Entry<String, NavArgument> entry : arguments.entrySet()) {
            storedParam = entry;
            boolean inputParams22 = false;
            String argName = storedParam.getKey();
            Map.Entry<String, NavArgument> inputParams22 = entry;
            n = 0;
            NavArgument argument = inputParams22.getValue();
            boolean argumentIsRequired = argument != null && !argument.isNullable() && !argument.isDefaultValuePresent();
            if (!argumentIsRequired || bundle.containsKey(argName)) continue;
            return null;
        }
        return bundle;
    }

    private final boolean parseArgument(Bundle bundle, String name, String value, NavArgument argument) {
        if (argument != null) {
            NavType<Object> type = argument.getType();
            try {
                type.parseAndPut(bundle, name, value);
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        } else {
            bundle.putString(name, value);
        }
        return false;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof NavDeepLink)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.uriPattern, (Object)((NavDeepLink)other).uriPattern) && Intrinsics.areEqual((Object)this.action, (Object)((NavDeepLink)other).action) && Intrinsics.areEqual((Object)this.mimeType, (Object)((NavDeepLink)other).mimeType);
    }

    public int hashCode() {
        int result = 0;
        String string = this.uriPattern;
        boolean bl = false;
        String string2 = string;
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        string = this.action;
        bl = false;
        String string3 = string;
        result = 31 * result + (string3 != null ? string3.hashCode() : 0);
        string = this.mimeType;
        bl = false;
        String string4 = string;
        result = 31 * result + (string4 != null ? string4.hashCode() : 0);
        return result;
    }

    public static final /* synthetic */ String access$getPatternFinalRegex$p(NavDeepLink $this) {
        return $this.patternFinalRegex;
    }

    public static final /* synthetic */ String access$getMimeTypeFinalRegex$p(NavDeepLink $this) {
        return $this.mimeTypeFinalRegex;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Landroidx/navigation/NavDeepLink$ParamQuery;", "", "()V", "arguments", "", "", "getArguments", "()Ljava/util/List;", "paramRegex", "getParamRegex", "()Ljava/lang/String;", "setParamRegex", "(Ljava/lang/String;)V", "addArgumentName", "", "name", "getArgumentName", "index", "", "size", "navigation-common_release"})
    private static final class ParamQuery {
        @Nullable
        private String paramRegex;
        @NotNull
        private final List<String> arguments;

        public ParamQuery() {
            boolean bl = false;
            this.arguments = new ArrayList();
        }

        @Nullable
        public final String getParamRegex() {
            return this.paramRegex;
        }

        public final void setParamRegex(@Nullable String string) {
            this.paramRegex = string;
        }

        @NotNull
        public final List<String> getArguments() {
            return this.arguments;
        }

        public final void addArgumentName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.arguments.add(name);
        }

        @NotNull
        public final String getArgumentName(int index) {
            return this.arguments.get(index);
        }

        public final int size() {
            return this.arguments.size();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\u0004\u00a8\u0006\u000f"}, d2={"Landroidx/navigation/NavDeepLink$MimeType;", "", "mimeType", "", "(Ljava/lang/String;)V", "subType", "getSubType", "()Ljava/lang/String;", "setSubType", "type", "getType", "setType", "compareTo", "", "other", "navigation-common_release"})
    private static final class MimeType
    implements Comparable<MimeType> {
        @NotNull
        private String type;
        @NotNull
        private String subType;

        public MimeType(@NotNull String mimeType) {
            List list;
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            CharSequence charSequence = mimeType;
            String string = "/";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    boolean bl3 = false;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List typeAndSubType = list;
            this.type = (String)typeAndSubType.get(0);
            this.subType = (String)typeAndSubType.get(1);
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.type = string;
        }

        @NotNull
        public final String getSubType() {
            return this.subType;
        }

        public final void setSubType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.subType = string;
        }

        @Override
        public int compareTo(@NotNull MimeType other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int result = 0;
            if (Intrinsics.areEqual((Object)this.type, (Object)other.type)) {
                result += 2;
            }
            if (Intrinsics.areEqual((Object)this.subType, (Object)other.subType)) {
                int n = result;
                result = n + 1;
            }
            return result;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/navigation/NavDeepLink$Builder;", "", "()V", "action", "", "mimeType", "uriPattern", "build", "Landroidx/navigation/NavDeepLink;", "setAction", "setMimeType", "setUriPattern", "Companion", "navigation-common_release"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String uriPattern;
        @Nullable
        private String action;
        @Nullable
        private String mimeType;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder() {
        }

        @NotNull
        public final Builder setUriPattern(@NotNull String uriPattern) {
            Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
            this.uriPattern = uriPattern;
            return this;
        }

        @NotNull
        public final Builder setAction(@NotNull String action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            CharSequence charSequence = action;
            boolean bl = false;
            boolean bl2 = charSequence.length() > 0;
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "The NavDeepLink cannot have an empty action.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.action = action;
            return this;
        }

        @NotNull
        public final Builder setMimeType(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            this.mimeType = mimeType;
            return this;
        }

        @NotNull
        public final NavDeepLink build() {
            return new NavDeepLink(this.uriPattern, this.action, this.mimeType);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromUriPattern(@NotNull String uriPattern) {
            return Companion.fromUriPattern(uriPattern);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromAction(@NotNull String action) {
            return Companion.fromAction(action);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromMimeType(@NotNull String mimeType) {
            return Companion.fromMimeType(mimeType);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Landroidx/navigation/NavDeepLink$Builder$Companion;", "", "()V", "fromAction", "Landroidx/navigation/NavDeepLink$Builder;", "action", "", "fromMimeType", "mimeType", "fromUriPattern", "uriPattern", "navigation-common_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder fromUriPattern(@NotNull String uriPattern) {
                Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
                Builder builder = new Builder();
                builder.setUriPattern(uriPattern);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromAction(@NotNull String action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                CharSequence charSequence = action;
                boolean bl = false;
                boolean bl2 = charSequence.length() > 0;
                bl = false;
                boolean bl3 = false;
                if (!bl2) {
                    boolean bl4 = false;
                    String string = "The NavDeepLink cannot have an empty action.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                Builder builder = new Builder();
                builder.setAction(action);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromMimeType(@NotNull String mimeType) {
                Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
                Builder builder = new Builder();
                builder.setMimeType(mimeType);
                return builder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/navigation/NavDeepLink$Companion;", "", "()V", "SCHEME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "navigation-common_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

