/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 F2\u00020\u0001:\u0004EFGHB\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\b\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ$\u0010)\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010*\u001a\u00060+j\u0002`,2\u0006\u0010-\u001a\u00020\u001cH\u0002J\u0013\u0010.\u001a\u00020\u00122\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J(\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u0002032\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010504H\u0007J\u0010\u00106\u001a\u0002072\u0006\u0010\u0007\u001a\u00020\u0003H\u0007J\b\u00108\u001a\u000207H\u0016J\u0012\u00109\u001a\u00020\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010:\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010;\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u000103H\u0002J\u0015\u0010<\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u000203H\u0000\u00a2\u0006\u0002\b=J\u0015\u0010<\u001a\u00020\u00122\u0006\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\b=J*\u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u0002012\u0006\u0010B\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u00032\b\u0010D\u001a\u0004\u0018\u000105H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010$\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010 \u001a\u0004\b%\u0010\u001eR\u0010\u0010'\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\n\u00a8\u0006I"}, d2={"Landroidx/navigation/NavDeepLink;", "", "uri", "", "(Ljava/lang/String;)V", "uriPattern", "action", "mimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "arguments", "", "argumentsNames", "", "getArgumentsNames$navigation_common_release", "()Ljava/util/List;", "<set-?>", "", "isExactDeepLink", "()Z", "setExactDeepLink$navigation_common_release", "(Z)V", "isParameterizedQuery", "isSingleQueryParamValueOnly", "getMimeType", "mimeTypeFinalRegex", "mimeTypePattern", "Ljava/util/regex/Pattern;", "getMimeTypePattern", "()Ljava/util/regex/Pattern;", "mimeTypePattern$delegate", "Lkotlin/Lazy;", "paramArgMap", "", "Landroidx/navigation/NavDeepLink$ParamQuery;", "pattern", "getPattern", "pattern$delegate", "patternFinalRegex", "getUriPattern", "buildPathRegex", "uriRegex", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "fillInPattern", "equals", "other", "getMatchingArguments", "Landroid/os/Bundle;", "deepLink", "Landroid/net/Uri;", "", "Landroidx/navigation/NavArgument;", "getMimeTypeMatchRating", "", "hashCode", "matchAction", "matchMimeType", "matchUri", "matches", "matches$navigation_common_release", "deepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "parseArgument", "bundle", "name", "value", "argument", "Builder", "Companion", "MimeType", "ParamQuery", "navigation-common_release"})
public final class NavDeepLink {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String uriPattern;
    @Nullable
    private final String action;
    @Nullable
    private final String mimeType;
    @NotNull
    private final List<String> arguments;
    @NotNull
    private final Map<String, ParamQuery> paramArgMap;
    @Nullable
    private String patternFinalRegex;
    @NotNull
    private final Lazy pattern$delegate;
    private boolean isParameterizedQuery;
    private boolean isSingleQueryParamValueOnly;
    @Nullable
    private String mimeTypeFinalRegex;
    @NotNull
    private final Lazy mimeTypePattern$delegate;
    private boolean isExactDeepLink;
    @Deprecated
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^[a-zA-Z]+[+\\w\\-.]*:");

    public NavDeepLink(@Nullable String uriPattern, @Nullable String action, @Nullable String mimeType) {
        this.uriPattern = uriPattern;
        this.action = action;
        this.mimeType = mimeType;
        this.arguments = new ArrayList();
        this.paramArgMap = new LinkedHashMap();
        this.pattern$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pattern>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pattern invoke() {
                Pattern pattern2;
                String string = NavDeepLink.access$getPatternFinalRegex$p(this.this$0);
                if (string == null) {
                    pattern2 = null;
                } else {
                    String it = string;
                    boolean bl = false;
                    pattern2 = Pattern.compile(it, 2);
                }
                return pattern2;
            }
        }));
        this.mimeTypePattern$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pattern>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pattern invoke() {
                Pattern pattern2;
                String string = NavDeepLink.access$getMimeTypeFinalRegex$p(this.this$0);
                if (string == null) {
                    pattern2 = null;
                } else {
                    String it = string;
                    boolean bl = false;
                    pattern2 = Pattern.compile(it);
                }
                return pattern2;
            }
        }));
        if (this.uriPattern != null) {
            Object matcher;
            Uri parameterizedUri = Uri.parse((String)this.uriPattern);
            this.isParameterizedQuery = parameterizedUri.getQuery() != null;
            StringBuilder uriRegex = new StringBuilder("^");
            if (!SCHEME_PATTERN.matcher(this.uriPattern).find()) {
                uriRegex.append("http[s]?://");
            }
            Pattern fillInPattern = Pattern.compile("\\{(.+?)\\}");
            if (this.isParameterizedQuery) {
                matcher = Pattern.compile("(\\?)").matcher(this.uriPattern);
                if (((Matcher)matcher).find()) {
                    String string = this.uriPattern;
                    int n = 0;
                    int n2 = ((Matcher)matcher).start();
                    String string2 = string.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    Intrinsics.checkNotNullExpressionValue((Object)fillInPattern, (String)"fillInPattern");
                    this.isExactDeepLink = this.buildPathRegex(string2, uriRegex, fillInPattern);
                }
                for (String paramName : parameterizedUri.getQueryParameterNames()) {
                    Object object;
                    String string;
                    StringBuilder argRegex = new StringBuilder();
                    String string3 = parameterizedUri.getQueryParameter(paramName);
                    if (string3 == null) {
                        String string4;
                        String $this$_init__u24lambda_u2d1 = string4 = paramName;
                        boolean bl = false;
                        this.isSingleQueryParamValueOnly = true;
                        string = string4;
                    } else {
                        string = string3;
                    }
                    String queryParam = string;
                    matcher = fillInPattern.matcher(queryParam);
                    int appendPos = 0;
                    ParamQuery param = new ParamQuery();
                    while (((Matcher)matcher).find()) {
                        String string5 = ((Matcher)matcher).group(1);
                        if (string5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        param.addArgumentName(string5);
                        Intrinsics.checkNotNullExpressionValue((Object)queryParam, (String)"queryParam");
                        object = queryParam;
                        int n = ((Matcher)matcher).start();
                        String string6 = ((String)object).substring(appendPos, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        argRegex.append(Pattern.quote(string6));
                        argRegex.append("(.+?)?");
                        appendPos = ((Matcher)matcher).end();
                    }
                    if (appendPos < queryParam.length()) {
                        Intrinsics.checkNotNullExpressionValue((Object)queryParam, (String)"queryParam");
                        String string7 = queryParam.substring(appendPos);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                        argRegex.append(Pattern.quote(string7));
                    }
                    object = argRegex.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"argRegex.toString()");
                    param.setParamRegex(StringsKt.replace$default((String)object, (String)".*", (String)"\\E.*\\Q", (boolean)false, (int)4, null));
                    object = this.paramArgMap;
                    Intrinsics.checkNotNullExpressionValue((Object)paramName, (String)"paramName");
                    String string8 = paramName;
                    object.put(string8, param);
                }
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)fillInPattern, (String)"fillInPattern");
                this.isExactDeepLink = this.buildPathRegex(this.uriPattern, uriRegex, fillInPattern);
            }
            matcher = uriRegex.toString();
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"uriRegex.toString()");
            this.patternFinalRegex = StringsKt.replace$default((String)matcher, (String)".*", (String)"\\E.*\\Q", (boolean)false, (int)4, null);
        }
        if (this.mimeType != null) {
            Pattern mimeTypePattern2 = Pattern.compile("^[\\s\\S]+/[\\s\\S]+$");
            Matcher mimeTypeMatcher = mimeTypePattern2.matcher(this.mimeType);
            if (!mimeTypeMatcher.matches()) {
                boolean $i$a$-require-NavDeepLink$22 = false;
                String $i$a$-require-NavDeepLink$22 = "The given mimeType " + this.getMimeType() + " does not match to required \"type/subtype\" format";
                throw new IllegalArgumentException($i$a$-require-NavDeepLink$22.toString());
            }
            MimeType splitMimeType = new MimeType(this.mimeType);
            String mimeTypeRegex = "^(" + splitMimeType.getType() + "|[*]+)/(" + splitMimeType.getSubType() + "|[*]+)$";
            this.mimeTypeFinalRegex = StringsKt.replace$default((String)mimeTypeRegex, (String)"*|[*]", (String)"[\\s\\S]", (boolean)false, (int)4, null);
        }
    }

    @Nullable
    public final String getUriPattern() {
        return this.uriPattern;
    }

    @Nullable
    public final String getAction() {
        return this.action;
    }

    @Nullable
    public final String getMimeType() {
        return this.mimeType;
    }

    private final Pattern getPattern() {
        Lazy lazy = this.pattern$delegate;
        return (Pattern)lazy.getValue();
    }

    private final Pattern getMimeTypePattern() {
        Lazy lazy = this.mimeTypePattern$delegate;
        return (Pattern)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getArgumentsNames$navigation_common_release() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.paramArgMap.values();
        Collection collection = this.arguments;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ParamQuery it = (ParamQuery)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getArguments();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isExactDeepLink() {
        return this.isExactDeepLink;
    }

    public final void setExactDeepLink$navigation_common_release(boolean bl) {
        this.isExactDeepLink = bl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public NavDeepLink(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(uri, null, null);
    }

    private final boolean buildPathRegex(String uri, StringBuilder uriRegex, Pattern fillInPattern) {
        String string;
        boolean exactDeepLink;
        Matcher matcher = fillInPattern.matcher(uri);
        int appendPos = 0;
        boolean bl = exactDeepLink = !StringsKt.contains$default((CharSequence)uri, (CharSequence)".*", (boolean)false, (int)2, null);
        while (matcher.find()) {
            String argName;
            if (matcher.group(1) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            this.arguments.add(argName);
            string = uri;
            int n = matcher.start();
            String string2 = string.substring(appendPos, n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            uriRegex.append(Pattern.quote(string2));
            uriRegex.append("([^/]+?)");
            appendPos = matcher.end();
            exactDeepLink = false;
        }
        if (appendPos < uri.length()) {
            string = uri.substring(appendPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            uriRegex.append(Pattern.quote(string));
        }
        uriRegex.append("($|(\\?(.)*)|(\\#(.)*))");
        return exactDeepLink;
    }

    public final boolean matches$navigation_common_release(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.matches$navigation_common_release(new NavDeepLinkRequest(uri, null, null));
    }

    public final boolean matches$navigation_common_release(@NotNull NavDeepLinkRequest deepLinkRequest) {
        Intrinsics.checkNotNullParameter((Object)deepLinkRequest, (String)"deepLinkRequest");
        if (!this.matchUri(deepLinkRequest.getUri())) {
            return false;
        }
        return !this.matchAction(deepLinkRequest.getAction()) ? false : this.matchMimeType(deepLinkRequest.getMimeType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchUri(Uri uri) {
        if (uri == null == (this.getPattern() != null)) {
            return false;
        }
        if (uri == null) return true;
        Pattern pattern2 = this.getPattern();
        Intrinsics.checkNotNull((Object)pattern2);
        if (!pattern2.matcher(uri.toString()).matches()) return false;
        return true;
    }

    private final boolean matchAction(String action) {
        return action == null == (this.action != null) ? false : action == null || Intrinsics.areEqual((Object)this.action, (Object)action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchMimeType(String mimeType) {
        if (mimeType == null == (this.mimeType != null)) {
            return false;
        }
        if (mimeType == null) return true;
        Pattern pattern2 = this.getMimeTypePattern();
        Intrinsics.checkNotNull((Object)pattern2);
        if (!pattern2.matcher(mimeType).matches()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final int getMimeTypeMatchRating(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        if (this.mimeType == null) return -1;
        Pattern pattern2 = this.getMimeTypePattern();
        Intrinsics.checkNotNull((Object)pattern2);
        if (!pattern2.matcher(mimeType).matches()) {
            return -1;
        }
        int n = new MimeType(this.mimeType).compareTo(new MimeType(mimeType));
        return n;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Bundle getMatchingArguments(@NotNull Uri deepLink, @NotNull Map<String, NavArgument> arguments) {
        Intrinsics.checkNotNullParameter((Object)deepLink, (String)"deepLink");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Pattern pattern2 = this.getPattern();
        Matcher matcher = pattern2 == null ? null : pattern2.matcher(deepLink.toString());
        if (matcher == null) {
            return null;
        }
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            return null;
        }
        Bundle bundle = new Bundle();
        int size = this.arguments.size();
        int n = 0;
        while (n < size) {
            int index = n++;
            String argumentName = this.arguments.get(index);
            String value = Uri.decode((String)matcher2.group(index + 1));
            NavArgument argument = arguments.get(argumentName);
            try {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                if (!this.parseArgument(bundle, argumentName, value, argument)) continue;
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (this.isParameterizedQuery) {
            for (String paramName : this.paramArgMap.keySet()) {
                Matcher argMatcher = null;
                ParamQuery storedParam = this.paramArgMap.get(paramName);
                String inputParams = deepLink.getQueryParameter(paramName);
                if (this.isSingleQueryParamValueOnly) {
                    String string = deepLink.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"deepLink.toString()");
                    String deepLinkString = string;
                    String argValue = StringsKt.substringAfter$default((String)deepLinkString, (char)'?', null, (int)2, null);
                    if (!Intrinsics.areEqual((Object)argValue, (Object)deepLinkString)) {
                        inputParams = argValue;
                    }
                }
                if (inputParams != null) {
                    ParamQuery paramQuery = storedParam;
                    Intrinsics.checkNotNull((Object)paramQuery);
                    argMatcher = Pattern.compile(paramQuery.getParamRegex(), 32).matcher(inputParams);
                    if (!argMatcher.matches()) {
                        return null;
                    }
                }
                Bundle queryParamBundle = new Bundle();
                try {
                    int n2 = 0;
                    ParamQuery paramQuery = storedParam;
                    Intrinsics.checkNotNull((Object)paramQuery);
                    int n3 = paramQuery.size();
                    while (n2 < n3) {
                        int index = n2++;
                        String value = null;
                        if (argMatcher != null) {
                            String string = argMatcher.group(index + 1);
                            if (string == null) {
                                string = "";
                            }
                            value = string;
                        }
                        String argName = storedParam.getArgumentName(index);
                        NavArgument argument = arguments.get(argName);
                        if (value == null || Intrinsics.areEqual((Object)value, (Object)('{' + argName + '}')) || !this.parseArgument(queryParamBundle, argName, value, argument)) continue;
                        return null;
                    }
                    bundle.putAll(queryParamBundle);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        for (Map.Entry<String, NavArgument> entry : arguments.entrySet()) {
            String argName = entry.getKey();
            NavArgument argument = entry.getValue();
            boolean argumentIsRequired = argument != null && !argument.isNullable() && !argument.isDefaultValuePresent();
            if (!argumentIsRequired || bundle.containsKey(argName)) continue;
            return null;
        }
        return bundle;
    }

    private final boolean parseArgument(Bundle bundle, String name, String value, NavArgument argument) {
        if (argument != null) {
            NavType<Object> type = argument.getType();
            type.parseAndPut(bundle, name, value);
        } else {
            bundle.putString(name, value);
        }
        return false;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof NavDeepLink)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.uriPattern, (Object)((NavDeepLink)other).uriPattern) && Intrinsics.areEqual((Object)this.action, (Object)((NavDeepLink)other).action) && Intrinsics.areEqual((Object)this.mimeType, (Object)((NavDeepLink)other).mimeType);
    }

    public int hashCode() {
        int result = 0;
        String string = this.uriPattern;
        result = 31 * result + (string == null ? 0 : string.hashCode());
        String string2 = this.action;
        result = 31 * result + (string2 == null ? 0 : string2.hashCode());
        String string3 = this.mimeType;
        result = 31 * result + (string3 == null ? 0 : string3.hashCode());
        return result;
    }

    public static final /* synthetic */ String access$getPatternFinalRegex$p(NavDeepLink $this) {
        return $this.patternFinalRegex;
    }

    public static final /* synthetic */ String access$getMimeTypeFinalRegex$p(NavDeepLink $this) {
        return $this.mimeTypeFinalRegex;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Landroidx/navigation/NavDeepLink$ParamQuery;", "", "()V", "arguments", "", "", "getArguments", "()Ljava/util/List;", "paramRegex", "getParamRegex", "()Ljava/lang/String;", "setParamRegex", "(Ljava/lang/String;)V", "addArgumentName", "", "name", "getArgumentName", "index", "", "size", "navigation-common_release"})
    private static final class ParamQuery {
        @Nullable
        private String paramRegex;
        @NotNull
        private final List<String> arguments = new ArrayList();

        @Nullable
        public final String getParamRegex() {
            return this.paramRegex;
        }

        public final void setParamRegex(@Nullable String string) {
            this.paramRegex = string;
        }

        @NotNull
        public final List<String> getArguments() {
            return this.arguments;
        }

        public final void addArgumentName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.arguments.add(name);
        }

        @NotNull
        public final String getArgumentName(int index) {
            return this.arguments.get(index);
        }

        public final int size() {
            return this.arguments.size();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\u0004\u00a8\u0006\u000f"}, d2={"Landroidx/navigation/NavDeepLink$MimeType;", "", "mimeType", "", "(Ljava/lang/String;)V", "subType", "getSubType", "()Ljava/lang/String;", "setSubType", "type", "getType", "setType", "compareTo", "", "other", "navigation-common_release"})
    private static final class MimeType
    implements Comparable<MimeType> {
        @NotNull
        private String type;
        @NotNull
        private String subType;

        public MimeType(@NotNull String mimeType) {
            List list;
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            CharSequence charSequence = mimeType;
            Regex regex = new Regex("/");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List typeAndSubType = list;
            this.type = (String)typeAndSubType.get(0);
            this.subType = (String)typeAndSubType.get(1);
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.type = string;
        }

        @NotNull
        public final String getSubType() {
            return this.subType;
        }

        public final void setSubType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.subType = string;
        }

        @Override
        public int compareTo(@NotNull MimeType other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int result = 0;
            if (Intrinsics.areEqual((Object)this.type, (Object)other.type)) {
                result += 2;
            }
            if (Intrinsics.areEqual((Object)this.subType, (Object)other.subType)) {
                int n = result;
                result = n + 1;
            }
            return result;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/navigation/NavDeepLink$Builder;", "", "()V", "action", "", "mimeType", "uriPattern", "build", "Landroidx/navigation/NavDeepLink;", "setAction", "setMimeType", "setUriPattern", "Companion", "navigation-common_release"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String uriPattern;
        @Nullable
        private String action;
        @Nullable
        private String mimeType;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder() {
        }

        @NotNull
        public final Builder setUriPattern(@NotNull String uriPattern) {
            Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
            this.uriPattern = uriPattern;
            return this;
        }

        @NotNull
        public final Builder setAction(@NotNull String action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            if (!(((CharSequence)action).length() > 0)) {
                boolean bl = false;
                String string = "The NavDeepLink cannot have an empty action.";
                throw new IllegalArgumentException(string.toString());
            }
            this.action = action;
            return this;
        }

        @NotNull
        public final Builder setMimeType(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            this.mimeType = mimeType;
            return this;
        }

        @NotNull
        public final NavDeepLink build() {
            return new NavDeepLink(this.uriPattern, this.action, this.mimeType);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromUriPattern(@NotNull String uriPattern) {
            return Companion.fromUriPattern(uriPattern);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromAction(@NotNull String action) {
            return Companion.fromAction(action);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromMimeType(@NotNull String mimeType) {
            return Companion.fromMimeType(mimeType);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Landroidx/navigation/NavDeepLink$Builder$Companion;", "", "()V", "fromAction", "Landroidx/navigation/NavDeepLink$Builder;", "action", "", "fromMimeType", "mimeType", "fromUriPattern", "uriPattern", "navigation-common_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder fromUriPattern(@NotNull String uriPattern) {
                Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
                Builder builder = new Builder();
                builder.setUriPattern(uriPattern);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromAction(@NotNull String action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                if (!(((CharSequence)action).length() > 0)) {
                    boolean bl = false;
                    String string = "The NavDeepLink cannot have an empty action.";
                    throw new IllegalArgumentException(string.toString());
                }
                Builder builder = new Builder();
                builder.setAction(action);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromMimeType(@NotNull String mimeType) {
                Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
                Builder builder = new Builder();
                builder.setMimeType(mimeType);
                return builder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/navigation/NavDeepLink$Companion;", "", "()V", "SCHEME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "navigation-common_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

