/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import androidx.annotation.CallSuper;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH&J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0006H\u0017J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\u00a8\u0006&"}, d2={"Landroidx/navigation/NavigatorState;", "", "()V", "_backStack", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Landroidx/navigation/NavBackStackEntry;", "_transitionsInProgress", "", "backStack", "Lkotlinx/coroutines/flow/StateFlow;", "getBackStack", "()Lkotlinx/coroutines/flow/StateFlow;", "backStackLock", "Ljava/util/concurrent/locks/ReentrantLock;", "isNavigating", "", "()Z", "setNavigating", "(Z)V", "transitionsInProgress", "getTransitionsInProgress", "createBackStackEntry", "destination", "Landroidx/navigation/NavDestination;", "arguments", "Landroid/os/Bundle;", "markTransitionComplete", "", "entry", "onLaunchSingleTop", "backStackEntry", "pop", "popUpTo", "saveState", "popWithTransition", "push", "pushWithTransition", "navigation-common_release"})
public abstract class NavigatorState {
    @NotNull
    private final ReentrantLock backStackLock = new ReentrantLock(true);
    @NotNull
    private final MutableStateFlow<List<NavBackStackEntry>> _backStack = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
    @NotNull
    private final MutableStateFlow<Set<NavBackStackEntry>> _transitionsInProgress = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private boolean isNavigating;
    @NotNull
    private final StateFlow<List<NavBackStackEntry>> backStack = FlowKt.asStateFlow(this._backStack);
    @NotNull
    private final StateFlow<Set<NavBackStackEntry>> transitionsInProgress = FlowKt.asStateFlow(this._transitionsInProgress);

    public final boolean isNavigating() {
        return this.isNavigating;
    }

    public final void setNavigating(boolean bl) {
        this.isNavigating = bl;
    }

    @NotNull
    public final StateFlow<List<NavBackStackEntry>> getBackStack() {
        return this.backStack;
    }

    @NotNull
    public final StateFlow<Set<NavBackStackEntry>> getTransitionsInProgress() {
        return this.transitionsInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(@NotNull NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        Lock lock = this.backStackLock;
        lock.lock();
        try {
            boolean bl = false;
            this._backStack.setValue((Object)CollectionsKt.plus((Collection)((Collection)this._backStack.getValue()), (Object)backStackEntry));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public void pushWithTransition(@NotNull NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        NavBackStackEntry previousEntry = (NavBackStackEntry)CollectionsKt.lastOrNull((List)((List)this.backStack.getValue()));
        if (previousEntry != null) {
            this._transitionsInProgress.setValue((Object)SetsKt.plus((Set)((Set)this._transitionsInProgress.getValue()), (Object)previousEntry));
        }
        this._transitionsInProgress.setValue((Object)SetsKt.plus((Set)((Set)this._transitionsInProgress.getValue()), (Object)backStackEntry));
        this.push(backStackEntry);
    }

    @NotNull
    public abstract NavBackStackEntry createBackStackEntry(@NotNull NavDestination var1, @Nullable Bundle var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void pop(@NotNull NavBackStackEntry popUpTo2, boolean saveState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo2, (String)"popUpTo");
        Lock lock = this.backStackLock;
        lock.lock();
        try {
            void $this$takeWhile$iv;
            boolean bl = false;
            Iterable iterable = (Iterable)this._backStack.getValue();
            MutableStateFlow<List<NavBackStackEntry>> mutableStateFlow = this._backStack;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                NavBackStackEntry it = (NavBackStackEntry)item$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)popUpTo2))) break;
                list$iv.add(item$iv);
            }
            mutableStateFlow.setValue((Object)list$iv);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public void popWithTransition(@NotNull NavBackStackEntry popUpTo2, boolean saveState) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)popUpTo2, (String)"popUpTo");
            this._transitionsInProgress.setValue((Object)SetsKt.plus((Set)((Set)this._transitionsInProgress.getValue()), (Object)popUpTo2));
            List $this$lastOrNull$iv = (List)this.backStack.getValue();
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                NavBackStackEntry entry = (NavBackStackEntry)element$iv;
                boolean bl = false;
                boolean bl2 = !Intrinsics.areEqual((Object)entry, (Object)popUpTo2) && ((List)this.backStack.getValue()).lastIndexOf(entry) < ((List)this.backStack.getValue()).lastIndexOf(popUpTo2);
                if (!bl2) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        NavBackStackEntry incomingEntry = v1;
        if (incomingEntry != null) {
            this._transitionsInProgress.setValue((Object)SetsKt.plus((Set)((Set)this._transitionsInProgress.getValue()), (Object)incomingEntry));
        }
        this.pop(popUpTo2, saveState);
    }

    @CallSuper
    public void onLaunchSingleTop(@NotNull NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        this._backStack.setValue((Object)CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)((Iterable)this._backStack.getValue()), (Object)CollectionsKt.last((List)((List)this._backStack.getValue()))), (Object)backStackEntry));
    }

    public void markTransitionComplete(@NotNull NavBackStackEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this._transitionsInProgress.setValue((Object)SetsKt.minus((Set)((Set)this._transitionsInProgress.getValue()), (Object)entry));
    }
}

