/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Bundle;
import android.util.AttributeSet;
import androidx.annotation.CallSuper;
import androidx.annotation.IdRes;
import androidx.annotation.RestrictTo;
import androidx.collection.SparseArrayCompat;
import androidx.collection.SparseArrayKt;
import androidx.navigation.NavAction;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLink;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.NavType;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.common.R;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 Z2\u00020\u0001:\u0003YZ[B\u0017\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\nJ\u000e\u00104\u001a\u0002012\u0006\u00105\u001a\u00020\u0014J\u000e\u00104\u001a\u0002012\u0006\u00106\u001a\u00020\u0006J\u0014\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u000108H\u0007J\u0014\u0010:\u001a\u00020;2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u0000H\u0007J\u0013\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001a\u0010@\u001a\u0004\u0018\u00010\u00062\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u000108J\u0012\u0010D\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010\u0018\u001a\u00020\u0019J\u0010\u0010E\u001a\u00020>2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010E\u001a\u00020>2\u0006\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020\u0019H\u0016J\u0012\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020IH\u0017J\u0018\u0010N\u001a\u0002012\u0006\u0010A\u001a\u00020B2\u0006\u0010O\u001a\u00020PH\u0017J\u0018\u0010Q\u001a\u0002012\b\b\u0001\u0010R\u001a\u00020\u00192\u0006\u0010S\u001a\u00020\rJ\u001a\u0010Q\u001a\u0002012\b\b\u0001\u0010R\u001a\u00020\u00192\b\b\u0001\u0010T\u001a\u00020\u0019J\u0010\u0010U\u001a\u0002012\b\b\u0001\u0010R\u001a\u00020\u0019J\u000e\u0010V\u001a\u0002012\u0006\u00102\u001a\u00020\u0006J\b\u0010W\u001a\u00020>H\u0017J\b\u0010X\u001a\u00020\u0006H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00068WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u0018\u001a\u00020\u00198G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0017R(\u0010(\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R(\u0010-\u001a\u0004\u0018\u00010\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0017\"\u0004\b/\u0010\u0007\u00a8\u0006\\"}, d2={"Landroidx/navigation/NavDestination;", "", "navigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "navigatorName", "", "(Ljava/lang/String;)V", "_arguments", "", "Landroidx/navigation/NavArgument;", "actions", "Landroidx/collection/SparseArrayCompat;", "Landroidx/navigation/NavAction;", "arguments", "", "getArguments", "()Ljava/util/Map;", "deepLinks", "", "Landroidx/navigation/NavDeepLink;", "displayName", "getDisplayName", "()Ljava/lang/String;", "id", "", "getId", "()I", "setId", "(I)V", "idName", "label", "", "getLabel", "()Ljava/lang/CharSequence;", "setLabel", "(Ljava/lang/CharSequence;)V", "getNavigatorName", "<set-?>", "Landroidx/navigation/NavGraph;", "parent", "getParent", "()Landroidx/navigation/NavGraph;", "setParent", "(Landroidx/navigation/NavGraph;)V", "route", "getRoute", "setRoute", "addArgument", "", "argumentName", "argument", "addDeepLink", "navDeepLink", "uriPattern", "addInDefaultArgs", "Landroid/os/Bundle;", "args", "buildDeepLinkIds", "", "previousDestination", "equals", "", "other", "fillInLabel", "context", "Landroid/content/Context;", "bundle", "getAction", "hasDeepLink", "deepLink", "Landroid/net/Uri;", "deepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "hashCode", "matchDeepLink", "Landroidx/navigation/NavDestination$DeepLinkMatch;", "navDeepLinkRequest", "onInflate", "attrs", "Landroid/util/AttributeSet;", "putAction", "actionId", "action", "destId", "removeAction", "removeArgument", "supportsActions", "toString", "ClassType", "Companion", "DeepLinkMatch", "navigation-common_release"})
public class NavDestination {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String navigatorName;
    @Nullable
    private NavGraph parent;
    @Nullable
    private String idName;
    @Nullable
    private CharSequence label;
    @NotNull
    private final List<NavDeepLink> deepLinks;
    @NotNull
    private final SparseArrayCompat<NavAction> actions;
    @NotNull
    private Map<String, NavArgument> _arguments;
    private int id;
    @Nullable
    private String route;
    @NotNull
    private static final Map<String, Class<?>> classes = new LinkedHashMap();

    public NavDestination(@NotNull String navigatorName) {
        Intrinsics.checkNotNullParameter((Object)navigatorName, (String)"navigatorName");
        this.navigatorName = navigatorName;
        this.deepLinks = new ArrayList();
        this.actions = new SparseArrayCompat();
        this._arguments = new LinkedHashMap();
    }

    @NotNull
    public final String getNavigatorName() {
        return this.navigatorName;
    }

    @Nullable
    public final NavGraph getParent() {
        return this.parent;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void setParent(@Nullable NavGraph navGraph) {
        this.parent = navGraph;
    }

    @Nullable
    public final CharSequence getLabel() {
        return this.label;
    }

    public final void setLabel(@Nullable CharSequence charSequence) {
        this.label = charSequence;
    }

    @NotNull
    public final Map<String, NavArgument> getArguments() {
        return MapsKt.toMap(this._arguments);
    }

    public NavDestination(@NotNull Navigator<? extends NavDestination> navigator) {
        Intrinsics.checkNotNullParameter(navigator, (String)"navigator");
        this(NavigatorProvider.Companion.getNameForNavigator$navigation_common_release(navigator.getClass()));
    }

    @CallSuper
    public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.Navigator);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.resources.obtain\u2026s, R.styleable.Navigator)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray array = $this$use$iv;
        boolean bl = false;
        this.setRoute(array.getString(R.styleable.Navigator_route));
        if (array.hasValue(R.styleable.Navigator_android_id)) {
            this.setId(array.getResourceId(R.styleable.Navigator_android_id, 0));
            this.idName = Companion.getDisplayName(context, this.id);
        }
        this.label = array.getText(R.styleable.Navigator_android_label);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl2 = false;
        $this$use$iv.recycle();
    }

    @IdRes
    public final int getId() {
        return this.id;
    }

    public final void setId(@IdRes int id) {
        this.id = id;
        this.idName = null;
    }

    @Nullable
    public final String getRoute() {
        return this.route;
    }

    public final void setRoute(@Nullable String route) {
        Object v0;
        Collection collection;
        block4: {
            if (route == null) {
                this.setId(0);
            } else {
                if (!(!StringsKt.isBlank((CharSequence)route))) {
                    boolean $i$a$-require-NavDestination$route$22 = false;
                    String $i$a$-require-NavDestination$route$22 = "Cannot have an empty route";
                    throw new IllegalArgumentException($i$a$-require-NavDestination$route$22.toString());
                }
                String internalRoute = Companion.createRoute(route);
                this.setId(internalRoute.hashCode());
                this.addDeepLink(internalRoute);
            }
            collection = this.deepLinks;
            Iterable $this$firstOrNull$iv = this.deepLinks;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NavDeepLink it = (NavDeepLink)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUriPattern(), (Object)Companion.createRoute(this.route))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Object var3_4 = v0;
        TypeIntrinsics.asMutableCollection((Object)collection).remove(var3_4);
        this.route = route;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public String getDisplayName() {
        String string = this.idName;
        if (string == null) {
            string = String.valueOf(this.id);
        }
        return string;
    }

    public boolean hasDeepLink(@NotNull Uri deepLink) {
        Intrinsics.checkNotNullParameter((Object)deepLink, (String)"deepLink");
        return this.hasDeepLink(new NavDeepLinkRequest(deepLink, null, null));
    }

    public boolean hasDeepLink(@NotNull NavDeepLinkRequest deepLinkRequest) {
        Intrinsics.checkNotNullParameter((Object)deepLinkRequest, (String)"deepLinkRequest");
        return this.matchDeepLink(deepLinkRequest) != null;
    }

    public final void addDeepLink(@NotNull String uriPattern) {
        Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
        this.addDeepLink(new NavDeepLink.Builder().setUriPattern(uriPattern).build());
    }

    /*
     * WARNING - void declaration
     */
    public final void addDeepLink(@NotNull NavDeepLink navDeepLink) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)navDeepLink, (String)"navDeepLink");
        Map<String, NavArgument> $this$filterValues$iv = this.getArguments();
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry<String, NavArgument> entry$iv : $this$filterValues$iv.entrySet()) {
            NavArgument it = entry$iv.getValue();
            boolean bl = false;
            if (!(!it.isNullable() && !it.isDefaultValuePresent())) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$filter$iv = ((Map)result$iv).keySet();
        boolean $i$f$filter = false;
        result$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!navDeepLink.getArgumentsNames$navigation_common_release().contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingRequiredArguments = (List)destination$iv$iv;
        if (!missingRequiredArguments.isEmpty()) {
            boolean bl = false;
            String string = "Deep link " + navDeepLink.getUriPattern() + " can't be used to open destination " + this + ".\nFollowing required arguments are missing: " + missingRequiredArguments;
            throw new IllegalArgumentException(string.toString());
        }
        this.deepLinks.add(navDeepLink);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public DeepLinkMatch matchDeepLink(@NotNull NavDeepLinkRequest navDeepLinkRequest) {
        Intrinsics.checkNotNullParameter((Object)navDeepLinkRequest, (String)"navDeepLinkRequest");
        if (this.deepLinks.isEmpty()) {
            return null;
        }
        DeepLinkMatch bestMatch = null;
        for (NavDeepLink deepLink : this.deepLinks) {
            int mimeTypeMatchLevel;
            String mimeType;
            Uri uri;
            Uri uri2 = uri = navDeepLinkRequest.getUri();
            Bundle matchingArguments = uri2 != null ? deepLink.getMatchingArguments(uri2, this.getArguments()) : null;
            int matchingPathSegments = deepLink.calculateMatchingPathSegments$navigation_common_release(uri);
            String requestAction = navDeepLinkRequest.getAction();
            boolean matchingAction = requestAction != null && Intrinsics.areEqual((Object)requestAction, (Object)deepLink.getAction());
            String string = mimeType = navDeepLinkRequest.getMimeType();
            int n = mimeTypeMatchLevel = string != null ? deepLink.getMimeTypeMatchRating(string) : -1;
            if (matchingArguments == null && !matchingAction && mimeTypeMatchLevel <= -1) continue;
            DeepLinkMatch newMatch = new DeepLinkMatch(this, matchingArguments, deepLink.isExactDeepLink(), matchingPathSegments, matchingAction, mimeTypeMatchLevel);
            if (bestMatch != null && newMatch.compareTo(bestMatch) <= 0) continue;
            bestMatch = newMatch;
        }
        return bestMatch;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final int[] buildDeepLinkIds(@Nullable NavDestination previousDestination) {
        void $this$mapTo$iv$iv;
        NavGraph parent;
        ArrayDeque hierarchy2 = new ArrayDeque();
        NavDestination current = this;
        do {
            NavDestination navDestination = current;
            Intrinsics.checkNotNull((Object)navDestination);
            parent = navDestination.parent;
            NavDestination navDestination2 = previousDestination;
            if ((navDestination2 != null ? navDestination2.parent : null) != null) {
                NavGraph navGraph = previousDestination.parent;
                Intrinsics.checkNotNull((Object)navGraph);
                if (navGraph.findNode(current.id) == current) {
                    hierarchy2.addFirst((Object)current);
                    break;
                }
            }
            if (parent != null && parent.getStartDestinationId() == current.id) continue;
            hierarchy2.addFirst((Object)current);
        } while (!Intrinsics.areEqual((Object)parent, (Object)previousDestination) && (current = (NavDestination)parent) != null);
        Iterable $this$map$iv = CollectionsKt.toList((Iterable)((Iterable)hierarchy2));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NavDestination navDestination = (NavDestination)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.id);
        }
        return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
    }

    public static /* synthetic */ int[] buildDeepLinkIds$default(NavDestination navDestination, NavDestination navDestination2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildDeepLinkIds");
        }
        if ((n & 1) != 0) {
            navDestination2 = null;
        }
        return navDestination.buildDeepLinkIds(navDestination2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean supportsActions() {
        return true;
    }

    @Nullable
    public final NavAction getAction(@IdRes int id) {
        NavAction destination = this.actions.isEmpty() ? null : (NavAction)this.actions.get(id);
        NavAction navAction = destination;
        if (navAction == null) {
            NavGraph navGraph = this.parent;
            if (navGraph != null) {
                NavGraph $this$getAction_u24lambda_u247 = navGraph;
                boolean bl = false;
                navAction = $this$getAction_u24lambda_u247.getAction(id);
            } else {
                navAction = null;
            }
        }
        return navAction;
    }

    public final void putAction(@IdRes int actionId, @IdRes int destId) {
        this.putAction(actionId, new NavAction(destId, null, null, 6, null));
    }

    public final void putAction(@IdRes int actionId, @NotNull NavAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (!this.supportsActions()) {
            throw new UnsupportedOperationException("Cannot add action " + actionId + " to " + this + " as it does not support actions, indicating that it is a terminal destination in your navigation graph and will never trigger actions.");
        }
        if (!(actionId != 0)) {
            boolean bl = false;
            String string = "Cannot have an action with actionId 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.actions.put(actionId, (Object)action);
    }

    public final void removeAction(@IdRes int actionId) {
        this.actions.remove(actionId);
    }

    public final void addArgument(@NotNull String argumentName, @NotNull NavArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        this._arguments.put(argumentName, argument);
    }

    public final void removeArgument(@NotNull String argumentName) {
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        this._arguments.remove(argumentName);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Bundle addInDefaultArgs(@Nullable Bundle args) {
        NavArgument value;
        String key;
        Map<String, NavArgument> map;
        if (args == null && ((map = this._arguments) == null || map.isEmpty())) {
            return null;
        }
        Bundle defaultArgs = new Bundle();
        for (Map.Entry<String, NavArgument> entry : this._arguments.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            value.putDefaultValue(key, defaultArgs);
        }
        if (args != null) {
            defaultArgs.putAll(args);
            for (Map.Entry<String, NavArgument> entry : this._arguments.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value.verify(key, defaultArgs)) continue;
                boolean bl = false;
                String string = "Wrong argument type for '" + key + "' in argument bundle. " + value.getType().getName() + " expected.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        return defaultArgs;
    }

    @Nullable
    public final String fillInLabel(@NotNull Context context, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = this.label;
        if (charSequence == null) {
            return null;
        }
        CharSequence label = charSequence;
        Pattern fillInPattern = Pattern.compile("\\{(.+?)\\}");
        Matcher matcher = fillInPattern.matcher(label);
        StringBuffer builder = new StringBuffer();
        while (matcher.find()) {
            String argName = matcher.group(1);
            if (bundle != null && bundle.containsKey(argName)) {
                NavType<Object> argType;
                NavType<Object> navType;
                matcher.appendReplacement(builder, "");
                if (argName != null) {
                    boolean bl = false;
                    NavArgument navArgument = this.getArguments().get(argName);
                    navType = navArgument != null ? navArgument.getType() : null;
                } else {
                    navType = argType = null;
                }
                if (Intrinsics.areEqual(argType, NavType.ReferenceType)) {
                    String value;
                    Intrinsics.checkNotNullExpressionValue((Object)context.getString(bundle.getInt(argName)), (String)"context.getString(bundle.getInt(argName))");
                    builder.append(value);
                    continue;
                }
                builder.append(bundle.getString(argName));
                continue;
            }
            throw new IllegalArgumentException("Could not find \"" + argName + "\" in " + bundle + " to fill label \"" + label + '\"');
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        if (this.idName == null) {
            sb.append("0x");
            sb.append(Integer.toHexString(this.id));
        } else {
            sb.append(this.idName);
        }
        sb.append(")");
        CharSequence charSequence = this.route;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            sb.append(" route=");
            sb.append(this.route);
        }
        if (this.label != null) {
            sb.append(" label=");
            sb.append(this.label);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(@Nullable Object other) {
        block12: {
            block11: {
                block10: {
                    block9: {
                        if (other == null || !(other instanceof NavDestination)) {
                            return false;
                        }
                        v0 = equalDeepLinks = CollectionsKt.intersect((Iterable)this.deepLinks, (Iterable)((NavDestination)other).deepLinks).size() == this.deepLinks.size();
                        if (this.actions.size() != ((NavDestination)other).actions.size()) ** GOTO lbl-1000
                        $this$all$iv = SequencesKt.asSequence((Iterator)SparseArrayKt.valueIterator(this.actions));
                        $i$f$all = false;
                        for (E element$iv : $this$all$iv) {
                            it = (NavAction)element$iv;
                            $i$a$-all-NavDestination$equals$equalActions$1 = false;
                            if (((NavDestination)other).actions.containsValue((Object)it)) continue;
                            v1 = false;
                            break block9;
                        }
                        v1 = true;
                    }
                    if (!v1) ** GOTO lbl-1000
                    $this$all$iv = SequencesKt.asSequence((Iterator)SparseArrayKt.valueIterator(((NavDestination)other).actions));
                    $i$f$all = false;
                    for (E element$iv : $this$all$iv) {
                        it = (NavAction)element$iv;
                        $i$a$-all-NavDestination$equals$equalActions$2 = false;
                        if (this.actions.containsValue((Object)it)) continue;
                        v2 = false;
                        break block10;
                    }
                    v2 = true;
                }
                if (v2) {
                    v3 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v3 = equalActions = false;
                }
                if (this.getArguments().size() != ((NavDestination)other).getArguments().size()) ** GOTO lbl-1000
                $this$all$iv = MapsKt.asSequence(this.getArguments());
                $i$f$all = false;
                for (E element$iv : $this$all$iv) {
                    it = (Map.Entry)element$iv;
                    $i$a$-all-NavDestination$equals$equalArguments$1 = false;
                    if (((NavDestination)other).getArguments().containsKey(it.getKey()) && Intrinsics.areEqual((Object)((NavDestination)other).getArguments().get(it.getKey()), it.getValue())) continue;
                    v4 = false;
                    break block11;
                }
                v4 = true;
            }
            if (!v4) ** GOTO lbl-1000
            $this$all$iv = MapsKt.asSequence(((NavDestination)other).getArguments());
            $i$f$all = false;
            for (E element$iv : $this$all$iv) {
                it = (Map.Entry)element$iv;
                $i$a$-all-NavDestination$equals$equalArguments$2 = false;
                if (this.getArguments().containsKey(it.getKey()) && Intrinsics.areEqual((Object)this.getArguments().get(it.getKey()), it.getValue())) continue;
                v5 = false;
                break block12;
            }
            v5 = true;
        }
        if (v5) {
            v6 = true;
        } else lbl-1000:
        // 3 sources

        {
            v6 = false;
        }
        equalArguments = v6;
        return this.id == ((NavDestination)other).id && Intrinsics.areEqual((Object)this.route, (Object)((NavDestination)other).route) != false && equalDeepLinks != false && equalActions != false && equalArguments != false;
    }

    public int hashCode() {
        Object it;
        Object element$iv;
        int result = 0;
        result = this.id;
        String string = this.route;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        Object $this$forEach$iv = this.deepLinks;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it = (NavDeepLink)element$iv;
            boolean bl = false;
            String string2 = ((NavDeepLink)it).getUriPattern();
            result = 31 * result + (string2 != null ? string2.hashCode() : 0);
            String string3 = ((NavDeepLink)it).getAction();
            result = 31 * result + (string3 != null ? string3.hashCode() : 0);
            String string4 = ((NavDeepLink)it).getMimeType();
            result = 31 * result + (string4 != null ? string4.hashCode() : 0);
        }
        $this$forEach$iv = SparseArrayKt.valueIterator(this.actions);
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Set set;
            element$iv = iterator2.next();
            NavAction value = (NavAction)element$iv;
            boolean bl = false;
            result = 31 * result + value.getDestinationId();
            NavOptions navOptions = value.getNavOptions();
            result = 31 * result + (navOptions != null ? ((Object)navOptions).hashCode() : 0);
            Object object = value.getDefaultArguments();
            if (object == null || (object = (set = object.keySet())) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"keySet()");
            Iterable $this$forEach$iv2 = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it2 = (String)element$iv2;
                boolean bl2 = false;
                Bundle bundle = value.getDefaultArguments();
                Intrinsics.checkNotNull((Object)bundle);
                Object object2 = bundle.get(it2);
                result = 31 * result + (object2 != null ? object2.hashCode() : 0);
            }
        }
        $this$forEach$iv = this.getArguments().keySet();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
            result = 31 * result + ((String)it).hashCode();
            NavArgument navArgument = this.getArguments().get(it);
            result = 31 * result + (navArgument != null ? ((Object)navArgument).hashCode() : 0);
        }
        return result;
    }

    @JvmOverloads
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final int[] buildDeepLinkIds() {
        return NavDestination.buildDeepLinkIds$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    protected static final <C> Class<? extends C> parseClassFromName(@NotNull Context context, @NotNull String name, @NotNull Class<? extends C> expectedClassType) {
        return Companion.parseClassFromName(context, name, expectedClassType);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final <C> Class<? extends C> parseClassFromNameInternal(@NotNull Context context, @NotNull String name, @NotNull Class<? extends C> expectedClassType) {
        return Companion.parseClassFromNameInternal(context, name, expectedClassType);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final String getDisplayName(@NotNull Context context, int id) {
        return Companion.getDisplayName(context, id);
    }

    @NotNull
    public static final Sequence<NavDestination> getHierarchy(@NotNull NavDestination $this$getHierarchy) {
        return Companion.getHierarchy($this$getHierarchy);
    }

    @Retention(value=AnnotationRetention.BINARY)
    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.ANNOTATION_CLASS, AnnotationTarget.CLASS})
    @java.lang.annotation.Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0002\u0018\u00002\u00020\u0001B\f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003R\u0013\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/navigation/NavDestination$ClassType;", "", "value", "Lkotlin/reflect/KClass;", "()Ljava/lang/Class;", "navigation-common_release"})
    public static @interface ClassType {
        public Class<?> value();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/navigation/NavDestination$DeepLinkMatch;", "", "destination", "Landroidx/navigation/NavDestination;", "matchingArgs", "Landroid/os/Bundle;", "isExactDeepLink", "", "matchingPathSegments", "", "hasMatchingAction", "mimeTypeMatchLevel", "(Landroidx/navigation/NavDestination;Landroid/os/Bundle;ZIZI)V", "getDestination", "()Landroidx/navigation/NavDestination;", "getMatchingArgs", "()Landroid/os/Bundle;", "compareTo", "other", "navigation-common_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class DeepLinkMatch
    implements Comparable<DeepLinkMatch> {
        @NotNull
        private final NavDestination destination;
        @Nullable
        private final Bundle matchingArgs;
        private final boolean isExactDeepLink;
        private final int matchingPathSegments;
        private final boolean hasMatchingAction;
        private final int mimeTypeMatchLevel;

        public DeepLinkMatch(@NotNull NavDestination destination, @Nullable Bundle matchingArgs, boolean isExactDeepLink, int matchingPathSegments, boolean hasMatchingAction, int mimeTypeMatchLevel) {
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            this.destination = destination;
            this.matchingArgs = matchingArgs;
            this.isExactDeepLink = isExactDeepLink;
            this.matchingPathSegments = matchingPathSegments;
            this.hasMatchingAction = hasMatchingAction;
            this.mimeTypeMatchLevel = mimeTypeMatchLevel;
        }

        @NotNull
        public final NavDestination getDestination() {
            return this.destination;
        }

        @Nullable
        public final Bundle getMatchingArgs() {
            return this.matchingArgs;
        }

        @Override
        public int compareTo(@NotNull DeepLinkMatch other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this.isExactDeepLink && !other.isExactDeepLink) {
                return 1;
            }
            if (!this.isExactDeepLink && other.isExactDeepLink) {
                return -1;
            }
            int pathSegmentDifference = this.matchingPathSegments - other.matchingPathSegments;
            if (pathSegmentDifference > 0) {
                return 1;
            }
            if (pathSegmentDifference < 0) {
                return -1;
            }
            if (this.matchingArgs != null && other.matchingArgs == null) {
                return 1;
            }
            if (this.matchingArgs == null && other.matchingArgs != null) {
                return -1;
            }
            if (this.matchingArgs != null) {
                int n = this.matchingArgs.size();
                Bundle bundle = other.matchingArgs;
                Intrinsics.checkNotNull((Object)bundle);
                int sizeDifference = n - bundle.size();
                if (sizeDifference > 0) {
                    return 1;
                }
                if (sizeDifference < 0) {
                    return -1;
                }
            }
            if (this.hasMatchingAction && !other.hasMatchingAction) {
                return 1;
            }
            if (!this.hasMatchingAction && other.hasMatchingAction) {
                return -1;
            }
            return this.mimeTypeMatchLevel - other.mimeTypeMatchLevel;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J:\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00160\u0006\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00052\u0010\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00160\u0006H\u0005J:\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00160\u0006\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00052\u0010\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00160\u0006H\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Landroidx/navigation/NavDestination$Companion;", "", "()V", "classes", "", "", "Ljava/lang/Class;", "hierarchy", "Lkotlin/sequences/Sequence;", "Landroidx/navigation/NavDestination;", "getHierarchy$annotations", "(Landroidx/navigation/NavDestination;)V", "getHierarchy", "(Landroidx/navigation/NavDestination;)Lkotlin/sequences/Sequence;", "createRoute", "route", "getDisplayName", "context", "Landroid/content/Context;", "id", "", "parseClassFromName", "C", "name", "expectedClassType", "parseClassFromNameInternal", "navigation-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        protected final <C> Class<? extends C> parseClassFromName(@NotNull Context context, @NotNull String name, @NotNull Class<? extends C> expectedClassType) {
            Class<?> clazz;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(expectedClassType, (String)"expectedClassType");
            String innerName = null;
            innerName = name;
            if (innerName.charAt(0) == '.') {
                innerName = context.getPackageName() + innerName;
            }
            if ((clazz = (Class<?>)classes.get(innerName)) == null) {
                try {
                    clazz = Class.forName(innerName, true, context.getClassLoader());
                    classes.put(name, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            Class<?> clazz2 = clazz;
            Intrinsics.checkNotNull((Object)clazz2);
            if (!expectedClassType.isAssignableFrom(clazz2)) {
                boolean bl = false;
                String string = innerName + " must be a subclass of " + expectedClassType;
                throw new IllegalArgumentException(string.toString());
            }
            return clazz;
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final <C> Class<? extends C> parseClassFromNameInternal(@NotNull Context context, @NotNull String name, @NotNull Class<? extends C> expectedClassType) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(expectedClassType, (String)"expectedClassType");
            return NavDestination.parseClassFromName(context, name, expectedClassType);
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final String getDisplayName(@NotNull Context context, int id) {
            String string;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (id <= 0xFFFFFF) {
                string = String.valueOf(id);
            } else {
                String string2;
                try {
                    string2 = context.getResources().getResourceName(id);
                }
                catch (Resources.NotFoundException e) {
                    string2 = String.valueOf(id);
                }
                String string3 = string2;
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"try {\n                co\u2026.toString()\n            }");
            }
            return string;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final String createRoute(@Nullable String route) {
            return route != null ? "android-app://androidx.navigation/" + route : "";
        }

        @NotNull
        public final Sequence<NavDestination> getHierarchy(@NotNull NavDestination $this$hierarchy) {
            Intrinsics.checkNotNullParameter((Object)$this$hierarchy, (String)"<this>");
            return SequencesKt.generateSequence((Object)$this$hierarchy, (Function1)hierarchy.1.INSTANCE);
        }

        @JvmStatic
        public static /* synthetic */ void getHierarchy$annotations(NavDestination navDestination) {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

