/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.annotation.IdRes;
import androidx.navigation.NavAction;
import androidx.navigation.NavActionBuilder;
import androidx.navigation.NavArgument;
import androidx.navigation.NavArgumentBuilder;
import androidx.navigation.NavDeepLink;
import androidx.navigation.NavDeepLinkDslBuilder;
import androidx.navigation.NavDestination;
import androidx.navigation.NavDestinationDsl;
import androidx.navigation.Navigator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NavDestinationDsl
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B!\b\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB+\b\u0000\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ)\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\"0%\u00a2\u0006\u0002\b'H\u0007J'\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\n2\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\"0%\u00a2\u0006\u0002\b'J\r\u0010,\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010-J\u001f\u0010.\u001a\u00020\"2\u0017\u0010/\u001a\u0013\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\"0%\u00a2\u0006\u0002\b'J\u000e\u0010.\u001a\u00020\"2\u0006\u00101\u001a\u00020\nR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00062"}, d2={"Landroidx/navigation/NavDestinationBuilder;", "D", "Landroidx/navigation/NavDestination;", "", "navigator", "Landroidx/navigation/Navigator;", "id", "", "(Landroidx/navigation/Navigator;I)V", "route", "", "(Landroidx/navigation/Navigator;Ljava/lang/String;)V", "(Landroidx/navigation/Navigator;ILjava/lang/String;)V", "actions", "", "Landroidx/navigation/NavAction;", "arguments", "Landroidx/navigation/NavArgument;", "deepLinks", "", "Landroidx/navigation/NavDeepLink;", "getId", "()I", "label", "", "getLabel", "()Ljava/lang/CharSequence;", "setLabel", "(Ljava/lang/CharSequence;)V", "getNavigator", "()Landroidx/navigation/Navigator;", "getRoute", "()Ljava/lang/String;", "action", "", "actionId", "actionBuilder", "Lkotlin/Function1;", "Landroidx/navigation/NavActionBuilder;", "Lkotlin/ExtensionFunctionType;", "argument", "name", "argumentBuilder", "Landroidx/navigation/NavArgumentBuilder;", "build", "()Landroidx/navigation/NavDestination;", "deepLink", "navDeepLink", "Landroidx/navigation/NavDeepLinkDslBuilder;", "uriPattern", "navigation-common_release"})
public class NavDestinationBuilder<D extends NavDestination> {
    @NotNull
    private final Navigator<? extends D> navigator;
    private final int id;
    @Nullable
    private final String route;
    @Nullable
    private CharSequence label;
    @NotNull
    private Map<String, NavArgument> arguments;
    @NotNull
    private List<NavDeepLink> deepLinks;
    @NotNull
    private Map<Integer, NavAction> actions;

    public NavDestinationBuilder(@NotNull Navigator<? extends D> navigator, @IdRes int id, @Nullable String route) {
        Intrinsics.checkNotNullParameter(navigator, (String)"navigator");
        this.navigator = navigator;
        this.id = id;
        this.route = route;
        this.arguments = new LinkedHashMap();
        this.deepLinks = new ArrayList();
        this.actions = new LinkedHashMap();
    }

    @NotNull
    protected final Navigator<? extends D> getNavigator() {
        return this.navigator;
    }

    public final int getId() {
        return this.id;
    }

    @Nullable
    public final String getRoute() {
        return this.route;
    }

    @Deprecated(message="Use routes to build your NavDestination instead", replaceWith=@ReplaceWith(expression="NavDestinationBuilder(navigator, route = id.toString())", imports={}))
    public NavDestinationBuilder(@NotNull Navigator<? extends D> navigator, @IdRes int id) {
        Intrinsics.checkNotNullParameter(navigator, (String)"navigator");
        this(navigator, id, null);
    }

    public NavDestinationBuilder(@NotNull Navigator<? extends D> navigator, @Nullable String route) {
        Intrinsics.checkNotNullParameter(navigator, (String)"navigator");
        this(navigator, -1, route);
    }

    @Nullable
    public final CharSequence getLabel() {
        return this.label;
    }

    public final void setLabel(@Nullable CharSequence charSequence) {
        this.label = charSequence;
    }

    public final void argument(@NotNull String name, @NotNull Function1<? super NavArgumentBuilder, Unit> argumentBuilder) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(argumentBuilder, (String)"argumentBuilder");
        Map<String, NavArgument> map = this.arguments;
        Object object = new NavArgumentBuilder();
        argumentBuilder.invoke(object);
        object = ((NavArgumentBuilder)object).build();
        map.put(name, (NavArgument)object);
    }

    public final void deepLink(@NotNull String uriPattern) {
        Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
        this.deepLinks.add(new NavDeepLink(uriPattern));
    }

    public final void deepLink(@NotNull Function1<? super NavDeepLinkDslBuilder, Unit> navDeepLink) {
        Intrinsics.checkNotNullParameter(navDeepLink, (String)"navDeepLink");
        NavDeepLinkDslBuilder navDeepLinkDslBuilder = new NavDeepLinkDslBuilder();
        navDeepLink.invoke((Object)navDeepLinkDslBuilder);
        this.deepLinks.add(navDeepLinkDslBuilder.build$navigation_common_release());
    }

    @Deprecated(message="Building NavDestinations using IDs with the Kotlin DSL has been deprecated in favor of using routes. When using routes there is no need for actions.")
    public final void action(int actionId, @NotNull Function1<? super NavActionBuilder, Unit> actionBuilder) {
        Intrinsics.checkNotNullParameter(actionBuilder, (String)"actionBuilder");
        Map<Integer, NavAction> map = this.actions;
        Integer n = actionId;
        Object object = new NavActionBuilder();
        actionBuilder.invoke(object);
        object = ((NavActionBuilder)object).build$navigation_common_release();
        map.put(n, (NavAction)object);
    }

    @NotNull
    public D build() {
        Map.Entry<String, NavArgument> entry;
        Map.Entry<Object, Object> element$iv;
        D d;
        D destination = d = this.navigator.createDestination();
        boolean bl = false;
        if (this.route != null) {
            ((NavDestination)destination).setRoute(this.route);
        }
        if (this.id != -1) {
            ((NavDestination)destination).setId(this.id);
        }
        ((NavDestination)destination).setLabel(this.label);
        Map<Integer, NavAction> $this$forEach$iv = this.arguments;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Object, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl2 = false;
            String name = entry.getKey();
            NavArgument argument = entry.getValue();
            ((NavDestination)destination).addArgument(name, argument);
        }
        $this$forEach$iv = this.deepLinks;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            NavDeepLink deepLink = (NavDeepLink)((Object)element$iv);
            boolean bl3 = false;
            ((NavDestination)destination).addDeepLink(deepLink);
        }
        $this$forEach$iv = this.actions;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl4 = false;
            int actionId = ((Number)((Object)entry.getKey())).intValue();
            NavAction action = (NavAction)((Object)entry.getValue());
            ((NavDestination)destination).putAction(actionId, action);
        }
        return d;
    }
}

