/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 k2\u00020\u0001:\u0004jklmB\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\b\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ*\u0010;\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\n\u0010>\u001a\u00060?j\u0002`@H\u0002J\u0017\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010DH\u0000\u00a2\u0006\u0002\bEJ\u0013\u0010F\u001a\u00020\"2\b\u0010G\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J(\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020D2\u0014\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010M0LH\u0007J.\u0010N\u001a\u00020\"2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020I2\u0014\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010M0LH\u0002J.\u0010R\u001a\u00020\"2\u0006\u0010J\u001a\u00020D2\u0006\u0010Q\u001a\u00020I2\u0014\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010M0LH\u0002J0\u0010S\u001a\u00020<2\b\u0010T\u001a\u0004\u0018\u00010\u00032\u0006\u0010Q\u001a\u00020I2\u0014\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010M0LH\u0002J\u0010\u0010U\u001a\u00020B2\u0006\u0010\u0007\u001a\u00020\u0003H\u0007J\b\u0010V\u001a\u00020BH\u0016J\u0012\u0010W\u001a\u00020\"2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010X\u001a\u00020\"2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010Y\u001a\u00020\"2\b\u0010\u0002\u001a\u0004\u0018\u00010DH\u0002J\u0015\u0010Z\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020DH\u0000\u00a2\u0006\u0002\b[J\u0015\u0010Z\u001a\u00020\"2\u0006\u0010\\\u001a\u00020]H\u0000\u00a2\u0006\u0002\b[J*\u0010^\u001a\u00020\"2\u0006\u0010Q\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00032\u0006\u0010`\u001a\u00020\u00032\b\u0010a\u001a\u0004\u0018\u00010MH\u0002J,\u0010b\u001a\u00020\"2\u0006\u0010Q\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00032\b\u0010`\u001a\u0004\u0018\u00010\u00032\b\u0010a\u001a\u0004\u0018\u00010MH\u0002J\u001c\u0010c\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0010\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0015H\u0002J>\u0010d\u001a\u00020\"2\u000e\u0010e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f2\u0006\u0010f\u001a\u0002062\u0006\u0010Q\u001a\u00020I2\u0014\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010M0LH\u0002J\b\u0010g\u001a\u00020<H\u0002J\b\u0010h\u001a\u00020<H\u0002J\u0014\u0010i\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020605H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0011\u0010\u000eR/\u0010\u0014\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0010\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0013\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001e\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0013\u001a\u0004\b\u001f\u0010\nR&\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"8G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001b\u0010'\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0013\u001a\u0004\b'\u0010$R\u000e\u0010)\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\nR\u001d\u0010+\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0013\u001a\u0004\b,\u0010\u001cR\u0010\u0010.\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u00100\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u0013\u001a\u0004\b1\u0010\u001cR\u0010\u00103\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u000206058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010\u0013\u001a\u0004\b7\u00108R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\n\u00a8\u0006n"}, d2={"Landroidx/navigation/NavDeepLink;", "", "uri", "", "(Ljava/lang/String;)V", "uriPattern", "action", "mimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "argumentsNames", "", "getArgumentsNames$navigation_common_release", "()Ljava/util/List;", "fragArgs", "", "getFragArgs", "fragArgs$delegate", "Lkotlin/Lazy;", "fragArgsAndRegex", "Lkotlin/Pair;", "getFragArgsAndRegex", "()Lkotlin/Pair;", "fragArgsAndRegex$delegate", "fragPattern", "Ljava/util/regex/Pattern;", "getFragPattern", "()Ljava/util/regex/Pattern;", "fragPattern$delegate", "fragRegex", "getFragRegex", "fragRegex$delegate", "<set-?>", "", "isExactDeepLink", "()Z", "setExactDeepLink$navigation_common_release", "(Z)V", "isParameterizedQuery", "isParameterizedQuery$delegate", "isSingleQueryParamValueOnly", "getMimeType", "mimeTypePattern", "getMimeTypePattern", "mimeTypePattern$delegate", "mimeTypeRegex", "pathArgs", "pathPattern", "getPathPattern", "pathPattern$delegate", "pathRegex", "queryArgsMap", "", "Landroidx/navigation/NavDeepLink$ParamQuery;", "getQueryArgsMap", "()Ljava/util/Map;", "queryArgsMap$delegate", "getUriPattern", "buildRegex", "", "args", "uriRegex", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "calculateMatchingPathSegments", "", "requestedLink", "Landroid/net/Uri;", "calculateMatchingPathSegments$navigation_common_release", "equals", "other", "getMatchingArguments", "Landroid/os/Bundle;", "deepLink", "arguments", "", "Landroidx/navigation/NavArgument;", "getMatchingPathArguments", "matcher", "Ljava/util/regex/Matcher;", "bundle", "getMatchingQueryArguments", "getMatchingUriFragment", "fragment", "getMimeTypeMatchRating", "hashCode", "matchAction", "matchMimeType", "matchUri", "matches", "matches$navigation_common_release", "deepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "parseArgument", "name", "value", "argument", "parseArgumentForRepeatedParam", "parseFragment", "parseInputParams", "inputParams", "storedParam", "parseMime", "parsePath", "parseQuery", "Builder", "Companion", "MimeType", "ParamQuery", "navigation-common_release"})
@SourceDebugExtension(value={"SMAP\nNavDeepLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,633:1\n1360#2:634\n1446#2,5:635\n1559#2:640\n1590#2,4:641\n1559#2:645\n1590#2,4:646\n1855#2:652\n1559#2:653\n1590#2,4:654\n1856#2:658\n215#3,2:650\n1#4:659\n*S KotlinDebug\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink\n*L\n85#1:634\n85#1:635,5\n211#1:640\n211#1:641,4\n229#1:645\n229#1:646,4\n277#1:652\n289#1:653\n289#1:654,4\n277#1:658\n251#1:650,2\n*E\n"})
public final class NavDeepLink {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String uriPattern;
    @Nullable
    private final String action;
    @Nullable
    private final String mimeType;
    @NotNull
    private final List<String> pathArgs;
    @Nullable
    private String pathRegex;
    @NotNull
    private final Lazy pathPattern$delegate;
    @NotNull
    private final Lazy isParameterizedQuery$delegate;
    @NotNull
    private final Lazy queryArgsMap$delegate;
    private boolean isSingleQueryParamValueOnly;
    @NotNull
    private final Lazy fragArgsAndRegex$delegate;
    @NotNull
    private final Lazy fragArgs$delegate;
    @NotNull
    private final Lazy fragRegex$delegate;
    @NotNull
    private final Lazy fragPattern$delegate;
    @Nullable
    private String mimeTypeRegex;
    @NotNull
    private final Lazy mimeTypePattern$delegate;
    private boolean isExactDeepLink;
    @Deprecated
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^[a-zA-Z]+[+\\w\\-.]*:");
    @Deprecated
    private static final Pattern FILL_IN_PATTERN = Pattern.compile("\\{(.+?)\\}");

    public NavDeepLink(@Nullable String uriPattern, @Nullable String action, @Nullable String mimeType) {
        this.uriPattern = uriPattern;
        this.action = action;
        this.mimeType = mimeType;
        this.pathArgs = new ArrayList();
        this.pathPattern$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pattern>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pattern invoke() {
                Pattern pattern;
                String string = NavDeepLink.access$getPathRegex$p(this.this$0);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    pattern = Pattern.compile(it, 2);
                } else {
                    pattern = null;
                }
                return pattern;
            }
        }));
        this.isParameterizedQuery$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getUriPattern() != null && Uri.parse((String)this.this$0.getUriPattern()).getQuery() != null;
            }
        }));
        this.queryArgsMap$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Map<String, ParamQuery>>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, ParamQuery> invoke() {
                return NavDeepLink.access$parseQuery(this.this$0);
            }
        }));
        this.fragArgsAndRegex$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Pair<? extends List<String>, ? extends String>>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pair<List<String>, String> invoke() {
                return NavDeepLink.access$parseFragment(this.this$0);
            }
        }));
        this.fragArgs$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<String>>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                Object object = NavDeepLink.access$getFragArgsAndRegex(this.this$0);
                if (object == null || (object = (List)object.getFirst()) == null) {
                    object = new ArrayList<E>();
                }
                return object;
            }
        }));
        this.fragRegex$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                Pair pair = NavDeepLink.access$getFragArgsAndRegex(this.this$0);
                return pair != null ? (String)pair.getSecond() : null;
            }
        }));
        this.fragPattern$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pattern>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pattern invoke() {
                Pattern pattern;
                String string = NavDeepLink.access$getFragRegex(this.this$0);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    pattern = Pattern.compile(it, 2);
                } else {
                    pattern = null;
                }
                return pattern;
            }
        }));
        this.mimeTypePattern$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pattern>(this){
            final /* synthetic */ NavDeepLink this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pattern invoke() {
                Pattern pattern;
                String string = NavDeepLink.access$getMimeTypeRegex$p(this.this$0);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    pattern = Pattern.compile(it);
                } else {
                    pattern = null;
                }
                return pattern;
            }
        }));
        this.parsePath();
        this.parseMime();
    }

    @Nullable
    public final String getUriPattern() {
        return this.uriPattern;
    }

    @Nullable
    public final String getAction() {
        return this.action;
    }

    @Nullable
    public final String getMimeType() {
        return this.mimeType;
    }

    private final Pattern getPathPattern() {
        Lazy lazy = this.pathPattern$delegate;
        return (Pattern)lazy.getValue();
    }

    private final boolean isParameterizedQuery() {
        Lazy lazy = this.isParameterizedQuery$delegate;
        return (Boolean)lazy.getValue();
    }

    private final Map<String, ParamQuery> getQueryArgsMap() {
        Lazy lazy = this.queryArgsMap$delegate;
        return (Map)lazy.getValue();
    }

    private final Pair<List<String>, String> getFragArgsAndRegex() {
        Lazy lazy = this.fragArgsAndRegex$delegate;
        return (Pair)lazy.getValue();
    }

    private final List<String> getFragArgs() {
        Lazy lazy = this.fragArgs$delegate;
        return (List)lazy.getValue();
    }

    private final String getFragRegex() {
        Lazy lazy = this.fragRegex$delegate;
        return (String)lazy.getValue();
    }

    private final Pattern getFragPattern() {
        Lazy lazy = this.fragPattern$delegate;
        return (Pattern)lazy.getValue();
    }

    private final Pattern getMimeTypePattern() {
        Lazy lazy = this.mimeTypePattern$delegate;
        return (Pattern)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getArgumentsNames$navigation_common_release() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.getQueryArgsMap().values();
        Collection collection = this.pathArgs;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ParamQuery it = (ParamQuery)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getArguments();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (Iterable)this.getFragArgs());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isExactDeepLink() {
        return this.isExactDeepLink;
    }

    public final void setExactDeepLink$navigation_common_release(boolean bl) {
        this.isExactDeepLink = bl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public NavDeepLink(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(uri, null, null);
    }

    private final void buildRegex(String uri, List<String> args, StringBuilder uriRegex) {
        Matcher matcher = FILL_IN_PATTERN.matcher(uri);
        int appendPos = 0;
        while (matcher.find()) {
            String argName;
            Intrinsics.checkNotNull((Object)matcher.group(1), (String)"null cannot be cast to non-null type kotlin.String");
            args.add(argName);
            if (matcher.start() > appendPos) {
                String string = uri.substring(appendPos, matcher.start());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                uriRegex.append(Pattern.quote(string));
            }
            uriRegex.append("([^/]+?)");
            appendPos = matcher.end();
        }
        if (appendPos < uri.length()) {
            String string = uri.substring(appendPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            uriRegex.append(Pattern.quote(string));
        }
    }

    public final boolean matches$navigation_common_release(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.matches$navigation_common_release(new NavDeepLinkRequest(uri, null, null));
    }

    public final boolean matches$navigation_common_release(@NotNull NavDeepLinkRequest deepLinkRequest) {
        Intrinsics.checkNotNullParameter((Object)deepLinkRequest, (String)"deepLinkRequest");
        if (!this.matchUri(deepLinkRequest.getUri())) {
            return false;
        }
        return !this.matchAction(deepLinkRequest.getAction()) ? false : this.matchMimeType(deepLinkRequest.getMimeType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchUri(Uri uri) {
        if (uri == null == (this.getPathPattern() != null)) {
            return false;
        }
        if (uri == null) return true;
        Pattern pattern = this.getPathPattern();
        Intrinsics.checkNotNull((Object)pattern);
        if (!pattern.matcher(uri.toString()).matches()) return false;
        return true;
    }

    private final boolean matchAction(String action) {
        return action == null == (this.action != null) ? false : action == null || Intrinsics.areEqual((Object)this.action, (Object)action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchMimeType(String mimeType) {
        if (mimeType == null == (this.mimeType != null)) {
            return false;
        }
        if (mimeType == null) return true;
        Pattern pattern = this.getMimeTypePattern();
        Intrinsics.checkNotNull((Object)pattern);
        if (!pattern.matcher(mimeType).matches()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final int getMimeTypeMatchRating(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        if (this.mimeType == null) return -1;
        Pattern pattern = this.getMimeTypePattern();
        Intrinsics.checkNotNull((Object)pattern);
        if (!pattern.matcher(mimeType).matches()) {
            return -1;
        }
        int n = new MimeType(this.mimeType).compareTo(new MimeType(mimeType));
        return n;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Bundle getMatchingArguments(@NotNull Uri deepLink, @NotNull Map<String, NavArgument> arguments) {
        Intrinsics.checkNotNullParameter((Object)deepLink, (String)"deepLink");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Pattern pattern = this.getPathPattern();
        Matcher matcher = pattern != null ? pattern.matcher(deepLink.toString()) : null;
        if (matcher == null) {
            return null;
        }
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            return null;
        }
        Bundle bundle = new Bundle();
        if (!this.getMatchingPathArguments(matcher2, bundle, arguments)) {
            return null;
        }
        if (this.isParameterizedQuery() && !this.getMatchingQueryArguments(deepLink, bundle, arguments)) {
            return null;
        }
        this.getMatchingUriFragment(deepLink.getFragment(), bundle, arguments);
        for (Map.Entry<String, NavArgument> entry : arguments.entrySet()) {
            String argName = entry.getKey();
            NavArgument argument = entry.getValue();
            boolean argumentIsRequired = argument != null && !argument.isNullable() && !argument.isDefaultValuePresent();
            if (!argumentIsRequired || bundle.containsKey(argName)) continue;
            return null;
        }
        return bundle;
    }

    /*
     * WARNING - void declaration
     */
    private final void getMatchingUriFragment(String fragment, Bundle bundle, Map<String, NavArgument> arguments) {
        void $this$mapIndexedTo$iv$iv;
        Pattern pattern = this.getFragPattern();
        Matcher matcher = pattern != null ? pattern.matcher(String.valueOf(fragment)) : null;
        if (matcher == null) {
            return;
        }
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            return;
        }
        Iterable $this$mapIndexed$iv = this.getFragArgs();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void argumentName;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String value = Uri.decode((String)matcher2.group((int)(index + true)));
            NavArgument argument = arguments.get(argumentName);
            try {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                if (this.parseArgument(bundle, (String)argumentName, value, argument)) {
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                return;
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean getMatchingPathArguments(Matcher matcher, Bundle bundle, Map<String, NavArgument> arguments) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = this.pathArgs;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void argumentName;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String value = Uri.decode((String)matcher.group((int)(index + true)));
            NavArgument argument = arguments.get(argumentName);
            try {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                if (this.parseArgument(bundle, (String)argumentName, value, argument)) {
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return true;
    }

    private final boolean getMatchingQueryArguments(Uri deepLink, Bundle bundle, Map<String, NavArgument> arguments) {
        Map<String, ParamQuery> $this$forEach$iv = this.getQueryArgsMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ParamQuery>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String argValue;
            Map.Entry<String, ParamQuery> element$iv;
            Map.Entry<String, ParamQuery> entry = element$iv = iterator2.next();
            boolean bl = false;
            String paramName = entry.getKey();
            ParamQuery storedParam = entry.getValue();
            List inputParams = deepLink.getQueryParameters(paramName);
            if (this.isSingleQueryParamValueOnly && (argValue = deepLink.getQuery()) != null && !Intrinsics.areEqual((Object)argValue, (Object)deepLink.toString())) {
                inputParams = CollectionsKt.listOf((Object)argValue);
            }
            if (this.parseInputParams(inputParams, storedParam, bundle, arguments)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parseInputParams(List<String> inputParams, ParamQuery storedParam, Bundle bundle, Map<String, NavArgument> arguments) {
        block11: {
            List<String> list = inputParams;
            if (list == null) break block11;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Matcher argMatcher;
                Matcher matcher;
                String inputParam = (String)element$iv;
                boolean bl = false;
                if (storedParam.getParamRegex() != null) {
                    String it;
                    boolean bl2 = false;
                    matcher = Pattern.compile(it, 32).matcher(inputParam);
                } else {
                    matcher = argMatcher = null;
                }
                if (argMatcher == null || !argMatcher.matches()) {
                    return false;
                }
                Bundle queryParamBundle = new Bundle();
                try {
                    void $this$mapIndexedTo$iv$iv;
                    Iterable $this$mapIndexed$iv = storedParam.getArguments();
                    boolean $i$f$mapIndexed = false;
                    Iterable bl2 = $this$mapIndexed$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void argName;
                        String string;
                        void index;
                        String string2;
                        int n;
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string3 = (String)item$iv$iv;
                        int n2 = n;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        String string4 = string2 = argMatcher.group((int)(index + true));
                        if (string4 == null) {
                            string = "";
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"argMatcher.group(index + 1) ?: \"\"");
                            string = string2;
                        }
                        String value = string;
                        NavArgument argument = arguments.get(argName);
                        if (this.parseArgumentForRepeatedParam(bundle, (String)argName, value, argument) && !Intrinsics.areEqual((Object)value, (Object)('{' + (String)argName + '}')) && this.parseArgument(queryParamBundle, (String)argName, value, argument)) {
                            return false;
                        }
                        collection.add(Unit.INSTANCE);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                    bundle.putAll(queryParamBundle);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return true;
    }

    public final int calculateMatchingPathSegments$navigation_common_release(@Nullable Uri requestedLink) {
        if (requestedLink == null || this.uriPattern == null) {
            return 0;
        }
        List requestedPathSegments = requestedLink.getPathSegments();
        List uriPathSegments = Uri.parse((String)this.uriPattern).getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)requestedPathSegments, (String)"requestedPathSegments");
        Iterable iterable = requestedPathSegments;
        Intrinsics.checkNotNullExpressionValue((Object)uriPathSegments, (String)"uriPathSegments");
        Set matches = CollectionsKt.intersect((Iterable)iterable, (Iterable)uriPathSegments);
        return matches.size();
    }

    private final boolean parseArgument(Bundle bundle, String name, String value, NavArgument argument) {
        if (argument != null) {
            NavType<Object> type = argument.getType();
            type.parseAndPut(bundle, name, value);
        } else {
            bundle.putString(name, value);
        }
        return false;
    }

    private final boolean parseArgumentForRepeatedParam(Bundle bundle, String name, String value, NavArgument argument) {
        if (!bundle.containsKey(name)) {
            return true;
        }
        if (argument != null) {
            NavType<Object> type = argument.getType();
            Object previousValue = type.get(bundle, name);
            type.parseAndPut(bundle, name, value, previousValue);
        }
        return false;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof NavDeepLink)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.uriPattern, (Object)((NavDeepLink)other).uriPattern) && Intrinsics.areEqual((Object)this.action, (Object)((NavDeepLink)other).action) && Intrinsics.areEqual((Object)this.mimeType, (Object)((NavDeepLink)other).mimeType);
    }

    public int hashCode() {
        int result = 0;
        String string = this.uriPattern;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        String string2 = this.action;
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        String string3 = this.mimeType;
        result = 31 * result + (string3 != null ? string3.hashCode() : 0);
        return result;
    }

    private final void parsePath() {
        if (this.uriPattern == null) {
            return;
        }
        StringBuilder uriRegex = new StringBuilder("^");
        if (!SCHEME_PATTERN.matcher(this.uriPattern).find()) {
            uriRegex.append("http[s]?://");
        }
        Matcher matcher = null;
        matcher = Pattern.compile("(\\?|\\#|$)").matcher(this.uriPattern);
        boolean it = matcher.find();
        boolean bl = false;
        String string = this.uriPattern.substring(0, matcher.start());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        this.buildRegex(string, this.pathArgs, uriRegex);
        this.isExactDeepLink = !StringsKt.contains$default((CharSequence)uriRegex, (CharSequence)".*", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)uriRegex, (CharSequence)"([^/]+?)", (boolean)false, (int)2, null);
        uriRegex.append("($|(\\?(.)*)|(\\#(.)*))");
        String string2 = uriRegex.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uriRegex.toString()");
        this.pathRegex = StringsKt.replace$default((String)string2, (String)".*", (String)"\\E.*\\Q", (boolean)false, (int)4, null);
    }

    private final Map<String, ParamQuery> parseQuery() {
        Map paramArgMap = new LinkedHashMap();
        if (!this.isParameterizedQuery()) {
            return paramArgMap;
        }
        Uri uri = Uri.parse((String)this.uriPattern);
        for (String paramName : uri.getQueryParameterNames()) {
            StringBuilder argRegex = new StringBuilder();
            List queryParams = uri.getQueryParameters(paramName);
            if (!(queryParams.size() <= 1)) {
                boolean $i$a$-require-NavDeepLink$parseQuery$22 = false;
                String $i$a$-require-NavDeepLink$parseQuery$22 = "Query parameter " + paramName + " must only be present once in " + this.uriPattern + ". To support repeated query parameters, use an array type for your argument and the pattern provided in your URI will be used to parse each query parameter instance.";
                throw new IllegalArgumentException($i$a$-require-NavDeepLink$parseQuery$22.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)queryParams, (String)"queryParams");
            String string = (String)CollectionsKt.firstOrNull((List)queryParams);
            if (string == null) {
                String string2;
                String $this$parseQuery_u24lambda_u249 = string2 = paramName;
                boolean bl = false;
                this.isSingleQueryParamValueOnly = true;
                string = string2;
            }
            String queryParam = string;
            Matcher matcher = FILL_IN_PATTERN.matcher(queryParam);
            int appendPos = 0;
            ParamQuery param = new ParamQuery();
            while (matcher.find()) {
                String string3 = matcher.group(1);
                Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type kotlin.String");
                param.addArgumentName(string3);
                Intrinsics.checkNotNullExpressionValue((Object)queryParam, (String)"queryParam");
                String string4 = queryParam.substring(appendPos, matcher.start());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                argRegex.append(Pattern.quote(string4));
                argRegex.append("(.+?)?");
                appendPos = matcher.end();
            }
            if (appendPos < queryParam.length()) {
                Intrinsics.checkNotNullExpressionValue((Object)queryParam, (String)"queryParam");
                String string5 = queryParam.substring(appendPos);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                argRegex.append(Pattern.quote(string5));
            }
            String string6 = argRegex.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"argRegex.toString()");
            param.setParamRegex(StringsKt.replace$default((String)string6, (String)".*", (String)"\\E.*\\Q", (boolean)false, (int)4, null));
            Intrinsics.checkNotNullExpressionValue((Object)paramName, (String)"paramName");
            paramArgMap.put(paramName, param);
        }
        return paramArgMap;
    }

    private final Pair<List<String>, String> parseFragment() {
        if (this.uriPattern == null || Uri.parse((String)this.uriPattern).getFragment() == null) {
            return null;
        }
        List fragArgs2 = new ArrayList();
        String fragment = Uri.parse((String)this.uriPattern).getFragment();
        StringBuilder fragRegex2 = new StringBuilder();
        String string = fragment;
        Intrinsics.checkNotNull((Object)string);
        this.buildRegex(string, fragArgs2, fragRegex2);
        String string2 = fragRegex2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fragRegex.toString()");
        return TuplesKt.to((Object)fragArgs2, (Object)string2);
    }

    private final void parseMime() {
        if (this.mimeType == null) {
            return;
        }
        Pattern mimeTypePattern2 = Pattern.compile("^[\\s\\S]+/[\\s\\S]+$");
        Matcher mimeTypeMatcher = mimeTypePattern2.matcher(this.mimeType);
        if (!mimeTypeMatcher.matches()) {
            boolean $i$a$-require-NavDeepLink$parseMime$22 = false;
            String $i$a$-require-NavDeepLink$parseMime$22 = "The given mimeType " + this.mimeType + " does not match to required \"type/subtype\" format";
            throw new IllegalArgumentException($i$a$-require-NavDeepLink$parseMime$22.toString());
        }
        MimeType splitMimeType = new MimeType(this.mimeType);
        String regex = "^(" + splitMimeType.getType() + "|[*]+)/(" + splitMimeType.getSubType() + "|[*]+)$";
        this.mimeTypeRegex = StringsKt.replace$default((String)regex, (String)"*|[*]", (String)"[\\s\\S]", (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ String access$getPathRegex$p(NavDeepLink $this) {
        return $this.pathRegex;
    }

    public static final /* synthetic */ Map access$parseQuery(NavDeepLink $this) {
        return $this.parseQuery();
    }

    public static final /* synthetic */ Pair access$parseFragment(NavDeepLink $this) {
        return $this.parseFragment();
    }

    public static final /* synthetic */ Pair access$getFragArgsAndRegex(NavDeepLink $this) {
        return $this.getFragArgsAndRegex();
    }

    public static final /* synthetic */ String access$getFragRegex(NavDeepLink $this) {
        return $this.getFragRegex();
    }

    public static final /* synthetic */ String access$getMimeTypeRegex$p(NavDeepLink $this) {
        return $this.mimeTypeRegex;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/navigation/NavDeepLink$Builder;", "", "()V", "action", "", "mimeType", "uriPattern", "build", "Landroidx/navigation/NavDeepLink;", "setAction", "setMimeType", "setUriPattern", "Companion", "navigation-common_release"})
    @SourceDebugExtension(value={"SMAP\nNavDeepLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,633:1\n1#2:634\n*E\n"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String uriPattern;
        @Nullable
        private String action;
        @Nullable
        private String mimeType;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder() {
        }

        @NotNull
        public final Builder setUriPattern(@NotNull String uriPattern) {
            Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
            this.uriPattern = uriPattern;
            return this;
        }

        @NotNull
        public final Builder setAction(@NotNull String action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            if (!(((CharSequence)action).length() > 0)) {
                boolean bl = false;
                String string = "The NavDeepLink cannot have an empty action.";
                throw new IllegalArgumentException(string.toString());
            }
            this.action = action;
            return this;
        }

        @NotNull
        public final Builder setMimeType(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            this.mimeType = mimeType;
            return this;
        }

        @NotNull
        public final NavDeepLink build() {
            return new NavDeepLink(this.uriPattern, this.action, this.mimeType);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromUriPattern(@NotNull String uriPattern) {
            return Companion.fromUriPattern(uriPattern);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromAction(@NotNull String action) {
            return Companion.fromAction(action);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromMimeType(@NotNull String mimeType) {
            return Companion.fromMimeType(mimeType);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Landroidx/navigation/NavDeepLink$Builder$Companion;", "", "()V", "fromAction", "Landroidx/navigation/NavDeepLink$Builder;", "action", "", "fromMimeType", "mimeType", "fromUriPattern", "uriPattern", "navigation-common_release"})
        @SourceDebugExtension(value={"SMAP\nNavDeepLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink$Builder$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,633:1\n1#2:634\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder fromUriPattern(@NotNull String uriPattern) {
                Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
                Builder builder = new Builder();
                builder.setUriPattern(uriPattern);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromAction(@NotNull String action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                if (!(((CharSequence)action).length() > 0)) {
                    boolean bl = false;
                    String string = "The NavDeepLink cannot have an empty action.";
                    throw new IllegalArgumentException(string.toString());
                }
                Builder builder = new Builder();
                builder.setAction(action);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromMimeType(@NotNull String mimeType) {
                Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
                Builder builder = new Builder();
                builder.setMimeType(mimeType);
                return builder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/NavDeepLink$Companion;", "", "()V", "FILL_IN_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SCHEME_PATTERN", "navigation-common_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\u0004\u00a8\u0006\u000f"}, d2={"Landroidx/navigation/NavDeepLink$MimeType;", "", "mimeType", "", "(Ljava/lang/String;)V", "subType", "getSubType", "()Ljava/lang/String;", "setSubType", "type", "getType", "setType", "compareTo", "", "other", "navigation-common_release"})
    @SourceDebugExtension(value={"SMAP\nNavDeepLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink$MimeType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,633:1\n731#2,9:634\n*S KotlinDebug\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink$MimeType\n*L\n394#1:634,9\n*E\n"})
    private static final class MimeType
    implements Comparable<MimeType> {
        @NotNull
        private String type;
        @NotNull
        private String subType;

        public MimeType(@NotNull String mimeType) {
            List list;
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            CharSequence charSequence = mimeType;
            Regex regex = new Regex("/");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List typeAndSubType = list;
            this.type = (String)typeAndSubType.get(0);
            this.subType = (String)typeAndSubType.get(1);
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.type = string;
        }

        @NotNull
        public final String getSubType() {
            return this.subType;
        }

        public final void setSubType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.subType = string;
        }

        @Override
        public int compareTo(@NotNull MimeType other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int result = 0;
            if (Intrinsics.areEqual((Object)this.type, (Object)other.type)) {
                result += 2;
            }
            if (Intrinsics.areEqual((Object)this.subType, (Object)other.subType)) {
                ++result;
            }
            return result;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Landroidx/navigation/NavDeepLink$ParamQuery;", "", "()V", "arguments", "", "", "getArguments", "()Ljava/util/List;", "paramRegex", "getParamRegex", "()Ljava/lang/String;", "setParamRegex", "(Ljava/lang/String;)V", "addArgumentName", "", "name", "getArgumentName", "index", "", "size", "navigation-common_release"})
    private static final class ParamQuery {
        @Nullable
        private String paramRegex;
        @NotNull
        private final List<String> arguments = new ArrayList();

        @Nullable
        public final String getParamRegex() {
            return this.paramRegex;
        }

        public final void setParamRegex(@Nullable String string) {
            this.paramRegex = string;
        }

        @NotNull
        public final List<String> getArguments() {
            return this.arguments;
        }

        public final void addArgumentName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.arguments.add(name);
        }

        @NotNull
        public final String getArgumentName(int index) {
            return this.arguments.get(index);
        }

        public final int size() {
            return this.arguments.size();
        }
    }
}

