/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import androidx.annotation.CallSuper;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH&J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0006H\u0017J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0006H\u0017J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0010H\u0016J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0010H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0017J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0006H\u0016J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u0006)"}, d2={"Landroidx/navigation/NavigatorState;", "", "()V", "_backStack", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Landroidx/navigation/NavBackStackEntry;", "_transitionsInProgress", "", "backStack", "Lkotlinx/coroutines/flow/StateFlow;", "getBackStack", "()Lkotlinx/coroutines/flow/StateFlow;", "backStackLock", "Ljava/util/concurrent/locks/ReentrantLock;", "<set-?>", "", "isNavigating", "()Z", "setNavigating", "(Z)V", "transitionsInProgress", "getTransitionsInProgress", "createBackStackEntry", "destination", "Landroidx/navigation/NavDestination;", "arguments", "Landroid/os/Bundle;", "markTransitionComplete", "", "entry", "onLaunchSingleTop", "backStackEntry", "onLaunchSingleTopWithTransition", "pop", "popUpTo", "saveState", "popWithTransition", "prepareForTransition", "push", "pushWithTransition", "navigation-common_release"})
@SourceDebugExtension(value={"SMAP\nNavigatorState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigatorState.kt\nandroidx/navigation/NavigatorState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1747#2,3:229\n1747#2,3:232\n959#2,7:235\n1747#2,3:242\n2624#2,3:245\n533#2,6:248\n378#2,7:254\n451#2,6:261\n*S KotlinDebug\n*F\n+ 1 NavigatorState.kt\nandroidx/navigation/NavigatorState\n*L\n83#1:229,3\n84#1:232,3\n112#1:235,7\n134#1:242,3\n135#1:245,3\n140#1:248,6\n167#1:254,7\n192#1:261,6\n*E\n"})
public abstract class NavigatorState {
    @NotNull
    private final ReentrantLock backStackLock = new ReentrantLock(true);
    @NotNull
    private final MutableStateFlow<List<NavBackStackEntry>> _backStack = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
    @NotNull
    private final MutableStateFlow<Set<NavBackStackEntry>> _transitionsInProgress = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
    private boolean isNavigating;
    @NotNull
    private final StateFlow<List<NavBackStackEntry>> backStack = FlowKt.asStateFlow(this._backStack);
    @NotNull
    private final StateFlow<Set<NavBackStackEntry>> transitionsInProgress = FlowKt.asStateFlow(this._transitionsInProgress);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isNavigating() {
        return this.isNavigating;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void setNavigating(boolean bl) {
        this.isNavigating = bl;
    }

    @NotNull
    public final StateFlow<List<NavBackStackEntry>> getBackStack() {
        return this.backStack;
    }

    @NotNull
    public final StateFlow<Set<NavBackStackEntry>> getTransitionsInProgress() {
        return this.transitionsInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(@NotNull NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        Lock lock = this.backStackLock;
        lock.lock();
        try {
            boolean bl = false;
            this._backStack.setValue((Object)CollectionsKt.plus((Collection)((Collection)this._backStack.getValue()), (Object)backStackEntry));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public void pushWithTransition(@NotNull NavBackStackEntry backStackEntry) {
        NavBackStackEntry previousEntry;
        NavBackStackEntry it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block9: {
            Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
            $this$any$iv = (Iterable)this._transitionsInProgress.getValue();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (NavBackStackEntry)element$iv;
                    boolean bl2 = false;
                    if (!(it == backStackEntry)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            boolean bl3;
            block10: {
                $this$any$iv = (Iterable)this.backStack.getValue();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (NavBackStackEntry)element$iv;
                        boolean bl4 = false;
                        if (!(it == backStackEntry)) continue;
                        bl3 = true;
                        break block10;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                return;
            }
        }
        if ((previousEntry = (NavBackStackEntry)CollectionsKt.lastOrNull((List)((List)this.backStack.getValue()))) != null) {
            this._transitionsInProgress.setValue((Object)SetsKt.plus((Set)((Set)this._transitionsInProgress.getValue()), (Object)previousEntry));
        }
        this._transitionsInProgress.setValue((Object)SetsKt.plus((Set)((Set)this._transitionsInProgress.getValue()), (Object)backStackEntry));
        this.push(backStackEntry);
    }

    @NotNull
    public abstract NavBackStackEntry createBackStackEntry(@NotNull NavDestination var1, @Nullable Bundle var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void pop(@NotNull NavBackStackEntry popUpTo2, boolean saveState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo2, (String)"popUpTo");
        Lock lock = this.backStackLock;
        lock.lock();
        try {
            void $this$takeWhile$iv;
            boolean bl = false;
            Iterable iterable = (Iterable)this._backStack.getValue();
            MutableStateFlow<List<NavBackStackEntry>> mutableStateFlow = this._backStack;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                NavBackStackEntry it = (NavBackStackEntry)item$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)popUpTo2))) break;
                list$iv.add(item$iv);
            }
            mutableStateFlow.setValue((Object)list$iv);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public void popWithTransition(@NotNull NavBackStackEntry popUpTo2, boolean saveState) {
        Object v3;
        block12: {
            NavBackStackEntry it;
            boolean bl;
            block10: {
                Intrinsics.checkNotNullParameter((Object)popUpTo2, (String)"popUpTo");
                Iterable $this$any$iv = (Iterable)this._transitionsInProgress.getValue();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (NavBackStackEntry)element$iv;
                        boolean bl2 = false;
                        if (!(it == popUpTo2)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                boolean bl3;
                block11: {
                    Iterable $this$none$iv = (Iterable)this.backStack.getValue();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (NavBackStackEntry)element$iv;
                            boolean bl4 = false;
                            if (!(it == popUpTo2)) continue;
                            bl3 = false;
                            break block11;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) {
                    return;
                }
            }
            this._transitionsInProgress.setValue((Object)SetsKt.plus((Set)((Set)this._transitionsInProgress.getValue()), (Object)popUpTo2));
            List $this$lastOrNull$iv = (List)this.backStack.getValue();
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                NavBackStackEntry entry = (NavBackStackEntry)element$iv;
                boolean bl5 = false;
                boolean bl6 = !Intrinsics.areEqual((Object)entry, (Object)popUpTo2) && ((List)this.backStack.getValue()).lastIndexOf(entry) < ((List)this.backStack.getValue()).lastIndexOf(popUpTo2);
                if (!bl6) continue;
                v3 = element$iv;
                break block12;
            }
            v3 = null;
        }
        NavBackStackEntry incomingEntry = v3;
        if (incomingEntry != null) {
            this._transitionsInProgress.setValue((Object)SetsKt.plus((Set)((Set)this._transitionsInProgress.getValue()), (Object)incomingEntry));
        }
        this.pop(popUpTo2, saveState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    public void onLaunchSingleTop(@NotNull NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        Lock lock = this.backStackLock;
        lock.lock();
        try {
            int n;
            List tempStack;
            block4: {
                boolean bl = false;
                List $this$indexOfLast$iv = tempStack = CollectionsKt.toMutableList((Collection)((Collection)this.backStack.getValue()));
                boolean $i$f$indexOfLast = false;
                ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    NavBackStackEntry it = (NavBackStackEntry)iterator$iv.previous();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)backStackEntry.getId())) continue;
                    n = iterator$iv.nextIndex();
                    break block4;
                }
                n = -1;
            }
            int idx = n;
            boolean bl = false;
            tempStack.set(idx, backStackEntry);
            this._backStack.setValue((Object)tempStack);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @CallSuper
    public void onLaunchSingleTopWithTransition(@NotNull NavBackStackEntry backStackEntry) {
        Object element$iv;
        block1: {
            Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
            List $this$last$iv = (List)this.backStack.getValue();
            boolean $i$f$last = false;
            ListIterator iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
            while (iterator$iv.hasPrevious()) {
                element$iv = iterator$iv.previous();
                NavBackStackEntry it = (NavBackStackEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)backStackEntry.getId())) continue;
                break block1;
            }
            throw new NoSuchElementException("List contains no element matching the predicate.");
        }
        NavBackStackEntry oldEntry = (NavBackStackEntry)element$iv;
        this._transitionsInProgress.setValue((Object)SetsKt.plus((Set)SetsKt.plus((Set)((Set)this._transitionsInProgress.getValue()), (Object)oldEntry), (Object)backStackEntry));
        this.onLaunchSingleTop(backStackEntry);
    }

    public void markTransitionComplete(@NotNull NavBackStackEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this._transitionsInProgress.setValue((Object)SetsKt.minus((Set)((Set)this._transitionsInProgress.getValue()), (Object)entry));
    }

    @CallSuper
    public void prepareForTransition(@NotNull NavBackStackEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this._transitionsInProgress.setValue((Object)SetsKt.plus((Set)((Set)this._transitionsInProgress.getValue()), (Object)entry));
    }
}

