/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.common.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/navigation/common/lint/EmptyNavDeepLinkDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "navigation-common-lint"})
public final class EmptyNavDeepLinkDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue EmptyNavDeepLink;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"navDeepLink");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (node.getValueArgumentCount() > 0) {
            Object e = node.getValueArguments().get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.uast.ULambdaExpression");
            ULambdaExpression lam = (ULambdaExpression)e;
            UExpression uExpression = lam.getBody();
            Intrinsics.checkNotNull((Object)uExpression, (String)"null cannot be cast to non-null type org.jetbrains.uast.UBlockExpression");
            UBlockExpression body = (UBlockExpression)uExpression;
            if (body.getExpressions().isEmpty()) {
                JavaContext.report$default((JavaContext)context, (Issue)EmptyNavDeepLink, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)"Creation of empty NavDeepLink", null, (int)16, null);
            }
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(EmptyNavDeepLinkDetector.class, Scope.JAVA_FILE_SCOPE);
        EmptyNavDeepLink = Issue.Companion.create$default((Issue.Companion)companion, (String)"EmptyNavDeepLink", (String)"NavDeepLink must define an uri, action, and/or mimetype to be valid.", (String)"Attempting to create an empty NavDeepLink will result in an IllegalStateException at runtime. You may set these arguments within the lambda of the call to navDeepLink.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, null, null, null, (int)3920, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/common/lint/EmptyNavDeepLinkDetector$Companion;", "", "()V", "EmptyNavDeepLink", "Lcom/android/tools/lint/detector/api/Issue;", "getEmptyNavDeepLink", "()Lcom/android/tools/lint/detector/api/Issue;", "navigation-common-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getEmptyNavDeepLink() {
            return EmptyNavDeepLink;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

