/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.serialization;

import androidx.navigation.serialization.ArgStore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0001J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/navigation/serialization/Decoder;", "", "store", "Landroidx/navigation/serialization/ArgStore;", "(Landroidx/navigation/serialization/ArgStore;)V", "elementIndex", "", "elementName", "", "computeNextElementIndex", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeValue", "isCurrentElementNull", "", "navigation-common_release"})
final class Decoder {
    @NotNull
    private final ArgStore store;
    private int elementIndex;
    @NotNull
    private String elementName;

    public Decoder(@NotNull ArgStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
        this.elementIndex = -1;
        this.elementName = "";
    }

    public final int computeNextElementIndex(@NotNull SerialDescriptor descriptor) {
        String currentName;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int currentIndex = this.elementIndex;
        do {
            if (++currentIndex < descriptor.getElementsCount()) continue;
            return -1;
        } while (!this.store.contains(currentName = descriptor.getElementName(currentIndex)));
        this.elementIndex = currentIndex;
        this.elementName = currentName;
        return this.elementIndex;
    }

    @NotNull
    public final Object decodeValue() {
        Object arg = this.store.get(this.elementName);
        if (arg == null) {
            boolean bl = false;
            String string = "Unexpected null value for non-nullable argument " + this.elementName;
            throw new IllegalStateException(string.toString());
        }
        return arg;
    }

    public final boolean isCurrentElementNull() {
        return this.store.get(this.elementName) == null;
    }
}

