/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="navigation")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0002H\u0016J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J*\u0010\r\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/navigation/NavGraphNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/NavGraph;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "(Landroidx/navigation/NavigatorProvider;)V", "backStack", "Lkotlinx/coroutines/flow/StateFlow;", "", "Landroidx/navigation/NavBackStackEntry;", "getBackStack", "()Lkotlinx/coroutines/flow/StateFlow;", "createDestination", "navigate", "", "entry", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "entries", "navigation-common_release"})
@SourceDebugExtension(value={"SMAP\nNavGraphNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavGraphNavigator.kt\nandroidx/navigation/NavGraphNavigator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public class NavGraphNavigator
extends Navigator<NavGraph> {
    @NotNull
    private final NavigatorProvider navigatorProvider;

    public NavGraphNavigator(@NotNull NavigatorProvider navigatorProvider) {
        Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
        this.navigatorProvider = navigatorProvider;
    }

    @NotNull
    public final StateFlow<List<NavBackStackEntry>> getBackStack() {
        return this.getState().getBackStack();
    }

    @Override
    @NotNull
    public NavGraph createDestination() {
        return new NavGraph(this);
    }

    @Override
    public void navigate(@NotNull List<NavBackStackEntry> entries, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        for (NavBackStackEntry entry : entries) {
            this.navigate(entry, navOptions, navigatorExtras);
        }
    }

    private final void navigate(NavBackStackEntry entry, NavOptions navOptions, Navigator.Extras navigatorExtras) {
        NavDestination navDestination = entry.getDestination();
        Intrinsics.checkNotNull((Object)navDestination, (String)"null cannot be cast to non-null type androidx.navigation.NavGraph");
        NavGraph destination = (NavGraph)navDestination;
        Bundle args = null;
        args = entry.getArguments();
        int startId = destination.getStartDestinationId();
        String startRoute = destination.getStartDestinationRoute();
        if (!(startId != 0 || startRoute != null)) {
            boolean $i$a$-check-NavGraphNavigator$navigate$22 = false;
            String $i$a$-check-NavGraphNavigator$navigate$22 = "no start destination defined via app:startDestination for " + destination.getDisplayName();
            throw new IllegalStateException($i$a$-check-NavGraphNavigator$navigate$22.toString());
        }
        NavDestination startDestination = startRoute != null ? destination.findNode(startRoute, false) : (NavDestination)destination.getNodes().get(startId);
        if (startDestination == null) {
            boolean bl = false;
            String dest = destination.getStartDestDisplayName();
            throw new IllegalArgumentException("navigation destination " + dest + " is not a direct child of this NavGraph");
        }
        if (startRoute != null) {
            Bundle matchingArgs;
            NavDestination.DeepLinkMatch deepLinkMatch = startDestination.matchDeepLink(startRoute);
            Object object = matchingArgs = deepLinkMatch != null ? deepLinkMatch.getMatchingArgs() : null;
            if (matchingArgs != null && !matchingArgs.isEmpty()) {
                Bundle bundle = new Bundle();
                bundle.putAll(matchingArgs);
                Bundle bundle2 = args;
                if (bundle2 != null) {
                    Bundle it = bundle2;
                    boolean bl = false;
                    bundle.putAll(args);
                }
                args = bundle;
            }
        }
        Object navigator = this.navigatorProvider.getNavigator(startDestination.getNavigatorName());
        NavBackStackEntry startDestinationEntry = this.getState().createBackStackEntry(startDestination, startDestination.addInDefaultArgs(args));
        ((Navigator)navigator).navigate(CollectionsKt.listOf((Object)startDestinationEntry), navOptions, navigatorExtras);
    }
}

