/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.IdRes;
import androidx.annotation.RestrictTo;
import androidx.collection.SparseArrayCompat;
import androidx.collection.SparseArrayKt;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavType;
import androidx.navigation.Navigator;
import androidx.navigation.common.R;
import androidx.navigation.serialization.RouteSerializerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 J2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002:\u0001JB\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0001J\u001f\u0010\"\u001a\u00020\u001e2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010#\"\u00020\u0001\u00a2\u0006\u0002\u0010$J\u0016\u0010\"\u001a\u00020\u001e2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010%J\u0006\u0010&\u001a\u00020\u001eJ\u0013\u0010'\u001a\u00020(2\b\u0010\u001f\u001a\u0004\u0018\u00010)H\u0096\u0002J\u0013\u0010*\u001a\u0004\u0018\u00010\u0001\"\u0006\b\u0000\u0010+\u0018\u0001H\u0086\bJ\u001d\u0010*\u001a\u0004\u0018\u00010\u0001\"\u0004\b\u0000\u0010+2\b\u0010,\u001a\u0004\u0018\u0001H+\u00a2\u0006\u0002\u0010-J\u0012\u0010*\u001a\u0004\u0018\u00010\u00012\b\b\u0001\u0010.\u001a\u00020\u0011J\u001a\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u0010,\u001a\u00020\u00072\u0006\u0010/\u001a\u00020(H\u0007J\u0012\u0010*\u001a\u0004\u0018\u00010\u00012\b\u0010,\u001a\u0004\u0018\u00010\u0007J&\u00100\u001a\u0004\u0018\u00010\u00012\b\b\u0001\u0010.\u001a\u00020\u00112\b\u00101\u001a\u0004\u0018\u00010\u00012\u0006\u00102\u001a\u00020(H\u0007J\b\u00103\u001a\u00020\u0011H\u0007J\b\u00104\u001a\u00020\u0011H\u0016J\u000f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000106H\u0086\u0002J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:H\u0017J\u0012\u0010;\u001a\u0004\u0018\u0001082\u0006\u0010<\u001a\u00020:H\u0007J\u0018\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J\u000e\u0010B\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0001J\u0015\u0010C\u001a\u00020\u001e\"\n\b\u0000\u0010+\u0018\u0001*\u00020)H\u0086\bJ\u001d\u0010C\u001a\u00020\u001e\"\b\b\u0000\u0010+*\u00020)2\u0006\u0010\u0018\u001a\u0002H+\u00a2\u0006\u0002\u0010DJ\u000e\u0010C\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010C\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0007J0\u0010C\u001a\u00020\u001e\"\u0004\b\u0000\u0010+2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002H+0F2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070HH\u0007J\b\u0010I\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118G@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\t\"\u0004\b\u001b\u0010\u001c\u00a8\u0006K"}, d2={"Landroidx/navigation/NavGraph;", "Landroidx/navigation/NavDestination;", "", "navGraphNavigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "nodes", "Landroidx/collection/SparseArrayCompat;", "getNodes", "()Landroidx/collection/SparseArrayCompat;", "startDestDisplayName", "getStartDestDisplayName", "startDestId", "", "startDestIdName", "startDestinationId", "getStartDestinationId", "()I", "setStartDestinationId", "(I)V", "startDestRoute", "startDestinationRoute", "getStartDestinationRoute", "setStartDestinationRoute", "(Ljava/lang/String;)V", "addAll", "", "other", "addDestination", "node", "addDestinations", "", "([Landroidx/navigation/NavDestination;)V", "", "clear", "equals", "", "", "findNode", "T", "route", "(Ljava/lang/Object;)Landroidx/navigation/NavDestination;", "resId", "searchParents", "findNodeComprehensive", "lastVisited", "searchChildren", "getStartDestination", "hashCode", "iterator", "", "matchDeepLink", "Landroidx/navigation/NavDestination$DeepLinkMatch;", "navDeepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "matchDeepLinkExcludingChildren", "request", "onInflate", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "remove", "setStartDestination", "(Ljava/lang/Object;)V", "serializer", "Lkotlinx/serialization/KSerializer;", "parseRoute", "Lkotlin/Function1;", "toString", "Companion", "navigation-common_release"})
@SourceDebugExtension(value={"SMAP\nNavGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavGraph.kt\nandroidx/navigation/NavGraph\n+ 2 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 SparseArray.kt\nandroidx/collection/SparseArrayKt\n*L\n1#1,590:1\n232#2,3:591\n1603#3,9:594\n1855#3:603\n1856#3:605\n1612#3:606\n1#4:604\n1#4:607\n179#5,2:608\n1224#5,2:611\n22#6:610\n56#6,4:613\n*S KotlinDebug\n*F\n+ 1 NavGraph.kt\nandroidx/navigation/NavGraph\n*L\n61#1:591,3\n73#1:594,9\n73#1:603\n73#1:605\n73#1:606\n73#1:604\n237#1:608,2\n476#1:611,2\n474#1:610\n481#1:613,4\n*E\n"})
public class NavGraph
extends NavDestination
implements Iterable<NavDestination>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SparseArrayCompat<NavDestination> nodes;
    private int startDestId;
    @Nullable
    private String startDestIdName;
    @Nullable
    private String startDestinationRoute;

    public NavGraph(@NotNull Navigator<? extends NavGraph> navGraphNavigator) {
        Intrinsics.checkNotNullParameter(navGraphNavigator, (String)"navGraphNavigator");
        super(navGraphNavigator);
        this.nodes = new SparseArrayCompat();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final SparseArrayCompat<NavDestination> getNodes() {
        return this.nodes;
    }

    @Override
    public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super.onInflate(context, attrs);
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.NavGraphNavigator);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.resources.obtain\u2026leable.NavGraphNavigator)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray it = $this$use$iv;
        boolean bl = false;
        this.setStartDestinationId(it.getResourceId(R.styleable.NavGraphNavigator_startDestination, 0));
        this.startDestIdName = NavDestination.Companion.getDisplayName(context, this.startDestId);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl2 = false;
        $this$use$iv.recycle();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public NavDestination.DeepLinkMatch matchDeepLink(@NotNull NavDeepLinkRequest navDeepLinkRequest) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)navDeepLinkRequest, (String)"navDeepLinkRequest");
        NavDestination.DeepLinkMatch bestMatch = super.matchDeepLink(navDeepLinkRequest);
        Iterable $this$mapNotNull$iv = this;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            NavDestination.DeepLinkMatch it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            NavDestination child = (NavDestination)element$iv$iv;
            boolean bl2 = false;
            if (child.matchDeepLink(navDeepLinkRequest) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        NavDestination.DeepLinkMatch bestChildMatch = (NavDestination.DeepLinkMatch)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        Object[] objectArray = new NavDestination.DeepLinkMatch[]{bestMatch, bestChildMatch};
        return (NavDestination.DeepLinkMatch)CollectionsKt.maxOrNull((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination.DeepLinkMatch matchDeepLinkExcludingChildren(@NotNull NavDeepLinkRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return super.matchDeepLink(request);
    }

    public final void addDestination(@NotNull NavDestination node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int id = node.getId();
        String innerRoute = node.getRoute();
        if (!(id != 0 || innerRoute != null)) {
            boolean $i$a$-require-NavGraph$addDestination$42 = false;
            String $i$a$-require-NavGraph$addDestination$42 = "Destinations must have an id or route. Call setId(), setRoute(), or include an android:id or app:route in your navigation XML.";
            throw new IllegalArgumentException($i$a$-require-NavGraph$addDestination$42.toString());
        }
        if (this.getRoute() != null && !(!Intrinsics.areEqual((Object)innerRoute, (Object)this.getRoute()))) {
            boolean $i$a$-require-NavGraph$addDestination$52 = false;
            String $i$a$-require-NavGraph$addDestination$52 = "Destination " + node + " cannot have the same route as graph " + this;
            throw new IllegalArgumentException($i$a$-require-NavGraph$addDestination$52.toString());
        }
        if (!(id != this.getId())) {
            boolean bl = false;
            String string = "Destination " + node + " cannot have the same id as graph " + this;
            throw new IllegalArgumentException(string.toString());
        }
        NavDestination existingDestination = (NavDestination)this.nodes.get(id);
        if (existingDestination == node) {
            return;
        }
        if (!(node.getParent() == null)) {
            boolean bl = false;
            String string = "Destination already has a parent set. Call NavGraph.remove() to remove the previous parent.";
            throw new IllegalStateException(string.toString());
        }
        if (existingDestination != null) {
            existingDestination.setParent(null);
        }
        node.setParent(this);
        this.nodes.put(node.getId(), (Object)node);
    }

    public final void addDestinations(@NotNull Collection<? extends NavDestination> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        for (NavDestination navDestination : nodes) {
            if (navDestination == null) continue;
            this.addDestination(navDestination);
        }
    }

    public final void addDestinations(NavDestination ... nodes) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        for (NavDestination node : nodes) {
            this.addDestination(node);
        }
    }

    @Nullable
    public final NavDestination findNode(@IdRes int resId) {
        return this.findNodeComprehensive(resId, this, false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination findNodeComprehensive(@IdRes int resId, @Nullable NavDestination lastVisited, boolean searchChildren) {
        NavDestination navDestination;
        NavDestination destination;
        block6: {
            NavDestination navDestination2 = destination = (NavDestination)this.nodes.get(resId);
            if (navDestination2 != null) {
                return navDestination2;
            }
            if (searchChildren) {
                NavDestination navDestination3;
                for (NavDestination child : SequencesKt.asSequence((Iterator)SparseArrayKt.valueIterator(this.nodes))) {
                    boolean bl = false;
                    NavDestination navDestination4 = child instanceof NavGraph && !Intrinsics.areEqual((Object)child, (Object)lastVisited) ? ((NavGraph)child).findNodeComprehensive(resId, this, true) : null;
                    if (navDestination4 == null) continue;
                    navDestination3 = navDestination4;
                    break block6;
                }
                navDestination3 = destination = null;
            }
        }
        if ((navDestination = destination) == null) {
            if (this.getParent() != null && !Intrinsics.areEqual((Object)this.getParent(), (Object)lastVisited)) {
                NavGraph navGraph = this.getParent();
                Intrinsics.checkNotNull((Object)navGraph);
                navDestination = navGraph.findNodeComprehensive(resId, this, searchChildren);
            } else {
                navDestination = null;
            }
        }
        return navDestination;
    }

    @Nullable
    public final NavDestination findNode(@Nullable String route) {
        CharSequence charSequence = route;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? this.findNode(route, true) : null;
    }

    public final /* synthetic */ <T> NavDestination findNode() {
        boolean $i$f$findNode = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.simple");
        return this.findNode(RouteSerializerKt.generateHashCode(SerializersKt.serializer(null)));
    }

    @Nullable
    public final <T> NavDestination findNode(@Nullable T route) {
        NavDestination navDestination;
        T t = route;
        if (t != null) {
            T it = t;
            boolean bl = false;
            navDestination = this.findNode(RouteSerializerKt.generateHashCode(SerializersKt.serializer((KClass)Reflection.getOrCreateKotlinClass(it.getClass()))));
        } else {
            navDestination = null;
        }
        return navDestination;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination findNode(@NotNull String route, boolean searchParents) {
        NavDestination destination;
        NavDestination navDestination;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            Sequence $this$firstOrNull$iv = SequencesKt.asSequence((Iterator)SparseArrayKt.valueIterator(this.nodes));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NavDestination it = (NavDestination)element$iv;
                boolean bl = false;
                if (!(StringsKt.equals$default((String)it.getRoute(), (String)route, (boolean)false, (int)2, null) || it.matchDeepLink(route) != null)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        if ((navDestination = (destination = (NavDestination)v0)) == null) {
            if (searchParents && this.getParent() != null) {
                NavGraph navGraph = this.getParent();
                Intrinsics.checkNotNull((Object)navGraph);
                navDestination = navGraph.findNode(route);
            } else {
                navDestination = null;
            }
        }
        return navDestination;
    }

    @Override
    @NotNull
    public final Iterator<NavDestination> iterator() {
        return new Iterator<NavDestination>(this){
            private int index;
            private boolean wentToNext;
            final /* synthetic */ NavGraph this$0;
            {
                this.this$0 = $receiver;
                this.index = -1;
            }

            public boolean hasNext() {
                return this.index + 1 < this.this$0.getNodes().size();
            }

            @NotNull
            public NavDestination next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.wentToNext = true;
                ++this.index;
                Object object = this.this$0.getNodes().valueAt(this.index);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodes.valueAt(++index)");
                return (NavDestination)object;
            }

            public void remove() {
                if (!this.wentToNext) {
                    boolean $i$a$-check-NavGraph$iterator$1$remove$22 = false;
                    String $i$a$-check-NavGraph$iterator$1$remove$22 = "You must call next() before you can remove an element";
                    throw new IllegalStateException($i$a$-check-NavGraph$iterator$1$remove$22.toString());
                }
                SparseArrayCompat<NavDestination> $this$remove_u24lambda_u241 = this.this$0.getNodes();
                boolean bl = false;
                ((NavDestination)$this$remove_u24lambda_u241.valueAt(this.index)).setParent(null);
                $this$remove_u24lambda_u241.removeAt(this.index);
                int n = this.index;
                this.index = n + -1;
                this.wentToNext = false;
            }
        };
    }

    public final void addAll(@NotNull NavGraph other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Iterator<NavDestination> iterator2 = other.iterator();
        while (iterator2.hasNext()) {
            NavDestination destination = iterator2.next();
            iterator2.remove();
            this.addDestination(destination);
        }
    }

    public final void remove(@NotNull NavDestination node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int index = this.nodes.indexOfKey(node.getId());
        if (index >= 0) {
            ((NavDestination)this.nodes.valueAt(index)).setParent(null);
            this.nodes.removeAt(index);
        }
    }

    public final void clear() {
        Iterator<NavDestination> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            iterator2.remove();
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public String getDisplayName() {
        return this.getId() != 0 ? super.getDisplayName() : "the root navigation";
    }

    @Deprecated(message="Use getStartDestinationId instead.", replaceWith=@ReplaceWith(expression="startDestinationId", imports={}))
    @IdRes
    public final int getStartDestination() {
        return this.getStartDestinationId();
    }

    @IdRes
    public final int getStartDestinationId() {
        return this.startDestId;
    }

    private final void setStartDestinationId(int startDestId) {
        if (!(startDestId != this.getId())) {
            boolean bl = false;
            String string = "Start destination " + startDestId + " cannot use the same id as the graph " + this;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.startDestinationRoute != null) {
            this.setStartDestinationRoute(null);
        }
        this.startDestId = startDestId;
        this.startDestIdName = null;
    }

    public final void setStartDestination(int startDestId) {
        this.setStartDestinationId(startDestId);
    }

    public final void setStartDestination(@NotNull String startDestRoute) {
        Intrinsics.checkNotNullParameter((Object)startDestRoute, (String)"startDestRoute");
        this.setStartDestinationRoute(startDestRoute);
    }

    public final /* synthetic */ <T> void setStartDestination() {
        boolean $i$f$setStartDestination = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.simple");
        this.setStartDestination(SerializersKt.serializer(null), (Function1<? super NavDestination, String>)((Function1)setStartDestination.1.INSTANCE));
    }

    public final <T> void setStartDestination(@NotNull T startDestRoute) {
        Intrinsics.checkNotNullParameter(startDestRoute, (String)"startDestRoute");
        this.setStartDestination(SerializersKt.serializer((KClass)Reflection.getOrCreateKotlinClass(startDestRoute.getClass())), (Function1<? super NavDestination, String>)((Function1)new Function1<NavDestination, String>(startDestRoute){
            final /* synthetic */ T $startDestRoute;
            {
                this.$startDestRoute = $startDestRoute;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke(@NotNull NavDestination startDestination) {
                void $this$mapValuesTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)startDestination, (String)"startDestination");
                Map<String, NavArgument> $this$mapValues$iv = startDestination.getArguments();
                boolean $i$f$mapValues = false;
                Map<String, NavArgument> map = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    K k = it$iv$iv.getKey();
                    Map map3 = map2;
                    boolean bl2 = false;
                    NavType<Object> navType = ((NavArgument)it.getValue()).getType();
                    map3.put(k, navType);
                }
                Map args = destination$iv$iv;
                return RouteSerializerKt.generateRouteWithArgs(this.$startDestRoute, args);
            }
        }));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final <T> void setStartDestination(@NotNull KSerializer<T> serializer, @NotNull Function1<? super NavDestination, String> parseRoute) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(parseRoute, (String)"parseRoute");
        int id = RouteSerializerKt.generateHashCode(serializer);
        NavDestination startDest = this.findNode(id);
        if (startDest == null) {
            boolean bl = false;
            String string = "Cannot find startDestination " + serializer.getDescriptor().getSerialName() + " from NavGraph. Ensure the starting NavDestination was added with route from KClass.";
            throw new IllegalStateException(string.toString());
        }
        this.setStartDestinationRoute((String)parseRoute.invoke((Object)startDest));
        this.startDestId = id;
    }

    @Nullable
    public final String getStartDestinationRoute() {
        return this.startDestinationRoute;
    }

    private final void setStartDestinationRoute(String startDestRoute) {
        int n;
        NavGraph navGraph = this;
        if (startDestRoute == null) {
            n = 0;
        } else {
            if (!(!Intrinsics.areEqual((Object)startDestRoute, (Object)this.getRoute()))) {
                NavGraph navGraph2 = navGraph;
                boolean $i$a$-require-NavGraph$startDestinationRoute$32 = false;
                NavGraph navGraph3 = navGraph2;
                String $i$a$-require-NavGraph$startDestinationRoute$32 = "Start destination " + startDestRoute + " cannot use the same route as the graph " + this;
                throw new IllegalArgumentException($i$a$-require-NavGraph$startDestinationRoute$32.toString());
            }
            if (!(!StringsKt.isBlank((CharSequence)startDestRoute))) {
                NavGraph navGraph4 = navGraph;
                boolean bl = false;
                NavGraph navGraph5 = navGraph4;
                String string = "Cannot have an empty start destination route";
                throw new IllegalArgumentException(string.toString());
            }
            String internalRoute = NavDestination.Companion.createRoute(startDestRoute);
            n = internalRoute.hashCode();
        }
        navGraph.startDestId = n;
        this.startDestinationRoute = startDestRoute;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final String getStartDestDisplayName() {
        if (this.startDestIdName == null) {
            String string = this.startDestinationRoute;
            if (string == null) {
                string = String.valueOf(this.startDestId);
            }
            this.startDestIdName = string;
        }
        String string = this.startDestIdName;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        NavDestination navDestination = this.findNode(this.startDestinationRoute);
        if (navDestination == null) {
            navDestination = this.findNode(this.getStartDestinationId());
        }
        NavDestination startDestination = navDestination;
        sb.append(" startDestination=");
        if (startDestination == null) {
            if (this.startDestinationRoute != null) {
                sb.append(this.startDestinationRoute);
            } else if (this.startDestIdName != null) {
                sb.append(this.startDestIdName);
            } else {
                sb.append("0x" + Integer.toHexString(this.startDestId));
            }
        } else {
            sb.append("{");
            sb.append(startDestination.toString());
            sb.append("}");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        NavDestination it;
        if (this == other) {
            return true;
        }
        if (other == null) return false;
        if (!(other instanceof NavGraph)) {
            return false;
        }
        if (!super.equals(other)) return false;
        SparseArrayCompat<NavDestination> $receiver$iv = this.nodes;
        boolean $i$f$getSize = false;
        int n = $receiver$iv.size();
        $receiver$iv = ((NavGraph)other).nodes;
        $i$f$getSize = false;
        if (n != $receiver$iv.size()) return false;
        if (this.getStartDestinationId() != ((NavGraph)other).getStartDestinationId()) return false;
        Sequence $this$all$iv = SequencesKt.asSequence((Iterator)SparseArrayKt.valueIterator(this.nodes));
        boolean $i$f$all = false;
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (NavDestination)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)it, (Object)((NavGraph)other).nodes.get(it.getId())));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        int result = 0;
        result = this.getStartDestinationId();
        SparseArrayCompat<NavDestination> $receiver$iv = this.nodes;
        boolean $i$f$forEach = false;
        int n = 0;
        int n2 = $receiver$iv.size();
        while (n < n2) {
            void value;
            void index$iv;
            NavDestination navDestination = (NavDestination)$receiver$iv.valueAt((int)index$iv);
            int key = $receiver$iv.keyAt((int)index$iv);
            boolean bl = false;
            result = 31 * result + key;
            result = 31 * result + value.hashCode();
            ++index$iv;
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final NavDestination findStartDestination(@NotNull NavGraph $this$findStartDestination) {
        return Companion.findStartDestination($this$findStartDestination);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Landroidx/navigation/NavGraph$Companion;", "", "()V", "findStartDestination", "Landroidx/navigation/NavDestination;", "Landroidx/navigation/NavGraph;", "navigation-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final NavDestination findStartDestination(@NotNull NavGraph $this$findStartDestination) {
            Intrinsics.checkNotNullParameter((Object)$this$findStartDestination, (String)"<this>");
            return (NavDestination)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)$this$findStartDestination.findNode($this$findStartDestination.getStartDestinationId()), (Function1)findStartDestination.1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

