/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.AnyRes;
import androidx.annotation.RestrictTo;
import androidx.navigation.CollectionNavType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u000e\b&\u0018\u0000 !*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0006!\"#$%&B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u00a6\u0002\u00a2\u0006\u0002\u0010\u000fJ%\u0010\u0010\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0010\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\bH\u0016J\u001d\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Landroidx/navigation/NavType;", "T", "", "isNullableAllowed", "", "(Z)V", "()Z", "name", "", "getName", "()Ljava/lang/String;", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)Ljava/lang/Object;", "parseAndPut", "value", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "previousValue", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "parseValue", "(Ljava/lang/String;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/lang/Object;)V", "serializeAsValue", "(Ljava/lang/Object;)Ljava/lang/String;", "toString", "valueEquals", "other", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "Companion", "EnumType", "ParcelableArrayType", "ParcelableType", "SerializableArrayType", "SerializableType", "navigation-common_release"})
public abstract class NavType<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isNullableAllowed;
    @NotNull
    private final String name;
    @JvmField
    @NotNull
    public static final NavType<Integer> IntType = new NavType<Integer>(){

        @NotNull
        public String getName() {
            return "integer";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, int value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putInt(key, value);
        }

        @NotNull
        public Integer get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            return (Integer)object;
        }

        @NotNull
        public Integer parseValue(@NotNull String value) {
            int n;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (StringsKt.startsWith$default((String)value, (String)"0x", (boolean)false, (int)2, null)) {
                String string = value.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                n = Integer.parseInt(string, CharsKt.checkRadix((int)16));
            } else {
                n = Integer.parseInt(value);
            }
            return n;
        }
    };
    @JvmField
    @NotNull
    public static final NavType<Integer> ReferenceType = new NavType<Integer>(){

        @NotNull
        public String getName() {
            return "reference";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @AnyRes int value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putInt(key, value);
        }

        @AnyRes
        @NotNull
        public Integer get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            return (Integer)object;
        }

        @NotNull
        public Integer parseValue(@NotNull String value) {
            int n;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (StringsKt.startsWith$default((String)value, (String)"0x", (boolean)false, (int)2, null)) {
                String string = value.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                n = Integer.parseInt(string, CharsKt.checkRadix((int)16));
            } else {
                n = Integer.parseInt(value);
            }
            return n;
        }
    };
    @JvmField
    @NotNull
    public static final NavType<int[]> IntArrayType = new CollectionNavType<int[]>(){

        @NotNull
        public String getName() {
            return "integer[]";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable int[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putIntArray(key, value);
        }

        @Nullable
        public int[] get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (int[])bundle.get(key);
        }

        @NotNull
        public int[] parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int[] nArray = new int[]{((Number)NavType.IntType.parseValue(value)).intValue()};
            return nArray;
        }

        @NotNull
        public int[] parseValue(@NotNull String value, @Nullable int[] previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int[] nArray = previousValue;
            if (previousValue == null || (nArray = ArraysKt.plus((int[])nArray, (int[])this.parseValue(value))) == null) {
                nArray = this.parseValue(value);
            }
            return nArray;
        }

        public boolean valueEquals(@Nullable int[] value, @Nullable int[] other) {
            Object[] valueArray = value != null ? ArraysKt.toTypedArray((int[])value) : null;
            Object[] otherArray = other != null ? ArraysKt.toTypedArray((int[])other) : null;
            Object[] objectArray = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])otherArray);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public List<String> serializeAsValues(@Nullable int[] value) {
            List list;
            Object object = value;
            if (value != null) {
                List list2 = ArraysKt.toList((int[])object);
                object = list2;
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                    while (true) {
                        void it;
                        if (!iterator2.hasNext()) {
                            list = (List)destination$iv$iv;
                            return list;
                        }
                        T item$iv$iv = iterator2.next();
                        int n = ((Number)item$iv$iv).intValue();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(String.valueOf((int)it));
                    }
                }
            }
            list = CollectionsKt.emptyList();
            return list;
        }

        @NotNull
        public int[] emptyCollection() {
            return new int[0];
        }
    };
    @JvmField
    @NotNull
    public static final NavType<List<Integer>> IntListType = new CollectionNavType<List<? extends Integer>>(){

        @NotNull
        public String getName() {
            return "List<Int>";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable List<Integer> value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            List<Integer> list = value;
            bundle.putIntArray(key, (int[])(list != null ? CollectionsKt.toIntArray((Collection)list) : null));
        }

        @Nullable
        public List<Integer> get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            int[] nArray = (int[])bundle.get(key);
            return nArray != null ? ArraysKt.toList((int[])nArray) : null;
        }

        @NotNull
        public List<Integer> parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return CollectionsKt.listOf((Object)NavType.IntType.parseValue(value));
        }

        @Nullable
        public List<Integer> parseValue(@NotNull String value, @Nullable List<Integer> previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            List<Integer> list = previousValue;
            if (list == null || (list = CollectionsKt.plus((Collection)list, (Iterable)((Iterable)this.parseValue(value)))) == null) {
                list = this.parseValue(value);
            }
            return list;
        }

        public boolean valueEquals(@Nullable List<Integer> value, @Nullable List<Integer> other) {
            Integer[] integerArray;
            Object[] objectArray;
            List<Integer> list = value;
            if (list != null) {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new Integer[0]);
            } else {
                objectArray = null;
            }
            Object[] valueArray = objectArray;
            List<Integer> list2 = other;
            if (list2 != null) {
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                integerArray = thisCollection$iv.toArray(new Integer[0]);
            } else {
                integerArray = null;
            }
            Integer[] otherArray = integerArray;
            Object[] objectArray2 = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray2, otherArray);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<String> serializeAsValues(@Nullable List<Integer> value) {
            List list;
            List<Integer> list2 = value;
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    int n = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(String.valueOf((int)it));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @NotNull
        public List<Integer> emptyCollection() {
            return CollectionsKt.emptyList();
        }
    };
    @JvmField
    @NotNull
    public static final NavType<Long> LongType = new NavType<Long>(){

        @NotNull
        public String getName() {
            return "long";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, long value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putLong(key, value);
        }

        @NotNull
        public Long get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            return (Long)object;
        }

        @NotNull
        public Long parseValue(@NotNull String value) {
            long l;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String localValue = value;
            if (StringsKt.endsWith$default((String)value, (String)"L", (boolean)false, (int)2, null)) {
                String string = localValue.substring(0, value.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                localValue = string;
            }
            if (StringsKt.startsWith$default((String)value, (String)"0x", (boolean)false, (int)2, null)) {
                String string = localValue.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                l = Long.parseLong(string, CharsKt.checkRadix((int)16));
            } else {
                l = Long.parseLong(localValue);
            }
            return l;
        }
    };
    @JvmField
    @NotNull
    public static final NavType<long[]> LongArrayType = new CollectionNavType<long[]>(){

        @NotNull
        public String getName() {
            return "long[]";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable long[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putLongArray(key, value);
        }

        @Nullable
        public long[] get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (long[])bundle.get(key);
        }

        @NotNull
        public long[] parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            long[] lArray = new long[]{((Number)NavType.LongType.parseValue(value)).longValue()};
            return lArray;
        }

        @Nullable
        public long[] parseValue(@NotNull String value, @Nullable long[] previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            long[] lArray = previousValue;
            if (previousValue == null || (lArray = ArraysKt.plus((long[])lArray, (long[])this.parseValue(value))) == null) {
                lArray = this.parseValue(value);
            }
            return lArray;
        }

        public boolean valueEquals(@Nullable long[] value, @Nullable long[] other) {
            Object[] valueArray = value != null ? ArraysKt.toTypedArray((long[])value) : null;
            Object[] otherArray = other != null ? ArraysKt.toTypedArray((long[])other) : null;
            Object[] objectArray = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])otherArray);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public List<String> serializeAsValues(@Nullable long[] value) {
            List list;
            Object object = value;
            if (value != null) {
                List list2 = ArraysKt.toList((long[])object);
                object = list2;
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                    while (true) {
                        void it;
                        if (!iterator2.hasNext()) {
                            list = (List)destination$iv$iv;
                            return list;
                        }
                        T item$iv$iv = iterator2.next();
                        long l = ((Number)item$iv$iv).longValue();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(String.valueOf((long)it));
                    }
                }
            }
            list = CollectionsKt.emptyList();
            return list;
        }

        @NotNull
        public long[] emptyCollection() {
            return new long[0];
        }
    };
    @JvmField
    @NotNull
    public static final NavType<List<Long>> LongListType = new CollectionNavType<List<? extends Long>>(){

        @NotNull
        public String getName() {
            return "List<Long>";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable List<Long> value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            List<Long> list = value;
            bundle.putLongArray(key, (long[])(list != null ? CollectionsKt.toLongArray((Collection)list) : null));
        }

        @Nullable
        public List<Long> get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            long[] lArray = (long[])bundle.get(key);
            return lArray != null ? ArraysKt.toList((long[])lArray) : null;
        }

        @NotNull
        public List<Long> parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return CollectionsKt.listOf((Object)NavType.LongType.parseValue(value));
        }

        @Nullable
        public List<Long> parseValue(@NotNull String value, @Nullable List<Long> previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            List<Long> list = previousValue;
            if (list == null || (list = CollectionsKt.plus((Collection)list, (Iterable)((Iterable)this.parseValue(value)))) == null) {
                list = this.parseValue(value);
            }
            return list;
        }

        public boolean valueEquals(@Nullable List<Long> value, @Nullable List<Long> other) {
            Long[] longArray;
            Object[] objectArray;
            List<Long> list = value;
            if (list != null) {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new Long[0]);
            } else {
                objectArray = null;
            }
            Object[] valueArray = objectArray;
            List<Long> list2 = other;
            if (list2 != null) {
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                longArray = thisCollection$iv.toArray(new Long[0]);
            } else {
                longArray = null;
            }
            Long[] otherArray = longArray;
            Object[] objectArray2 = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray2, otherArray);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<String> serializeAsValues(@Nullable List<Long> value) {
            List list;
            List<Long> list2 = value;
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    long l = ((Number)item$iv$iv).longValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(String.valueOf((long)it));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @NotNull
        public List<Long> emptyCollection() {
            return CollectionsKt.emptyList();
        }
    };
    @JvmField
    @NotNull
    public static final NavType<Float> FloatType = new NavType<Float>(){

        @NotNull
        public String getName() {
            return "float";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, float value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putFloat(key, value);
        }

        @NotNull
        public Float get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            return (Float)object;
        }

        @NotNull
        public Float parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Float.valueOf(Float.parseFloat(value));
        }
    };
    @JvmField
    @NotNull
    public static final NavType<float[]> FloatArrayType = new CollectionNavType<float[]>(){

        @NotNull
        public String getName() {
            return "float[]";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable float[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putFloatArray(key, value);
        }

        @Nullable
        public float[] get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (float[])bundle.get(key);
        }

        @NotNull
        public float[] parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            float[] fArray = new float[]{((Number)NavType.FloatType.parseValue(value)).floatValue()};
            return fArray;
        }

        @Nullable
        public float[] parseValue(@NotNull String value, @Nullable float[] previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            float[] fArray = previousValue;
            if (previousValue == null || (fArray = ArraysKt.plus((float[])fArray, (float[])this.parseValue(value))) == null) {
                fArray = this.parseValue(value);
            }
            return fArray;
        }

        public boolean valueEquals(@Nullable float[] value, @Nullable float[] other) {
            Object[] valueArray = value != null ? ArraysKt.toTypedArray((float[])value) : null;
            Object[] otherArray = other != null ? ArraysKt.toTypedArray((float[])other) : null;
            Object[] objectArray = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])otherArray);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public List<String> serializeAsValues(@Nullable float[] value) {
            List list;
            Object object = value;
            if (value != null) {
                List list2 = ArraysKt.toList((float[])object);
                object = list2;
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                    while (true) {
                        void it;
                        if (!iterator2.hasNext()) {
                            list = (List)destination$iv$iv;
                            return list;
                        }
                        T item$iv$iv = iterator2.next();
                        float f = ((Number)item$iv$iv).floatValue();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(String.valueOf((float)it));
                    }
                }
            }
            list = CollectionsKt.emptyList();
            return list;
        }

        @NotNull
        public float[] emptyCollection() {
            return new float[0];
        }
    };
    @JvmField
    @NotNull
    public static final NavType<List<Float>> FloatListType = new CollectionNavType<List<? extends Float>>(){

        @NotNull
        public String getName() {
            return "List<Float>";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable List<Float> value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            List<Float> list = value;
            bundle.putFloatArray(key, (float[])(list != null ? CollectionsKt.toFloatArray((Collection)list) : null));
        }

        @Nullable
        public List<Float> get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            float[] fArray = (float[])bundle.get(key);
            return fArray != null ? ArraysKt.toList((float[])fArray) : null;
        }

        @NotNull
        public List<Float> parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return CollectionsKt.listOf((Object)NavType.FloatType.parseValue(value));
        }

        @Nullable
        public List<Float> parseValue(@NotNull String value, @Nullable List<Float> previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            List<Float> list = previousValue;
            if (list == null || (list = CollectionsKt.plus((Collection)list, (Iterable)((Iterable)this.parseValue(value)))) == null) {
                list = this.parseValue(value);
            }
            return list;
        }

        public boolean valueEquals(@Nullable List<Float> value, @Nullable List<Float> other) {
            Float[] floatArray;
            Object[] objectArray;
            List<Float> list = value;
            if (list != null) {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new Float[0]);
            } else {
                objectArray = null;
            }
            Object[] valueArray = objectArray;
            List<Float> list2 = other;
            if (list2 != null) {
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                floatArray = thisCollection$iv.toArray(new Float[0]);
            } else {
                floatArray = null;
            }
            Float[] otherArray = floatArray;
            Object[] objectArray2 = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray2, otherArray);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<String> serializeAsValues(@Nullable List<Float> value) {
            List list;
            List<Float> list2 = value;
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    float f = ((Number)item$iv$iv).floatValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(String.valueOf((float)it));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @NotNull
        public List<Float> emptyCollection() {
            return CollectionsKt.emptyList();
        }
    };
    @JvmField
    @NotNull
    public static final NavType<Boolean> BoolType = new NavType<Boolean>(){

        @NotNull
        public String getName() {
            return "boolean";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, boolean value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putBoolean(key, value);
        }

        @Nullable
        public Boolean get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (Boolean)bundle.get(key);
        }

        @NotNull
        public Boolean parseValue(@NotNull String value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = value;
            if (Intrinsics.areEqual((Object)string, (Object)"true")) {
                bl = true;
            } else if (Intrinsics.areEqual((Object)string, (Object)"false")) {
                bl = false;
            } else {
                throw new IllegalArgumentException("A boolean NavType only accepts \"true\" or \"false\" values.");
            }
            return bl;
        }
    };
    @JvmField
    @NotNull
    public static final NavType<boolean[]> BoolArrayType = new CollectionNavType<boolean[]>(){

        @NotNull
        public String getName() {
            return "boolean[]";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable boolean[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putBooleanArray(key, value);
        }

        @Nullable
        public boolean[] get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (boolean[])bundle.get(key);
        }

        @NotNull
        public boolean[] parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            boolean[] blArray = new boolean[]{NavType.BoolType.parseValue(value)};
            return blArray;
        }

        @Nullable
        public boolean[] parseValue(@NotNull String value, @Nullable boolean[] previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            boolean[] blArray = previousValue;
            if (previousValue == null || (blArray = ArraysKt.plus((boolean[])blArray, (boolean[])this.parseValue(value))) == null) {
                blArray = this.parseValue(value);
            }
            return blArray;
        }

        public boolean valueEquals(@Nullable boolean[] value, @Nullable boolean[] other) {
            Object[] valueArray = value != null ? ArraysKt.toTypedArray((boolean[])value) : null;
            Object[] otherArray = other != null ? ArraysKt.toTypedArray((boolean[])other) : null;
            Object[] objectArray = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])otherArray);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public List<String> serializeAsValues(@Nullable boolean[] value) {
            List list;
            Object object = value;
            if (value != null) {
                List list2 = ArraysKt.toList((boolean[])object);
                object = list2;
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                    while (true) {
                        void it;
                        if (!iterator2.hasNext()) {
                            list = (List)destination$iv$iv;
                            return list;
                        }
                        T item$iv$iv = iterator2.next();
                        boolean bl = (Boolean)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(String.valueOf((boolean)it));
                    }
                }
            }
            list = CollectionsKt.emptyList();
            return list;
        }

        @NotNull
        public boolean[] emptyCollection() {
            return new boolean[0];
        }
    };
    @JvmField
    @NotNull
    public static final NavType<List<Boolean>> BoolListType = new CollectionNavType<List<? extends Boolean>>(){

        @NotNull
        public String getName() {
            return "List<Boolean>";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable List<Boolean> value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            List<Boolean> list = value;
            bundle.putBooleanArray(key, (boolean[])(list != null ? CollectionsKt.toBooleanArray((Collection)list) : null));
        }

        @Nullable
        public List<Boolean> get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            boolean[] blArray = (boolean[])bundle.get(key);
            return blArray != null ? ArraysKt.toList((boolean[])blArray) : null;
        }

        @NotNull
        public List<Boolean> parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return CollectionsKt.listOf((Object)NavType.BoolType.parseValue(value));
        }

        @Nullable
        public List<Boolean> parseValue(@NotNull String value, @Nullable List<Boolean> previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            List<Boolean> list = previousValue;
            if (list == null || (list = CollectionsKt.plus((Collection)list, (Iterable)((Iterable)this.parseValue(value)))) == null) {
                list = this.parseValue(value);
            }
            return list;
        }

        public boolean valueEquals(@Nullable List<Boolean> value, @Nullable List<Boolean> other) {
            Boolean[] booleanArray;
            Object[] objectArray;
            List<Boolean> list = value;
            if (list != null) {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new Boolean[0]);
            } else {
                objectArray = null;
            }
            Object[] valueArray = objectArray;
            List<Boolean> list2 = other;
            if (list2 != null) {
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                booleanArray = thisCollection$iv.toArray(new Boolean[0]);
            } else {
                booleanArray = null;
            }
            Boolean[] otherArray = booleanArray;
            Object[] objectArray2 = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray2, otherArray);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<String> serializeAsValues(@Nullable List<Boolean> value) {
            List list;
            List<Boolean> list2 = value;
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    boolean bl = (Boolean)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(String.valueOf((boolean)it));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @NotNull
        public List<Boolean> emptyCollection() {
            return CollectionsKt.emptyList();
        }
    };
    @JvmField
    @NotNull
    public static final NavType<String> StringType = new NavType<String>(){

        @NotNull
        public String getName() {
            return "string";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putString(key, value);
        }

        @Nullable
        public String get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (String)bundle.get(key);
        }

        @Nullable
        public String parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.areEqual((Object)value, (Object)"null") ? null : value;
        }

        @NotNull
        public String serializeAsValue(@Nullable String value) {
            String string;
            String string2;
            String string3 = value;
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                string2 = Uri.encode((String)value);
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "null";
            }
            return string;
        }
    };
    @JvmField
    @NotNull
    public static final NavType<String[]> StringArrayType = new CollectionNavType<String[]>(){

        @NotNull
        public String getName() {
            return "string[]";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable String[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putStringArray(key, value);
        }

        @Nullable
        public String[] get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (String[])bundle.get(key);
        }

        @NotNull
        public String[] parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String[] stringArray = new String[]{value};
            return stringArray;
        }

        @Nullable
        public String[] parseValue(@NotNull String value, @Nullable String[] previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object[] objectArray = previousValue;
            if (previousValue == null || (objectArray = (String[])ArraysKt.plus((Object[])objectArray, (Object[])this.parseValue(value))) == null) {
                objectArray = this.parseValue(value);
            }
            return objectArray;
        }

        public boolean valueEquals(@Nullable String[] value, @Nullable String[] other) {
            Object[] objectArray = value;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])other);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<String> serializeAsValues(@Nullable String[] value) {
            List list;
            if (value != null) {
                void $this$mapTo$iv$iv;
                String[] $this$map$iv = value;
                boolean $i$f$map = false;
                String[] stringArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Uri.encode((String)it));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @NotNull
        public String[] emptyCollection() {
            return new String[0];
        }
    };
    @JvmField
    @NotNull
    public static final NavType<List<String>> StringListType = new CollectionNavType<List<? extends String>>(){

        @NotNull
        public String getName() {
            return "List<String>";
        }

        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable List<String> value) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            List<String> list = value;
            if (list != null) {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                stringArray = thisCollection$iv.toArray(new String[0]);
            } else {
                stringArray = null;
            }
            bundle.putStringArray(key, stringArray);
        }

        @Nullable
        public List<String> get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object[] objectArray = (String[])bundle.get(key);
            return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        }

        @NotNull
        public List<String> parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return CollectionsKt.listOf((Object)value);
        }

        @Nullable
        public List<String> parseValue(@NotNull String value, @Nullable List<String> previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            List<String> list = previousValue;
            if (list == null || (list = CollectionsKt.plus((Collection)list, (Iterable)((Iterable)this.parseValue(value)))) == null) {
                list = this.parseValue(value);
            }
            return list;
        }

        public boolean valueEquals(@Nullable List<String> value, @Nullable List<String> other) {
            String[] stringArray;
            Object[] objectArray;
            List<String> list = value;
            if (list != null) {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new String[0]);
            } else {
                objectArray = null;
            }
            Object[] valueArray = objectArray;
            List<String> list2 = other;
            if (list2 != null) {
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                stringArray = thisCollection$iv.toArray(new String[0]);
            } else {
                stringArray = null;
            }
            String[] otherArray = stringArray;
            Object[] objectArray2 = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray2, otherArray);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<String> serializeAsValues(@Nullable List<String> value) {
            List list;
            List<String> list2 = value;
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Uri.encode((String)it));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @NotNull
        public List<String> emptyCollection() {
            return CollectionsKt.emptyList();
        }
    };

    public NavType(boolean isNullableAllowed) {
        this.isNullableAllowed = isNullableAllowed;
        this.name = "nav_type";
    }

    public boolean isNullableAllowed() {
        return this.isNullableAllowed;
    }

    public abstract void put(@NotNull Bundle var1, @NotNull String var2, T var3);

    @Nullable
    public abstract T get(@NotNull Bundle var1, @NotNull String var2);

    public abstract T parseValue(@NotNull String var1);

    public T parseValue(@NotNull String value, T previousValue) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.parseValue(value);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final T parseAndPut(@NotNull Bundle bundle, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        T parsedValue = this.parseValue(value);
        this.put(bundle, key, parsedValue);
        return parsedValue;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final T parseAndPut(@NotNull Bundle bundle, @NotNull String key, @Nullable String value, T previousValue) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!bundle.containsKey(key)) {
            throw new IllegalArgumentException("There is no previous value in this bundle.");
        }
        if (value != null) {
            T parsedCombinedValue = this.parseValue(value, previousValue);
            this.put(bundle, key, parsedCombinedValue);
            return parsedCombinedValue;
        }
        return previousValue;
    }

    @NotNull
    public String serializeAsValue(T value) {
        return String.valueOf(value);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean valueEquals(T value, T other) {
        return Intrinsics.areEqual(value, other);
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    @JvmStatic
    @NotNull
    public static NavType<?> fromArgType(@Nullable String type, @Nullable String packageName) {
        return Companion.fromArgType(type, packageName);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final NavType<Object> inferFromValue(@NotNull String value) {
        return Companion.inferFromValue(value);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final NavType<Object> inferFromValueType(@Nullable Object value) {
        return Companion.inferFromValueType(value);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010 \u001a\u0004\u0018\u00010\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u001cH\u0017J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010#\u001a\u00020\u001cH\u0007J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0007J'\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b)R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/navigation/NavType$Companion;", "", "()V", "BoolArrayType", "Landroidx/navigation/NavType;", "", "BoolListType", "", "", "BoolType", "FloatArrayType", "", "FloatListType", "", "FloatType", "IntArrayType", "", "IntListType", "", "IntType", "LongArrayType", "", "LongListType", "", "LongType", "ReferenceType", "StringArrayType", "", "", "StringListType", "StringType", "fromArgType", "type", "packageName", "inferFromValue", "value", "inferFromValueType", "parseSerializableOrParcelableType", "clazz", "Ljava/lang/Class;", "isArray", "parseSerializableOrParcelableType$navigation_common_release", "navigation-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public NavType<?> fromArgType(@Nullable String type, @Nullable String packageName) {
            if (Intrinsics.areEqual((Object)IntType.getName(), (Object)type)) {
                return IntType;
            }
            if (Intrinsics.areEqual((Object)IntArrayType.getName(), (Object)type)) {
                return IntArrayType;
            }
            if (Intrinsics.areEqual((Object)IntListType.getName(), (Object)type)) {
                return IntListType;
            }
            if (Intrinsics.areEqual((Object)LongType.getName(), (Object)type)) {
                return LongType;
            }
            if (Intrinsics.areEqual((Object)LongArrayType.getName(), (Object)type)) {
                return LongArrayType;
            }
            if (Intrinsics.areEqual((Object)LongListType.getName(), (Object)type)) {
                return LongListType;
            }
            if (Intrinsics.areEqual((Object)BoolType.getName(), (Object)type)) {
                return BoolType;
            }
            if (Intrinsics.areEqual((Object)BoolArrayType.getName(), (Object)type)) {
                return BoolArrayType;
            }
            if (Intrinsics.areEqual((Object)BoolListType.getName(), (Object)type)) {
                return BoolListType;
            }
            if (Intrinsics.areEqual((Object)StringType.getName(), (Object)type)) {
                return StringType;
            }
            if (Intrinsics.areEqual((Object)StringArrayType.getName(), (Object)type)) {
                return StringArrayType;
            }
            if (Intrinsics.areEqual((Object)StringListType.getName(), (Object)type)) {
                return StringListType;
            }
            if (Intrinsics.areEqual((Object)FloatType.getName(), (Object)type)) {
                return FloatType;
            }
            if (Intrinsics.areEqual((Object)FloatArrayType.getName(), (Object)type)) {
                return FloatArrayType;
            }
            if (Intrinsics.areEqual((Object)FloatListType.getName(), (Object)type)) {
                return FloatListType;
            }
            if (Intrinsics.areEqual((Object)ReferenceType.getName(), (Object)type)) {
                return ReferenceType;
            }
            CharSequence charSequence = type;
            if (!(charSequence == null || charSequence.length() == 0)) {
                try {
                    String className = null;
                    className = StringsKt.startsWith$default((String)type, (String)".", (boolean)false, (int)2, null) && packageName != null ? packageName + type : type;
                    boolean isArray = StringsKt.endsWith$default((String)type, (String)"[]", (boolean)false, (int)2, null);
                    if (isArray) {
                        String string = className.substring(0, className.length() - 2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        className = string;
                    }
                    Class<?> clazz = Class.forName(className);
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"clazz");
                    NavType<?> navType = this.parseSerializableOrParcelableType$navigation_common_release(clazz, isArray);
                    if (navType == null) {
                        boolean bl = false;
                        String string = className + " is not Serializable or Parcelable.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return navType;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return StringType;
        }

        @Nullable
        public final NavType<?> parseSerializableOrParcelableType$navigation_common_release(@NotNull Class<?> clazz, boolean isArray) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            return Parcelable.class.isAssignableFrom(clazz) ? (isArray ? (NavType)new ParcelableArrayType(clazz) : (NavType)new ParcelableType(clazz)) : (Enum.class.isAssignableFrom(clazz) && !isArray ? (NavType)new EnumType(clazz) : (Serializable.class.isAssignableFrom(clazz) ? (isArray ? (NavType)new SerializableArrayType(clazz) : (NavType)new SerializableType(clazz)) : null));
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final NavType<Object> inferFromValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                IntType.parseValue(value);
                NavType<Object> navType = IntType;
                Intrinsics.checkNotNull(navType, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    LongType.parseValue(value);
                    NavType<Object> navType = LongType;
                    Intrinsics.checkNotNull(navType, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                    return navType;
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        FloatType.parseValue(value);
                        NavType<Object> navType = FloatType;
                        Intrinsics.checkNotNull(navType, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                        return navType;
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        try {
                            BoolType.parseValue(value);
                            NavType<Object> navType = BoolType;
                            Intrinsics.checkNotNull(navType, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                            return navType;
                        }
                        catch (IllegalArgumentException illegalArgumentException4) {
                            NavType<Object> navType = StringType;
                            Intrinsics.checkNotNull(navType, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                            return navType;
                        }
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final NavType<Object> inferFromValueType(@Nullable Object value) {
            NavType navType;
            if (value instanceof Integer) {
                NavType navType2 = IntType;
                navType = navType2;
                Intrinsics.checkNotNull(navType2, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            if (value instanceof int[]) {
                NavType<int[]> navType3 = IntArrayType;
                navType = navType3;
                Intrinsics.checkNotNull(navType3, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            if (value instanceof Long) {
                NavType<Long> navType4 = LongType;
                navType = navType4;
                Intrinsics.checkNotNull(navType4, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            if (value instanceof long[]) {
                NavType<long[]> navType5 = LongArrayType;
                navType = navType5;
                Intrinsics.checkNotNull(navType5, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            if (value instanceof Float) {
                NavType<Float> navType6 = FloatType;
                navType = navType6;
                Intrinsics.checkNotNull(navType6, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            if (value instanceof float[]) {
                NavType<float[]> navType7 = FloatArrayType;
                navType = navType7;
                Intrinsics.checkNotNull(navType7, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            if (value instanceof Boolean) {
                NavType<Boolean> navType8 = BoolType;
                navType = navType8;
                Intrinsics.checkNotNull(navType8, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            if (value instanceof boolean[]) {
                NavType<boolean[]> navType9 = BoolArrayType;
                navType = navType9;
                Intrinsics.checkNotNull(navType9, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            if (value instanceof String || value == null) {
                NavType<String> navType10 = StringType;
                navType = navType10;
                Intrinsics.checkNotNull(navType10, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            if (value instanceof Object[] && (Object[])value instanceof String[]) {
                NavType<String[]> navType11 = StringArrayType;
                navType = navType11;
                Intrinsics.checkNotNull(navType11, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                return navType;
            }
            if (value.getClass().isArray()) {
                Class<?> clazz = value.getClass().getComponentType();
                Intrinsics.checkNotNull(clazz);
                if (Parcelable.class.isAssignableFrom(clazz)) {
                    Class<?> clazz2 = value.getClass().getComponentType();
                    Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<android.os.Parcelable>");
                    navType = new ParcelableArrayType(clazz2);
                    return navType;
                }
            }
            if (value.getClass().isArray()) {
                Class<?> clazz = value.getClass().getComponentType();
                Intrinsics.checkNotNull(clazz);
                if (Serializable.class.isAssignableFrom(clazz)) {
                    Class<?> clazz3 = value.getClass().getComponentType();
                    Intrinsics.checkNotNull(clazz3, (String)"null cannot be cast to non-null type java.lang.Class<java.io.Serializable>");
                    navType = new SerializableArrayType(clazz3);
                    return navType;
                }
            }
            if (value instanceof Parcelable) {
                navType = new ParcelableType(value.getClass());
                return navType;
            }
            if (value instanceof Enum) {
                navType = new EnumType(value.getClass());
                return navType;
            }
            if (!(value instanceof Serializable)) throw new IllegalArgumentException("Object of type " + value.getClass().getName() + " is not supported for navigation arguments.");
            navType = new SerializableType(value.getClass());
            return navType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000*\f\b\u0001\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u00028\u00012\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/navigation/NavType$EnumType;", "D", "", "Landroidx/navigation/NavType$SerializableType;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "name", "", "getName", "()Ljava/lang/String;", "parseValue", "value", "(Ljava/lang/String;)Ljava/lang/Enum;", "navigation-common_release"})
    @SourceDebugExtension(value={"SMAP\nNavType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavType.kt\nandroidx/navigation/NavType$EnumType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1211:1\n1#2:1212\n1282#3,2:1213\n*S KotlinDebug\n*F\n+ 1 NavType.kt\nandroidx/navigation/NavType$EnumType\n*L\n1134#1:1213,2\n*E\n"})
    public static final class EnumType<D extends Enum<?>>
    extends SerializableType<D> {
        @NotNull
        private final Class<D> type;

        public EnumType(@NotNull Class<D> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(false, type);
            if (!type.isEnum()) {
                boolean bl = false;
                String string = type + " is not an Enum type.";
                throw new IllegalArgumentException(string.toString());
            }
            this.type = type;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.type.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name");
            return string;
        }

        @Override
        @NotNull
        public D parseValue(@NotNull String value) {
            Object v1;
            block2: {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                D[] DArray = this.type.getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(DArray, (String)"type.enumConstants");
                D[] $this$firstOrNull$iv = DArray;
                boolean $i$f$firstOrNull = false;
                for (D element$iv : $this$firstOrNull$iv) {
                    Enum constant = (Enum)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)constant.name(), (String)value, (boolean)true)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            Enum enum_ = v1;
            if (enum_ == null) {
                throw new IllegalArgumentException("Enum value " + value + " not found for type " + this.type.getName() + '.');
            }
            return (D)enum_;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J&\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u00020\u000e2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00042\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u001fR\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Landroidx/navigation/NavType$ParcelableArrayType;", "D", "Landroid/os/Parcelable;", "Landroidx/navigation/NavType;", "", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "arrayType", "name", "", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)[Landroid/os/Parcelable;", "hashCode", "", "parseValue", "value", "(Ljava/lang/String;)[Landroid/os/Parcelable;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;[Landroid/os/Parcelable;)V", "valueEquals", "([Landroid/os/Parcelable;[Landroid/os/Parcelable;)Z", "navigation-common_release"})
    public static final class ParcelableArrayType<D extends Parcelable>
    extends NavType<D[]> {
        @NotNull
        private final Class<D[]> arrayType;

        public ParcelableArrayType(@NotNull Class<D> type) {
            Class<?> clazz;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(true);
            if (!Parcelable.class.isAssignableFrom(type)) {
                boolean bl = false;
                String string = type + " does not implement Parcelable.";
                throw new IllegalArgumentException(string.toString());
            }
            try {
                Class<?> clazz2 = Class.forName("[L" + type.getName() + ';');
                Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.Array<D of androidx.navigation.NavType.ParcelableArrayType>>");
                clazz = clazz2;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            Class<?> arrayType = clazz;
            this.arrayType = arrayType;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.arrayType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arrayType.name");
            return string;
        }

        @Override
        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable D[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.arrayType.cast(value);
            bundle.putParcelableArray(key, value);
        }

        @Override
        @Nullable
        public D[] get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (Parcelable[])bundle.get(key);
        }

        @Override
        @NotNull
        public D[] parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw new UnsupportedOperationException("Arrays don't support default values.");
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            ParcelableArrayType that = (ParcelableArrayType)other;
            return Intrinsics.areEqual(this.arrayType, that.arrayType);
        }

        public int hashCode() {
            return this.arrayType.hashCode();
        }

        @Override
        public boolean valueEquals(@Nullable D[] value, @Nullable D[] other) {
            Object[] objectArray = value;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])other);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J \u0010\u000e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0015\u0010\u0015\u001a\u00028\u00012\u0006\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0017J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/navigation/NavType$ParcelableType;", "D", "Landroidx/navigation/NavType;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "name", "", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)Ljava/lang/Object;", "hashCode", "", "parseValue", "value", "(Ljava/lang/String;)Ljava/lang/Object;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/lang/Object;)V", "navigation-common_release"})
    public static final class ParcelableType<D>
    extends NavType<D> {
        @NotNull
        private final Class<D> type;

        public ParcelableType(@NotNull Class<D> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(true);
            if (!(Parcelable.class.isAssignableFrom(type) || Serializable.class.isAssignableFrom(type))) {
                boolean bl = false;
                String string = type + " does not implement Parcelable or Serializable.";
                throw new IllegalArgumentException(string.toString());
            }
            this.type = type;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.type.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name");
            return string;
        }

        @Override
        public void put(@NotNull Bundle bundle, @NotNull String key, D value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.type.cast(value);
            if (value == null || value instanceof Parcelable) {
                bundle.putParcelable(key, (Parcelable)value);
            } else if (value instanceof Serializable) {
                bundle.putSerializable(key, (Serializable)value);
            }
        }

        @Override
        @Nullable
        public D get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (D)bundle.get(key);
        }

        @Override
        public D parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw new UnsupportedOperationException("Parcelables don't support default values.");
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            ParcelableType that = (ParcelableType)other;
            return Intrinsics.areEqual(this.type, that.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J&\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u00020\u000e2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00042\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u001fR\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Landroidx/navigation/NavType$SerializableArrayType;", "D", "Ljava/io/Serializable;", "Landroidx/navigation/NavType;", "", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "arrayType", "name", "", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)[Ljava/io/Serializable;", "hashCode", "", "parseValue", "value", "(Ljava/lang/String;)[Ljava/io/Serializable;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;[Ljava/io/Serializable;)V", "valueEquals", "([Ljava/io/Serializable;[Ljava/io/Serializable;)Z", "navigation-common_release"})
    public static final class SerializableArrayType<D extends Serializable>
    extends NavType<D[]> {
        @NotNull
        private final Class<D[]> arrayType;

        public SerializableArrayType(@NotNull Class<D> type) {
            Class<?> clazz;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(true);
            if (!Serializable.class.isAssignableFrom(type)) {
                boolean bl = false;
                String string = type + " does not implement Serializable.";
                throw new IllegalArgumentException(string.toString());
            }
            try {
                Class<?> clazz2 = Class.forName("[L" + type.getName() + ';');
                Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.Array<D of androidx.navigation.NavType.SerializableArrayType>>");
                clazz = clazz2;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            Class<?> arrayType = clazz;
            this.arrayType = arrayType;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.arrayType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arrayType.name");
            return string;
        }

        @Override
        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable D[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.arrayType.cast(value);
            bundle.putSerializable(key, (Serializable)value);
        }

        @Override
        @Nullable
        public D[] get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (Serializable[])bundle.get(key);
        }

        @Override
        @NotNull
        public D[] parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw new UnsupportedOperationException("Arrays don't support default values.");
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            SerializableArrayType that = (SerializableArrayType)other;
            return Intrinsics.areEqual(this.arrayType, that.arrayType);
        }

        public int hashCode() {
            return this.arrayType.hashCode();
        }

        @Override
        public boolean valueEquals(@Nullable D[] value, @Nullable D[] other) {
            Object[] objectArray = value;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])other);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J \u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0015\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0019\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/navigation/NavType$SerializableType;", "D", "Ljava/io/Serializable;", "Landroidx/navigation/NavType;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "nullableAllowed", "", "(ZLjava/lang/Class;)V", "name", "", "getName", "()Ljava/lang/String;", "equals", "other", "", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)Ljava/io/Serializable;", "hashCode", "", "parseValue", "value", "(Ljava/lang/String;)Ljava/io/Serializable;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/io/Serializable;)V", "navigation-common_release"})
    @SourceDebugExtension(value={"SMAP\nNavType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavType.kt\nandroidx/navigation/NavType$SerializableType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1211:1\n1#2:1212\n*E\n"})
    public static class SerializableType<D extends Serializable>
    extends NavType<D> {
        @NotNull
        private final Class<D> type;

        @Override
        @NotNull
        public String getName() {
            String string = this.type.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name");
            return string;
        }

        public SerializableType(@NotNull Class<D> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(true);
            if (!Serializable.class.isAssignableFrom(type)) {
                boolean $i$a$-require-NavType$SerializableType$32 = false;
                String $i$a$-require-NavType$SerializableType$32 = type + " does not implement Serializable.";
                throw new IllegalArgumentException($i$a$-require-NavType$SerializableType$32.toString());
            }
            if (!(!type.isEnum())) {
                boolean bl = false;
                String string = type + " is an Enum. You should use EnumType instead.";
                throw new IllegalArgumentException(string.toString());
            }
            this.type = type;
        }

        public SerializableType(boolean nullableAllowed, @NotNull Class<D> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(nullableAllowed);
            if (!Serializable.class.isAssignableFrom(type)) {
                boolean bl = false;
                String string = type + " does not implement Serializable.";
                throw new IllegalArgumentException(string.toString());
            }
            this.type = type;
        }

        @Override
        public void put(@NotNull Bundle bundle, @NotNull String key, @NotNull D value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.type.cast(value);
            bundle.putSerializable(key, value);
        }

        @Override
        @Nullable
        public D get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (D)((Serializable)bundle.get(key));
        }

        @Override
        @NotNull
        public D parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw new UnsupportedOperationException("Serializables don't support default values.");
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializableType)) {
                return false;
            }
            return Intrinsics.areEqual(this.type, ((SerializableType)other).type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }
}

