/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.annotation.SuppressLint;
import androidx.annotation.CallSuper;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavDestination;
import androidx.navigation.Navigator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006J*\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u00052\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0017J'\u0010\u000f\u001a\u0002H\u0010\"\f\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012\u00a2\u0006\u0002\u0010\u0013J#\u0010\u000f\u001a\u0002H\u0010\"\f\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0017\u00a2\u0006\u0002\u0010\u0014R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\t8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Landroidx/navigation/NavigatorProvider;", "", "()V", "_navigators", "", "", "Landroidx/navigation/Navigator;", "Landroidx/navigation/NavDestination;", "navigators", "", "getNavigators", "()Ljava/util/Map;", "addNavigator", "navigator", "name", "getNavigator", "T", "navigatorClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/navigation/Navigator;", "(Ljava/lang/String;)Landroidx/navigation/Navigator;", "Companion", "navigation-common_release"})
@SuppressLint(value={"TypeParameterUnusedInFormals"})
@SourceDebugExtension(value={"SMAP\nNavigatorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigatorProvider.kt\nandroidx/navigation/NavigatorProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public class NavigatorProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Navigator<? extends NavDestination>> _navigators = new LinkedHashMap();
    @NotNull
    private static final Map<Class<?>, String> annotationNames = new LinkedHashMap();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final Map<String, Navigator<? extends NavDestination>> getNavigators() {
        return MapsKt.toMap(this._navigators);
    }

    @NotNull
    public final <T extends Navigator<?>> T getNavigator(@NotNull Class<T> navigatorClass) {
        Intrinsics.checkNotNullParameter(navigatorClass, (String)"navigatorClass");
        String name = Companion.getNameForNavigator$navigation_common_release(navigatorClass);
        return this.getNavigator(name);
    }

    @CallSuper
    @NotNull
    public <T extends Navigator<?>> T getNavigator(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!Companion.validateName$navigation_common_release(name)) {
            boolean bl = false;
            String string = "navigator name cannot be an empty string";
            throw new IllegalArgumentException(string.toString());
        }
        Navigator<? extends NavDestination> navigator = this._navigators.get(name);
        if (navigator == null) {
            throw new IllegalStateException("Could not find Navigator with name \"" + name + "\". You must call NavController.addNavigator() for each navigation type.");
        }
        Navigator<? extends NavDestination> navigator2 = navigator;
        return (T)navigator2;
    }

    @Nullable
    public final Navigator<? extends NavDestination> addNavigator(@NotNull Navigator<? extends NavDestination> navigator) {
        Intrinsics.checkNotNullParameter(navigator, (String)"navigator");
        return this.addNavigator(Companion.getNameForNavigator$navigation_common_release(navigator.getClass()), navigator);
    }

    @CallSuper
    @Nullable
    public Navigator<? extends NavDestination> addNavigator(@NotNull String name, @NotNull Navigator<? extends NavDestination> navigator) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(navigator, (String)"navigator");
        if (!Companion.validateName$navigation_common_release(name)) {
            boolean bl = false;
            String string = "navigator name cannot be an empty string";
            throw new IllegalArgumentException(string.toString());
        }
        Navigator<? extends NavDestination> previousNavigator = this._navigators.get(name);
        if (Intrinsics.areEqual(previousNavigator, navigator)) {
            return navigator;
        }
        Navigator<? extends NavDestination> navigator2 = previousNavigator;
        if (!(!(navigator2 != null ? navigator2.isAttached() : false))) {
            boolean $i$a$-check-NavigatorProvider$addNavigator$42 = false;
            String $i$a$-check-NavigatorProvider$addNavigator$42 = "Navigator " + navigator + " is replacing an already attached " + previousNavigator;
            throw new IllegalStateException($i$a$-check-NavigatorProvider$addNavigator$42.toString());
        }
        if (!(!navigator.isAttached())) {
            boolean bl = false;
            String string = "Navigator " + navigator + " is already attached to another NavController";
            throw new IllegalStateException(string.toString());
        }
        return this._navigators.put(name, navigator);
    }

    @JvmStatic
    @NotNull
    public static final String getNameForNavigator$navigation_common_release(@NotNull Class<? extends Navigator<?>> navigatorClass) {
        return Companion.getNameForNavigator$navigation_common_release(navigatorClass);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\u0005H\u0001\u00a2\u0006\u0002\b\nJ\u0017\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u000eR \u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/navigation/NavigatorProvider$Companion;", "", "()V", "annotationNames", "", "Ljava/lang/Class;", "", "getNameForNavigator", "navigatorClass", "Landroidx/navigation/Navigator;", "getNameForNavigator$navigation_common_release", "validateName", "", "name", "validateName$navigation_common_release", "navigation-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean validateName$navigation_common_release(@Nullable String name) {
            return name != null && ((CharSequence)name).length() > 0;
        }

        @JvmStatic
        @NotNull
        public final String getNameForNavigator$navigation_common_release(@NotNull Class<? extends Navigator<?>> navigatorClass) {
            Intrinsics.checkNotNullParameter(navigatorClass, (String)"navigatorClass");
            String name = (String)annotationNames.get(navigatorClass);
            if (name == null) {
                Navigator.Name annotation;
                Navigator.Name name2 = annotation = navigatorClass.getAnnotation(Navigator.Name.class);
                String string = name = name2 != null ? name2.value() : null;
                if (!this.validateName$navigation_common_release(name)) {
                    boolean bl = false;
                    String string2 = "No @Navigator.Name annotation found for " + navigatorClass.getSimpleName();
                    throw new IllegalArgumentException(string2.toString());
                }
                annotationNames.put(navigatorClass, name);
            }
            String string = name;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

