/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.core.os.BundleKt;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.lifecycle.viewmodel.InitializerViewModelFactoryBuilder;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.NavigatorState;
import androidx.navigation.fragment.FragmentNavigator;
import androidx.navigation.fragment.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="fragment")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0017\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004:;<=B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010$\u001a\u00020\u0002H\u0016J\u001a\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J*\u0010)\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00122\b\u0010+\u001a\u0004\u0018\u00010,H\u0017J$\u0010-\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J*\u0010-\u001a\u00020\u001c2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0010\u00101\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\rH\u0016J\u0010\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020,H\u0016J\n\u00106\u001a\u0004\u0018\u00010,H\u0016J\u0018\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\r2\u0006\u00105\u001a\u000209H\u0016R \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00160\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Landroidx/navigation/fragment/FragmentNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/fragment/FragmentNavigator$Destination;", "context", "Landroid/content/Context;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "containerId", "", "(Landroid/content/Context;Landroidx/fragment/app/FragmentManager;I)V", "backStack", "Lkotlinx/coroutines/flow/StateFlow;", "", "Landroidx/navigation/NavBackStackEntry;", "getBackStack$navigation_fragment_release", "()Lkotlinx/coroutines/flow/StateFlow;", "entriesToPop", "", "", "getEntriesToPop$navigation_fragment_release", "()Ljava/util/Set;", "fragmentObserver", "Landroidx/lifecycle/LifecycleEventObserver;", "fragmentViewObserver", "Lkotlin/Function1;", "savedIds", "", "attachClearViewModel", "", "fragment", "Landroidx/fragment/app/Fragment;", "entry", "state", "Landroidx/navigation/NavigatorState;", "attachClearViewModel$navigation_fragment_release", "attachObservers", "createDestination", "createFragmentTransaction", "Landroidx/fragment/app/FragmentTransaction;", "navOptions", "Landroidx/navigation/NavOptions;", "instantiateFragment", "className", "args", "Landroid/os/Bundle;", "navigate", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "entries", "onAttach", "onLaunchSingleTop", "backStackEntry", "onRestoreState", "savedState", "onSaveState", "popBackStack", "popUpTo", "", "ClearEntryStateViewModel", "Companion", "Destination", "Extras", "navigation-fragment_release"})
@SourceDebugExtension(value={"SMAP\nFragmentNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FragmentNavigator.kt\nandroidx/navigation/fragment/FragmentNavigator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 InitializerViewModelFactory.kt\nandroidx/lifecycle/viewmodel/InitializerViewModelFactoryKt\n*L\n1#1,661:1\n1549#2:662\n1620#2,3:663\n518#2,7:669\n533#2,6:676\n31#3:666\n63#3,2:667\n*S KotlinDebug\n*F\n+ 1 FragmentNavigator.kt\nandroidx/navigation/fragment/FragmentNavigator\n*L\n73#1:662\n73#1:663,3\n84#1:669,7\n140#1:676,6\n241#1:666\n241#1:667,2\n*E\n"})
public class FragmentNavigator
extends Navigator<Destination> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final FragmentManager fragmentManager;
    private final int containerId;
    @NotNull
    private final Set<String> savedIds;
    @NotNull
    private final LifecycleEventObserver fragmentObserver;
    @NotNull
    private final Function1<NavBackStackEntry, LifecycleEventObserver> fragmentViewObserver;
    @NotNull
    private static final String TAG = "FragmentNavigator";
    @NotNull
    private static final String KEY_SAVED_IDS = "androidx-nav-fragment:navigator:savedIds";

    public FragmentNavigator(@NotNull Context context, @NotNull FragmentManager fragmentManager, int containerId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        this.context = context;
        this.fragmentManager = fragmentManager;
        this.containerId = containerId;
        this.savedIds = new LinkedHashSet();
        this.fragmentObserver = (arg_0, arg_1) -> FragmentNavigator.fragmentObserver$lambda$2(this, arg_0, arg_1);
        this.fragmentViewObserver = (Function1)new Function1<NavBackStackEntry, LifecycleEventObserver>(this){
            final /* synthetic */ FragmentNavigator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final LifecycleEventObserver invoke(@NotNull NavBackStackEntry entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                return (arg_0, arg_1) -> fragmentViewObserver.1.invoke$lambda$0(this.this$0, entry, arg_0, arg_1);
            }

            private static final void invoke$lambda$0(FragmentNavigator this$0, NavBackStackEntry $entry, LifecycleOwner owner, Lifecycle.Event event) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$entry, (String)"$entry");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event == Lifecycle.Event.ON_RESUME && ((List)FragmentNavigator.access$getState(this$0).getBackStack().getValue()).contains($entry)) {
                    if (FragmentManager.isLoggingEnabled((int)2)) {
                        Log.v((String)"FragmentNavigator", (String)("Marking transition complete for entry " + $entry + " due to fragment " + owner + " view lifecycle reaching RESUMED"));
                    }
                    FragmentNavigator.access$getState(this$0).markTransitionComplete($entry);
                }
                if (event == Lifecycle.Event.ON_DESTROY && !((List)FragmentNavigator.access$getState(this$0).getBackStack().getValue()).contains($entry)) {
                    if (FragmentManager.isLoggingEnabled((int)2)) {
                        Log.v((String)"FragmentNavigator", (String)("Marking transition complete for entry " + $entry + " due to fragment " + owner + " view lifecycle reaching DESTROYED"));
                    }
                    FragmentNavigator.access$getState(this$0).markTransitionComplete($entry);
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getEntriesToPop$navigation_fragment_release() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = SetsKt.minus((Set)((Set)this.getState().getTransitionsInProgress().getValue()), (Iterable)CollectionsKt.toSet((Iterable)((Iterable)this.getState().getBackStack().getValue())));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NavBackStackEntry navBackStackEntry = (NavBackStackEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final StateFlow<List<NavBackStackEntry>> getBackStack$navigation_fragment_release() {
        return this.getState().getBackStack();
    }

    public void onAttach(@NotNull NavigatorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onAttach(state);
        if (FragmentManager.isLoggingEnabled((int)2)) {
            Log.v((String)TAG, (String)"onAttach");
        }
        this.fragmentManager.addFragmentOnAttachListener((arg_0, arg_1) -> FragmentNavigator.onAttach$lambda$4(state, this, arg_0, arg_1));
        this.fragmentManager.addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener(state, this){
            final /* synthetic */ NavigatorState $state;
            final /* synthetic */ FragmentNavigator this$0;
            {
                this.$state = $state;
                this.this$0 = $receiver;
            }

            public void onBackStackChanged() {
            }

            public void onBackStackChangeStarted(@NotNull Fragment fragment, boolean pop) {
                block4: {
                    Object v0;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
                        if (!pop) break block4;
                        List $this$lastOrNull$iv = (List)this.$state.getBackStack().getValue();
                        boolean $i$f$lastOrNull = false;
                        ListIterator<E> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            E element$iv = iterator$iv.previous();
                            NavBackStackEntry it = (NavBackStackEntry)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)fragment.getTag())) continue;
                            v0 = element$iv;
                            break block3;
                        }
                        v0 = null;
                    }
                    NavBackStackEntry entry = v0;
                    if (FragmentManager.isLoggingEnabled((int)2)) {
                        Log.v((String)"FragmentNavigator", (String)("OnBackStackChangedStarted for fragment " + fragment + " associated with entry " + entry));
                    }
                    NavBackStackEntry navBackStackEntry = entry;
                    if (navBackStackEntry != null) {
                        NavBackStackEntry navBackStackEntry2 = navBackStackEntry;
                        NavigatorState navigatorState = this.$state;
                        NavBackStackEntry it = navBackStackEntry2;
                        boolean bl = false;
                        navigatorState.prepareForTransition(it);
                    }
                }
            }

            public void onBackStackChangeCommitted(@NotNull Fragment fragment, boolean pop) {
                Object v0;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
                    List $this$lastOrNull$iv = CollectionsKt.plus((Collection)((Collection)this.$state.getBackStack().getValue()), (Iterable)((Iterable)this.$state.getTransitionsInProgress().getValue()));
                    boolean $i$f$lastOrNull = false;
                    ListIterator<E> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        E element$iv = iterator$iv.previous();
                        NavBackStackEntry it = (NavBackStackEntry)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)fragment.getTag())) continue;
                        v0 = element$iv;
                        break block6;
                    }
                    v0 = null;
                }
                NavBackStackEntry entry = v0;
                if (FragmentManager.isLoggingEnabled((int)2)) {
                    Log.v((String)"FragmentNavigator", (String)("OnBackStackChangedCommitted for fragment " + fragment + " associated with entry " + entry));
                }
                if (!pop && entry == null) {
                    boolean bl = false;
                    String string = "The fragment " + fragment + " is unknown to the FragmentNavigator. Please use the navigate() function to add fragments to the FragmentNavigator managed FragmentManager.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (entry != null) {
                    this.this$0.attachClearViewModel$navigation_fragment_release(fragment, entry, this.$state);
                    if (pop && this.this$0.getEntriesToPop$navigation_fragment_release().isEmpty() && fragment.isRemoving()) {
                        if (FragmentManager.isLoggingEnabled((int)2)) {
                            Log.v((String)"FragmentNavigator", (String)("Popping entry " + entry + " with transition via system back"));
                        }
                        this.$state.popWithTransition(entry, false);
                    }
                }
            }
        });
    }

    private final void attachObservers(NavBackStackEntry entry, Fragment fragment) {
        Function1 function1 = (Function1)new Function1<LifecycleOwner, Unit>(this, fragment, entry){
            final /* synthetic */ FragmentNavigator this$0;
            final /* synthetic */ Fragment $fragment;
            final /* synthetic */ NavBackStackEntry $entry;
            {
                this.this$0 = $receiver;
                this.$fragment = $fragment;
                this.$entry = $entry;
                super(1);
            }

            public final void invoke(LifecycleOwner owner) {
                Lifecycle viewLifecycle;
                if (owner != null && !CollectionsKt.contains((Iterable)this.this$0.getEntriesToPop$navigation_fragment_release(), (Object)this.$fragment.getTag()) && (viewLifecycle = this.$fragment.getViewLifecycleOwner().getLifecycle()).getCurrentState().isAtLeast(Lifecycle.State.CREATED)) {
                    viewLifecycle.addObserver((LifecycleObserver)FragmentNavigator.access$getFragmentViewObserver$p(this.this$0).invoke((Object)this.$entry));
                }
            }
        };
        fragment.getViewLifecycleOwnerLiveData().observe((LifecycleOwner)fragment, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        fragment.getLifecycle().addObserver((LifecycleObserver)this.fragmentObserver);
    }

    /*
     * WARNING - void declaration
     */
    public final void attachClearViewModel$navigation_fragment_release(@NotNull Fragment fragment, @NotNull NavBackStackEntry entry, @NotNull NavigatorState state) {
        void $this$initializer$iv;
        void $this$attachClearViewModel_u24lambda_u245;
        InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder;
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ViewModelStore viewModelStore = fragment.getViewModelStore();
        Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"fragment.viewModelStore");
        boolean $i$f$viewModelFactory = false;
        InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder2 = initializerViewModelFactoryBuilder = new InitializerViewModelFactoryBuilder();
        ViewModelStore viewModelStore2 = viewModelStore;
        boolean bl = false;
        void var9_9 = $this$attachClearViewModel_u24lambda_u245;
        Function1 initializer$iv = attachClearViewModel.viewModel.1.1.INSTANCE;
        boolean $i$f$initializer = false;
        $this$initializer$iv.addInitializer(Reflection.getOrCreateKotlinClass(ClearEntryStateViewModel.class), initializer$iv);
        CreationExtras creationExtras = (CreationExtras)CreationExtras.Empty.INSTANCE;
        ViewModelProvider.Factory factory = initializerViewModelFactoryBuilder.build();
        ViewModelStore viewModelStore3 = viewModelStore2;
        ClearEntryStateViewModel viewModel2 = (ClearEntryStateViewModel)new ViewModelProvider(viewModelStore3, factory, creationExtras).get(ClearEntryStateViewModel.class);
        viewModel2.setCompleteTransition(new WeakReference<Function0<Unit>>(new Function0<Unit>(entry, state, fragment){
            final /* synthetic */ NavBackStackEntry $entry;
            final /* synthetic */ NavigatorState $state;
            final /* synthetic */ Fragment $fragment;
            {
                this.$entry = $entry;
                this.$state = $state;
                this.$fragment = $fragment;
                super(0);
            }

            public final void invoke() {
                NavBackStackEntry navBackStackEntry = this.$entry;
                NavigatorState navigatorState = this.$state;
                Fragment fragment = this.$fragment;
                NavBackStackEntry it = navBackStackEntry;
                boolean bl = false;
                Iterable $this$forEach$iv = (Iterable)navigatorState.getTransitionsInProgress().getValue();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    NavBackStackEntry entry = (NavBackStackEntry)element$iv;
                    boolean bl2 = false;
                    if (FragmentManager.isLoggingEnabled((int)2)) {
                        Log.v((String)"FragmentNavigator", (String)("Marking transition complete for entry " + entry + " due to fragment " + fragment + " viewmodel being cleared"));
                    }
                    navigatorState.markTransitionComplete(entry);
                }
            }
        }));
    }

    public void popBackStack(@NotNull NavBackStackEntry popUpTo, boolean savedState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo, (String)"popUpTo");
        if (this.fragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring popBackStack() call: FragmentManager has already saved its state");
            return;
        }
        List beforePopList = (List)this.getState().getBackStack().getValue();
        List poppedList = beforePopList.subList(beforePopList.indexOf(popUpTo), beforePopList.size());
        if (savedState) {
            NavBackStackEntry initialEntry = (NavBackStackEntry)CollectionsKt.first((List)beforePopList);
            for (NavBackStackEntry entry : CollectionsKt.reversed((Iterable)poppedList)) {
                if (Intrinsics.areEqual((Object)entry, (Object)initialEntry)) {
                    Log.i((String)TAG, (String)("FragmentManager cannot save the state of the initial destination " + entry));
                    continue;
                }
                this.fragmentManager.saveBackStack(entry.getId());
                ((Collection)this.savedIds).add(entry.getId());
            }
        } else {
            this.fragmentManager.popBackStack(popUpTo.getId(), 1);
        }
        if (FragmentManager.isLoggingEnabled((int)2)) {
            Log.v((String)TAG, (String)("Calling popWithTransition via popBackStack() on entry " + popUpTo + " with savedState " + savedState));
        }
        this.getState().popWithTransition(popUpTo, savedState);
    }

    @NotNull
    public Destination createDestination() {
        return new Destination((Navigator<? extends Destination>)((Navigator)this));
    }

    @Deprecated(message="Set a custom {@link androidx.fragment.app.FragmentFactory} via\n      {@link FragmentManager#setFragmentFactory(FragmentFactory)} to control\n      instantiation of Fragments.")
    @NotNull
    public Fragment instantiateFragment(@NotNull Context context, @NotNull FragmentManager fragmentManager, @NotNull String className, @Nullable Bundle args) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Fragment fragment = fragmentManager.getFragmentFactory().instantiate(context.getClassLoader(), className);
        Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentManager.fragment\u2026t.classLoader, className)");
        return fragment;
    }

    public void navigate(@NotNull List<NavBackStackEntry> entries, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        if (this.fragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring navigate() call: FragmentManager has already saved its state");
            return;
        }
        for (NavBackStackEntry entry : entries) {
            this.navigate(entry, navOptions, navigatorExtras);
        }
    }

    private final void navigate(NavBackStackEntry entry, NavOptions navOptions, Navigator.Extras navigatorExtras) {
        boolean restoreState;
        boolean initialNavigation = ((List)this.getState().getBackStack().getValue()).isEmpty();
        boolean bl = restoreState = navOptions != null && !initialNavigation && navOptions.shouldRestoreState() && this.savedIds.remove(entry.getId());
        if (restoreState) {
            this.fragmentManager.restoreBackStack(entry.getId());
            this.getState().pushWithTransition(entry);
            return;
        }
        FragmentTransaction ft = this.createFragmentTransaction(entry, navOptions);
        if (!initialNavigation) {
            ft.addToBackStack(entry.getId());
        }
        if (navigatorExtras instanceof Extras) {
            for (Map.Entry<View, String> entry2 : ((Extras)navigatorExtras).getSharedElements().entrySet()) {
                View key = entry2.getKey();
                String value = entry2.getValue();
                ft.addSharedElement(key, value);
            }
        }
        ft.commit();
        if (FragmentManager.isLoggingEnabled((int)2)) {
            Log.v((String)TAG, (String)("Calling pushWithTransition via navigate() on entry " + entry));
        }
        this.getState().pushWithTransition(entry);
    }

    public void onLaunchSingleTop(@NotNull NavBackStackEntry backStackEntry2) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry2, (String)"backStackEntry");
        if (this.fragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring onLaunchSingleTop() call: FragmentManager has already saved its state");
            return;
        }
        FragmentTransaction ft = this.createFragmentTransaction(backStackEntry2, null);
        if (((List)this.getState().getBackStack().getValue()).size() > 1) {
            this.fragmentManager.popBackStack(backStackEntry2.getId(), 1);
            ft.addToBackStack(backStackEntry2.getId());
        }
        ft.commit();
        this.getState().onLaunchSingleTop(backStackEntry2);
    }

    private final FragmentTransaction createFragmentTransaction(NavBackStackEntry entry, NavOptions navOptions) {
        int popExitAnim;
        NavDestination navDestination = entry.getDestination();
        Intrinsics.checkNotNull((Object)navDestination, (String)"null cannot be cast to non-null type androidx.navigation.fragment.FragmentNavigator.Destination");
        Destination destination = (Destination)navDestination;
        Bundle args = entry.getArguments();
        String className = destination.getClassName();
        if (className.charAt(0) == '.') {
            className = this.context.getPackageName() + className;
        }
        Fragment fragment = this.fragmentManager.getFragmentFactory().instantiate(this.context.getClassLoader(), className);
        Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentManager.fragment\u2026t.classLoader, className)");
        Fragment frag = fragment;
        frag.setArguments(args);
        FragmentTransaction fragmentTransaction = this.fragmentManager.beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"fragmentManager.beginTransaction()");
        FragmentTransaction ft = fragmentTransaction;
        NavOptions navOptions2 = navOptions;
        int enterAnim = navOptions2 != null ? navOptions2.getEnterAnim() : -1;
        NavOptions navOptions3 = navOptions;
        int exitAnim = navOptions3 != null ? navOptions3.getExitAnim() : -1;
        NavOptions navOptions4 = navOptions;
        int popEnterAnim = navOptions4 != null ? navOptions4.getPopEnterAnim() : -1;
        NavOptions navOptions5 = navOptions;
        int n = popExitAnim = navOptions5 != null ? navOptions5.getPopExitAnim() : -1;
        if (enterAnim != -1 || exitAnim != -1 || popEnterAnim != -1 || popExitAnim != -1) {
            enterAnim = enterAnim != -1 ? enterAnim : 0;
            exitAnim = exitAnim != -1 ? exitAnim : 0;
            popEnterAnim = popEnterAnim != -1 ? popEnterAnim : 0;
            popExitAnim = popExitAnim != -1 ? popExitAnim : 0;
            ft.setCustomAnimations(enterAnim, exitAnim, popEnterAnim, popExitAnim);
        }
        ft.replace(this.containerId, frag, entry.getId());
        ft.setPrimaryNavigationFragment(frag);
        ft.setReorderingAllowed(true);
        return ft;
    }

    @Nullable
    public Bundle onSaveState() {
        if (this.savedIds.isEmpty()) {
            return null;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)KEY_SAVED_IDS, new ArrayList(this.savedIds))};
        return BundleKt.bundleOf((Pair[])pairArray);
    }

    public void onRestoreState(@NotNull Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)savedState, (String)"savedState");
        ArrayList savedIds = savedState.getStringArrayList(KEY_SAVED_IDS);
        if (savedIds != null) {
            this.savedIds.clear();
            CollectionsKt.addAll((Collection)this.savedIds, (Iterable)savedIds);
        }
    }

    private static final void fragmentObserver$lambda$2(FragmentNavigator this$0, LifecycleOwner source, Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event == Lifecycle.Event.ON_DESTROY) {
            Fragment fragment = (Fragment)source;
            Iterable $this$lastOrNull$iv = (Iterable)this$0.getState().getTransitionsInProgress().getValue();
            boolean $i$f$lastOrNull = false;
            Object last$iv = null;
            for (Object element$iv : $this$lastOrNull$iv) {
                NavBackStackEntry entry = (NavBackStackEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)entry.getId(), (Object)fragment.getTag())) continue;
                last$iv = element$iv;
            }
            NavBackStackEntry entry = last$iv;
            if (entry != null && !((List)this$0.getState().getBackStack().getValue()).contains(entry)) {
                if (FragmentManager.isLoggingEnabled((int)2)) {
                    Log.v((String)TAG, (String)("Marking transition complete for entry " + entry + " due to fragment " + source + " lifecycle reaching DESTROYED"));
                }
                this$0.getState().markTransitionComplete(entry);
            }
        }
    }

    private static final void onAttach$lambda$4(NavigatorState $state, FragmentNavigator this$0, FragmentManager fragmentManager, Fragment fragment) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"<anonymous parameter 0>");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            List $this$lastOrNull$iv = (List)$state.getBackStack().getValue();
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                NavBackStackEntry it = (NavBackStackEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)fragment.getTag())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        NavBackStackEntry entry = v0;
        if (FragmentManager.isLoggingEnabled((int)2)) {
            Log.v((String)TAG, (String)("Attaching fragment " + fragment + " associated with entry " + entry + " to FragmentManager " + this$0.fragmentManager));
        }
        if (entry != null) {
            this$0.attachObservers(entry, fragment);
            this$0.attachClearViewModel$navigation_fragment_release(fragment, entry, $state);
        }
    }

    public static final /* synthetic */ Function1 access$getFragmentViewObserver$p(FragmentNavigator $this) {
        return $this.fragmentViewObserver;
    }

    public static final /* synthetic */ NavigatorState access$getState(FragmentNavigator $this) {
        return $this.getState();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\u0006H\u0014R&\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Landroidx/navigation/fragment/FragmentNavigator$ClearEntryStateViewModel;", "Landroidx/lifecycle/ViewModel;", "()V", "completeTransition", "Ljava/lang/ref/WeakReference;", "Lkotlin/Function0;", "", "getCompleteTransition", "()Ljava/lang/ref/WeakReference;", "setCompleteTransition", "(Ljava/lang/ref/WeakReference;)V", "onCleared", "navigation-fragment_release"})
    public static final class ClearEntryStateViewModel
    extends ViewModel {
        public WeakReference<Function0<Unit>> completeTransition;

        @NotNull
        public final WeakReference<Function0<Unit>> getCompleteTransition() {
            WeakReference<Function0<Unit>> weakReference = this.completeTransition;
            if (weakReference != null) {
                return weakReference;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"completeTransition");
            return null;
        }

        public final void setCompleteTransition(@NotNull WeakReference<Function0<Unit>> weakReference) {
            Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
            this.completeTransition = weakReference;
        }

        protected void onCleared() {
            block0: {
                super.onCleared();
                Function0 function0 = (Function0)this.getCompleteTransition().get();
                if (function0 == null) break block0;
                function0.invoke();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/navigation/fragment/FragmentNavigator$Companion;", "", "()V", "KEY_SAVED_IDS", "", "TAG", "navigation-fragment_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\tJ\b\u0010\u001a\u001a\u00020\tH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Landroidx/navigation/fragment/FragmentNavigator$Destination;", "Landroidx/navigation/NavDestination;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "(Landroidx/navigation/NavigatorProvider;)V", "fragmentNavigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "_className", "", "className", "getClassName", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "onInflate", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "setClassName", "toString", "navigation-fragment_release"})
    @NavDestination.ClassType(value=Fragment.class)
    @SourceDebugExtension(value={"SMAP\nFragmentNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FragmentNavigator.kt\nandroidx/navigation/fragment/FragmentNavigator$Destination\n+ 2 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,661:1\n232#2,3:662\n1#3:665\n*S KotlinDebug\n*F\n+ 1 FragmentNavigator.kt\nandroidx/navigation/fragment/FragmentNavigator$Destination\n*L\n529#1:662,3\n*E\n"})
    public static class Destination
    extends NavDestination {
        @Nullable
        private String _className;

        public Destination(@NotNull Navigator<? extends Destination> fragmentNavigator) {
            Intrinsics.checkNotNullParameter(fragmentNavigator, (String)"fragmentNavigator");
            super(fragmentNavigator);
        }

        public Destination(@NotNull NavigatorProvider navigatorProvider) {
            Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
            this((Navigator<? extends Destination>)navigatorProvider.getNavigator(FragmentNavigator.class));
        }

        @CallSuper
        public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
            super.onInflate(context, attrs);
            TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.FragmentNavigator);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.resources.obtain\u2026leable.FragmentNavigator)");
            TypedArray $this$use$iv = typedArray;
            boolean $i$f$use = false;
            TypedArray array = $this$use$iv;
            boolean bl = false;
            String className = array.getString(R.styleable.FragmentNavigator_android_name);
            if (className != null) {
                this.setClassName(className);
            }
            Unit it$iv = unit = Unit.INSTANCE;
            boolean bl2 = false;
            $this$use$iv.recycle();
        }

        @NotNull
        public final Destination setClassName(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this._className = className;
            return this;
        }

        @NotNull
        public final String getClassName() {
            if (this._className == null) {
                boolean bl = false;
                String string = "Fragment class was not set";
                throw new IllegalStateException(string.toString());
            }
            String string = this._className;
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
            return string;
        }

        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" class=");
            if (this._className == null) {
                sb.append("null");
            } else {
                sb.append(this._className);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || !(other instanceof Destination)) {
                return false;
            }
            return super.equals(other) && Intrinsics.areEqual((Object)this._className, (Object)((Destination)((Object)other))._className);
        }

        public int hashCode() {
            int result = super.hashCode();
            String string = this._className;
            result = 31 * result + (string != null ? string.hashCode() : 0);
            return result;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\fB\u001b\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Landroidx/navigation/fragment/FragmentNavigator$Extras;", "Landroidx/navigation/Navigator$Extras;", "sharedElements", "", "Landroid/view/View;", "", "(Ljava/util/Map;)V", "_sharedElements", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "getSharedElements", "()Ljava/util/Map;", "Builder", "navigation-fragment_release"})
    public static final class Extras
    implements Navigator.Extras {
        @NotNull
        private final LinkedHashMap<View, String> _sharedElements;

        public Extras(@NotNull Map<View, String> sharedElements) {
            Intrinsics.checkNotNullParameter(sharedElements, (String)"sharedElements");
            this._sharedElements = new LinkedHashMap();
            this._sharedElements.putAll(sharedElements);
        }

        @NotNull
        public final Map<View, String> getSharedElements() {
            return MapsKt.toMap((Map)this._sharedElements);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0006J\u001a\u0010\u000b\u001a\u00020\u00002\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\rJ\u0006\u0010\u000e\u001a\u00020\u000fR*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/navigation/fragment/FragmentNavigator$Extras$Builder;", "", "()V", "_sharedElements", "Ljava/util/LinkedHashMap;", "Landroid/view/View;", "", "Lkotlin/collections/LinkedHashMap;", "addSharedElement", "sharedElement", "name", "addSharedElements", "sharedElements", "", "build", "Landroidx/navigation/fragment/FragmentNavigator$Extras;", "navigation-fragment_release"})
        public static final class Builder {
            @NotNull
            private final LinkedHashMap<View, String> _sharedElements = new LinkedHashMap();

            @NotNull
            public final Builder addSharedElements(@NotNull Map<View, String> sharedElements) {
                Intrinsics.checkNotNullParameter(sharedElements, (String)"sharedElements");
                for (Map.Entry<View, String> entry : sharedElements.entrySet()) {
                    View view = entry.getKey();
                    String name = entry.getValue();
                    this.addSharedElement(view, name);
                }
                return this;
            }

            @NotNull
            public final Builder addSharedElement(@NotNull View sharedElement, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)sharedElement, (String)"sharedElement");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                ((Map)this._sharedElements).put(sharedElement, name);
                return this;
            }

            @NotNull
            public final Extras build() {
                return new Extras((Map<View, String>)this._sharedElements);
            }
        }
    }
}

