/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.annotation.CallSuper;
import androidx.annotation.IdRes;
import androidx.annotation.NavigationRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.TaskStackBuilder;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStore;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.NavAction;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavControllerViewModel;
import androidx.navigation.NavDeepLinkBuilder;
import androidx.navigation.NavDestination;
import androidx.navigation.NavDirections;
import androidx.navigation.NavGraph;
import androidx.navigation.NavGraphNavigator;
import androidx.navigation.NavInflater;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class NavController {
    private static final String TAG = "NavController";
    private static final String KEY_NAVIGATOR_STATE = "android-support-nav:controller:navigatorState";
    private static final String KEY_NAVIGATOR_STATE_NAMES = "android-support-nav:controller:navigatorState:names";
    private static final String KEY_BACK_STACK_UUIDS = "android-support-nav:controller:backStackUUIDs";
    private static final String KEY_BACK_STACK_IDS = "android-support-nav:controller:backStackIds";
    private static final String KEY_BACK_STACK_ARGS = "android-support-nav:controller:backStackArgs";
    static final String KEY_DEEP_LINK_IDS = "android-support-nav:controller:deepLinkIds";
    static final String KEY_DEEP_LINK_EXTRAS = "android-support-nav:controller:deepLinkExtras";
    static final String KEY_DEEP_LINK_HANDLED = "android-support-nav:controller:deepLinkHandled";
    @NonNull
    public static final String KEY_DEEP_LINK_INTENT = "android-support-nav:controller:deepLinkIntent";
    private final Context mContext;
    private Activity mActivity;
    private NavInflater mInflater;
    private NavGraph mGraph;
    private Bundle mNavigatorStateToRestore;
    private String[] mBackStackUUIDsToRestore;
    private int[] mBackStackIdsToRestore;
    private Parcelable[] mBackStackArgsToRestore;
    private boolean mDeepLinkHandled;
    private final Deque<NavBackStackEntry> mBackStack = new ArrayDeque<NavBackStackEntry>();
    private LifecycleOwner mLifecycleOwner;
    private NavControllerViewModel mViewModel;
    private final NavigatorProvider mNavigatorProvider = new NavigatorProvider();
    private final CopyOnWriteArrayList<OnDestinationChangedListener> mOnDestinationChangedListeners = new CopyOnWriteArrayList();
    private final OnBackPressedCallback mOnBackPressedCallback = new OnBackPressedCallback(false){

        public void handleOnBackPressed() {
            NavController.this.popBackStack();
        }
    };
    private boolean mEnableOnBackPressedCallback = true;

    public NavController(@NonNull Context context) {
        this.mContext = context;
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                this.mActivity = (Activity)context;
                break;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        this.mNavigatorProvider.addNavigator((Navigator)new NavGraphNavigator(this.mNavigatorProvider));
        this.mNavigatorProvider.addNavigator((Navigator)new ActivityNavigator(this.mContext));
    }

    @NonNull
    Context getContext() {
        return this.mContext;
    }

    @NonNull
    public NavigatorProvider getNavigatorProvider() {
        return this.mNavigatorProvider;
    }

    public void addOnDestinationChangedListener(@NonNull OnDestinationChangedListener listener) {
        if (!this.mBackStack.isEmpty()) {
            NavBackStackEntry backStackEntry = this.mBackStack.peekLast();
            listener.onDestinationChanged(this, backStackEntry.getDestination(), backStackEntry.getArguments());
        }
        this.mOnDestinationChangedListeners.add(listener);
    }

    public void removeOnDestinationChangedListener(@NonNull OnDestinationChangedListener listener) {
        this.mOnDestinationChangedListeners.remove(listener);
    }

    public boolean popBackStack() {
        if (this.mBackStack.isEmpty()) {
            return false;
        }
        return this.popBackStack(this.getCurrentDestination().getId(), true);
    }

    public boolean popBackStack(@IdRes int destinationId, boolean inclusive) {
        boolean popped = this.popBackStackInternal(destinationId, inclusive);
        return popped && this.dispatchOnDestinationChanged();
    }

    boolean popBackStackInternal(@IdRes int destinationId, boolean inclusive) {
        Navigator navigator;
        if (this.mBackStack.isEmpty()) {
            return false;
        }
        ArrayList<Navigator> popOperations = new ArrayList<Navigator>();
        Iterator<NavBackStackEntry> iterator = this.mBackStack.descendingIterator();
        boolean foundDestination = false;
        while (iterator.hasNext()) {
            NavDestination destination = iterator.next().getDestination();
            Navigator navigator2 = this.mNavigatorProvider.getNavigator(destination.getNavigatorName());
            if (inclusive || destination.getId() != destinationId) {
                popOperations.add(navigator2);
            }
            if (destination.getId() != destinationId) continue;
            foundDestination = true;
            break;
        }
        if (!foundDestination) {
            String destinationName = NavDestination.getDisplayName((Context)this.mContext, (int)destinationId);
            Log.i((String)TAG, (String)("Ignoring popBackStack to destination " + destinationName + " as it was not found on the current back stack"));
            return false;
        }
        boolean popped = false;
        Iterator iterator2 = popOperations.iterator();
        while (iterator2.hasNext() && (navigator = (Navigator)iterator2.next()).popBackStack()) {
            NavBackStackEntry entry = this.mBackStack.removeLast();
            if (this.mViewModel != null) {
                this.mViewModel.clear(entry.mId);
            }
            popped = true;
        }
        this.updateOnBackPressedCallbackEnabled();
        return popped;
    }

    public boolean navigateUp() {
        if (this.getDestinationCountOnBackStack() == 1) {
            NavDestination currentDestination = this.getCurrentDestination();
            int destId = currentDestination.getId();
            for (NavGraph parent = currentDestination.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getStartDestination() != destId) {
                    TaskStackBuilder parentIntents = new NavDeepLinkBuilder(this).setDestination(parent.getId()).createTaskStackBuilder();
                    parentIntents.startActivities();
                    if (this.mActivity != null) {
                        this.mActivity.finish();
                    }
                    return true;
                }
                destId = parent.getId();
            }
            return false;
        }
        return this.popBackStack();
    }

    private int getDestinationCountOnBackStack() {
        int count = 0;
        for (NavBackStackEntry entry : this.mBackStack) {
            if (entry.getDestination() instanceof NavGraph) continue;
            ++count;
        }
        return count;
    }

    private boolean dispatchOnDestinationChanged() {
        while (!this.mBackStack.isEmpty() && this.mBackStack.peekLast().getDestination() instanceof NavGraph && this.popBackStackInternal(this.mBackStack.peekLast().getDestination().getId(), true)) {
        }
        if (!this.mBackStack.isEmpty()) {
            NavBackStackEntry backStackEntry = this.mBackStack.peekLast();
            for (OnDestinationChangedListener listener : this.mOnDestinationChangedListeners) {
                listener.onDestinationChanged(this, backStackEntry.getDestination(), backStackEntry.getArguments());
            }
            return true;
        }
        return false;
    }

    @NonNull
    public NavInflater getNavInflater() {
        if (this.mInflater == null) {
            this.mInflater = new NavInflater(this.mContext, this.mNavigatorProvider);
        }
        return this.mInflater;
    }

    @CallSuper
    public void setGraph(@NavigationRes int graphResId) {
        this.setGraph(graphResId, null);
    }

    @CallSuper
    public void setGraph(@NavigationRes int graphResId, @Nullable Bundle startDestinationArgs) {
        this.setGraph(this.getNavInflater().inflate(graphResId), startDestinationArgs);
    }

    @CallSuper
    public void setGraph(@NonNull NavGraph graph) {
        this.setGraph(graph, null);
    }

    @CallSuper
    public void setGraph(@NonNull NavGraph graph, @Nullable Bundle startDestinationArgs) {
        if (this.mGraph != null) {
            this.popBackStackInternal(this.mGraph.getId(), true);
        }
        this.mGraph = graph;
        this.onGraphCreated(startDestinationArgs);
    }

    private void onGraphCreated(@Nullable Bundle startDestinationArgs) {
        ArrayList navigatorNames;
        if (this.mNavigatorStateToRestore != null && (navigatorNames = this.mNavigatorStateToRestore.getStringArrayList(KEY_NAVIGATOR_STATE_NAMES)) != null) {
            for (String name : navigatorNames) {
                Navigator navigator = this.mNavigatorProvider.getNavigator(name);
                Bundle bundle = this.mNavigatorStateToRestore.getBundle(name);
                if (bundle == null) continue;
                navigator.onRestoreState(bundle);
            }
        }
        if (this.mBackStackUUIDsToRestore != null) {
            for (int index = 0; index < this.mBackStackUUIDsToRestore.length; ++index) {
                UUID uuid = UUID.fromString(this.mBackStackUUIDsToRestore[index]);
                int destinationId = this.mBackStackIdsToRestore[index];
                Bundle args = (Bundle)this.mBackStackArgsToRestore[index];
                NavDestination node = this.findDestination(destinationId);
                if (node == null) {
                    throw new IllegalStateException("unknown destination during restore: " + this.mContext.getResources().getResourceName(destinationId));
                }
                if (args != null) {
                    args.setClassLoader(this.mContext.getClassLoader());
                }
                this.mBackStack.add(new NavBackStackEntry(uuid, node, args));
            }
            this.updateOnBackPressedCallbackEnabled();
            this.mBackStackUUIDsToRestore = null;
            this.mBackStackIdsToRestore = null;
            this.mBackStackArgsToRestore = null;
        }
        if (this.mGraph != null && this.mBackStack.isEmpty()) {
            boolean deepLinked;
            boolean bl = deepLinked = !this.mDeepLinkHandled && this.mActivity != null && this.handleDeepLink(this.mActivity.getIntent());
            if (!deepLinked) {
                this.navigate((NavDestination)this.mGraph, startDestinationArgs, null, null);
            }
        }
    }

    public boolean handleDeepLink(@Nullable Intent intent) {
        NavDestination.DeepLinkMatch matchingDeepLink;
        Bundle deepLinkExtras;
        if (intent == null) {
            return false;
        }
        Bundle extras = intent.getExtras();
        int[] deepLink = extras != null ? extras.getIntArray(KEY_DEEP_LINK_IDS) : null;
        Bundle bundle = new Bundle();
        Bundle bundle2 = deepLinkExtras = extras != null ? extras.getBundle(KEY_DEEP_LINK_EXTRAS) : null;
        if (deepLinkExtras != null) {
            bundle.putAll(deepLinkExtras);
        }
        if ((deepLink == null || deepLink.length == 0) && intent.getData() != null && (matchingDeepLink = this.mGraph.matchDeepLink(intent.getData())) != null) {
            deepLink = matchingDeepLink.getDestination().buildDeepLinkIds();
            bundle.putAll(matchingDeepLink.getMatchingArgs());
        }
        if (deepLink == null || deepLink.length == 0) {
            return false;
        }
        String invalidDestinationDisplayName = this.findInvalidDestinationDisplayNameInDeepLink(deepLink);
        if (invalidDestinationDisplayName != null) {
            Log.i((String)TAG, (String)("Could not find destination " + invalidDestinationDisplayName + " in the navigation graph, ignoring the deep link from " + intent));
            return false;
        }
        bundle.putParcelable(KEY_DEEP_LINK_INTENT, (Parcelable)intent);
        int flags = intent.getFlags();
        if ((flags & 0x10000000) != 0 && (flags & 0x8000) == 0) {
            intent.addFlags(32768);
            TaskStackBuilder taskStackBuilder = TaskStackBuilder.create((Context)this.mContext).addNextIntentWithParentStack(intent);
            taskStackBuilder.startActivities();
            if (this.mActivity != null) {
                this.mActivity.finish();
            }
            return true;
        }
        if ((flags & 0x10000000) != 0) {
            if (!this.mBackStack.isEmpty()) {
                this.popBackStackInternal(this.mGraph.getId(), true);
            }
            int index = 0;
            while (index < deepLink.length) {
                int destinationId;
                NavDestination node;
                if ((node = this.findDestination(destinationId = deepLink[index++])) == null) {
                    throw new IllegalStateException("unknown destination during deep link: " + NavDestination.getDisplayName((Context)this.mContext, (int)destinationId));
                }
                this.navigate(node, bundle, new NavOptions.Builder().setEnterAnim(0).setExitAnim(0).build(), null);
            }
            return true;
        }
        NavGraph graph = this.mGraph;
        for (int i = 0; i < deepLink.length; ++i) {
            NavGraph node;
            int destinationId = deepLink[i];
            Object object = node = i == 0 ? this.mGraph : graph.findNode(destinationId);
            if (node == null) {
                throw new IllegalStateException("unknown destination during deep link: " + NavDestination.getDisplayName((Context)this.mContext, (int)destinationId));
            }
            if (i != deepLink.length - 1) {
                graph = node;
                while (graph.findNode(graph.getStartDestination()) instanceof NavGraph) {
                    graph = (NavGraph)graph.findNode(graph.getStartDestination());
                }
                continue;
            }
            this.navigate((NavDestination)node, node.addInDefaultArgs(bundle), new NavOptions.Builder().setPopUpTo(this.mGraph.getId(), true).setEnterAnim(0).setExitAnim(0).build(), null);
        }
        this.mDeepLinkHandled = true;
        return true;
    }

    @Nullable
    private String findInvalidDestinationDisplayNameInDeepLink(@NonNull int[] deepLink) {
        NavGraph graph = this.mGraph;
        for (int i = 0; i < deepLink.length; ++i) {
            NavGraph node;
            int destinationId = deepLink[i];
            Object object = node = i == 0 ? this.mGraph : graph.findNode(destinationId);
            if (node == null) {
                return NavDestination.getDisplayName((Context)this.mContext, (int)destinationId);
            }
            if (i == deepLink.length - 1) continue;
            graph = node;
            while (graph.findNode(graph.getStartDestination()) instanceof NavGraph) {
                graph = (NavGraph)graph.findNode(graph.getStartDestination());
            }
        }
        return null;
    }

    @NonNull
    public NavGraph getGraph() {
        if (this.mGraph == null) {
            throw new IllegalStateException("You must call setGraph() before calling getGraph()");
        }
        return this.mGraph;
    }

    @Nullable
    public NavDestination getCurrentDestination() {
        if (this.mBackStack.isEmpty()) {
            return null;
        }
        return this.mBackStack.getLast().getDestination();
    }

    NavDestination findDestination(@IdRes int destinationId) {
        if (this.mGraph == null) {
            return null;
        }
        if (this.mGraph.getId() == destinationId) {
            return this.mGraph;
        }
        NavGraph currentNode = this.mBackStack.isEmpty() ? this.mGraph : this.mBackStack.getLast().getDestination();
        NavGraph currentGraph = currentNode instanceof NavGraph ? currentNode : currentNode.getParent();
        return currentGraph.findNode(destinationId);
    }

    public void navigate(@IdRes int resId) {
        this.navigate(resId, null);
    }

    public void navigate(@IdRes int resId, @Nullable Bundle args) {
        this.navigate(resId, args, null);
    }

    public void navigate(@IdRes int resId, @Nullable Bundle args, @Nullable NavOptions navOptions) {
        this.navigate(resId, args, navOptions, null);
    }

    public void navigate(@IdRes int resId, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        NavGraph currentNode;
        Object object = currentNode = this.mBackStack.isEmpty() ? this.mGraph : this.mBackStack.getLast().getDestination();
        if (currentNode == null) {
            throw new IllegalStateException("no current navigation node");
        }
        int destId = resId;
        NavAction navAction = currentNode.getAction(resId);
        Bundle combinedArgs = null;
        if (navAction != null) {
            if (navOptions == null) {
                navOptions = navAction.getNavOptions();
            }
            destId = navAction.getDestinationId();
            Bundle navActionArgs = navAction.getDefaultArguments();
            if (navActionArgs != null) {
                combinedArgs = new Bundle();
                combinedArgs.putAll(navActionArgs);
            }
        }
        if (args != null) {
            if (combinedArgs == null) {
                combinedArgs = new Bundle();
            }
            combinedArgs.putAll(args);
        }
        if (destId == 0 && navOptions != null && navOptions.getPopUpTo() != -1) {
            this.popBackStack(navOptions.getPopUpTo(), navOptions.isPopUpToInclusive());
            return;
        }
        if (destId == 0) {
            throw new IllegalArgumentException("Destination id == 0 can only be used in conjunction with a valid navOptions.popUpTo");
        }
        NavDestination node = this.findDestination(destId);
        if (node == null) {
            String dest = NavDestination.getDisplayName((Context)this.mContext, (int)destId);
            throw new IllegalArgumentException("navigation destination " + dest + (navAction != null ? " referenced from action " + NavDestination.getDisplayName((Context)this.mContext, (int)resId) : "") + " is unknown to this NavController");
        }
        this.navigate(node, combinedArgs, navOptions, navigatorExtras);
    }

    public void navigate(@NonNull Uri deepLink) {
        this.navigate(deepLink, null);
    }

    public void navigate(@NonNull Uri deepLink, @Nullable NavOptions navOptions) {
        this.navigate(deepLink, navOptions, null);
    }

    public void navigate(@NonNull Uri deepLink, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        NavDestination.DeepLinkMatch deepLinkMatch = this.mGraph.matchDeepLink(deepLink);
        if (deepLinkMatch == null) {
            throw new IllegalArgumentException("navigation destination with deepLink " + deepLink + " is unknown to this NavController");
        }
        Bundle args = deepLinkMatch.getMatchingArgs();
        NavDestination node = deepLinkMatch.getDestination();
        this.navigate(node, args, navOptions, navigatorExtras);
    }

    private void navigate(@NonNull NavDestination node, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Bundle finalArgs;
        Navigator navigator;
        NavDestination newDest;
        boolean popped = false;
        if (navOptions != null && navOptions.getPopUpTo() != -1) {
            popped = this.popBackStackInternal(navOptions.getPopUpTo(), navOptions.isPopUpToInclusive());
        }
        if ((newDest = (navigator = this.mNavigatorProvider.getNavigator(node.getNavigatorName())).navigate(node, finalArgs = node.addInDefaultArgs(args), navOptions, navigatorExtras)) != null) {
            if (this.mBackStack.isEmpty()) {
                this.mBackStack.add(new NavBackStackEntry((NavDestination)this.mGraph, finalArgs));
            }
            ArrayDeque<NavBackStackEntry> hierarchy = new ArrayDeque<NavBackStackEntry>();
            NavDestination destination = newDest;
            while (destination != null && this.findDestination(destination.getId()) == null) {
                NavGraph parent = destination.getParent();
                if (parent != null) {
                    hierarchy.addFirst(new NavBackStackEntry((NavDestination)parent, finalArgs));
                }
                destination = parent;
            }
            this.mBackStack.addAll(hierarchy);
            NavBackStackEntry newBackStackEntry = new NavBackStackEntry(newDest, newDest.addInDefaultArgs(finalArgs));
            this.mBackStack.add(newBackStackEntry);
        }
        this.updateOnBackPressedCallbackEnabled();
        if (popped || newDest != null) {
            this.dispatchOnDestinationChanged();
        }
    }

    public void navigate(@NonNull NavDirections directions) {
        this.navigate(directions.getActionId(), directions.getArguments());
    }

    public void navigate(@NonNull NavDirections directions, @Nullable NavOptions navOptions) {
        this.navigate(directions.getActionId(), directions.getArguments(), navOptions);
    }

    public void navigate(@NonNull NavDirections directions, @NonNull Navigator.Extras navigatorExtras) {
        this.navigate(directions.getActionId(), directions.getArguments(), null, navigatorExtras);
    }

    @NonNull
    public NavDeepLinkBuilder createDeepLink() {
        return new NavDeepLinkBuilder(this);
    }

    @CallSuper
    @Nullable
    public Bundle saveState() {
        Bundle b = null;
        ArrayList<String> navigatorNames = new ArrayList<String>();
        Bundle navigatorState = new Bundle();
        for (Map.Entry entry : this.mNavigatorProvider.getNavigators().entrySet()) {
            String name = (String)entry.getKey();
            Bundle savedState = ((Navigator)entry.getValue()).onSaveState();
            if (savedState == null) continue;
            navigatorNames.add(name);
            navigatorState.putBundle(name, savedState);
        }
        if (!navigatorNames.isEmpty()) {
            b = new Bundle();
            navigatorState.putStringArrayList(KEY_NAVIGATOR_STATE_NAMES, navigatorNames);
            b.putBundle(KEY_NAVIGATOR_STATE, navigatorState);
        }
        if (!this.mBackStack.isEmpty()) {
            if (b == null) {
                b = new Bundle();
            }
            String[] backStackUUIDs = new String[this.mBackStack.size()];
            int[] backStackIds = new int[this.mBackStack.size()];
            Parcelable[] backStackArgs = new Parcelable[this.mBackStack.size()];
            int index = 0;
            for (NavBackStackEntry backStackEntry : this.mBackStack) {
                backStackUUIDs[index] = backStackEntry.mId.toString();
                backStackIds[index] = backStackEntry.getDestination().getId();
                backStackArgs[index++] = backStackEntry.getArguments();
            }
            b.putStringArray(KEY_BACK_STACK_UUIDS, backStackUUIDs);
            b.putIntArray(KEY_BACK_STACK_IDS, backStackIds);
            b.putParcelableArray(KEY_BACK_STACK_ARGS, backStackArgs);
        }
        if (this.mDeepLinkHandled) {
            if (b == null) {
                b = new Bundle();
            }
            b.putBoolean(KEY_DEEP_LINK_HANDLED, this.mDeepLinkHandled);
        }
        return b;
    }

    @CallSuper
    public void restoreState(@Nullable Bundle navState) {
        if (navState == null) {
            return;
        }
        navState.setClassLoader(this.mContext.getClassLoader());
        this.mNavigatorStateToRestore = navState.getBundle(KEY_NAVIGATOR_STATE);
        this.mBackStackUUIDsToRestore = navState.getStringArray(KEY_BACK_STACK_UUIDS);
        this.mBackStackIdsToRestore = navState.getIntArray(KEY_BACK_STACK_IDS);
        this.mBackStackArgsToRestore = navState.getParcelableArray(KEY_BACK_STACK_ARGS);
        this.mDeepLinkHandled = navState.getBoolean(KEY_DEEP_LINK_HANDLED);
    }

    void setLifecycleOwner(@NonNull LifecycleOwner owner) {
        this.mLifecycleOwner = owner;
    }

    void setOnBackPressedDispatcher(@NonNull OnBackPressedDispatcher dispatcher) {
        if (this.mLifecycleOwner == null) {
            throw new IllegalStateException("You must call setLifecycleOwner() before calling setOnBackPressedDispatcher()");
        }
        this.mOnBackPressedCallback.remove();
        dispatcher.addCallback(this.mLifecycleOwner, this.mOnBackPressedCallback);
    }

    void enableOnBackPressed(boolean enabled) {
        this.mEnableOnBackPressedCallback = enabled;
        this.updateOnBackPressedCallbackEnabled();
    }

    private void updateOnBackPressedCallbackEnabled() {
        this.mOnBackPressedCallback.setEnabled(this.mEnableOnBackPressedCallback && this.getDestinationCountOnBackStack() > 1);
    }

    void setViewModelStore(@NonNull ViewModelStore viewModelStore) {
        this.mViewModel = NavControllerViewModel.getInstance(viewModelStore);
    }

    @NonNull
    public ViewModelStore getViewModelStore(@IdRes int navGraphId) {
        if (this.mViewModel == null) {
            throw new IllegalStateException("You must call setViewModelStore() before calling getViewModelStore().");
        }
        NavBackStackEntry lastFromBackStack = null;
        Iterator<NavBackStackEntry> iterator = this.mBackStack.descendingIterator();
        while (iterator.hasNext()) {
            NavBackStackEntry entry = iterator.next();
            NavDestination destination = entry.getDestination();
            if (!(destination instanceof NavGraph) || destination.getId() != navGraphId) continue;
            lastFromBackStack = entry;
            break;
        }
        if (lastFromBackStack == null) {
            throw new IllegalArgumentException("No NavGraph with ID " + navGraphId + " is on the NavController's back stack");
        }
        return this.mViewModel.getViewModelStore(lastFromBackStack.mId);
    }

    public static interface OnDestinationChangedListener {
        public void onDestinationChanged(@NonNull NavController var1, @NonNull NavDestination var2, @Nullable Bundle var3);
    }
}

