/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.HasDefaultViewModelProviderFactory;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.SavedStateViewModelFactory;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.NavControllerViewModel;
import androidx.navigation.NavDestination;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryController;
import androidx.savedstate.SavedStateRegistryOwner;
import java.util.UUID;

final class NavBackStackEntry
implements LifecycleOwner,
ViewModelStoreOwner,
HasDefaultViewModelProviderFactory,
SavedStateRegistryOwner {
    private final Context mContext;
    private final NavDestination mDestination;
    private final Bundle mArgs;
    private final LifecycleRegistry mLifecycle = new LifecycleRegistry((LifecycleOwner)this);
    private final SavedStateRegistryController mSavedStateRegistryController = SavedStateRegistryController.create((SavedStateRegistryOwner)this);
    @NonNull
    final UUID mId;
    private NavControllerViewModel mNavControllerViewModel;
    private ViewModelProvider.Factory mDefaultFactory;

    NavBackStackEntry(@NonNull Context context, @NonNull NavDestination destination, @Nullable Bundle args, @Nullable LifecycleOwner navControllerLifecyleOwner, @Nullable NavControllerViewModel navControllerViewModel) {
        this(context, destination, args, navControllerLifecyleOwner, navControllerViewModel, UUID.randomUUID(), null);
    }

    NavBackStackEntry(@NonNull Context context, @NonNull NavDestination destination, @Nullable Bundle args, @Nullable LifecycleOwner navControllerLifecyleOwner, @Nullable NavControllerViewModel navControllerViewModel, @NonNull UUID uuid, @Nullable Bundle savedState) {
        this.mContext = context;
        this.mId = uuid;
        this.mDestination = destination;
        this.mArgs = args;
        this.mNavControllerViewModel = navControllerViewModel;
        this.mSavedStateRegistryController.performRestore(savedState);
        if (navControllerLifecyleOwner != null) {
            this.mLifecycle.setCurrentState(navControllerLifecyleOwner.getLifecycle().getCurrentState());
        } else {
            this.mLifecycle.setCurrentState(Lifecycle.State.CREATED);
        }
    }

    @NonNull
    public NavDestination getDestination() {
        return this.mDestination;
    }

    @Nullable
    public Bundle getArguments() {
        return this.mArgs;
    }

    void setNavControllerViewModel(@NonNull NavControllerViewModel navControllerViewModel) {
        this.mNavControllerViewModel = navControllerViewModel;
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return this.mLifecycle;
    }

    void handleLifecycleEvent(Lifecycle.Event event) {
        this.mLifecycle.handleLifecycleEvent(event);
    }

    @NonNull
    public ViewModelStore getViewModelStore() {
        return this.mNavControllerViewModel.getViewModelStore(this.mId);
    }

    @NonNull
    public ViewModelProvider.Factory getDefaultViewModelProviderFactory() {
        if (this.mDefaultFactory == null) {
            this.mDefaultFactory = new SavedStateViewModelFactory((Application)this.mContext.getApplicationContext(), (SavedStateRegistryOwner)this, this.mArgs);
        }
        return this.mDefaultFactory;
    }

    @NonNull
    public SavedStateRegistry getSavedStateRegistry() {
        return this.mSavedStateRegistryController.getSavedStateRegistry();
    }

    void saveState(@NonNull Bundle outBundle) {
        this.mSavedStateRegistryController.performSave(outBundle);
    }
}

