/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.core.app.ActivityCompat;
import androidx.navigation.NavController;
import androidx.navigation.NavDirections;
import androidx.navigation.Navigation;
import androidx.navigation.R;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001e\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0007\u00a8\u0006\u0017"}, d2={"Landroidx/navigation/Navigation;", "", "()V", "createNavigateOnClickListener", "Landroid/view/View$OnClickListener;", "directions", "Landroidx/navigation/NavDirections;", "resId", "", "args", "Landroid/os/Bundle;", "findNavController", "Landroidx/navigation/NavController;", "activity", "Landroid/app/Activity;", "viewId", "view", "Landroid/view/View;", "findViewNavController", "getViewNavController", "setViewNavController", "", "controller", "navigation-runtime_release"})
public final class Navigation {
    @NotNull
    public static final Navigation INSTANCE = new Navigation();

    private Navigation() {
    }

    @JvmStatic
    @NotNull
    public static final NavController findNavController(@NotNull Activity activity2, @IdRes int viewId) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        View view = ActivityCompat.requireViewById((Activity)activity2, (int)viewId);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"requireViewById<View>(activity, viewId)");
        View view2 = view;
        NavController navController = INSTANCE.findViewNavController(view2);
        if (navController == null) {
            throw new IllegalStateException("Activity " + activity2 + " does not have a NavController set on " + viewId);
        }
        return navController;
    }

    @JvmStatic
    @NotNull
    public static final NavController findNavController(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        NavController navController = INSTANCE.findViewNavController(view);
        if (navController == null) {
            throw new IllegalStateException("View " + view + " does not have a NavController set");
        }
        return navController;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final View.OnClickListener createNavigateOnClickListener(@IdRes int resId, @Nullable Bundle args) {
        return arg_0 -> Navigation.createNavigateOnClickListener$lambda-0(resId, args, arg_0);
    }

    public static /* synthetic */ View.OnClickListener createNavigateOnClickListener$default(int n, Bundle bundle, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bundle = null;
        }
        return Navigation.createNavigateOnClickListener(n, bundle);
    }

    @JvmStatic
    @NotNull
    public static final View.OnClickListener createNavigateOnClickListener(@NotNull NavDirections directions) {
        Intrinsics.checkNotNullParameter((Object)directions, (String)"directions");
        return arg_0 -> Navigation.createNavigateOnClickListener$lambda-1(directions, arg_0);
    }

    @JvmStatic
    public static final void setViewNavController(@NotNull View view, @Nullable NavController controller) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setTag(R.id.nav_controller_view_tag, (Object)controller);
    }

    private final NavController findViewNavController(View view) {
        return (NavController)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)view, (Function1)findViewNavController.1.INSTANCE), (Function1)findViewNavController.2.INSTANCE));
    }

    private final NavController getViewNavController(View view) {
        Object tag = view.getTag(R.id.nav_controller_view_tag);
        NavController controller = null;
        if (tag instanceof WeakReference) {
            controller = (NavController)((WeakReference)tag).get();
        } else if (tag instanceof NavController) {
            controller = (NavController)tag;
        }
        return controller;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final View.OnClickListener createNavigateOnClickListener(@IdRes int resId) {
        return Navigation.createNavigateOnClickListener$default(resId, null, 2, null);
    }

    private static final void createNavigateOnClickListener$lambda-0(int $resId, Bundle $args, View view) {
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
        Navigation.findNavController(view).navigate($resId, $args);
    }

    private static final void createNavigateOnClickListener$lambda-1(NavDirections $directions, View view) {
        Intrinsics.checkNotNullParameter((Object)$directions, (String)"$directions");
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
        Navigation.findNavController(view).navigate($directions);
    }

    public static final /* synthetic */ NavController access$getViewNavController(Navigation $this, View view) {
        return $this.getViewNavController(view);
    }
}

