/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.runtime.lint;

import androidx.navigation.lint.common.LintUtilKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Landroidx/navigation/runtime/lint/WrongNavigateRouteDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "navigation-runtime-lint"})
@SourceDebugExtension(value={"SMAP\nWrongNavigateRouteDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrongNavigateRouteDetector.kt\nandroidx/navigation/runtime/lint/WrongNavigateRouteDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class WrongNavigateRouteDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue WrongNavigateRouteType;

    @NotNull
    public final List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"navigate");
    }

    public final void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Iterable iterable = node.getValueArguments();
            for (Object t : iterable) {
                UExpression it = (UExpression)t;
                boolean bl = false;
                PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)it);
                if (!Intrinsics.areEqual((Object)(psiParameter != null ? psiParameter.getName() : null), (Object)"route")) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        UExpression uExpression = v1;
        if (uExpression == null) {
            return;
        }
        UExpression startNode = uExpression;
        boolean isClassLiteral = startNode instanceof UClassLiteralExpression;
        boolean isClassType = (Boolean)LintUtilKt.isClassReference(startNode).component1();
        if (isClassType || isClassLiteral) {
            JavaContext.report$default((JavaContext)context, (Issue)WrongNavigateRouteType, (UElement)((UElement)startNode), (Location)context.getNameLocation((UElement)startNode), (String)"The route should be a destination class instance or destination object.", null, (int)16, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(WrongNavigateRouteDetector.class, Scope.JAVA_FILE_SCOPE);
        WrongNavigateRouteType = Issue.Companion.create$default((Issue.Companion)companion, (String)"WrongNavigateRouteType", (String)"Navigation route should be an object literal or a destination class instance with arguments.", (String)"If the destination class contains arguments, the route is expected to be class instance with the arguments filled in.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, null, null, null, (int)3920, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/runtime/lint/WrongNavigateRouteDetector$Companion;", "", "()V", "WrongNavigateRouteType", "Lcom/android/tools/lint/detector/api/Issue;", "getWrongNavigateRouteType", "()Lcom/android/tools/lint/detector/api/Issue;", "navigation-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getWrongNavigateRouteType() {
            return WrongNavigateRouteType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

