/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safe.args.generator;

import androidx.navigation.safe.args.generator.BoolArrayType;
import androidx.navigation.safe.args.generator.BoolType;
import androidx.navigation.safe.args.generator.Context;
import androidx.navigation.safe.args.generator.EnumValue;
import androidx.navigation.safe.args.generator.FloatArrayType;
import androidx.navigation.safe.args.generator.FloatType;
import androidx.navigation.safe.args.generator.IntArrayType;
import androidx.navigation.safe.args.generator.IntType;
import androidx.navigation.safe.args.generator.IntValue;
import androidx.navigation.safe.args.generator.LongArrayType;
import androidx.navigation.safe.args.generator.LongType;
import androidx.navigation.safe.args.generator.NavParser;
import androidx.navigation.safe.args.generator.NavParserErrors;
import androidx.navigation.safe.args.generator.NavParserKt;
import androidx.navigation.safe.args.generator.NavType;
import androidx.navigation.safe.args.generator.NullValue;
import androidx.navigation.safe.args.generator.ObjectArrayType;
import androidx.navigation.safe.args.generator.ObjectType;
import androidx.navigation.safe.args.generator.ReferenceArrayType;
import androidx.navigation.safe.args.generator.ReferenceType;
import androidx.navigation.safe.args.generator.ReferenceValue;
import androidx.navigation.safe.args.generator.StringArrayType;
import androidx.navigation.safe.args.generator.StringType;
import androidx.navigation.safe.args.generator.StringValue;
import androidx.navigation.safe.args.generator.WritableValue;
import androidx.navigation.safe.args.generator.XmlPosition;
import androidx.navigation.safe.args.generator.XmlPositionParser;
import androidx.navigation.safe.args.generator.ext.String_extKt;
import androidx.navigation.safe.args.generator.models.Action;
import androidx.navigation.safe.args.generator.models.Argument;
import androidx.navigation.safe.args.generator.models.Destination;
import androidx.navigation.safe.args.generator.models.IncludedDestination;
import androidx.navigation.safe.args.generator.models.ResReference;
import com.squareup.javapoet.ClassName;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/navigation/safe/args/generator/NavParser;", "", "parser", "Landroidx/navigation/safe/args/generator/XmlPositionParser;", "context", "Landroidx/navigation/safe/args/generator/Context;", "rFilePackage", "", "applicationId", "(Landroidx/navigation/safe/args/generator/XmlPositionParser;Landroidx/navigation/safe/args/generator/Context;Ljava/lang/String;Ljava/lang/String;)V", "parseAction", "Landroidx/navigation/safe/args/generator/models/Action;", "parseArgument", "Landroidx/navigation/safe/args/generator/models/Argument;", "parseDestination", "Landroidx/navigation/safe/args/generator/models/Destination;", "parseDestination$navigation_safe_args_generator", "parseId", "Landroidx/navigation/safe/args/generator/models/ResReference;", "xmlId", "xmlPosition", "Landroidx/navigation/safe/args/generator/XmlPosition;", "parseIncludeDestination", "Landroidx/navigation/safe/args/generator/models/IncludedDestination;", "Companion", "navigation-safe-args-generator"})
public final class NavParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XmlPositionParser parser;
    @NotNull
    private final Context context;
    @NotNull
    private final String rFilePackage;
    @NotNull
    private final String applicationId;

    public NavParser(@NotNull XmlPositionParser parser, @NotNull Context context, @NotNull String rFilePackage, @NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)rFilePackage, (String)"rFilePackage");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        this.parser = parser;
        this.context = context;
        this.rFilePackage = rFilePackage;
        this.applicationId = applicationId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Destination parseDestination$navigation_safe_args_generator() {
        ResReference resReference;
        String sanitizedName;
        Map.Entry element$iv;
        void $this$forEach$iv;
        List list$iv$iv;
        List answer$iv$iv$iv;
        Object value$iv$iv$iv;
        boolean $i$f$getOrPut;
        Map $this$getOrPut$iv$iv$iv;
        String key$iv$iv;
        Object it;
        Object element$iv$iv;
        Object $this$groupByTo$iv$iv;
        XmlPosition position = this.parser.xmlPosition();
        String type = this.parser.name();
        String string = this.parser.attrValue("http://schemas.android.com/apk/res/android", "name");
        if (string == null) {
            string = "";
        }
        String name = string;
        String idValue = this.parser.attrValue("http://schemas.android.com/apk/res/android", "id");
        List args = new ArrayList();
        List actions = new ArrayList();
        List nested = new ArrayList();
        List included = new ArrayList();
        this.parser.traverseInnerStartTags((Function0<Unit>)((Function0)new Function0<Unit>(this, (List<Action>)actions, (List<Argument>)args, (List<IncludedDestination>)included, type, (List<Destination>)nested){
            final /* synthetic */ NavParser this$0;
            final /* synthetic */ List<Action> $actions;
            final /* synthetic */ List<Argument> $args;
            final /* synthetic */ List<IncludedDestination> $included;
            final /* synthetic */ String $type;
            final /* synthetic */ List<Destination> $nested;
            {
                this.this$0 = $receiver;
                this.$actions = $actions;
                this.$args = $args;
                this.$included = $included;
                this.$type = $type;
                this.$nested = $nested;
                super(0);
            }

            public final void invoke() {
                if (Intrinsics.areEqual((Object)NavParser.access$getParser$p(this.this$0).name(), (Object)"action")) {
                    this.$actions.add(NavParser.access$parseAction(this.this$0));
                } else if (Intrinsics.areEqual((Object)NavParser.access$getParser$p(this.this$0).name(), (Object)"argument")) {
                    this.$args.add(NavParser.access$parseArgument(this.this$0));
                } else if (Intrinsics.areEqual((Object)NavParser.access$getParser$p(this.this$0).name(), (Object)"include")) {
                    this.$included.add(NavParser.access$parseIncludeDestination(this.this$0));
                } else if (Intrinsics.areEqual((Object)this.$type, (Object)"navigation")) {
                    this.$nested.add(this.this$0.parseDestination$navigation_safe_args_generator());
                }
            }
        }));
        Object $this$groupBy$iv = actions;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object2;
            element$iv$iv = iterator.next();
            it = (Action)element$iv$iv;
            boolean bl = false;
            key$iv$iv = String_extKt.toCamelCase(((Action)it).getId().getJavaIdentifier());
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Map.Entry $dstr$sanitizedName$actions = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            sanitizedName = (String)$dstr$sanitizedName$actions.getKey();
            List actions2 = (List)$dstr$sanitizedName$actions.getValue();
            if (actions2.size() <= 1) continue;
            this.context.getLogger().error(NavParserErrors.INSTANCE.sameSanitizedNameActions(sanitizedName, actions2), position);
        }
        $this$groupBy$iv = args;
        $i$f$groupBy = false;
        $this$groupByTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$groupByTo = false;
        Iterator bl = $this$groupByTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object object3;
            element$iv$iv = bl.next();
            it = (Argument)element$iv$iv;
            boolean bl3 = false;
            key$iv$iv = ((Argument)it).getSanitizedName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry $dstr$sanitizedName$args = element$iv = (Map.Entry)object.next();
            boolean bl5 = false;
            sanitizedName = (String)$dstr$sanitizedName$args.getKey();
            List args2 = (List)$dstr$sanitizedName$args.getValue();
            if (args2.size() <= 1) continue;
            this.context.getLogger().error(NavParserErrors.INSTANCE.sameSanitizedNameArguments(sanitizedName, args2), position);
        }
        String string2 = idValue;
        if (string2 == null) {
            resReference = null;
        } else {
            String it2 = string2;
            boolean bl6 = false;
            resReference = this.parseId(idValue, this.rFilePackage, position);
        }
        ResReference id = resReference;
        ClassName className = Destination.Companion.createName(id, name, this.applicationId);
        if (className == null && (!((Collection)actions).isEmpty() || !((Collection)args).isEmpty())) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.getUNNAMED_DESTINATION(), position);
            return this.context.createStubDestination();
        }
        return new Destination(id, className, type, args, actions, nested, included);
    }

    private final IncludedDestination parseIncludeDestination() {
        XmlPosition xmlPosition = this.parser.xmlPosition();
        String graphValue = this.parser.attrValue("http://schemas.android.com/apk/res-auto", "graph");
        if (graphValue == null) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.getMISSING_GRAPH_ATTR(), xmlPosition);
            return this.context.createStubIncludedDestination();
        }
        ResReference graphRef = NavParserKt.parseReference(graphValue, this.rFilePackage);
        if (graphRef == null || !Intrinsics.areEqual((Object)graphRef.getResType(), (Object)"navigation")) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.invalidNavReference(graphValue), xmlPosition);
            return this.context.createStubIncludedDestination();
        }
        return new IncludedDestination(graphRef, null, 2, null);
    }

    private final Argument parseArgument() {
        WritableValue writableValue;
        boolean nullable;
        boolean bl;
        XmlPosition xmlPosition = this.parser.xmlPosition();
        String name = this.parser.attrValueOrError("http://schemas.android.com/apk/res/android", "name");
        String defaultValue = this.parser.attrValue("http://schemas.android.com/apk/res/android", "defaultValue");
        String typeString = this.parser.attrValue("http://schemas.android.com/apk/res-auto", "argType");
        String string = this.parser.attrValue("http://schemas.android.com/apk/res-auto", "nullable");
        if (string == null) {
            bl = false;
        } else {
            boolean bl2;
            String it = string;
            boolean bl3 = false;
            bl = nullable = (bl2 = Intrinsics.areEqual((Object)it, (Object)"true"));
        }
        if (name == null) {
            return this.context.createStubArg();
        }
        if (this.parser.attrValue("http://schemas.android.com/apk/res-auto", "type") != null) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.deprecatedTypeAttrUsed(name), xmlPosition);
            return this.context.createStubArg();
        }
        if (typeString == null && defaultValue != null) {
            return NavParserKt.inferArgument(name, defaultValue, this.rFilePackage);
        }
        NavType type = NavType.Companion.from(typeString, this.rFilePackage);
        if (nullable && !type.allowsNullable()) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.typeIsNotNullable(typeString), xmlPosition);
            return this.context.createStubArg();
        }
        if (defaultValue == null) {
            return new Argument(name, type, null, nullable);
        }
        NavType navType = type;
        if (Intrinsics.areEqual((Object)navType, (Object)IntType.INSTANCE)) {
            writableValue = NavParserKt.parseIntValue(defaultValue);
        } else if (Intrinsics.areEqual((Object)navType, (Object)LongType.INSTANCE)) {
            writableValue = NavParserKt.parseLongValue(defaultValue);
        } else if (Intrinsics.areEqual((Object)navType, (Object)FloatType.INSTANCE)) {
            writableValue = NavParserKt.access$parseFloatValue(defaultValue);
        } else if (Intrinsics.areEqual((Object)navType, (Object)BoolType.INSTANCE)) {
            writableValue = NavParserKt.access$parseBoolean(defaultValue);
        } else if (Intrinsics.areEqual((Object)navType, (Object)ReferenceType.INSTANCE)) {
            String string2 = defaultValue;
            if (Intrinsics.areEqual((Object)string2, (Object)"@null")) {
                this.context.getLogger().error(NavParserErrors.INSTANCE.nullDefaultValueReference(name), xmlPosition);
                return this.context.createStubArg();
            }
            if (Intrinsics.areEqual((Object)string2, (Object)"0")) {
                writableValue = new IntValue("0");
            } else {
                ReferenceValue referenceValue;
                ResReference resReference = NavParserKt.parseReference(defaultValue, this.rFilePackage);
                if (resReference == null) {
                    referenceValue = null;
                } else {
                    ResReference it = resReference;
                    boolean bl4 = false;
                    referenceValue = new ReferenceValue(it);
                }
                writableValue = referenceValue;
            }
        } else if (Intrinsics.areEqual((Object)navType, (Object)StringType.INSTANCE)) {
            writableValue = Intrinsics.areEqual((Object)defaultValue, (Object)"@null") ? (WritableValue)NullValue.INSTANCE : (WritableValue)new StringValue(defaultValue);
        } else if ((((((Intrinsics.areEqual((Object)navType, (Object)IntArrayType.INSTANCE) ? true : Intrinsics.areEqual((Object)navType, (Object)LongArrayType.INSTANCE)) ? true : Intrinsics.areEqual((Object)navType, (Object)FloatArrayType.INSTANCE)) ? true : Intrinsics.areEqual((Object)navType, (Object)StringArrayType.INSTANCE)) ? true : Intrinsics.areEqual((Object)navType, (Object)BoolArrayType.INSTANCE)) ? true : Intrinsics.areEqual((Object)navType, (Object)ReferenceArrayType.INSTANCE)) ? true : navType instanceof ObjectArrayType) {
            if (!Intrinsics.areEqual((Object)defaultValue, (Object)"@null")) {
                this.context.getLogger().error(NavParserErrors.INSTANCE.defaultValueObjectType(typeString), xmlPosition);
                return this.context.createStubArg();
            }
            writableValue = NullValue.INSTANCE;
        } else if (navType instanceof ObjectType) {
            writableValue = Intrinsics.areEqual((Object)defaultValue, (Object)"@null") ? (WritableValue)NullValue.INSTANCE : (WritableValue)new EnumValue((ObjectType)type, defaultValue);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown type: ", (Object)type));
        }
        WritableValue defaultTypedValue = writableValue;
        if (defaultTypedValue == null) {
            String errorMessage = Intrinsics.areEqual((Object)type, (Object)ReferenceType.INSTANCE) ? NavParserErrors.INSTANCE.invalidDefaultValueReference(defaultValue) : NavParserErrors.INSTANCE.invalidDefaultValue(defaultValue, type);
            this.context.getLogger().error(errorMessage, xmlPosition);
            return this.context.createStubArg();
        }
        if (!nullable && Intrinsics.areEqual((Object)defaultTypedValue, (Object)NullValue.INSTANCE)) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.defaultNullButNotNullable(name), xmlPosition);
            return this.context.createStubArg();
        }
        return new Argument(name, type, defaultTypedValue, nullable);
    }

    /*
     * WARNING - void declaration
     */
    private final Action parseAction() {
        ResReference resReference;
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        String idValue = this.parser.attrValueOrError("http://schemas.android.com/apk/res/android", "id");
        String destValue = this.parser.attrValue("http://schemas.android.com/apk/res-auto", "destination");
        List args = new ArrayList();
        XmlPosition position = this.parser.xmlPosition();
        this.parser.traverseInnerStartTags((Function0<Unit>)((Function0)new Function0<Unit>(this, (List<Argument>)args){
            final /* synthetic */ NavParser this$0;
            final /* synthetic */ List<Argument> $args;
            {
                this.this$0 = $receiver;
                this.$args = $args;
                super(0);
            }

            public final void invoke() {
                if (Intrinsics.areEqual((Object)NavParser.access$getParser$p(this.this$0).name(), (Object)"argument")) {
                    this.$args.add(NavParser.access$parseArgument(this.this$0));
                }
            }
        }));
        Object $this$groupBy$iv = args;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Argument it = (Argument)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getSanitizedName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$sanitizedName$args = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String sanitizedName = (String)$dstr$sanitizedName$args.getKey();
            List args2 = (List)$dstr$sanitizedName$args.getValue();
            if (args2.size() <= 1) continue;
            this.context.getLogger().error(NavParserErrors.INSTANCE.sameSanitizedNameArguments(sanitizedName, args2), position);
        }
        ResReference id = idValue != null ? this.parseId(idValue, this.rFilePackage, position) : this.context.createStubId();
        String string = destValue;
        if (string == null) {
            resReference = null;
        } else {
            String it = string;
            boolean bl = false;
            resReference = this.parseId(destValue, this.rFilePackage, position);
        }
        ResReference destination = resReference;
        return new Action(id, destination, args);
    }

    private final ResReference parseId(String xmlId, String rFilePackage, XmlPosition xmlPosition) {
        ResReference ref;
        ResReference resReference = ref = NavParserKt.parseReference(xmlId, rFilePackage);
        if (resReference == null ? false : resReference.isId()) {
            return ref;
        }
        this.context.getLogger().error(NavParserErrors.INSTANCE.invalidId(xmlId), xmlPosition);
        return this.context.createStubId();
    }

    public static final /* synthetic */ XmlPositionParser access$getParser$p(NavParser $this) {
        return $this.parser;
    }

    public static final /* synthetic */ Action access$parseAction(NavParser $this) {
        return $this.parseAction();
    }

    public static final /* synthetic */ Argument access$parseArgument(NavParser $this) {
        return $this.parseArgument();
    }

    public static final /* synthetic */ IncludedDestination access$parseIncludeDestination(NavParser $this) {
        return $this.parseIncludeDestination();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Landroidx/navigation/safe/args/generator/NavParser$Companion;", "", "()V", "parseNavigationFile", "Landroidx/navigation/safe/args/generator/models/Destination;", "navigationXml", "Ljava/io/File;", "rFilePackage", "", "applicationId", "context", "Landroidx/navigation/safe/args/generator/Context;", "navigation-safe-args-generator"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Destination parseNavigationFile(@NotNull File navigationXml, @NotNull String rFilePackage, @NotNull String applicationId, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)navigationXml, (String)"navigationXml");
            Intrinsics.checkNotNullParameter((Object)rFilePackage, (String)"rFilePackage");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Closeable closeable = new FileReader(navigationXml);
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl = false;
                String string = navigationXml.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"navigationXml.path");
                XmlPositionParser parser = new XmlPositionParser(string, reader, context.getLogger());
                parser.traverseStartTags((Function0<Boolean>)((Function0)parseNavigationFile.1.1.INSTANCE));
                Destination destination = new NavParser(parser, context, rFilePackage, applicationId).parseDestination$navigation_safe_args_generator();
                return destination;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

