/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safe.args.generator;

import androidx.navigation.safe.args.generator.CodeFile;
import androidx.navigation.safe.args.generator.Context;
import androidx.navigation.safe.args.generator.GeneratorOutput;
import androidx.navigation.safe.args.generator.NavArgumentResolverKt;
import androidx.navigation.safe.args.generator.NavParser;
import androidx.navigation.safe.args.generator.NavWriter;
import androidx.navigation.safe.args.generator.models.Destination;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B5\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/navigation/safe/args/generator/NavSafeArgsGenerator;", "T", "Landroidx/navigation/safe/args/generator/CodeFile;", "", "rFilePackage", "", "applicationId", "navigationXml", "Ljava/io/File;", "outputDir", "writer", "Landroidx/navigation/safe/args/generator/NavWriter;", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;Ljava/io/File;Landroidx/navigation/safe/args/generator/NavWriter;)V", "generate", "Landroidx/navigation/safe/args/generator/GeneratorOutput;", "navigation-safe-args-generator"})
public final class NavSafeArgsGenerator<T extends CodeFile> {
    @NotNull
    private final String rFilePackage;
    @NotNull
    private final String applicationId;
    @NotNull
    private final File navigationXml;
    @NotNull
    private final File outputDir;
    @NotNull
    private final NavWriter<T> writer;

    public NavSafeArgsGenerator(@NotNull String rFilePackage, @NotNull String applicationId, @NotNull File navigationXml, @NotNull File outputDir, @NotNull NavWriter<T> writer) {
        Intrinsics.checkNotNullParameter((Object)rFilePackage, (String)"rFilePackage");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)navigationXml, (String)"navigationXml");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        this.rFilePackage = rFilePackage;
        this.applicationId = applicationId;
        this.navigationXml = navigationXml;
        this.outputDir = outputDir;
        this.writer = writer;
    }

    @NotNull
    public final GeneratorOutput generate() {
        Context context = new Context();
        Destination rawDestination = NavParser.Companion.parseNavigationFile(this.navigationXml, this.rFilePackage, this.applicationId, context);
        Destination resolvedDestination = NavArgumentResolverKt.resolveArguments(rawDestination);
        Set codeFiles = new LinkedHashSet();
        NavSafeArgsGenerator.generate$writeCodeFiles(this, codeFiles, resolvedDestination, CollectionsKt.emptyList());
        Iterable $this$forEach$iv = codeFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeFile it = (CodeFile)element$iv;
            boolean bl = false;
            it.writeTo(this.outputDir);
        }
        return new GeneratorOutput(CollectionsKt.toList((Iterable)codeFiles), context.getLogger().allMessages());
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends CodeFile> void generate$writeCodeFiles(NavSafeArgsGenerator<T> this$0, Set<CodeFile> codeFiles, Destination destination, List<? extends T> parentDirectionsFileList) {
        Object newParentDirectionFile;
        Object v1;
        T t;
        Object object = !((Collection)destination.getActions()).isEmpty() || !((Collection)parentDirectionsFileList).isEmpty() ? this$0.writer.generateDirectionsCodeFile(destination, parentDirectionsFileList) : (t = (CodeFile)null);
        if (t == null) {
            v1 = null;
        } else {
            T t2;
            T it = t2 = t;
            boolean bl = false;
            codeFiles.add((CodeFile)it);
            v1 = newParentDirectionFile = t2;
        }
        if (!((Collection)destination.getArgs()).isEmpty()) {
            codeFiles.add((CodeFile)this$0.writer.generateArgsCodeFile(destination));
        }
        Iterable $this$forEach$iv = destination.getNested();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list;
            Destination nestedDestination = (Destination)element$iv;
            boolean bl = false;
            NavSafeArgsGenerator<T> navSafeArgsGenerator = this$0;
            Set<CodeFile> set = codeFiles;
            Destination destination2 = nestedDestination;
            Object var11_13 = newParentDirectionFile;
            if (var11_13 == null) {
                list = parentDirectionsFileList;
            } else {
                void it;
                Object var12_14 = var11_13;
                Destination destination3 = destination2;
                Set<CodeFile> set2 = set;
                NavSafeArgsGenerator<T> navSafeArgsGenerator2 = navSafeArgsGenerator;
                boolean bl2 = false;
                List list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)it), (Iterable)parentDirectionsFileList);
                navSafeArgsGenerator = navSafeArgsGenerator2;
                set = set2;
                destination2 = destination3;
                List list3 = list2;
                list = list3 == null ? parentDirectionsFileList : list3;
            }
            NavSafeArgsGenerator.generate$writeCodeFiles(navSafeArgsGenerator, set, destination2, list);
        }
    }
}

