/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safeargs.gradle;

import androidx.navigation.safe.args.generator.ErrorMessage;
import androidx.navigation.safe.args.generator.GeneratorOutput;
import androidx.navigation.safe.args.generator.NavSafeArgsGeneratorKt;
import androidx.navigation.safeargs.gradle.ArgumentsGenerationTask;
import androidx.navigation.safeargs.gradle.Mapping;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0002J\u0016\u00100\u001a\u00020,2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u001dH\u0002J6\u00103\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u001d042\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0016072\u0006\u00108\u001a\u00020\u0016H\u0002J\n\u00109\u001a\u0004\u0018\u00010\u0004H\u0007J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u0002050\u001dH\u0002J\u0015\u0010;\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0001\u00a2\u0006\u0002\b<J\u0016\u0010=\u001a\u00020,2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002050\u001dH\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u00020\u00108GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u00020\u00168GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR(\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001d0\u001c8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u00020\u00168GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0018\"\u0004\b$\u0010\u001aR\"\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001c\u0010(\u001a\u00020\u00108GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0012\"\u0004\b*\u0010\u0014\u00a8\u0006?"}, d2={"Landroidx/navigation/safeargs/gradle/ArgumentsGenerationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "applicationId", "", "getApplicationId", "()Ljava/lang/String;", "setApplicationId", "(Ljava/lang/String;)V", "applicationIdResource", "Lorg/gradle/api/resources/TextResource;", "getApplicationIdResource", "()Lorg/gradle/api/resources/TextResource;", "setApplicationIdResource", "(Lorg/gradle/api/resources/TextResource;)V", "generateKotlin", "", "getGenerateKotlin", "()Z", "setGenerateKotlin", "(Z)V", "incrementalFolder", "Ljava/io/File;", "getIncrementalFolder", "()Ljava/io/File;", "setIncrementalFolder", "(Ljava/io/File;)V", "navigationFiles", "Lorg/gradle/api/provider/Provider;", "", "getNavigationFiles", "()Lorg/gradle/api/provider/Provider;", "setNavigationFiles", "(Lorg/gradle/api/provider/Provider;)V", "outputDir", "getOutputDir", "setOutputDir", "rFilePackage", "getRFilePackage", "setRFilePackage", "useAndroidX", "getUseAndroidX", "setUseAndroidX", "doFullTaskAction", "", "doIncrementalTaskAction", "inputs", "Lorg/gradle/api/tasks/incremental/IncrementalTaskInputs;", "failIfErrors", "errors", "Landroidx/navigation/safe/args/generator/ErrorMessage;", "generateArgs", "Lkotlin/Pair;", "Landroidx/navigation/safeargs/gradle/Mapping;", "navFiles", "", "out", "getApplicationIdResourceString", "readMappings", "taskAction", "taskAction$navigation_safe_args_gradle_plugin", "writeMappings", "mappings", "navigation-safe-args-gradle-plugin"})
public class ArgumentsGenerationTask
extends DefaultTask {
    @NotNull
    public Provider<String> rFilePackage;
    @Nullable
    private TextResource applicationIdResource;
    @Nullable
    private String applicationId;
    private boolean useAndroidX = true;
    private boolean generateKotlin;
    @NotNull
    public File outputDir;
    @NotNull
    public Provider<List<File>> navigationFiles;
    @NotNull
    public File incrementalFolder;

    @Input
    @NotNull
    public final Provider<String> getRFilePackage() {
        Provider<String> provider = this.rFilePackage;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rFilePackage");
        }
        return provider;
    }

    public final void setRFilePackage(@NotNull Provider<String> provider) {
        Intrinsics.checkParameterIsNotNull(provider, (String)"<set-?>");
        this.rFilePackage = provider;
    }

    @Nullable
    public final TextResource getApplicationIdResource() {
        return this.applicationIdResource;
    }

    public final void setApplicationIdResource(@Nullable TextResource textResource) {
        this.applicationIdResource = textResource;
    }

    @Nullable
    public final String getApplicationId() {
        return this.applicationId;
    }

    public final void setApplicationId(@Nullable String string) {
        this.applicationId = string;
    }

    @Input
    public final boolean getUseAndroidX() {
        return this.useAndroidX;
    }

    public final void setUseAndroidX(boolean bl) {
        this.useAndroidX = bl;
    }

    @Input
    public final boolean getGenerateKotlin() {
        return this.generateKotlin;
    }

    public final void setGenerateKotlin(boolean bl) {
        this.generateKotlin = bl;
    }

    @OutputDirectory
    @NotNull
    public final File getOutputDir() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    @InputFiles
    @NotNull
    public final Provider<List<File>> getNavigationFiles() {
        Provider<List<File>> provider = this.navigationFiles;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"navigationFiles");
        }
        return provider;
    }

    public final void setNavigationFiles(@NotNull Provider<List<File>> provider) {
        Intrinsics.checkParameterIsNotNull(provider, (String)"<set-?>");
        this.navigationFiles = provider;
    }

    @OutputDirectory
    @NotNull
    public final File getIncrementalFolder() {
        File file = this.incrementalFolder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"incrementalFolder");
        }
        return file;
    }

    public final void setIncrementalFolder(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.incrementalFolder = file;
    }

    @Input
    @Nullable
    public final String getApplicationIdResourceString() {
        Object object = this.applicationIdResource;
        if (object == null || (object = object.asString()) == null) {
            object = this.applicationId;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<Mapping>, List<ErrorMessage>> generateArgs(Collection<? extends File> navFiles, File out) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = navFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Provider<String> provider = this.rFilePackage;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rFilePackage");
            }
            Object object = provider.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"rFilePackage.get()");
            String string = (String)object;
            String string2 = this.getApplicationIdResourceString();
            if (string2 == null) {
                string2 = "";
            }
            GeneratorOutput output = NavSafeArgsGeneratorKt.SafeArgsGenerator((String)string, (String)string2, (File)file, (File)out, (boolean)this.useAndroidX, (boolean)this.generateKotlin).generate();
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            File file3 = project.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"project.projectDir");
            String string3 = FilesKt.relativeTo((File)file, (File)file3).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.relativeTo(project.projectDir).path");
            Pair pair = TuplesKt.to((Object)new Mapping(string3, output.getFileNames()), (Object)output.getErrors());
            collection.add(pair);
        }
        Pair pair = CollectionsKt.unzip((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        boolean bl2 = false;
        Pair $dstr$mappings$errorLists = pair;
        boolean bl3 = false;
        List mappings = (List)$dstr$mappings$errorLists.component1();
        List errorLists = (List)$dstr$mappings$errorLists.component2();
        return TuplesKt.to((Object)mappings, (Object)CollectionsKt.flatten((Iterable)errorLists));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeMappings(List<Mapping> mappings) {
        File file = this.incrementalFolder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"incrementalFolder");
        }
        Object object = new File(file, "file_mappings.json");
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        object2 = new FileOutputStream((File)object2);
        bl2 = false;
        object = new OutputStreamWriter((OutputStream)object2, charset);
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            boolean bl4 = false;
            new Gson().toJson(mappings, (Appendable)it);
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Mapping> readMappings() {
        File mappingsFile;
        Type type2 = new TypeToken<List<? extends Mapping>>(){}.getType();
        File file = this.incrementalFolder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"incrementalFolder");
        }
        if ((mappingsFile = new File(file, "file_mappings.json")).exists()) {
            Object object;
            Object object2 = mappingsFile;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object3 = object2;
            boolean bl2 = false;
            object3 = new FileInputStream((File)object3);
            bl2 = false;
            object2 = new InputStreamReader((InputStream)object3, charset);
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                InputStreamReader it = (InputStreamReader)object2;
                boolean bl4 = false;
                Object object4 = new Gson().fromJson((Reader)it, type2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"Gson().fromJson(it, type)");
                object3 = (List)object4;
                object = object3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mappingsFile.reader().us\u2026on().fromJson(it, type) }");
            return object;
        }
        return CollectionsKt.emptyList();
    }

    @TaskAction
    public final void taskAction$navigation_safe_args_gradle_plugin(@NotNull IncrementalTaskInputs inputs) {
        Intrinsics.checkParameterIsNotNull((Object)inputs, (String)"inputs");
        if (inputs.isIncremental()) {
            this.doIncrementalTaskAction(inputs);
        } else {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            project.getLogger().info("Unable do incremental execution: full task run");
            this.doFullTaskAction();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doFullTaskAction() {
        void mappings;
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        if (file.exists()) {
            File file2 = this.outputDir;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            }
            if (!FilesKt.deleteRecursively((File)file2)) {
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                project.getLogger().warn("Failed to clear directory for navigation arguments");
            }
        }
        File file3 = this.outputDir;
        if (file3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        if (!file3.exists()) {
            File file4 = this.outputDir;
            if (file4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            }
            if (!file4.mkdirs()) {
                throw (Throwable)new GradleException("Failed to create directory for navigation arguments");
            }
        }
        Provider<List<File>> provider = this.navigationFiles;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"navigationFiles");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"navigationFiles.get()");
        Collection collection = (Collection)object;
        File file5 = this.outputDir;
        if (file5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        Pair<List<Mapping>, List<ErrorMessage>> pair = this.generateArgs(collection, file5);
        List list = (List)pair.component1();
        List errors = (List)pair.component2();
        this.writeMappings((List<Mapping>)mappings);
        this.failIfErrors(errors);
    }

    /*
     * WARNING - void declaration
     */
    private final void doIncrementalTaskAction(IncrementalTaskInputs inputs) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        void modified;
        Mapping it;
        void $this$flatMapTo$iv$iv2;
        void newMapping;
        boolean bl = false;
        Set modifiedFiles = new LinkedHashSet();
        boolean bl2 = false;
        Set removedFiles = new LinkedHashSet();
        inputs.outOfDate((Action)new Action<InputFileDetails>(modifiedFiles){
            final /* synthetic */ Set $modifiedFiles;

            public final void execute(InputFileDetails change) {
                InputFileDetails inputFileDetails = change;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputFileDetails, (String)"change");
                File file = inputFileDetails.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"change.file");
                this.$modifiedFiles.add(file);
            }
            {
                this.$modifiedFiles = set;
            }
        });
        inputs.removed((Action)new Action<InputFileDetails>(removedFiles){
            final /* synthetic */ Set $removedFiles;

            public final void execute(InputFileDetails change) {
                InputFileDetails inputFileDetails = change;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputFileDetails, (String)"change");
                File file = inputFileDetails.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"change.file");
                this.$removedFiles.add(file);
            }
            {
                this.$removedFiles = set;
            }
        });
        List<Mapping> oldMapping = this.readMappings();
        Collection collection = modifiedFiles;
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        Pair<List<Mapping>, List<ErrorMessage>> pair = this.generateArgs(collection, file);
        List list = (List)pair.component1();
        List errors = (List)pair.component2();
        Iterable $this$flatMap$iv = (Iterable)newMapping;
        boolean $i$f$flatMap22 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            Mapping it2 = (Mapping)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it2.getJavaFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set newJavaFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set changedInputs = SetsKt.plus((Set)removedFiles, (Iterable)modifiedFiles);
        Iterable $this$partition$iv = oldMapping;
        boolean $i$f$partition22 = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = (Mapping)element$iv;
            boolean bl4 = false;
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            if (changedInputs.contains(new File(project.getProjectDir(), it.getNavFile()))) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        destination$iv$iv = new Pair(first$iv, second$iv);
        List $i$f$flatMap22 = (List)destination$iv$iv.component1();
        List unmodified = (List)destination$iv$iv.component2();
        Iterable $this$flatMap$iv2 = (Iterable)modified;
        boolean $i$f$flatMap = false;
        Iterable $i$f$partition22 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Mapping)element$iv$iv;
            boolean bl5 = false;
            Iterable list$iv$iv = it.getJavaFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String name = (String)element$iv$iv;
            boolean bl6 = false;
            if (!(!newJavaFiles.contains(name))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2;
            String javaName = (String)element$iv;
            boolean bl7 = false;
            String fileExtension = this.generateKotlin ? ".kt" : ".java";
            String fileName = StringsKt.replace$default((String)javaName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null) + fileExtension;
            File file3 = this.outputDir;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            }
            if (!(file2 = new File(file3, fileName)).exists()) continue;
            file2.delete();
        }
        this.writeMappings(CollectionsKt.plus((Collection)unmodified, (Iterable)((Iterable)newMapping)));
        this.failIfErrors(errors);
    }

    private final void failIfErrors(List<ErrorMessage> errors) {
        Collection collection = errors;
        boolean bl = false;
        if (!collection.isEmpty()) {
            String errString2 = CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, (Function1)failIfErrors.errString.1.INSTANCE, (int)30, null);
            throw (Throwable)new GradleException("androidx.navigation.safeargs plugin failed.\n " + "Following errors found: \n" + errString2);
        }
    }
}

