/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safeargs.gradle;

import androidx.navigation.safe.args.generator.ErrorMessage;
import androidx.navigation.safe.args.generator.GeneratorOutput;
import androidx.navigation.safe.args.generator.NavSafeArgsGeneratorKt;
import androidx.navigation.safeargs.gradle.ArgumentsGenerationTask;
import androidx.navigation.safeargs.gradle.Mapping;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\u00020)2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0002J6\u00101\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002030/\u0012\n\u0012\b\u0012\u0004\u0012\u0002000/022\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u0011052\u0006\u00106\u001a\u00020\u0011H\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u0002030/H\u0002J\u0015\u00108\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0001\u00a2\u0006\u0002\b9J\u0016\u0010:\u001a\u00020)2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002030/H\u0002R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u000b8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u00020\u00118GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u00020\u00178GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u00020\u00118GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u00020\u000b8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010\u000f\u00a8\u0006<"}, d2={"Landroidx/navigation/safeargs/gradle/ArgumentsGenerationTask;", "Lorg/gradle/api/DefaultTask;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/file/ProjectLayout;)V", "applicationId", "Lorg/gradle/api/provider/Property;", "", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "generateKotlin", "", "getGenerateKotlin", "()Z", "setGenerateKotlin", "(Z)V", "incrementalFolder", "Ljava/io/File;", "getIncrementalFolder", "()Ljava/io/File;", "setIncrementalFolder", "(Ljava/io/File;)V", "navigationFiles", "Lorg/gradle/api/file/FileCollection;", "getNavigationFiles", "()Lorg/gradle/api/file/FileCollection;", "setNavigationFiles", "(Lorg/gradle/api/file/FileCollection;)V", "outputDir", "getOutputDir", "setOutputDir", "rFilePackage", "Lorg/gradle/api/provider/Provider;", "getRFilePackage", "()Lorg/gradle/api/provider/Provider;", "setRFilePackage", "(Lorg/gradle/api/provider/Provider;)V", "useAndroidX", "getUseAndroidX", "setUseAndroidX", "doFullTaskAction", "", "doIncrementalTaskAction", "inputs", "Lorg/gradle/work/InputChanges;", "failIfErrors", "errors", "", "Landroidx/navigation/safe/args/generator/ErrorMessage;", "generateArgs", "Lkotlin/Pair;", "Landroidx/navigation/safeargs/gradle/Mapping;", "navFiles", "", "out", "readMappings", "taskAction", "taskAction$navigation_safe_args_gradle_plugin", "writeMappings", "mappings", "navigation-safe-args-gradle-plugin"})
public class ArgumentsGenerationTask
extends DefaultTask {
    @NotNull
    private final ProjectLayout projectLayout;
    public Provider<String> rFilePackage;
    @NotNull
    private final Property<String> applicationId;
    private boolean useAndroidX;
    private boolean generateKotlin;
    public File outputDir;
    public FileCollection navigationFiles;
    public File incrementalFolder;

    @Inject
    public ArgumentsGenerationTask(@NotNull ProjectLayout projectLayout) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        this.projectLayout = projectLayout;
        Property property = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(String::class.java)");
        this.applicationId = property;
        this.useAndroidX = true;
    }

    @Input
    @NotNull
    public final Provider<String> getRFilePackage() {
        Provider<String> provider = this.rFilePackage;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rFilePackage");
        throw null;
    }

    public final void setRFilePackage(@NotNull Provider<String> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.rFilePackage = provider;
    }

    @Input
    @NotNull
    public final Property<String> getApplicationId() {
        return this.applicationId;
    }

    @Input
    public final boolean getUseAndroidX() {
        return this.useAndroidX;
    }

    public final void setUseAndroidX(boolean bl) {
        this.useAndroidX = bl;
    }

    @Input
    public final boolean getGenerateKotlin() {
        return this.generateKotlin;
    }

    public final void setGenerateKotlin(boolean bl) {
        this.generateKotlin = bl;
    }

    @OutputDirectory
    @NotNull
    public final File getOutputDir() {
        File file = this.outputDir;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        throw null;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    @Incremental
    @InputFiles
    @NotNull
    public final FileCollection getNavigationFiles() {
        FileCollection fileCollection = this.navigationFiles;
        if (fileCollection != null) {
            return fileCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"navigationFiles");
        throw null;
    }

    public final void setNavigationFiles(@NotNull FileCollection fileCollection) {
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"<set-?>");
        this.navigationFiles = fileCollection;
    }

    @OutputDirectory
    @NotNull
    public final File getIncrementalFolder() {
        File file = this.incrementalFolder;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"incrementalFolder");
        throw null;
    }

    public final void setIncrementalFolder(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.incrementalFolder = file;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<Mapping>, List<ErrorMessage>> generateArgs(Collection<? extends File> navFiles, File out) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = navFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = this.getRFilePackage().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rFilePackage.get()");
            String string = (String)object;
            object = (String)this.getApplicationId().get();
            GeneratorOutput output = NavSafeArgsGeneratorKt.SafeArgsGenerator((String)string, (String)(object == null ? "" : object), (File)file, (File)out, (boolean)this.getUseAndroidX(), (boolean)this.getGenerateKotlin()).generate();
            File file3 = this.projectLayout.getProjectDirectory().getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"projectLayout.projectDirectory.asFile");
            object = FilesKt.relativeTo((File)file, (File)file3).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.relativeTo(\n                projectLayout.projectDirectory.asFile\n            ).path");
            Pair pair = TuplesKt.to((Object)new Mapping((String)object, output.getFileNames()), (Object)output.getErrors());
            collection.add(pair);
        }
        Pair pair = CollectionsKt.unzip((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        boolean bl2 = false;
        Pair $dstr$mappings$errorLists = pair;
        boolean bl3 = false;
        List mappings = (List)$dstr$mappings$errorLists.component1();
        List errorLists = (List)$dstr$mappings$errorLists.component2();
        return TuplesKt.to((Object)mappings, (Object)CollectionsKt.flatten((Iterable)errorLists));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeMappings(List<Mapping> mappings) {
        Object object = new File(this.getIncrementalFolder(), "file_mappings.json");
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        object2 = new FileOutputStream((File)object2);
        bl2 = false;
        object = new OutputStreamWriter((OutputStream)object2, charset);
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            boolean bl4 = false;
            new Gson().toJson(mappings, (Appendable)it);
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Mapping> readMappings() {
        Type type2 = new TypeToken<List<? extends Mapping>>(){}.getType();
        File mappingsFile = new File(this.getIncrementalFolder(), "file_mappings.json");
        if (mappingsFile.exists()) {
            Object object = mappingsFile;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            object2 = new FileInputStream((File)object2);
            bl2 = false;
            object = new InputStreamReader((InputStream)object2, charset);
            boolean bl3 = false;
            bl = false;
            Throwable throwable = null;
            try {
                InputStreamReader it = (InputStreamReader)object;
                boolean bl4 = false;
                object2 = (List)new Gson().fromJson((Reader)it, type2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Object object3 = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"mappingsFile.reader().use { Gson().fromJson(it, type) }");
            return object3;
        }
        return CollectionsKt.emptyList();
    }

    @TaskAction
    public final void taskAction$navigation_safe_args_gradle_plugin(@NotNull InputChanges inputs) {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        if (inputs.isIncremental()) {
            this.doIncrementalTaskAction(inputs);
        } else {
            this.getLogger().info("Unable do incremental execution: full task run");
            this.doFullTaskAction();
        }
    }

    private final void doFullTaskAction() {
        if (this.getOutputDir().exists() && !FilesKt.deleteRecursively((File)this.getOutputDir())) {
            this.getLogger().warn("Failed to clear directory for navigation arguments");
        }
        if (!this.getOutputDir().exists() && !this.getOutputDir().mkdirs()) {
            throw new GradleException("Failed to create directory for navigation arguments");
        }
        Set set = this.getNavigationFiles().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"navigationFiles.files");
        Pair<List<Mapping>, List<ErrorMessage>> pair = this.generateArgs(set, this.getOutputDir());
        List mappings = (List)pair.component1();
        List errors = (List)pair.component2();
        this.writeMappings(mappings);
        this.failIfErrors(errors);
    }

    /*
     * WARNING - void declaration
     */
    private final void doIncrementalTaskAction(InputChanges inputs) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Object element$iv$iv2;
        void $this$flatMapTo$iv$iv2;
        boolean bl = false;
        Set modifiedFiles = new LinkedHashSet();
        boolean bl2 = false;
        Set removedFiles = new LinkedHashSet();
        Iterable iterable = inputs.getFileChanges(this.getNavigationFiles());
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputs.getFileChanges(navigationFiles)");
        Iterable $this$forEach$iv2 = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            File file;
            FileChange change = (FileChange)element$iv;
            boolean bl3 = false;
            if (change.getChangeType() == ChangeType.MODIFIED || change.getChangeType() == ChangeType.ADDED) {
                file = change.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"change.file");
                modifiedFiles.add(file);
                continue;
            }
            if (change.getChangeType() != ChangeType.REMOVED) continue;
            file = change.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"change.file");
            removedFiles.add(file);
        }
        List<Mapping> oldMapping = this.readMappings();
        Pair<List<Mapping>, List<ErrorMessage>> pair = this.generateArgs(modifiedFiles, this.getOutputDir());
        List newMapping = (List)pair.component1();
        List errors = (List)pair.component2();
        Iterable $this$flatMap$iv = newMapping;
        boolean $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
            Mapping it = (Mapping)element$iv$iv2;
            boolean bl4 = false;
            Iterable list$iv$iv = it.getJavaFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set newJavaFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set changedInputs = SetsKt.plus((Set)removedFiles, (Iterable)modifiedFiles);
        Iterable $this$partition$iv = oldMapping;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Mapping it = (Mapping)element$iv;
            boolean bl5 = false;
            if (changedInputs.contains(new File(this.projectLayout.getProjectDirectory().getAsFile(), it.getNavFile()))) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair2 = new Pair(first$iv, second$iv);
        List modified = (List)pair2.component1();
        List unmodified = (List)pair2.component2();
        Iterable $this$flatMap$iv2 = modified;
        boolean $i$f$flatMap2 = false;
        element$iv$iv2 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv3 : $this$flatMapTo$iv$iv) {
            Mapping it = (Mapping)element$iv$iv3;
            boolean bl6 = false;
            Iterable list$iv$iv = it.getJavaFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            String name = (String)element$iv$iv3;
            boolean bl7 = false;
            if (!(!newJavaFiles.contains(name))) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String javaName = (String)element$iv;
            boolean bl8 = false;
            String fileExtension = this.getGenerateKotlin() ? ".kt" : ".java";
            String fileName = Intrinsics.stringPlus((String)StringsKt.replace$default((String)javaName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null), (Object)fileExtension);
            File file = new File(this.getOutputDir(), fileName);
            if (!file.exists()) continue;
            file.delete();
        }
        this.writeMappings(CollectionsKt.plus((Collection)unmodified, (Iterable)newMapping));
        this.failIfErrors(errors);
    }

    private final void failIfErrors(List<ErrorMessage> errors) {
        Collection collection = errors;
        boolean bl = false;
        if (!collection.isEmpty()) {
            String errString2 = CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, (Function1)failIfErrors.errString.1.INSTANCE, (int)30, null);
            throw new GradleException(Intrinsics.stringPlus((String)"androidx.navigation.safeargs plugin failed.\n Following errors found: \n", (Object)errString2));
        }
    }
}

